/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.ui;

import android.content.res.Resources;
import android.text.TextUtils;
import com.akamai.amp.exoplayer2.Format;
import com.akamai.amp.exoplayer2.ui.R;
import com.akamai.amp.exoplayer2.ui.TrackNameProvider;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.MimeTypes;
import com.akamai.amp.exoplayer2.util.Util;
import java.util.Locale;

public class DefaultTrackNameProvider
implements TrackNameProvider {
    private final Resources resources;

    public DefaultTrackNameProvider(Resources resources) {
        this.resources = Assertions.checkNotNull(resources);
    }

    @Override
    public String getTrackName(Format format) {
        int trackType = DefaultTrackNameProvider.inferPrimaryTrackType(format);
        String trackName = trackType == 2 ? this.joinWithSeparator(this.buildRoleString(format), this.buildResolutionString(format), this.buildBitrateString(format)) : (trackType == 1 ? this.joinWithSeparator(this.buildLanguageOrLabelString(format), this.buildAudioChannelString(format), this.buildBitrateString(format)) : this.buildLanguageOrLabelString(format));
        return trackName.length() == 0 ? this.resources.getString(R.string.exo_track_unknown) : trackName;
    }

    private String buildResolutionString(Format format) {
        int width = format.width;
        int height = format.height;
        return width == -1 || height == -1 ? "" : this.resources.getString(R.string.exo_track_resolution, new Object[]{width, height});
    }

    private String buildBitrateString(Format format) {
        int bitrate = format.bitrate;
        return bitrate == -1 ? "" : this.resources.getString(R.string.exo_track_bitrate, new Object[]{Float.valueOf((float)bitrate / 1000000.0f)});
    }

    private String buildAudioChannelString(Format format) {
        int channelCount = format.channelCount;
        if (channelCount == -1 || channelCount < 1) {
            return "";
        }
        switch (channelCount) {
            case 1: {
                return this.resources.getString(R.string.exo_track_mono);
            }
            case 2: {
                return this.resources.getString(R.string.exo_track_stereo);
            }
            case 6: 
            case 7: {
                return this.resources.getString(R.string.exo_track_surround_5_point_1);
            }
            case 8: {
                return this.resources.getString(R.string.exo_track_surround_7_point_1);
            }
        }
        return this.resources.getString(R.string.exo_track_surround);
    }

    private String buildLanguageOrLabelString(Format format) {
        String languageAndRole = this.joinWithSeparator(this.buildLanguageString(format), this.buildRoleString(format));
        return TextUtils.isEmpty((CharSequence)languageAndRole) ? this.buildLabelString(format) : languageAndRole;
    }

    private String buildLabelString(Format format) {
        return TextUtils.isEmpty((CharSequence)format.label) ? "" : format.label;
    }

    private String buildLanguageString(Format format) {
        String language = format.language;
        if (TextUtils.isEmpty((CharSequence)language) || "und".equals(language)) {
            return "";
        }
        Locale locale = Util.SDK_INT >= 21 ? Locale.forLanguageTag(language) : new Locale(language);
        return locale.getDisplayName();
    }

    private String buildRoleString(Format format) {
        String roles = "";
        if ((format.roleFlags & 2) != 0) {
            roles = this.resources.getString(R.string.exo_track_role_alternate);
        }
        if ((format.roleFlags & 4) != 0) {
            roles = this.joinWithSeparator(roles, this.resources.getString(R.string.exo_track_role_supplementary));
        }
        if ((format.roleFlags & 8) != 0) {
            roles = this.joinWithSeparator(roles, this.resources.getString(R.string.exo_track_role_commentary));
        }
        if ((format.roleFlags & 0x440) != 0) {
            roles = this.joinWithSeparator(roles, this.resources.getString(R.string.exo_track_role_closed_captions));
        }
        return roles;
    }

    private String joinWithSeparator(String ... items) {
        String itemList = "";
        for (String item : items) {
            if (item.length() <= 0) continue;
            itemList = TextUtils.isEmpty((CharSequence)itemList) ? item : this.resources.getString(R.string.exo_item_list, new Object[]{itemList, item});
        }
        return itemList;
    }

    private static int inferPrimaryTrackType(Format format) {
        int trackType = MimeTypes.getTrackType(format.sampleMimeType);
        if (trackType != -1) {
            return trackType;
        }
        if (MimeTypes.getVideoMediaMimeType(format.codecs) != null) {
            return 2;
        }
        if (MimeTypes.getAudioMediaMimeType(format.codecs) != null) {
            return 1;
        }
        if (format.width != -1 || format.height != -1) {
            return 2;
        }
        if (format.channelCount != -1 || format.sampleRate != -1) {
            return 1;
        }
        return -1;
    }
}

