/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.source.ads;

import androidx.annotation.VisibleForTesting;
import com.akamai.amp.exoplayer2.Timeline;
import com.akamai.amp.exoplayer2.source.ForwardingTimeline;
import com.akamai.amp.exoplayer2.source.ads.AdPlaybackState;
import com.akamai.amp.exoplayer2.util.Assertions;

@VisibleForTesting(otherwise=3)
public final class SinglePeriodAdTimeline
extends ForwardingTimeline {
    private final AdPlaybackState adPlaybackState;

    public SinglePeriodAdTimeline(Timeline contentTimeline, AdPlaybackState adPlaybackState) {
        super(contentTimeline);
        Assertions.checkState(contentTimeline.getPeriodCount() == 1);
        Assertions.checkState(contentTimeline.getWindowCount() == 1);
        this.adPlaybackState = adPlaybackState;
    }

    @Override
    public Timeline.Period getPeriod(int periodIndex, Timeline.Period period, boolean setIds) {
        this.timeline.getPeriod(periodIndex, period, setIds);
        long durationUs = period.durationUs == -9223372036854775807L ? this.adPlaybackState.contentDurationUs : period.durationUs;
        period.set(period.id, period.uid, period.windowIndex, durationUs, period.getPositionInWindowUs(), this.adPlaybackState);
        return period;
    }
}

