/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.source;

import android.content.Context;
import android.net.Uri;
import android.util.SparseArray;
import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.C;
import com.akamai.amp.exoplayer2.MediaItem;
import com.akamai.amp.exoplayer2.drm.DrmSessionManager;
import com.akamai.amp.exoplayer2.extractor.DefaultExtractorsFactory;
import com.akamai.amp.exoplayer2.extractor.ExtractorsFactory;
import com.akamai.amp.exoplayer2.offline.StreamKey;
import com.akamai.amp.exoplayer2.source.ClippingMediaSource;
import com.akamai.amp.exoplayer2.source.MediaSource;
import com.akamai.amp.exoplayer2.source.MediaSourceDrmHelper;
import com.akamai.amp.exoplayer2.source.MediaSourceFactory;
import com.akamai.amp.exoplayer2.source.MergingMediaSource;
import com.akamai.amp.exoplayer2.source.ProgressiveMediaSource;
import com.akamai.amp.exoplayer2.source.SingleSampleMediaSource;
import com.akamai.amp.exoplayer2.source.ads.AdsLoader;
import com.akamai.amp.exoplayer2.source.ads.AdsMediaSource;
import com.akamai.amp.exoplayer2.trackselection.DefaultTrackSelector;
import com.akamai.amp.exoplayer2.upstream.DataSource;
import com.akamai.amp.exoplayer2.upstream.DataSpec;
import com.akamai.amp.exoplayer2.upstream.DefaultDataSourceFactory;
import com.akamai.amp.exoplayer2.upstream.HttpDataSource;
import com.akamai.amp.exoplayer2.upstream.LoadErrorHandlingPolicy;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.Log;
import com.akamai.amp.exoplayer2.util.Util;
import java.util.Arrays;
import java.util.List;

public final class DefaultMediaSourceFactory
implements MediaSourceFactory {
    private static final String TAG = "DefaultMediaSourceFactory";
    private final MediaSourceDrmHelper mediaSourceDrmHelper;
    private DefaultTrackSelector defaultTrackSelector;
    private final DataSource.Factory dataSourceFactory;
    private final SparseArray<MediaSourceFactory> mediaSourceFactories;
    private final int[] supportedTypes;
    @Nullable
    private AdsLoaderProvider adsLoaderProvider;
    @Nullable
    private AdsLoader.AdViewProvider adViewProvider;
    @Nullable
    private DrmSessionManager drmSessionManager;
    @Nullable
    private List<StreamKey> streamKeys;
    @Nullable
    private LoadErrorHandlingPolicy loadErrorHandlingPolicy;

    public DefaultMediaSourceFactory(Context context) {
        this(new DefaultDataSourceFactory(context), null);
    }

    public DefaultMediaSourceFactory(Context context, ExtractorsFactory extractorsFactory) {
        this(new DefaultDataSourceFactory(context), extractorsFactory, null);
    }

    public DefaultMediaSourceFactory(DataSource.Factory dataSourceFactory, DefaultTrackSelector defaultTrackSelector) {
        this(dataSourceFactory, new DefaultExtractorsFactory(), defaultTrackSelector);
    }

    public DefaultMediaSourceFactory(DataSource.Factory dataSourceFactory, ExtractorsFactory extractorsFactory, DefaultTrackSelector defaultTrackSelector) {
        this.dataSourceFactory = dataSourceFactory;
        this.defaultTrackSelector = defaultTrackSelector;
        this.mediaSourceDrmHelper = new MediaSourceDrmHelper();
        this.mediaSourceFactories = DefaultMediaSourceFactory.loadDelegates(dataSourceFactory, extractorsFactory);
        this.supportedTypes = new int[this.mediaSourceFactories.size()];
        for (int i = 0; i < this.mediaSourceFactories.size(); ++i) {
            this.supportedTypes[i] = this.mediaSourceFactories.keyAt(i);
        }
    }

    public DefaultMediaSourceFactory setAdsLoaderProvider(@Nullable AdsLoaderProvider adsLoaderProvider) {
        this.adsLoaderProvider = adsLoaderProvider;
        return this;
    }

    public DefaultMediaSourceFactory setAdViewProvider(@Nullable AdsLoader.AdViewProvider adViewProvider) {
        this.adViewProvider = adViewProvider;
        return this;
    }

    @Override
    public DefaultMediaSourceFactory setDrmHttpDataSourceFactory(@Nullable HttpDataSource.Factory drmHttpDataSourceFactory) {
        this.mediaSourceDrmHelper.setDrmHttpDataSourceFactory(drmHttpDataSourceFactory);
        return this;
    }

    @Override
    public DefaultMediaSourceFactory setDrmUserAgent(@Nullable String userAgent) {
        this.mediaSourceDrmHelper.setDrmUserAgent(userAgent);
        return this;
    }

    @Override
    public DefaultMediaSourceFactory setDrmSessionManager(@Nullable DrmSessionManager drmSessionManager) {
        this.drmSessionManager = drmSessionManager;
        return this;
    }

    @Override
    public DefaultMediaSourceFactory setLoadErrorHandlingPolicy(@Nullable LoadErrorHandlingPolicy loadErrorHandlingPolicy) {
        this.loadErrorHandlingPolicy = loadErrorHandlingPolicy;
        return this;
    }

    @Override
    @Deprecated
    public DefaultMediaSourceFactory setStreamKeys(@Nullable List<StreamKey> streamKeys) {
        this.streamKeys = streamKeys != null && !streamKeys.isEmpty() ? streamKeys : null;
        return this;
    }

    @Override
    public int[] getSupportedTypes() {
        return Arrays.copyOf(this.supportedTypes, this.supportedTypes.length);
    }

    @Override
    public MediaSource createMediaSource(MediaItem mediaItem) {
        Assertions.checkNotNull(mediaItem.playbackProperties);
        int type = Util.inferContentTypeForUriAndMimeType(mediaItem.playbackProperties.uri, mediaItem.playbackProperties.mimeType);
        MediaSourceFactory mediaSourceFactory = (MediaSourceFactory)this.mediaSourceFactories.get(type);
        Assertions.checkNotNull(mediaSourceFactory, "No suitable media source factory found for content type: " + type);
        mediaSourceFactory.setDrmSessionManager(this.drmSessionManager != null ? this.drmSessionManager : this.mediaSourceDrmHelper.create(mediaItem));
        mediaSourceFactory.setStreamKeys(!mediaItem.playbackProperties.streamKeys.isEmpty() ? mediaItem.playbackProperties.streamKeys : this.streamKeys);
        mediaSourceFactory.setLoadErrorHandlingPolicy(this.loadErrorHandlingPolicy);
        MediaSource mediaSource = mediaSourceFactory.createMediaSource(mediaItem);
        List<MediaItem.Subtitle> subtitles = mediaItem.playbackProperties.subtitles;
        if (!subtitles.isEmpty()) {
            MediaSource[] mediaSources = new MediaSource[subtitles.size() + 1];
            mediaSources[0] = mediaSource;
            SingleSampleMediaSource.Factory singleSampleSourceFactory = new SingleSampleMediaSource.Factory(this.dataSourceFactory, this.defaultTrackSelector).setLoadErrorHandlingPolicy(this.loadErrorHandlingPolicy);
            for (int i = 0; i < subtitles.size(); ++i) {
                mediaSources[i + 1] = singleSampleSourceFactory.createMediaSource(subtitles.get(i), -9223372036854775807L);
            }
            mediaSource = new MergingMediaSource(mediaSources);
        }
        return this.maybeWrapWithAdsMediaSource(mediaItem, DefaultMediaSourceFactory.maybeClipMediaSource(mediaItem, mediaSource));
    }

    private static MediaSource maybeClipMediaSource(MediaItem mediaItem, MediaSource mediaSource) {
        if (mediaItem.clippingProperties.startPositionMs == 0L && mediaItem.clippingProperties.endPositionMs == Long.MIN_VALUE && !mediaItem.clippingProperties.relativeToDefaultPosition) {
            return mediaSource;
        }
        return new ClippingMediaSource(mediaSource, C.msToUs(mediaItem.clippingProperties.startPositionMs), C.msToUs(mediaItem.clippingProperties.endPositionMs), !mediaItem.clippingProperties.startsAtKeyFrame, mediaItem.clippingProperties.relativeToLiveWindow, mediaItem.clippingProperties.relativeToDefaultPosition);
    }

    private MediaSource maybeWrapWithAdsMediaSource(MediaItem mediaItem, MediaSource mediaSource) {
        Assertions.checkNotNull(mediaItem.playbackProperties);
        Uri adTagUri = mediaItem.playbackProperties.adTagUri;
        if (adTagUri == null) {
            return mediaSource;
        }
        AdsLoaderProvider adsLoaderProvider = this.adsLoaderProvider;
        AdsLoader.AdViewProvider adViewProvider = this.adViewProvider;
        if (adsLoaderProvider == null || adViewProvider == null) {
            Log.w(TAG, "Playing media without ads. Configure ad support by calling setAdsLoaderProvider and setAdViewProvider.");
            return mediaSource;
        }
        AdsLoader adsLoader = adsLoaderProvider.getAdsLoader(adTagUri);
        if (adsLoader == null) {
            Log.w(TAG, "Playing media without ads. No AdsLoader for provided adTagUri");
            return mediaSource;
        }
        return new AdsMediaSource(mediaSource, new DataSpec(adTagUri), this, adsLoader, adViewProvider);
    }

    private static SparseArray<MediaSourceFactory> loadDelegates(DataSource.Factory dataSourceFactory, ExtractorsFactory extractorsFactory) {
        Class<MediaSourceFactory> factoryClazz2;
        SparseArray factories = new SparseArray();
        try {
            factoryClazz2 = Class.forName("com.akamai.amp.exoplayer2.source.dash.DashMediaSource$Factory").asSubclass(MediaSourceFactory.class);
            factories.put(0, (Object)factoryClazz2.getConstructor(DataSource.Factory.class).newInstance(dataSourceFactory));
        }
        catch (Exception factoryClazz2) {
            // empty catch block
        }
        try {
            factoryClazz2 = Class.forName("com.akamai.amp.exoplayer2.source.smoothstreaming.SsMediaSource$Factory").asSubclass(MediaSourceFactory.class);
            factories.put(1, (Object)factoryClazz2.getConstructor(DataSource.Factory.class).newInstance(dataSourceFactory));
        }
        catch (Exception factoryClazz3) {
            // empty catch block
        }
        try {
            factoryClazz2 = Class.forName("com.akamai.amp.exoplayer2.source.hls.HlsMediaSource$Factory").asSubclass(MediaSourceFactory.class);
            factories.put(2, (Object)factoryClazz2.getConstructor(DataSource.Factory.class).newInstance(dataSourceFactory));
        }
        catch (Exception exception) {
            // empty catch block
        }
        factories.put(3, (Object)new ProgressiveMediaSource.Factory(dataSourceFactory, extractorsFactory));
        return factories;
    }

    public static interface AdsLoaderProvider {
        @Nullable
        public AdsLoader getAdsLoader(Uri var1);
    }
}

