/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.extractor.ts;

import com.akamai.amp.exoplayer2.Format;
import com.akamai.amp.exoplayer2.extractor.CeaUtil;
import com.akamai.amp.exoplayer2.extractor.ExtractorOutput;
import com.akamai.amp.exoplayer2.extractor.TrackOutput;
import com.akamai.amp.exoplayer2.extractor.ts.TsPayloadReader;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.ParsableByteArray;
import java.util.List;

final class UserDataReader {
    private static final int USER_DATA_START_CODE = 434;
    private final List<Format> closedCaptionFormats;
    private final TrackOutput[] outputs;

    public UserDataReader(List<Format> closedCaptionFormats) {
        this.closedCaptionFormats = closedCaptionFormats;
        this.outputs = new TrackOutput[closedCaptionFormats.size()];
    }

    public void createTracks(ExtractorOutput extractorOutput, TsPayloadReader.TrackIdGenerator idGenerator) {
        for (int i = 0; i < this.outputs.length; ++i) {
            idGenerator.generateNewId();
            TrackOutput output = extractorOutput.track(idGenerator.getTrackId(), 3);
            Format channelFormat = this.closedCaptionFormats.get(i);
            String channelMimeType = channelFormat.sampleMimeType;
            Assertions.checkArgument("application/cea-608".equals(channelMimeType) || "application/cea-708".equals(channelMimeType), "Invalid closed caption mime type provided: " + channelMimeType);
            output.format(new Format.Builder().setId(idGenerator.getFormatId()).setSampleMimeType(channelMimeType).setSelectionFlags(channelFormat.selectionFlags).setLanguage(channelFormat.language).setAccessibilityChannel(channelFormat.accessibilityChannel).setInitializationData(channelFormat.initializationData).build());
            this.outputs[i] = output;
        }
    }

    public void consume(long pesTimeUs, ParsableByteArray userDataPayload) {
        if (userDataPayload.bytesLeft() < 9) {
            return;
        }
        int userDataStartCode = userDataPayload.readInt();
        int userDataIdentifier = userDataPayload.readInt();
        int userDataTypeCode = userDataPayload.readUnsignedByte();
        if (userDataStartCode == 434 && userDataIdentifier == 1195456820 && userDataTypeCode == 3) {
            CeaUtil.consumeCcData(pesTimeUs, userDataPayload, this.outputs);
        }
    }
}

