/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.tracker;

import android.os.AsyncTask;
import com.akamai.amp.tracker.OnTaskCompleted;
import com.akamai.amp.utils.LogManager;
import java.net.HttpURLConnection;
import java.net.URL;

public class DoGetTask
extends AsyncTask<String, Void, Integer> {
    public static final String TAG = DoGetTask.class.getSimpleName();
    private OnTaskCompleted listener;
    private String tag;

    public DoGetTask(OnTaskCompleted listener) {
        this.listener = listener;
    }

    public DoGetTask(String tag, OnTaskCompleted queryListener) {
        this.listener = queryListener;
        this.tag = tag;
    }

    protected Integer doInBackground(String ... params) {
        Integer getResult = this.executeGet(params[0], params[1]);
        return getResult;
    }

    protected void onPostExecute(Integer result) {
        this.listener.onTaskCompleted(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer executeGet(String targetURL, String eventType) {
        LogManager.log(this.getTag(), "Beacon executeGet: event " + eventType.toUpperCase() + ", URL: " + targetURL);
        HttpURLConnection connection = null;
        try {
            URL url = new URL(targetURL);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setUseCaches(false);
            int responseCode = connection.getResponseCode();
            Integer n = responseCode;
            return n;
        }
        catch (Exception e) {
            LogManager.log(this.getTag(), "Beacon Exception on GET execution: " + e.getLocalizedMessage());
            Integer n = null;
            return n;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private String getTag() {
        if (this.tag != null) {
            return this.tag;
        }
        return TAG;
    }
}

