/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.parser.config;

import com.akamai.amp.config.data.streamsense.StreamsenseAppData;
import com.akamai.amp.config.data.streamsense.StreamsenseData;
import com.akamai.amp.parser.utils.UtilsParser;
import com.akamai.amp.utils.LogManager;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class StreamsenseParser {
    public static final String STREAMSENSE_OBJ_TAG = "comscorestreamsense";
    public static final String PERSISTENT_TAG = "persistent";
    public static final String PLAYLIST_TAG = "playlist";
    public static final String METADATA_TAG = "metadata";
    public static final String VIDEO_TAG = "video";
    public static final String AD_TAG = "ads";
    public static final String APP_DATA_PUBLISHER_ID = "publisherId";
    public static final String APP_DATA_PUBLISHER_SECRET = "publisherSecret";
    public static final String APP_DATA_APP_NAME = "appName";
    public static final String APP_DATA_APP_VERSION = "appVersion";

    public StreamsenseData buildStreamsenseData(JSONObject root) {
        JSONObject ssData = UtilsParser.getObj(STREAMSENSE_OBJ_TAG, root);
        StreamsenseAppData appData = this.parseAppData(ssData);
        Map<String, String> persistentLabels = this.parsePersistentLabels(ssData);
        StreamsenseData sd = new StreamsenseData();
        sd.setAppData(appData);
        sd.setPersistentLabels(persistentLabels);
        return sd;
    }

    private StreamsenseAppData parseAppData(JSONObject ssData) {
        StreamsenseAppData result = new StreamsenseAppData();
        if (ssData != null) {
            result.setPublisherId(UtilsParser.getValue(APP_DATA_PUBLISHER_ID, ssData));
            result.setPublisherSecret(UtilsParser.getValue(APP_DATA_PUBLISHER_SECRET, ssData));
            result.setAppName(UtilsParser.getValue(APP_DATA_APP_NAME, ssData));
            result.setAppVersion(UtilsParser.getValue(APP_DATA_APP_VERSION, ssData));
        }
        return result;
    }

    private Map<String, String> parsePersistentLabels(JSONObject ssData) {
        JSONObject data;
        HashMap<String, String> result = new HashMap<String, String>();
        if (ssData != null && (data = UtilsParser.getObj(PERSISTENT_TAG, ssData)) != null) {
            this.setValues(result, data, "Persistent");
        }
        return result;
    }

    private void setValues(Map<String, String> data, JSONObject jsonObject, String id) {
        for (String key : data.keySet()) {
            String value = UtilsParser.getValue(key, jsonObject);
            if (value == null) continue;
            LogManager.log("StreamsenseParser", "Comscore Streamsense: " + id + " Data: " + key + " (" + value + ")");
            data.put(key, value);
        }
    }
}

