/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.util;

import android.os.SystemClock;
import android.text.TextUtils;
import android.view.Surface;
import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.ExoPlaybackException;
import com.akamai.amp.exoplayer2.Format;
import com.akamai.amp.exoplayer2.MediaItem;
import com.akamai.amp.exoplayer2.PlaybackParameters;
import com.akamai.amp.exoplayer2.RendererCapabilities;
import com.akamai.amp.exoplayer2.Timeline;
import com.akamai.amp.exoplayer2.analytics.AnalyticsListener;
import com.akamai.amp.exoplayer2.audio.AudioAttributes;
import com.akamai.amp.exoplayer2.decoder.DecoderCounters;
import com.akamai.amp.exoplayer2.metadata.Metadata;
import com.akamai.amp.exoplayer2.source.LoadEventInfo;
import com.akamai.amp.exoplayer2.source.MediaLoadData;
import com.akamai.amp.exoplayer2.source.TrackGroup;
import com.akamai.amp.exoplayer2.source.TrackGroupArray;
import com.akamai.amp.exoplayer2.trackselection.MappingTrackSelector;
import com.akamai.amp.exoplayer2.trackselection.TrackSelection;
import com.akamai.amp.exoplayer2.trackselection.TrackSelectionArray;
import com.akamai.amp.exoplayer2.util.Log;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Locale;

public class EventLogger
implements AnalyticsListener {
    private static final String DEFAULT_TAG = "EventLogger";
    private static final int MAX_TIMELINE_ITEM_LINES = 3;
    private static final NumberFormat TIME_FORMAT = NumberFormat.getInstance(Locale.US);
    @Nullable
    private final MappingTrackSelector trackSelector;
    private final String tag;
    private final Timeline.Window window;
    private final Timeline.Period period;
    private final long startTimeMs;

    public EventLogger(@Nullable MappingTrackSelector trackSelector) {
        this(trackSelector, DEFAULT_TAG);
    }

    public EventLogger(@Nullable MappingTrackSelector trackSelector, String tag) {
        this.trackSelector = trackSelector;
        this.tag = tag;
        this.window = new Timeline.Window();
        this.period = new Timeline.Period();
        this.startTimeMs = SystemClock.elapsedRealtime();
    }

    @Override
    public void onIsLoadingChanged(AnalyticsListener.EventTime eventTime, boolean isLoading) {
        this.logd(eventTime, "loading", Boolean.toString(isLoading));
    }

    @Override
    public void onPlaybackStateChanged(AnalyticsListener.EventTime eventTime, int state) {
        this.logd(eventTime, "state", EventLogger.getStateString(state));
    }

    @Override
    public void onPlayWhenReadyChanged(AnalyticsListener.EventTime eventTime, boolean playWhenReady, int reason) {
        this.logd(eventTime, "playWhenReady", playWhenReady + ", " + EventLogger.getPlayWhenReadyChangeReasonString(reason));
    }

    @Override
    public void onPlaybackSuppressionReasonChanged(AnalyticsListener.EventTime eventTime, int playbackSuppressionReason) {
        this.logd(eventTime, "playbackSuppressionReason", EventLogger.getPlaybackSuppressionReasonString(playbackSuppressionReason));
    }

    @Override
    public void onIsPlayingChanged(AnalyticsListener.EventTime eventTime, boolean isPlaying) {
        this.logd(eventTime, "isPlaying", Boolean.toString(isPlaying));
    }

    @Override
    public void onRepeatModeChanged(AnalyticsListener.EventTime eventTime, int repeatMode) {
        this.logd(eventTime, "repeatMode", EventLogger.getRepeatModeString(repeatMode));
    }

    @Override
    public void onShuffleModeChanged(AnalyticsListener.EventTime eventTime, boolean shuffleModeEnabled) {
        this.logd(eventTime, "shuffleModeEnabled", Boolean.toString(shuffleModeEnabled));
    }

    @Override
    public void onPositionDiscontinuity(AnalyticsListener.EventTime eventTime, int reason) {
        this.logd(eventTime, "positionDiscontinuity", EventLogger.getDiscontinuityReasonString(reason));
    }

    @Override
    public void onSeekStarted(AnalyticsListener.EventTime eventTime) {
        this.logd(eventTime, "seekStarted");
    }

    @Override
    public void onPlaybackParametersChanged(AnalyticsListener.EventTime eventTime, PlaybackParameters playbackParameters) {
        this.logd(eventTime, "playbackParameters", playbackParameters.toString());
    }

    @Override
    public void onTimelineChanged(AnalyticsListener.EventTime eventTime, int reason) {
        int i;
        int periodCount = eventTime.timeline.getPeriodCount();
        int windowCount = eventTime.timeline.getWindowCount();
        this.logd("timeline [" + this.getEventTimeString(eventTime) + ", periodCount=" + periodCount + ", windowCount=" + windowCount + ", reason=" + EventLogger.getTimelineChangeReasonString(reason));
        for (i = 0; i < Math.min(periodCount, 3); ++i) {
            eventTime.timeline.getPeriod(i, this.period);
            this.logd("  period [" + EventLogger.getTimeString(this.period.getDurationMs()) + "]");
        }
        if (periodCount > 3) {
            this.logd("  ...");
        }
        for (i = 0; i < Math.min(windowCount, 3); ++i) {
            eventTime.timeline.getWindow(i, this.window);
            this.logd("  window [" + EventLogger.getTimeString(this.window.getDurationMs()) + ", seekable=" + this.window.isSeekable + ", dynamic=" + this.window.isDynamic + "]");
        }
        if (windowCount > 3) {
            this.logd("  ...");
        }
        this.logd("]");
    }

    @Override
    public void onMediaItemTransition(AnalyticsListener.EventTime eventTime, @Nullable MediaItem mediaItem, int reason) {
        this.logd("mediaItem [" + this.getEventTimeString(eventTime) + ", reason=" + EventLogger.getMediaItemTransitionReasonString(reason) + "]");
    }

    @Override
    public void onPlayerError(AnalyticsListener.EventTime eventTime, ExoPlaybackException e) {
        this.loge(eventTime, "playerFailed", e);
    }

    @Override
    public void onTracksChanged(AnalyticsListener.EventTime eventTime, TrackGroupArray ignored, TrackSelectionArray trackSelections) {
        MappingTrackSelector.MappedTrackInfo mappedTrackInfo;
        MappingTrackSelector.MappedTrackInfo mappedTrackInfo2 = mappedTrackInfo = this.trackSelector != null ? this.trackSelector.getCurrentMappedTrackInfo() : null;
        if (mappedTrackInfo == null) {
            this.logd(eventTime, "tracks", "[]");
            return;
        }
        this.logd("tracks [" + this.getEventTimeString(eventTime));
        int rendererCount = mappedTrackInfo.getRendererCount();
        for (int rendererIndex = 0; rendererIndex < rendererCount; ++rendererIndex) {
            TrackGroupArray rendererTrackGroups = mappedTrackInfo.getTrackGroups(rendererIndex);
            TrackSelection trackSelection = trackSelections.get(rendererIndex);
            if (rendererTrackGroups.length == 0) {
                this.logd("  " + mappedTrackInfo.getRendererName(rendererIndex) + " []");
                continue;
            }
            this.logd("  " + mappedTrackInfo.getRendererName(rendererIndex) + " [");
            for (int groupIndex = 0; groupIndex < rendererTrackGroups.length; ++groupIndex) {
                TrackGroup trackGroup = rendererTrackGroups.get(groupIndex);
                String adaptiveSupport = EventLogger.getAdaptiveSupportString(trackGroup.length, mappedTrackInfo.getAdaptiveSupport(rendererIndex, groupIndex, false));
                this.logd("    Group:" + groupIndex + ", adaptive_supported=" + adaptiveSupport + " [");
                for (int trackIndex = 0; trackIndex < trackGroup.length; ++trackIndex) {
                    String status = EventLogger.getTrackStatusString(trackSelection, trackGroup, trackIndex);
                    String formatSupport = RendererCapabilities.getFormatSupportString(mappedTrackInfo.getTrackSupport(rendererIndex, groupIndex, trackIndex));
                    this.logd("      " + status + " Track:" + trackIndex + ", " + Format.toLogString(trackGroup.getFormat(trackIndex)) + ", supported=" + formatSupport);
                }
                this.logd("    ]");
            }
            if (trackSelection != null) {
                for (int selectionIndex = 0; selectionIndex < trackSelection.length(); ++selectionIndex) {
                    Metadata metadata = trackSelection.getFormat((int)selectionIndex).metadata;
                    if (metadata == null) continue;
                    this.logd("    Metadata [");
                    this.printMetadata(metadata, "      ");
                    this.logd("    ]");
                    break;
                }
            }
            this.logd("  ]");
        }
        TrackGroupArray unassociatedTrackGroups = mappedTrackInfo.getUnmappedTrackGroups();
        if (unassociatedTrackGroups.length > 0) {
            this.logd("  Unmapped [");
            for (int groupIndex = 0; groupIndex < unassociatedTrackGroups.length; ++groupIndex) {
                this.logd("    Group:" + groupIndex + " [");
                TrackGroup trackGroup = unassociatedTrackGroups.get(groupIndex);
                for (int trackIndex = 0; trackIndex < trackGroup.length; ++trackIndex) {
                    String status = EventLogger.getTrackStatusString(false);
                    String formatSupport = RendererCapabilities.getFormatSupportString(0);
                    this.logd("      " + status + " Track:" + trackIndex + ", " + Format.toLogString(trackGroup.getFormat(trackIndex)) + ", supported=" + formatSupport);
                }
                this.logd("    ]");
            }
            this.logd("  ]");
        }
        this.logd("]");
    }

    @Override
    public void onMetadata(AnalyticsListener.EventTime eventTime, Metadata metadata) {
        this.logd("metadata [" + this.getEventTimeString(eventTime));
        this.printMetadata(metadata, "  ");
        this.logd("]");
    }

    @Override
    public void onAudioEnabled(AnalyticsListener.EventTime eventTime, DecoderCounters counters) {
        this.logd(eventTime, "audioEnabled");
    }

    @Override
    public void onAudioDecoderInitialized(AnalyticsListener.EventTime eventTime, String decoderName, long initializationDurationMs) {
        this.logd(eventTime, "audioDecoderInitialized", decoderName);
    }

    @Override
    public void onAudioInputFormatChanged(AnalyticsListener.EventTime eventTime, Format format) {
        this.logd(eventTime, "audioInputFormat", Format.toLogString(format));
    }

    @Override
    public void onAudioUnderrun(AnalyticsListener.EventTime eventTime, int bufferSize, long bufferSizeMs, long elapsedSinceLastFeedMs) {
        this.loge(eventTime, "audioTrackUnderrun", bufferSize + ", " + bufferSizeMs + ", " + elapsedSinceLastFeedMs, null);
    }

    @Override
    public void onAudioDisabled(AnalyticsListener.EventTime eventTime, DecoderCounters counters) {
        this.logd(eventTime, "audioDisabled");
    }

    @Override
    public void onAudioSessionId(AnalyticsListener.EventTime eventTime, int audioSessionId) {
        this.logd(eventTime, "audioSessionId", Integer.toString(audioSessionId));
    }

    @Override
    public void onAudioAttributesChanged(AnalyticsListener.EventTime eventTime, AudioAttributes audioAttributes) {
        this.logd(eventTime, "audioAttributes", audioAttributes.contentType + "," + audioAttributes.flags + "," + audioAttributes.usage + "," + audioAttributes.allowedCapturePolicy);
    }

    @Override
    public void onSkipSilenceEnabledChanged(AnalyticsListener.EventTime eventTime, boolean skipSilenceEnabled) {
        this.logd(eventTime, "skipSilenceEnabled", Boolean.toString(skipSilenceEnabled));
    }

    @Override
    public void onVolumeChanged(AnalyticsListener.EventTime eventTime, float volume) {
        this.logd(eventTime, "volume", Float.toString(volume));
    }

    @Override
    public void onVideoEnabled(AnalyticsListener.EventTime eventTime, DecoderCounters counters) {
        this.logd(eventTime, "videoEnabled");
    }

    @Override
    public void onVideoDecoderInitialized(AnalyticsListener.EventTime eventTime, String decoderName, long initializationDurationMs) {
        this.logd(eventTime, "videoDecoderInitialized", decoderName);
    }

    @Override
    public void onVideoInputFormatChanged(AnalyticsListener.EventTime eventTime, Format format) {
        this.logd(eventTime, "videoInputFormat", Format.toLogString(format));
    }

    @Override
    public void onDroppedVideoFrames(AnalyticsListener.EventTime eventTime, int count, long elapsedMs) {
        this.logd(eventTime, "droppedFrames", Integer.toString(count));
    }

    @Override
    public void onVideoDisabled(AnalyticsListener.EventTime eventTime, DecoderCounters counters) {
        this.logd(eventTime, "videoDisabled");
    }

    @Override
    public void onRenderedFirstFrame(AnalyticsListener.EventTime eventTime, @Nullable Surface surface) {
        this.logd(eventTime, "renderedFirstFrame", String.valueOf(surface));
    }

    @Override
    public void onVideoSizeChanged(AnalyticsListener.EventTime eventTime, int width, int height, int unappliedRotationDegrees, float pixelWidthHeightRatio) {
        this.logd(eventTime, "videoSize", width + ", " + height);
    }

    @Override
    public void onLoadStarted(AnalyticsListener.EventTime eventTime, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData) {
    }

    @Override
    public void onLoadError(AnalyticsListener.EventTime eventTime, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData, IOException error, boolean wasCanceled) {
        this.printInternalError(eventTime, "loadError", error);
    }

    @Override
    public void onLoadCanceled(AnalyticsListener.EventTime eventTime, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData) {
    }

    @Override
    public void onLoadCompleted(AnalyticsListener.EventTime eventTime, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData) {
    }

    @Override
    public void onBandwidthEstimate(AnalyticsListener.EventTime eventTime, int totalLoadTimeMs, long totalBytesLoaded, long bitrateEstimate) {
    }

    @Override
    public void onSurfaceSizeChanged(AnalyticsListener.EventTime eventTime, int width, int height) {
        this.logd(eventTime, "surfaceSize", width + ", " + height);
    }

    @Override
    public void onUpstreamDiscarded(AnalyticsListener.EventTime eventTime, MediaLoadData mediaLoadData) {
        this.logd(eventTime, "upstreamDiscarded", Format.toLogString(mediaLoadData.trackFormat));
    }

    @Override
    public void onDownstreamFormatChanged(AnalyticsListener.EventTime eventTime, MediaLoadData mediaLoadData) {
        this.logd(eventTime, "downstreamFormat", Format.toLogString(mediaLoadData.trackFormat));
    }

    @Override
    public void onDrmSessionAcquired(AnalyticsListener.EventTime eventTime) {
        this.logd(eventTime, "drmSessionAcquired");
    }

    @Override
    public void onDrmSessionManagerError(AnalyticsListener.EventTime eventTime, Exception e) {
        this.printInternalError(eventTime, "drmSessionManagerError", e);
    }

    @Override
    public void onDrmKeysRestored(AnalyticsListener.EventTime eventTime) {
        this.logd(eventTime, "drmKeysRestored");
    }

    @Override
    public void onDrmKeysRemoved(AnalyticsListener.EventTime eventTime) {
        this.logd(eventTime, "drmKeysRemoved");
    }

    @Override
    public void onDrmKeysLoaded(AnalyticsListener.EventTime eventTime) {
        this.logd(eventTime, "drmKeysLoaded");
    }

    @Override
    public void onDrmSessionReleased(AnalyticsListener.EventTime eventTime) {
        this.logd(eventTime, "drmSessionReleased");
    }

    protected void logd(String msg) {
        Log.d(this.tag, msg);
    }

    protected void loge(String msg) {
        Log.e(this.tag, msg);
    }

    private void logd(AnalyticsListener.EventTime eventTime, String eventName) {
        this.logd(this.getEventString(eventTime, eventName, null, null));
    }

    private void logd(AnalyticsListener.EventTime eventTime, String eventName, String eventDescription) {
        this.logd(this.getEventString(eventTime, eventName, eventDescription, null));
    }

    private void loge(AnalyticsListener.EventTime eventTime, String eventName, @Nullable Throwable throwable) {
        this.loge(this.getEventString(eventTime, eventName, null, throwable));
    }

    private void loge(AnalyticsListener.EventTime eventTime, String eventName, String eventDescription, @Nullable Throwable throwable) {
        this.loge(this.getEventString(eventTime, eventName, eventDescription, throwable));
    }

    private void printInternalError(AnalyticsListener.EventTime eventTime, String type, Exception e) {
        this.loge(eventTime, "internalError", type, e);
    }

    private void printMetadata(Metadata metadata, String prefix) {
        for (int i = 0; i < metadata.length(); ++i) {
            this.logd(prefix + metadata.get(i));
        }
    }

    private String getEventString(AnalyticsListener.EventTime eventTime, String eventName, @Nullable String eventDescription, @Nullable Throwable throwable) {
        String throwableString;
        String eventString = eventName + " [" + this.getEventTimeString(eventTime);
        if (eventDescription != null) {
            eventString = eventString + ", " + eventDescription;
        }
        if (!TextUtils.isEmpty((CharSequence)(throwableString = Log.getThrowableString(throwable)))) {
            eventString = eventString + "\n  " + throwableString.replace("\n", "\n  ") + '\n';
        }
        eventString = eventString + "]";
        return eventString;
    }

    private String getEventTimeString(AnalyticsListener.EventTime eventTime) {
        String windowPeriodString = "window=" + eventTime.windowIndex;
        if (eventTime.mediaPeriodId != null) {
            windowPeriodString = windowPeriodString + ", period=" + eventTime.timeline.getIndexOfPeriod(eventTime.mediaPeriodId.periodUid);
            if (eventTime.mediaPeriodId.isAd()) {
                windowPeriodString = windowPeriodString + ", adGroup=" + eventTime.mediaPeriodId.adGroupIndex;
                windowPeriodString = windowPeriodString + ", ad=" + eventTime.mediaPeriodId.adIndexInAdGroup;
            }
        }
        return "eventTime=" + EventLogger.getTimeString(eventTime.realtimeMs - this.startTimeMs) + ", mediaPos=" + EventLogger.getTimeString(eventTime.eventPlaybackPositionMs) + ", " + windowPeriodString;
    }

    private static String getTimeString(long timeMs) {
        return timeMs == -9223372036854775807L ? "?" : TIME_FORMAT.format((float)timeMs / 1000.0f);
    }

    public static String getStateString(int state) {
        switch (state) {
            case 2: {
                return "BUFFERING";
            }
            case 4: {
                return "ENDED";
            }
            case 1: {
                return "IDLE";
            }
            case 3: {
                return "READY";
            }
        }
        return "?";
    }

    private static String getAdaptiveSupportString(int trackCount, int adaptiveSupport) {
        if (trackCount < 2) {
            return "N/A";
        }
        switch (adaptiveSupport) {
            case 16: {
                return "YES";
            }
            case 8: {
                return "YES_NOT_SEAMLESS";
            }
            case 0: {
                return "NO";
            }
        }
        throw new IllegalStateException();
    }

    private static String getTrackStatusString(@Nullable TrackSelection selection, TrackGroup group, int trackIndex) {
        return EventLogger.getTrackStatusString(selection != null && selection.getTrackGroup() == group && selection.indexOf(trackIndex) != -1);
    }

    private static String getTrackStatusString(boolean enabled) {
        return enabled ? "[X]" : "[ ]";
    }

    private static String getRepeatModeString(int repeatMode) {
        switch (repeatMode) {
            case 0: {
                return "OFF";
            }
            case 1: {
                return "ONE";
            }
            case 2: {
                return "ALL";
            }
        }
        return "?";
    }

    private static String getDiscontinuityReasonString(int reason) {
        switch (reason) {
            case 0: {
                return "PERIOD_TRANSITION";
            }
            case 1: {
                return "SEEK";
            }
            case 2: {
                return "SEEK_ADJUSTMENT";
            }
            case 3: {
                return "AD_INSERTION";
            }
            case 4: {
                return "INTERNAL";
            }
        }
        return "?";
    }

    private static String getTimelineChangeReasonString(int reason) {
        switch (reason) {
            case 1: {
                return "SOURCE_UPDATE";
            }
            case 0: {
                return "PLAYLIST_CHANGED";
            }
        }
        return "?";
    }

    private static String getMediaItemTransitionReasonString(int reason) {
        switch (reason) {
            case 1: {
                return "AUTO";
            }
            case 3: {
                return "PLAYLIST_CHANGED";
            }
            case 0: {
                return "REPEAT";
            }
            case 2: {
                return "SEEK";
            }
        }
        return "?";
    }

    private static String getPlaybackSuppressionReasonString(int playbackSuppressionReason) {
        switch (playbackSuppressionReason) {
            case 0: {
                return "NONE";
            }
            case 1: {
                return "TRANSIENT_AUDIO_FOCUS_LOSS";
            }
        }
        return "?";
    }

    private static String getPlayWhenReadyChangeReasonString(int reason) {
        switch (reason) {
            case 3: {
                return "AUDIO_BECOMING_NOISY";
            }
            case 2: {
                return "AUDIO_FOCUS_LOSS";
            }
            case 4: {
                return "REMOTE";
            }
            case 1: {
                return "USER_REQUEST";
            }
            case 5: {
                return "END_OF_MEDIA_ITEM";
            }
        }
        return "?";
    }

    static {
        TIME_FORMAT.setMinimumFractionDigits(2);
        TIME_FORMAT.setMaximumFractionDigits(2);
        TIME_FORMAT.setGroupingUsed(false);
    }
}

