/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.upstream.cache;

import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.akamai.amp.exoplayer2.upstream.DataSourceException;
import com.akamai.amp.exoplayer2.upstream.DataSpec;
import com.akamai.amp.exoplayer2.upstream.cache.Cache;
import com.akamai.amp.exoplayer2.upstream.cache.CacheDataSource;
import com.akamai.amp.exoplayer2.upstream.cache.ContentMetadata;
import com.akamai.amp.exoplayer2.util.Util;
import java.io.IOException;
import java.io.InterruptedIOException;

public final class CacheWriter {
    public static final int DEFAULT_BUFFER_SIZE_BYTES = 131072;
    private final CacheDataSource dataSource;
    private final Cache cache;
    private final DataSpec dataSpec;
    private final boolean allowShortContent;
    private final String cacheKey;
    private final byte[] temporaryBuffer;
    @Nullable
    private final ProgressListener progressListener;
    private boolean initialized;
    private long nextPosition;
    private long endPosition;
    private long bytesCached;
    private volatile boolean isCanceled;

    public CacheWriter(CacheDataSource dataSource, DataSpec dataSpec, boolean allowShortContent, @Nullable byte[] temporaryBuffer, @Nullable ProgressListener progressListener) {
        this.dataSource = dataSource;
        this.cache = dataSource.getCache();
        this.dataSpec = dataSpec;
        this.allowShortContent = allowShortContent;
        this.temporaryBuffer = temporaryBuffer == null ? new byte[131072] : temporaryBuffer;
        this.progressListener = progressListener;
        this.cacheKey = dataSource.getCacheKeyFactory().buildCacheKey(dataSpec);
        this.nextPosition = dataSpec.position;
    }

    public void cancel() {
        this.isCanceled = true;
    }

    @WorkerThread
    public void cache() throws IOException {
        this.throwIfCanceled();
        if (!this.initialized) {
            long contentLength;
            this.endPosition = this.dataSpec.length != -1L ? this.dataSpec.position + this.dataSpec.length : ((contentLength = ContentMetadata.getContentLength(this.cache.getContentMetadata(this.cacheKey))) == -1L ? -1L : contentLength);
            this.bytesCached = this.cache.getCachedBytes(this.cacheKey, this.dataSpec.position, this.dataSpec.length);
            if (this.progressListener != null) {
                this.progressListener.onProgress(this.getLength(), this.bytesCached, 0L);
            }
            this.initialized = true;
        }
        while (this.endPosition == -1L || this.nextPosition < this.endPosition) {
            this.throwIfCanceled();
            long maxRemainingLength = this.endPosition == -1L ? Long.MAX_VALUE : this.endPosition - this.nextPosition;
            long blockLength = this.cache.getCachedLength(this.cacheKey, this.nextPosition, maxRemainingLength);
            if (blockLength > 0L) {
                this.nextPosition += blockLength;
                continue;
            }
            long nextRequestLength = (blockLength = -blockLength) == Long.MAX_VALUE ? -1L : blockLength;
            this.nextPosition += this.readBlockToCache(this.nextPosition, nextRequestLength);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long readBlockToCache(long position, long length) throws IOException {
        boolean isLastBlock = position + length == this.endPosition || length == -1L;
        try {
            long resolvedLength = -1L;
            boolean isDataSourceOpen = false;
            if (length != -1L) {
                try {
                    DataSpec boundedDataSpec = this.dataSpec.buildUpon().setPosition(position).setLength(length).build();
                    resolvedLength = this.dataSource.open(boundedDataSpec);
                    isDataSourceOpen = true;
                }
                catch (IOException exception) {
                    if (this.allowShortContent && isLastBlock && DataSourceException.isCausedByPositionOutOfRange(exception)) {
                        Util.closeQuietly(this.dataSource);
                    }
                    throw exception;
                }
            }
            if (!isDataSourceOpen) {
                this.throwIfCanceled();
                DataSpec unboundedDataSpec = this.dataSpec.buildUpon().setPosition(position).setLength(-1L).build();
                resolvedLength = this.dataSource.open(unboundedDataSpec);
            }
            if (isLastBlock && resolvedLength != -1L) {
                this.onRequestEndPosition(position + resolvedLength);
            }
            int totalBytesRead = 0;
            int bytesRead = 0;
            while (bytesRead != -1) {
                this.throwIfCanceled();
                bytesRead = this.dataSource.read(this.temporaryBuffer, 0, this.temporaryBuffer.length);
                if (bytesRead == -1) continue;
                this.onNewBytesCached(bytesRead);
                totalBytesRead += bytesRead;
            }
            if (isLastBlock) {
                this.onRequestEndPosition(position + (long)totalBytesRead);
            }
            long l = totalBytesRead;
            return l;
        }
        finally {
            Util.closeQuietly(this.dataSource);
        }
    }

    private void onRequestEndPosition(long endPosition) {
        if (this.endPosition == endPosition) {
            return;
        }
        this.endPosition = endPosition;
        if (this.progressListener != null) {
            this.progressListener.onProgress(this.getLength(), this.bytesCached, 0L);
        }
    }

    private void onNewBytesCached(long newBytesCached) {
        this.bytesCached += newBytesCached;
        if (this.progressListener != null) {
            this.progressListener.onProgress(this.getLength(), this.bytesCached, newBytesCached);
        }
    }

    private long getLength() {
        return this.endPosition == -1L ? -1L : this.endPosition - this.dataSpec.position;
    }

    private void throwIfCanceled() throws InterruptedIOException {
        if (this.isCanceled) {
            throw new InterruptedIOException();
        }
    }

    public static interface ProgressListener {
        public void onProgress(long var1, long var3, long var5);
    }
}

