/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.upstream;

import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.upstream.DataSink;
import com.akamai.amp.exoplayer2.upstream.DataSpec;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public final class ByteArrayDataSink
implements DataSink {
    private @MonotonicNonNull ByteArrayOutputStream stream;

    @Override
    public void open(DataSpec dataSpec) {
        if (dataSpec.length == -1L) {
            this.stream = new ByteArrayOutputStream();
        } else {
            Assertions.checkArgument(dataSpec.length <= Integer.MAX_VALUE);
            this.stream = new ByteArrayOutputStream((int)dataSpec.length);
        }
    }

    @Override
    public void close() throws IOException {
        Util.castNonNull(this.stream).close();
    }

    @Override
    public void write(byte[] buffer, int offset, int length) {
        Util.castNonNull(this.stream).write(buffer, offset, length);
    }

    @Nullable
    public byte[] getData() {
        return this.stream == null ? null : this.stream.toByteArray();
    }
}

