/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.source.hls;

import android.net.Uri;
import android.os.Handler;
import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.C;
import com.akamai.amp.exoplayer2.ExoPlayerLibraryInfo;
import com.akamai.amp.exoplayer2.MediaItem;
import com.akamai.amp.exoplayer2.ampcustom.AMPPreSettings;
import com.akamai.amp.exoplayer2.drm.DrmSessionEventListener;
import com.akamai.amp.exoplayer2.drm.DrmSessionManager;
import com.akamai.amp.exoplayer2.offline.StreamKey;
import com.akamai.amp.exoplayer2.source.BaseMediaSource;
import com.akamai.amp.exoplayer2.source.CompositeSequenceableLoaderFactory;
import com.akamai.amp.exoplayer2.source.DefaultCompositeSequenceableLoaderFactory;
import com.akamai.amp.exoplayer2.source.MediaPeriod;
import com.akamai.amp.exoplayer2.source.MediaSource;
import com.akamai.amp.exoplayer2.source.MediaSourceDrmHelper;
import com.akamai.amp.exoplayer2.source.MediaSourceEventListener;
import com.akamai.amp.exoplayer2.source.MediaSourceFactory;
import com.akamai.amp.exoplayer2.source.SinglePeriodTimeline;
import com.akamai.amp.exoplayer2.source.hls.DefaultHlsDataSourceFactory;
import com.akamai.amp.exoplayer2.source.hls.HlsDataSourceFactory;
import com.akamai.amp.exoplayer2.source.hls.HlsExtractorFactory;
import com.akamai.amp.exoplayer2.source.hls.HlsManifest;
import com.akamai.amp.exoplayer2.source.hls.HlsMediaPeriod;
import com.akamai.amp.exoplayer2.source.hls.playlist.DefaultHlsPlaylistParserFactory;
import com.akamai.amp.exoplayer2.source.hls.playlist.DefaultHlsPlaylistTracker;
import com.akamai.amp.exoplayer2.source.hls.playlist.FilteringHlsPlaylistParserFactory;
import com.akamai.amp.exoplayer2.source.hls.playlist.HlsMediaPlaylist;
import com.akamai.amp.exoplayer2.source.hls.playlist.HlsPlaylistParserFactory;
import com.akamai.amp.exoplayer2.source.hls.playlist.HlsPlaylistTracker;
import com.akamai.amp.exoplayer2.upstream.Allocator;
import com.akamai.amp.exoplayer2.upstream.DataSource;
import com.akamai.amp.exoplayer2.upstream.DefaultLoadErrorHandlingPolicy;
import com.akamai.amp.exoplayer2.upstream.HttpDataSource;
import com.akamai.amp.exoplayer2.upstream.LoadErrorHandlingPolicy;
import com.akamai.amp.exoplayer2.upstream.TransferListener;
import com.akamai.amp.exoplayer2.util.Assertions;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collections;
import java.util.List;

public final class HlsMediaSource
extends BaseMediaSource
implements HlsPlaylistTracker.PrimaryPlaylistListener {
    public static final int METADATA_TYPE_ID3 = 1;
    public static final int METADATA_TYPE_EMSG = 3;
    private final HlsExtractorFactory extractorFactory;
    private final MediaItem mediaItem;
    private final MediaItem.PlaybackProperties playbackProperties;
    private final HlsDataSourceFactory dataSourceFactory;
    private final CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory;
    private final DrmSessionManager drmSessionManager;
    private final LoadErrorHandlingPolicy loadErrorHandlingPolicy;
    private final boolean allowChunklessPreparation;
    private final int metadataType;
    private final boolean useSessionKeys;
    private final HlsPlaylistTracker playlistTracker;
    @Nullable
    private TransferListener mediaTransferListener;

    private HlsMediaSource(MediaItem mediaItem, HlsDataSourceFactory dataSourceFactory, HlsExtractorFactory extractorFactory, CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory, DrmSessionManager drmSessionManager, LoadErrorHandlingPolicy loadErrorHandlingPolicy, HlsPlaylistTracker playlistTracker, boolean allowChunklessPreparation, int metadataType, boolean useSessionKeys) {
        this.playbackProperties = Assertions.checkNotNull(mediaItem.playbackProperties);
        this.mediaItem = mediaItem;
        this.dataSourceFactory = dataSourceFactory;
        this.extractorFactory = extractorFactory;
        this.compositeSequenceableLoaderFactory = compositeSequenceableLoaderFactory;
        this.drmSessionManager = drmSessionManager;
        this.loadErrorHandlingPolicy = loadErrorHandlingPolicy;
        this.playlistTracker = playlistTracker;
        this.allowChunklessPreparation = allowChunklessPreparation;
        this.metadataType = metadataType;
        this.useSessionKeys = useSessionKeys;
    }

    @Override
    public boolean isLive() {
        return this.playlistTracker.isLive();
    }

    @Override
    @Deprecated
    @Nullable
    public Object getTag() {
        return this.playbackProperties.tag;
    }

    @Override
    public MediaItem getMediaItem() {
        return this.mediaItem;
    }

    @Override
    protected void prepareSourceInternal(@Nullable TransferListener mediaTransferListener) {
        this.mediaTransferListener = mediaTransferListener;
        this.drmSessionManager.prepare();
        MediaSourceEventListener.EventDispatcher eventDispatcher = this.createEventDispatcher(null);
        this.playlistTracker.start(this.playbackProperties.uri, eventDispatcher, this);
    }

    @Override
    public void maybeThrowSourceInfoRefreshError() throws IOException {
        this.playlistTracker.maybeThrowPrimaryPlaylistRefreshError();
    }

    @Override
    public MediaPeriod createPeriod(MediaSource.MediaPeriodId id, Allocator allocator, long startPositionUs) {
        MediaSourceEventListener.EventDispatcher mediaSourceEventDispatcher = this.createEventDispatcher(id);
        DrmSessionEventListener.EventDispatcher drmEventDispatcher = this.createDrmEventDispatcher(id);
        return new HlsMediaPeriod(this.extractorFactory, this.playlistTracker, this.dataSourceFactory, this.mediaTransferListener, this.drmSessionManager, drmEventDispatcher, this.loadErrorHandlingPolicy, mediaSourceEventDispatcher, allocator, this.compositeSequenceableLoaderFactory, this.allowChunklessPreparation, this.metadataType, this.useSessionKeys);
    }

    @Override
    public void releasePeriod(MediaPeriod mediaPeriod) {
        ((HlsMediaPeriod)mediaPeriod).release();
    }

    @Override
    protected void releaseSourceInternal() {
        this.playlistTracker.stop();
        this.drmSessionManager.release();
    }

    @Override
    public void onPrimaryPlaylistRefreshed(HlsMediaPlaylist playlist) {
        SinglePeriodTimeline timeline;
        long windowStartTimeMs = playlist.hasProgramDateTime ? C.usToMs(playlist.startTimeUs) : -9223372036854775807L;
        long presentationStartTimeMs = playlist.playlistType == 2 || playlist.playlistType == 1 ? windowStartTimeMs : -9223372036854775807L;
        long windowDefaultStartPositionUs = playlist.startOffsetUs;
        HlsManifest manifest = new HlsManifest(Assertions.checkNotNull(this.playlistTracker.getMasterPlaylist()), playlist);
        if (this.playlistTracker.isLive()) {
            long offsetFromInitialStartTimeUs = playlist.startTimeUs - this.playlistTracker.getInitialStartTimeUs();
            long periodDurationUs = playlist.hasEndTag ? offsetFromInitialStartTimeUs + playlist.durationUs : -9223372036854775807L;
            List<HlsMediaPlaylist.Segment> segments = playlist.segments;
            if (windowDefaultStartPositionUs == -9223372036854775807L) {
                windowDefaultStartPositionUs = 0L;
                if (!segments.isEmpty()) {
                    int defaultStartSegmentIndex;
                    int startSegmentIndex = 3;
                    if (AMPPreSettings.getPreSettingsInstance().getLowLatencySettings().isLowLatencyTurnedOn()) {
                        startSegmentIndex = 1;
                    }
                    long minStartPositionUs = playlist.durationUs - playlist.targetDurationUs * 2L;
                    for (defaultStartSegmentIndex = Math.max(0, segments.size() - startSegmentIndex); defaultStartSegmentIndex > 0 && segments.get((int)defaultStartSegmentIndex).relativeStartTimeUs > minStartPositionUs; --defaultStartSegmentIndex) {
                    }
                    windowDefaultStartPositionUs = segments.get((int)defaultStartSegmentIndex).relativeStartTimeUs;
                }
            }
            timeline = new SinglePeriodTimeline(presentationStartTimeMs, windowStartTimeMs, -9223372036854775807L, periodDurationUs, playlist.durationUs, offsetFromInitialStartTimeUs, windowDefaultStartPositionUs, true, !playlist.hasEndTag, true, (Object)manifest, this.mediaItem);
        } else {
            if (windowDefaultStartPositionUs == -9223372036854775807L) {
                windowDefaultStartPositionUs = 0L;
            }
            timeline = new SinglePeriodTimeline(presentationStartTimeMs, windowStartTimeMs, -9223372036854775807L, playlist.durationUs, playlist.durationUs, 0L, windowDefaultStartPositionUs, true, false, false, (Object)manifest, this.mediaItem);
        }
        this.refreshSourceInfo(timeline);
    }

    static {
        ExoPlayerLibraryInfo.registerModule("goog.exo.hls");
    }

    public static final class Factory
    implements MediaSourceFactory {
        private final HlsDataSourceFactory hlsDataSourceFactory;
        private final MediaSourceDrmHelper mediaSourceDrmHelper;
        private HlsExtractorFactory extractorFactory;
        private HlsPlaylistParserFactory playlistParserFactory;
        private HlsPlaylistTracker.Factory playlistTrackerFactory;
        private CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory;
        @Nullable
        private DrmSessionManager drmSessionManager;
        private LoadErrorHandlingPolicy loadErrorHandlingPolicy;
        private boolean allowChunklessPreparation;
        private int metadataType;
        private boolean useSessionKeys;
        private List<StreamKey> streamKeys;
        @Nullable
        private Object tag;

        public Factory(DataSource.Factory dataSourceFactory) {
            this(new DefaultHlsDataSourceFactory(dataSourceFactory));
        }

        public Factory(HlsDataSourceFactory hlsDataSourceFactory) {
            this.hlsDataSourceFactory = Assertions.checkNotNull(hlsDataSourceFactory);
            this.mediaSourceDrmHelper = new MediaSourceDrmHelper();
            this.playlistParserFactory = new DefaultHlsPlaylistParserFactory();
            this.playlistTrackerFactory = DefaultHlsPlaylistTracker.FACTORY;
            this.extractorFactory = HlsExtractorFactory.DEFAULT;
            this.loadErrorHandlingPolicy = new DefaultLoadErrorHandlingPolicy();
            this.compositeSequenceableLoaderFactory = new DefaultCompositeSequenceableLoaderFactory();
            this.metadataType = 1;
            this.streamKeys = Collections.emptyList();
        }

        @Deprecated
        public Factory setTag(@Nullable Object tag) {
            this.tag = tag;
            return this;
        }

        public Factory setExtractorFactory(@Nullable HlsExtractorFactory extractorFactory) {
            this.extractorFactory = extractorFactory != null ? extractorFactory : HlsExtractorFactory.DEFAULT;
            return this;
        }

        @Override
        public Factory setLoadErrorHandlingPolicy(@Nullable LoadErrorHandlingPolicy loadErrorHandlingPolicy) {
            this.loadErrorHandlingPolicy = loadErrorHandlingPolicy != null ? loadErrorHandlingPolicy : new DefaultLoadErrorHandlingPolicy();
            return this;
        }

        @Deprecated
        public Factory setMinLoadableRetryCount(int minLoadableRetryCount) {
            this.loadErrorHandlingPolicy = new DefaultLoadErrorHandlingPolicy(minLoadableRetryCount);
            return this;
        }

        public Factory setPlaylistParserFactory(@Nullable HlsPlaylistParserFactory playlistParserFactory) {
            this.playlistParserFactory = playlistParserFactory != null ? playlistParserFactory : new DefaultHlsPlaylistParserFactory();
            return this;
        }

        public Factory setPlaylistTrackerFactory(@Nullable HlsPlaylistTracker.Factory playlistTrackerFactory) {
            this.playlistTrackerFactory = playlistTrackerFactory != null ? playlistTrackerFactory : DefaultHlsPlaylistTracker.FACTORY;
            return this;
        }

        public Factory setCompositeSequenceableLoaderFactory(@Nullable CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory) {
            this.compositeSequenceableLoaderFactory = compositeSequenceableLoaderFactory != null ? compositeSequenceableLoaderFactory : new DefaultCompositeSequenceableLoaderFactory();
            return this;
        }

        public Factory setAllowChunklessPreparation(boolean allowChunklessPreparation) {
            this.allowChunklessPreparation = allowChunklessPreparation;
            return this;
        }

        public Factory setMetadataType(int metadataType) {
            this.metadataType = metadataType;
            return this;
        }

        public Factory setUseSessionKeys(boolean useSessionKeys) {
            this.useSessionKeys = useSessionKeys;
            return this;
        }

        @Override
        public Factory setDrmSessionManager(@Nullable DrmSessionManager drmSessionManager) {
            this.drmSessionManager = drmSessionManager;
            return this;
        }

        @Override
        public Factory setDrmHttpDataSourceFactory(@Nullable HttpDataSource.Factory drmHttpDataSourceFactory) {
            this.mediaSourceDrmHelper.setDrmHttpDataSourceFactory(drmHttpDataSourceFactory);
            return this;
        }

        @Override
        public MediaSourceFactory setDrmUserAgent(@Nullable String userAgent) {
            this.mediaSourceDrmHelper.setDrmUserAgent(userAgent);
            return this;
        }

        @Override
        @Deprecated
        public Factory setStreamKeys(@Nullable List<StreamKey> streamKeys) {
            this.streamKeys = streamKeys != null ? streamKeys : Collections.emptyList();
            return this;
        }

        @Deprecated
        public HlsMediaSource createMediaSource(Uri playlistUri, @Nullable Handler eventHandler, @Nullable MediaSourceEventListener eventListener) {
            HlsMediaSource mediaSource = this.createMediaSource(playlistUri);
            if (eventHandler != null && eventListener != null) {
                mediaSource.addEventListener(eventHandler, eventListener);
            }
            return mediaSource;
        }

        @Override
        @Deprecated
        public HlsMediaSource createMediaSource(Uri uri) {
            return this.createMediaSource(new MediaItem.Builder().setUri(uri).setMimeType("application/x-mpegURL").build());
        }

        @Override
        public HlsMediaSource createMediaSource(MediaItem mediaItem) {
            boolean needsStreamKeys;
            List<StreamKey> streamKeys;
            Assertions.checkNotNull(mediaItem.playbackProperties);
            HlsPlaylistParserFactory playlistParserFactory = this.playlistParserFactory;
            List<StreamKey> list = streamKeys = mediaItem.playbackProperties.streamKeys.isEmpty() ? this.streamKeys : mediaItem.playbackProperties.streamKeys;
            if (!streamKeys.isEmpty()) {
                playlistParserFactory = new FilteringHlsPlaylistParserFactory(playlistParserFactory, streamKeys);
            }
            boolean needsTag = mediaItem.playbackProperties.tag == null && this.tag != null;
            boolean bl = needsStreamKeys = mediaItem.playbackProperties.streamKeys.isEmpty() && !streamKeys.isEmpty();
            if (needsTag && needsStreamKeys) {
                mediaItem = mediaItem.buildUpon().setTag(this.tag).setStreamKeys(streamKeys).build();
            } else if (needsTag) {
                mediaItem = mediaItem.buildUpon().setTag(this.tag).build();
            } else if (needsStreamKeys) {
                mediaItem = mediaItem.buildUpon().setStreamKeys(streamKeys).build();
            }
            return new HlsMediaSource(mediaItem, this.hlsDataSourceFactory, this.extractorFactory, this.compositeSequenceableLoaderFactory, this.drmSessionManager != null ? this.drmSessionManager : this.mediaSourceDrmHelper.create(mediaItem), this.loadErrorHandlingPolicy, this.playlistTrackerFactory.createTracker(this.hlsDataSourceFactory, this.loadErrorHandlingPolicy, playlistParserFactory), this.allowChunklessPreparation, this.metadataType, this.useSessionKeys);
        }

        @Override
        public int[] getSupportedTypes() {
            return new int[]{2};
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MetadataType {
    }
}

