/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.offline;

import android.app.Notification;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import com.akamai.amp.exoplayer2.offline.Download;
import com.akamai.amp.exoplayer2.offline.DownloadManager;
import com.akamai.amp.exoplayer2.offline.DownloadRequest;
import com.akamai.amp.exoplayer2.scheduler.Requirements;
import com.akamai.amp.exoplayer2.scheduler.Scheduler;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.Log;
import com.akamai.amp.exoplayer2.util.NotificationUtil;
import com.akamai.amp.exoplayer2.util.Util;
import java.util.HashMap;
import java.util.List;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public abstract class DownloadService
extends Service {
    public static final String ACTION_INIT = "com.akamai.amp.exoplayer.downloadService.action.INIT";
    private static final String ACTION_RESTART = "com.akamai.amp.exoplayer.downloadService.action.RESTART";
    public static final String ACTION_ADD_DOWNLOAD = "com.akamai.amp.exoplayer.downloadService.action.ADD_DOWNLOAD";
    public static final String ACTION_REMOVE_DOWNLOAD = "com.akamai.amp.exoplayer.downloadService.action.REMOVE_DOWNLOAD";
    public static final String ACTION_REMOVE_ALL_DOWNLOADS = "com.akamai.amp.exoplayer.downloadService.action.REMOVE_ALL_DOWNLOADS";
    public static final String ACTION_RESUME_DOWNLOADS = "com.akamai.amp.exoplayer.downloadService.action.RESUME_DOWNLOADS";
    public static final String ACTION_PAUSE_DOWNLOADS = "com.akamai.amp.exoplayer.downloadService.action.PAUSE_DOWNLOADS";
    public static final String ACTION_SET_STOP_REASON = "com.akamai.amp.exoplayer.downloadService.action.SET_STOP_REASON";
    public static final String ACTION_SET_REQUIREMENTS = "com.akamai.amp.exoplayer.downloadService.action.SET_REQUIREMENTS";
    public static final String KEY_DOWNLOAD_REQUEST = "download_request";
    public static final String KEY_CONTENT_ID = "content_id";
    public static final String KEY_STOP_REASON = "stop_reason";
    public static final String KEY_REQUIREMENTS = "requirements";
    public static final String KEY_FOREGROUND = "foreground";
    public static final int FOREGROUND_NOTIFICATION_ID_NONE = 0;
    public static final long DEFAULT_FOREGROUND_NOTIFICATION_UPDATE_INTERVAL = 1000L;
    private static final String TAG = "DownloadService";
    private static final HashMap<Class<? extends DownloadService>, DownloadManagerHelper> downloadManagerHelpers = new HashMap();
    @Nullable
    private final ForegroundNotificationUpdater foregroundNotificationUpdater;
    @Nullable
    private final String channelId;
    @StringRes
    private final int channelNameResourceId;
    @StringRes
    private final int channelDescriptionResourceId;
    private @MonotonicNonNull DownloadManager downloadManager;
    private int lastStartId;
    private boolean startedInForeground;
    private boolean taskRemoved;
    private boolean isStopped;
    private boolean isDestroyed;

    protected DownloadService(int foregroundNotificationId) {
        this(foregroundNotificationId, 1000L);
    }

    protected DownloadService(int foregroundNotificationId, long foregroundNotificationUpdateInterval) {
        this(foregroundNotificationId, foregroundNotificationUpdateInterval, null, 0, 0);
    }

    @Deprecated
    protected DownloadService(int foregroundNotificationId, long foregroundNotificationUpdateInterval, @Nullable String channelId, @StringRes int channelNameResourceId) {
        this(foregroundNotificationId, foregroundNotificationUpdateInterval, channelId, channelNameResourceId, 0);
    }

    protected DownloadService(int foregroundNotificationId, long foregroundNotificationUpdateInterval, @Nullable String channelId, @StringRes int channelNameResourceId, @StringRes int channelDescriptionResourceId) {
        if (foregroundNotificationId == 0) {
            this.foregroundNotificationUpdater = null;
            this.channelId = null;
            this.channelNameResourceId = 0;
            this.channelDescriptionResourceId = 0;
        } else {
            this.foregroundNotificationUpdater = new ForegroundNotificationUpdater(foregroundNotificationId, foregroundNotificationUpdateInterval);
            this.channelId = channelId;
            this.channelNameResourceId = channelNameResourceId;
            this.channelDescriptionResourceId = channelDescriptionResourceId;
        }
    }

    public static Intent buildAddDownloadIntent(Context context, Class<? extends DownloadService> clazz, DownloadRequest downloadRequest, boolean foreground) {
        return DownloadService.buildAddDownloadIntent(context, clazz, downloadRequest, 0, foreground);
    }

    public static Intent buildAddDownloadIntent(Context context, Class<? extends DownloadService> clazz, DownloadRequest downloadRequest, int stopReason, boolean foreground) {
        return DownloadService.getIntent(context, clazz, ACTION_ADD_DOWNLOAD, foreground).putExtra(KEY_DOWNLOAD_REQUEST, (Parcelable)downloadRequest).putExtra(KEY_STOP_REASON, stopReason);
    }

    public static Intent buildRemoveDownloadIntent(Context context, Class<? extends DownloadService> clazz, String id, boolean foreground) {
        return DownloadService.getIntent(context, clazz, ACTION_REMOVE_DOWNLOAD, foreground).putExtra(KEY_CONTENT_ID, id);
    }

    public static Intent buildRemoveAllDownloadsIntent(Context context, Class<? extends DownloadService> clazz, boolean foreground) {
        return DownloadService.getIntent(context, clazz, ACTION_REMOVE_ALL_DOWNLOADS, foreground);
    }

    public static Intent buildResumeDownloadsIntent(Context context, Class<? extends DownloadService> clazz, boolean foreground) {
        return DownloadService.getIntent(context, clazz, ACTION_RESUME_DOWNLOADS, foreground);
    }

    public static Intent buildPauseDownloadsIntent(Context context, Class<? extends DownloadService> clazz, boolean foreground) {
        return DownloadService.getIntent(context, clazz, ACTION_PAUSE_DOWNLOADS, foreground);
    }

    public static Intent buildSetStopReasonIntent(Context context, Class<? extends DownloadService> clazz, @Nullable String id, int stopReason, boolean foreground) {
        return DownloadService.getIntent(context, clazz, ACTION_SET_STOP_REASON, foreground).putExtra(KEY_CONTENT_ID, id).putExtra(KEY_STOP_REASON, stopReason);
    }

    public static Intent buildSetRequirementsIntent(Context context, Class<? extends DownloadService> clazz, Requirements requirements, boolean foreground) {
        return DownloadService.getIntent(context, clazz, ACTION_SET_REQUIREMENTS, foreground).putExtra(KEY_REQUIREMENTS, (Parcelable)requirements);
    }

    public static void sendAddDownload(Context context, Class<? extends DownloadService> clazz, DownloadRequest downloadRequest, boolean foreground) {
        Intent intent = DownloadService.buildAddDownloadIntent(context, clazz, downloadRequest, foreground);
        DownloadService.startService(context, intent, foreground);
    }

    public static void sendAddDownload(Context context, Class<? extends DownloadService> clazz, DownloadRequest downloadRequest, int stopReason, boolean foreground) {
        Intent intent = DownloadService.buildAddDownloadIntent(context, clazz, downloadRequest, stopReason, foreground);
        DownloadService.startService(context, intent, foreground);
    }

    public static void sendRemoveDownload(Context context, Class<? extends DownloadService> clazz, String id, boolean foreground) {
        Intent intent = DownloadService.buildRemoveDownloadIntent(context, clazz, id, foreground);
        DownloadService.startService(context, intent, foreground);
    }

    public static void sendRemoveAllDownloads(Context context, Class<? extends DownloadService> clazz, boolean foreground) {
        Intent intent = DownloadService.buildRemoveAllDownloadsIntent(context, clazz, foreground);
        DownloadService.startService(context, intent, foreground);
    }

    public static void sendResumeDownloads(Context context, Class<? extends DownloadService> clazz, boolean foreground) {
        Intent intent = DownloadService.buildResumeDownloadsIntent(context, clazz, foreground);
        DownloadService.startService(context, intent, foreground);
    }

    public static void sendPauseDownloads(Context context, Class<? extends DownloadService> clazz, boolean foreground) {
        Intent intent = DownloadService.buildPauseDownloadsIntent(context, clazz, foreground);
        DownloadService.startService(context, intent, foreground);
    }

    public static void sendSetStopReason(Context context, Class<? extends DownloadService> clazz, @Nullable String id, int stopReason, boolean foreground) {
        Intent intent = DownloadService.buildSetStopReasonIntent(context, clazz, id, stopReason, foreground);
        DownloadService.startService(context, intent, foreground);
    }

    public static void sendSetRequirements(Context context, Class<? extends DownloadService> clazz, Requirements requirements, boolean foreground) {
        Intent intent = DownloadService.buildSetRequirementsIntent(context, clazz, requirements, foreground);
        DownloadService.startService(context, intent, foreground);
    }

    public static void start(Context context, Class<? extends DownloadService> clazz) {
        context.startService(DownloadService.getIntent(context, clazz, ACTION_INIT));
    }

    public static void startForeground(Context context, Class<? extends DownloadService> clazz) {
        Intent intent = DownloadService.getIntent(context, clazz, ACTION_INIT, true);
        Util.startForegroundService(context, intent);
    }

    public void onCreate() {
        Class<?> clazz;
        DownloadManagerHelper downloadManagerHelper;
        if (this.channelId != null) {
            NotificationUtil.createNotificationChannel((Context)this, this.channelId, this.channelNameResourceId, this.channelDescriptionResourceId, 2);
        }
        if ((downloadManagerHelper = downloadManagerHelpers.get(clazz = ((Object)((Object)this)).getClass())) == null) {
            boolean foregroundAllowed = this.foregroundNotificationUpdater != null;
            Scheduler scheduler = foregroundAllowed ? this.getScheduler() : null;
            this.downloadManager = this.getDownloadManager();
            this.downloadManager.resumeDownloads();
            downloadManagerHelper = new DownloadManagerHelper(this.getApplicationContext(), this.downloadManager, foregroundAllowed, scheduler, clazz);
            downloadManagerHelpers.put(clazz, downloadManagerHelper);
        } else {
            this.downloadManager = downloadManagerHelper.downloadManager;
        }
        downloadManagerHelper.attachService(this);
    }

    public int onStartCommand(@Nullable Intent intent, int flags, int startId) {
        this.lastStartId = startId;
        this.taskRemoved = false;
        String intentAction = null;
        String contentId = null;
        if (intent != null) {
            intentAction = intent.getAction();
            contentId = intent.getStringExtra(KEY_CONTENT_ID);
            this.startedInForeground |= intent.getBooleanExtra(KEY_FOREGROUND, false) || ACTION_RESTART.equals(intentAction);
        }
        if (intentAction == null) {
            intentAction = ACTION_INIT;
        }
        DownloadManager downloadManager = Assertions.checkNotNull(this.downloadManager);
        switch (intentAction) {
            case "com.akamai.amp.exoplayer.downloadService.action.INIT": 
            case "com.akamai.amp.exoplayer.downloadService.action.RESTART": {
                break;
            }
            case "com.akamai.amp.exoplayer.downloadService.action.ADD_DOWNLOAD": {
                DownloadRequest downloadRequest = (DownloadRequest)Assertions.checkNotNull(intent).getParcelableExtra(KEY_DOWNLOAD_REQUEST);
                if (downloadRequest == null) {
                    Log.e(TAG, "Ignored ADD_DOWNLOAD: Missing download_request extra");
                    break;
                }
                int stopReason = intent.getIntExtra(KEY_STOP_REASON, 0);
                downloadManager.addDownload(downloadRequest, stopReason);
                break;
            }
            case "com.akamai.amp.exoplayer.downloadService.action.REMOVE_DOWNLOAD": {
                if (contentId == null) {
                    Log.e(TAG, "Ignored REMOVE_DOWNLOAD: Missing content_id extra");
                    break;
                }
                downloadManager.removeDownload(contentId);
                break;
            }
            case "com.akamai.amp.exoplayer.downloadService.action.REMOVE_ALL_DOWNLOADS": {
                downloadManager.removeAllDownloads();
                break;
            }
            case "com.akamai.amp.exoplayer.downloadService.action.RESUME_DOWNLOADS": {
                downloadManager.resumeDownloads();
                break;
            }
            case "com.akamai.amp.exoplayer.downloadService.action.PAUSE_DOWNLOADS": {
                downloadManager.pauseDownloads();
                break;
            }
            case "com.akamai.amp.exoplayer.downloadService.action.SET_STOP_REASON": {
                if (!Assertions.checkNotNull(intent).hasExtra(KEY_STOP_REASON)) {
                    Log.e(TAG, "Ignored SET_STOP_REASON: Missing stop_reason extra");
                    break;
                }
                int stopReason = intent.getIntExtra(KEY_STOP_REASON, 0);
                downloadManager.setStopReason(contentId, stopReason);
                break;
            }
            case "com.akamai.amp.exoplayer.downloadService.action.SET_REQUIREMENTS": {
                Requirements supportedRequirements;
                Requirements requirements = (Requirements)Assertions.checkNotNull(intent).getParcelableExtra(KEY_REQUIREMENTS);
                if (requirements == null) {
                    Log.e(TAG, "Ignored SET_REQUIREMENTS: Missing requirements extra");
                    break;
                }
                Scheduler scheduler = this.getScheduler();
                if (scheduler != null && !(supportedRequirements = scheduler.getSupportedRequirements(requirements)).equals(requirements)) {
                    Log.w(TAG, "Ignoring requirements not supported by the Scheduler: " + (requirements.getRequirements() ^ supportedRequirements.getRequirements()));
                    requirements = supportedRequirements;
                }
                downloadManager.setRequirements(requirements);
                break;
            }
            default: {
                Log.e(TAG, "Ignored unrecognized action: " + intentAction);
            }
        }
        if (Util.SDK_INT >= 26 && this.startedInForeground && this.foregroundNotificationUpdater != null) {
            this.foregroundNotificationUpdater.showNotificationIfNotAlready();
        }
        this.isStopped = false;
        if (downloadManager.isIdle()) {
            this.stop();
        }
        return 1;
    }

    public void onTaskRemoved(Intent rootIntent) {
        this.taskRemoved = true;
    }

    public void onDestroy() {
        this.isDestroyed = true;
        DownloadManagerHelper downloadManagerHelper = Assertions.checkNotNull(downloadManagerHelpers.get(((Object)((Object)this)).getClass()));
        downloadManagerHelper.detachService(this);
        if (this.foregroundNotificationUpdater != null) {
            this.foregroundNotificationUpdater.stopPeriodicUpdates();
        }
    }

    @Nullable
    public final IBinder onBind(Intent intent) {
        throw new UnsupportedOperationException();
    }

    protected abstract DownloadManager getDownloadManager();

    @Nullable
    protected abstract Scheduler getScheduler();

    protected abstract Notification getForegroundNotification(List<Download> var1);

    protected final void invalidateForegroundNotification() {
        if (this.foregroundNotificationUpdater != null && !this.isDestroyed) {
            this.foregroundNotificationUpdater.invalidate();
        }
    }

    @Deprecated
    protected void onDownloadChanged(Download download) {
    }

    @Deprecated
    protected void onDownloadRemoved(Download download) {
    }

    private void notifyDownloads(List<Download> downloads) {
        if (this.foregroundNotificationUpdater != null) {
            for (int i = 0; i < downloads.size(); ++i) {
                if (!DownloadService.needsStartedService(downloads.get((int)i).state)) continue;
                this.foregroundNotificationUpdater.startPeriodicUpdates();
                break;
            }
        }
    }

    private void notifyDownloadChanged(Download download) {
        this.onDownloadChanged(download);
        if (this.foregroundNotificationUpdater != null) {
            if (DownloadService.needsStartedService(download.state)) {
                this.foregroundNotificationUpdater.startPeriodicUpdates();
            } else {
                this.foregroundNotificationUpdater.invalidate();
            }
        }
    }

    private void notifyDownloadRemoved(Download download) {
        this.onDownloadRemoved(download);
        if (this.foregroundNotificationUpdater != null) {
            this.foregroundNotificationUpdater.invalidate();
        }
    }

    private boolean isStopped() {
        return this.isStopped;
    }

    private void stop() {
        if (this.foregroundNotificationUpdater != null) {
            this.foregroundNotificationUpdater.stopPeriodicUpdates();
        }
        if (Util.SDK_INT < 28 && this.taskRemoved) {
            this.stopSelf();
            this.isStopped = true;
        } else {
            this.isStopped |= this.stopSelfResult(this.lastStartId);
        }
    }

    private static boolean needsStartedService(int state) {
        return state == 2 || state == 5 || state == 7;
    }

    private static Intent getIntent(Context context, Class<? extends DownloadService> clazz, String action, boolean foreground) {
        return DownloadService.getIntent(context, clazz, action).putExtra(KEY_FOREGROUND, foreground);
    }

    private static Intent getIntent(Context context, Class<? extends DownloadService> clazz, String action) {
        return new Intent(context, clazz).setAction(action);
    }

    private static void startService(Context context, Intent intent, boolean foreground) {
        if (foreground) {
            Util.startForegroundService(context, intent);
        } else {
            context.startService(intent);
        }
    }

    private final class ForegroundNotificationUpdater {
        private final int notificationId;
        private final long updateInterval;
        private final Handler handler;
        private boolean periodicUpdatesStarted;
        private boolean notificationDisplayed;

        public ForegroundNotificationUpdater(int notificationId, long updateInterval) {
            this.notificationId = notificationId;
            this.updateInterval = updateInterval;
            this.handler = new Handler(Looper.getMainLooper());
        }

        public void startPeriodicUpdates() {
            this.periodicUpdatesStarted = true;
            this.update();
        }

        public void stopPeriodicUpdates() {
            this.periodicUpdatesStarted = false;
            this.handler.removeCallbacksAndMessages(null);
        }

        public void showNotificationIfNotAlready() {
            if (!this.notificationDisplayed) {
                this.update();
            }
        }

        public void invalidate() {
            if (this.notificationDisplayed) {
                this.update();
            }
        }

        private void update() {
            List<Download> downloads = Assertions.checkNotNull(DownloadService.this.downloadManager).getCurrentDownloads();
            Notification notification = DownloadService.this.getForegroundNotification(downloads);
            if (Build.VERSION.SDK_INT >= 34) {
                DownloadService.this.startForeground(this.notificationId, notification, 1);
            } else {
                DownloadService.this.startForeground(this.notificationId, notification);
            }
            this.notificationDisplayed = true;
            if (this.periodicUpdatesStarted) {
                this.handler.removeCallbacksAndMessages(null);
                this.handler.postDelayed(this::update, this.updateInterval);
            }
        }
    }

    private static final class DownloadManagerHelper
    implements DownloadManager.Listener {
        private final Context context;
        private final DownloadManager downloadManager;
        private final boolean foregroundAllowed;
        @Nullable
        private final Scheduler scheduler;
        private final Class<? extends DownloadService> serviceClass;
        @Nullable
        private DownloadService downloadService;

        private DownloadManagerHelper(Context context, DownloadManager downloadManager, boolean foregroundAllowed, @Nullable Scheduler scheduler, Class<? extends DownloadService> serviceClass) {
            this.context = context;
            this.downloadManager = downloadManager;
            this.foregroundAllowed = foregroundAllowed;
            this.scheduler = scheduler;
            this.serviceClass = serviceClass;
            downloadManager.addListener(this);
            this.updateScheduler();
        }

        public void attachService(DownloadService downloadService) {
            Assertions.checkState(this.downloadService == null);
            this.downloadService = downloadService;
            if (this.downloadManager.isInitialized()) {
                Util.createHandlerForCurrentOrMainLooper().postAtFrontOfQueue(() -> downloadService.notifyDownloads(this.downloadManager.getCurrentDownloads()));
            }
        }

        public void detachService(DownloadService downloadService) {
            Assertions.checkState(this.downloadService == downloadService);
            this.downloadService = null;
            if (this.scheduler != null && !this.downloadManager.isWaitingForRequirements()) {
                this.scheduler.cancel();
            }
        }

        @Override
        public void onInitialized(DownloadManager downloadManager) {
            if (this.downloadService != null) {
                this.downloadService.notifyDownloads(downloadManager.getCurrentDownloads());
            }
        }

        @Override
        public void onDownloadChanged(DownloadManager downloadManager, Download download, @Nullable Exception finalException) {
            if (this.downloadService != null) {
                this.downloadService.notifyDownloadChanged(download);
            }
            if (this.serviceMayNeedRestart() && DownloadService.needsStartedService(download.state)) {
                Log.w(DownloadService.TAG, "DownloadService wasn't running. Restarting.");
                this.restartService();
            }
        }

        @Override
        public void onDownloadRemoved(DownloadManager downloadManager, Download download) {
            if (this.downloadService != null) {
                this.downloadService.notifyDownloadRemoved(download);
            }
        }

        @Override
        public final void onIdle(DownloadManager downloadManager) {
            if (this.downloadService != null) {
                this.downloadService.stop();
            }
        }

        @Override
        public void onWaitingForRequirementsChanged(DownloadManager downloadManager, boolean waitingForRequirements) {
            if (!waitingForRequirements && !downloadManager.getDownloadsPaused() && this.serviceMayNeedRestart()) {
                List<Download> downloads = downloadManager.getCurrentDownloads();
                for (int i = 0; i < downloads.size(); ++i) {
                    if (downloads.get((int)i).state != 0) continue;
                    this.restartService();
                    break;
                }
            }
            this.updateScheduler();
        }

        private boolean serviceMayNeedRestart() {
            return this.downloadService == null || this.downloadService.isStopped();
        }

        private void restartService() {
            if (this.foregroundAllowed) {
                Intent intent = DownloadService.getIntent(this.context, this.serviceClass, DownloadService.ACTION_RESTART);
                Util.startForegroundService(this.context, intent);
            } else {
                try {
                    Intent intent = DownloadService.getIntent(this.context, this.serviceClass, DownloadService.ACTION_INIT);
                    this.context.startService(intent);
                }
                catch (IllegalStateException e) {
                    Log.w(DownloadService.TAG, "Failed to restart DownloadService (process is idle).");
                }
            }
        }

        private void updateScheduler() {
            if (this.scheduler == null) {
                return;
            }
            if (this.downloadManager.isWaitingForRequirements()) {
                String servicePackage = this.context.getPackageName();
                Requirements requirements = this.downloadManager.getRequirements();
                boolean success = this.scheduler.schedule(requirements, servicePackage, DownloadService.ACTION_RESTART);
                if (!success) {
                    Log.e(DownloadService.TAG, "Scheduling downloads failed.");
                }
            } else {
                this.scheduler.cancel();
            }
        }
    }
}

