/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.mediacodec;

import com.akamai.amp.exoplayer2.Format;
import com.akamai.amp.exoplayer2.audio.MpegAudioUtil;
import com.akamai.amp.exoplayer2.decoder.DecoderInputBuffer;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.Log;
import java.nio.ByteBuffer;

final class C2Mp3TimestampTracker {
    private static final long DECODER_DELAY_SAMPLES = 529L;
    private static final String TAG = "C2Mp3TimestampTracker";
    private long processedSamples;
    private long anchorTimestampUs;
    private boolean seenInvalidMpegAudioHeader;

    C2Mp3TimestampTracker() {
    }

    public void reset() {
        this.processedSamples = 0L;
        this.anchorTimestampUs = 0L;
        this.seenInvalidMpegAudioHeader = false;
    }

    public long updateAndGetPresentationTimeUs(Format format, DecoderInputBuffer buffer) {
        if (this.seenInvalidMpegAudioHeader) {
            return buffer.timeUs;
        }
        ByteBuffer data = Assertions.checkNotNull(buffer.data);
        int sampleHeaderData = 0;
        for (int i = 0; i < 4; ++i) {
            sampleHeaderData <<= 8;
            sampleHeaderData |= data.get(i) & 0xFF;
        }
        int frameCount = MpegAudioUtil.parseMpegAudioFrameSampleCount(sampleHeaderData);
        if (frameCount == -1) {
            this.seenInvalidMpegAudioHeader = true;
            Log.w(TAG, "MPEG audio header is invalid.");
            return buffer.timeUs;
        }
        if (this.processedSamples == 0L) {
            this.anchorTimestampUs = buffer.timeUs;
            this.processedSamples = (long)frameCount - 529L;
            return this.anchorTimestampUs;
        }
        long processedDurationUs = this.getProcessedDurationUs(format);
        this.processedSamples += (long)frameCount;
        return this.anchorTimestampUs + processedDurationUs;
    }

    private long getProcessedDurationUs(Format format) {
        return this.processedSamples * 1000000L / (long)format.sampleRate;
    }
}

