/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.mediacodec;

import android.media.MediaCodec;
import android.media.MediaCrypto;
import android.media.MediaFormat;
import android.os.Handler;
import android.os.HandlerThread;
import android.view.Surface;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import com.akamai.amp.exoplayer2.decoder.CryptoInfo;
import com.akamai.amp.exoplayer2.mediacodec.AsynchronousMediaCodecBufferEnqueuer;
import com.akamai.amp.exoplayer2.mediacodec.MediaCodecAdapter;
import com.akamai.amp.exoplayer2.mediacodec.MediaCodecAsyncCallback;
import com.akamai.amp.exoplayer2.mediacodec.MediaCodecInputBufferEnqueuer;
import com.akamai.amp.exoplayer2.mediacodec.SynchronousMediaCodecBufferEnqueuer;
import com.akamai.amp.exoplayer2.util.Util;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@RequiresApi(value=23)
final class AsynchronousMediaCodecAdapter
extends MediaCodec.Callback
implements MediaCodecAdapter {
    private static final int STATE_CREATED = 0;
    private static final int STATE_CONFIGURED = 1;
    private static final int STATE_STARTED = 2;
    private static final int STATE_SHUT_DOWN = 3;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private final MediaCodecAsyncCallback mediaCodecAsyncCallback = new MediaCodecAsyncCallback();
    private final MediaCodec codec;
    private final HandlerThread handlerThread;
    private @MonotonicNonNull Handler handler;
    @GuardedBy(value="lock")
    private long pendingFlushCount;
    private int state;
    private final MediaCodecInputBufferEnqueuer bufferEnqueuer;
    @GuardedBy(value="lock")
    @Nullable
    private IllegalStateException internalException;

    AsynchronousMediaCodecAdapter(MediaCodec codec, int trackType) {
        this(codec, false, trackType, new HandlerThread(AsynchronousMediaCodecAdapter.createThreadLabel(trackType)));
    }

    AsynchronousMediaCodecAdapter(MediaCodec codec, boolean enableAsynchronousQueueing, int trackType) {
        this(codec, enableAsynchronousQueueing, trackType, new HandlerThread(AsynchronousMediaCodecAdapter.createThreadLabel(trackType)));
    }

    @VisibleForTesting
    AsynchronousMediaCodecAdapter(MediaCodec codec, boolean enableAsynchronousQueueing, int trackType, HandlerThread handlerThread) {
        this.codec = codec;
        this.handlerThread = handlerThread;
        this.bufferEnqueuer = enableAsynchronousQueueing ? new AsynchronousMediaCodecBufferEnqueuer(codec, trackType) : new SynchronousMediaCodecBufferEnqueuer(this.codec);
        this.state = 0;
    }

    @Override
    public void configure(@Nullable MediaFormat mediaFormat, @Nullable Surface surface, @Nullable MediaCrypto crypto, int flags) {
        this.handlerThread.start();
        this.handler = new Handler(this.handlerThread.getLooper());
        this.codec.setCallback((MediaCodec.Callback)this, this.handler);
        this.codec.configure(mediaFormat, surface, crypto, flags);
        this.state = 1;
    }

    @Override
    public void start() {
        this.bufferEnqueuer.start();
        this.codec.start();
        this.state = 2;
    }

    @Override
    public void queueInputBuffer(int index, int offset, int size, long presentationTimeUs, int flags) {
        this.bufferEnqueuer.queueInputBuffer(index, offset, size, presentationTimeUs, flags);
    }

    @Override
    public void queueSecureInputBuffer(int index, int offset, CryptoInfo info, long presentationTimeUs, int flags) {
        this.bufferEnqueuer.queueSecureInputBuffer(index, offset, info, presentationTimeUs, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int dequeueInputBufferIndex() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isFlushing()) {
                return -1;
            }
            this.maybeThrowException();
            return this.mediaCodecAsyncCallback.dequeueInputBufferIndex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int dequeueOutputBufferIndex(MediaCodec.BufferInfo bufferInfo) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isFlushing()) {
                return -1;
            }
            this.maybeThrowException();
            return this.mediaCodecAsyncCallback.dequeueOutputBufferIndex(bufferInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MediaFormat getOutputFormat() {
        Object object = this.lock;
        synchronized (object) {
            return this.mediaCodecAsyncCallback.getOutputFormat();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        Object object = this.lock;
        synchronized (object) {
            this.bufferEnqueuer.flush();
            this.codec.flush();
            ++this.pendingFlushCount;
            Util.castNonNull(this.handler).post(this::onFlushCompleted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Object object = this.lock;
        synchronized (object) {
            if (this.state == 2) {
                this.bufferEnqueuer.shutdown();
            }
            if (this.state == 1 || this.state == 2) {
                this.handlerThread.quit();
                this.mediaCodecAsyncCallback.flush();
                ++this.pendingFlushCount;
            }
            this.state = 3;
        }
    }

    @Override
    public MediaCodec getCodec() {
        return this.codec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onInputBufferAvailable(MediaCodec codec, int index) {
        Object object = this.lock;
        synchronized (object) {
            this.mediaCodecAsyncCallback.onInputBufferAvailable(codec, index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOutputBufferAvailable(MediaCodec codec, int index, MediaCodec.BufferInfo info) {
        Object object = this.lock;
        synchronized (object) {
            this.mediaCodecAsyncCallback.onOutputBufferAvailable(codec, index, info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(MediaCodec codec, MediaCodec.CodecException e) {
        Object object = this.lock;
        synchronized (object) {
            this.mediaCodecAsyncCallback.onError(codec, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOutputFormatChanged(MediaCodec codec, MediaFormat format) {
        Object object = this.lock;
        synchronized (object) {
            this.mediaCodecAsyncCallback.onOutputFormatChanged(codec, format);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onFlushCompleted() {
        Object object = this.lock;
        synchronized (object) {
            this.onFlushCompletedSynchronized();
        }
    }

    @GuardedBy(value="lock")
    private void onFlushCompletedSynchronized() {
        if (this.state == 3) {
            return;
        }
        --this.pendingFlushCount;
        if (this.pendingFlushCount > 0L) {
            return;
        }
        if (this.pendingFlushCount < 0L) {
            this.internalException = new IllegalStateException();
            return;
        }
        this.mediaCodecAsyncCallback.flush();
        try {
            this.codec.start();
        }
        catch (IllegalStateException e) {
            this.internalException = e;
        }
        catch (Exception e) {
            this.internalException = new IllegalStateException(e);
        }
    }

    @GuardedBy(value="lock")
    private boolean isFlushing() {
        return this.pendingFlushCount > 0L;
    }

    @GuardedBy(value="lock")
    private void maybeThrowException() {
        this.maybeThrowInternalException();
        this.mediaCodecAsyncCallback.maybeThrowMediaCodecException();
    }

    @GuardedBy(value="lock")
    private void maybeThrowInternalException() {
        if (this.internalException != null) {
            IllegalStateException e = this.internalException;
            this.internalException = null;
            throw e;
        }
    }

    private static String createThreadLabel(int trackType) {
        StringBuilder labelBuilder = new StringBuilder("ExoPlayer:MediaCodecAsyncAdapter:");
        if (trackType == 1) {
            labelBuilder.append("Audio");
        } else if (trackType == 2) {
            labelBuilder.append("Video");
        } else {
            labelBuilder.append("Unknown(").append(trackType).append(")");
        }
        return labelBuilder.toString();
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface State {
    }
}

