/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.extractor.mp3;

import androidx.annotation.VisibleForTesting;
import com.akamai.amp.exoplayer2.extractor.SeekMap;
import com.akamai.amp.exoplayer2.extractor.SeekPoint;
import com.akamai.amp.exoplayer2.extractor.mp3.Seeker;
import com.akamai.amp.exoplayer2.util.LongArray;
import com.akamai.amp.exoplayer2.util.Util;

final class IndexSeeker
implements Seeker {
    @VisibleForTesting
    static final long MIN_TIME_BETWEEN_POINTS_US = 100000L;
    private final long dataEndPosition;
    private final LongArray timesUs;
    private final LongArray positions;
    private long durationUs;

    public IndexSeeker(long durationUs, long dataStartPosition, long dataEndPosition) {
        this.durationUs = durationUs;
        this.dataEndPosition = dataEndPosition;
        this.timesUs = new LongArray();
        this.positions = new LongArray();
        this.timesUs.add(0L);
        this.positions.add(dataStartPosition);
    }

    @Override
    public long getTimeUs(long position) {
        int targetIndex = Util.binarySearchFloor(this.positions, position, true, true);
        return this.timesUs.get(targetIndex);
    }

    @Override
    public long getDataEndPosition() {
        return this.dataEndPosition;
    }

    @Override
    public boolean isSeekable() {
        return true;
    }

    @Override
    public long getDurationUs() {
        return this.durationUs;
    }

    @Override
    public SeekMap.SeekPoints getSeekPoints(long timeUs) {
        int targetIndex = Util.binarySearchFloor(this.timesUs, timeUs, true, true);
        SeekPoint seekPoint = new SeekPoint(this.timesUs.get(targetIndex), this.positions.get(targetIndex));
        if (seekPoint.timeUs == timeUs || targetIndex == this.timesUs.size() - 1) {
            return new SeekMap.SeekPoints(seekPoint);
        }
        SeekPoint nextSeekPoint = new SeekPoint(this.timesUs.get(targetIndex + 1), this.positions.get(targetIndex + 1));
        return new SeekMap.SeekPoints(seekPoint, nextSeekPoint);
    }

    public void maybeAddSeekPoint(long timeUs, long position) {
        if (this.isTimeUsInIndex(timeUs)) {
            return;
        }
        this.timesUs.add(timeUs);
        this.positions.add(position);
    }

    public boolean isTimeUsInIndex(long timeUs) {
        long lastIndexedTimeUs = this.timesUs.get(this.timesUs.size() - 1);
        return timeUs - lastIndexedTimeUs < 100000L;
    }

    void setDurationUs(long durationUs) {
        this.durationUs = durationUs;
    }
}

