/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.audio;

import com.akamai.amp.exoplayer2.audio.AudioProcessor;
import com.akamai.amp.exoplayer2.audio.BaseAudioProcessor;
import com.akamai.amp.exoplayer2.util.Util;
import java.nio.ByteBuffer;

final class ResamplingAudioProcessor
extends BaseAudioProcessor {
    ResamplingAudioProcessor() {
    }

    @Override
    public AudioProcessor.AudioFormat onConfigure(AudioProcessor.AudioFormat inputAudioFormat) throws AudioProcessor.UnhandledAudioFormatException {
        int encoding = inputAudioFormat.encoding;
        if (encoding != 3 && encoding != 2 && encoding != 0x10000000 && encoding != 0x20000000 && encoding != 0x30000000 && encoding != 4) {
            throw new AudioProcessor.UnhandledAudioFormatException(inputAudioFormat);
        }
        return encoding != 2 ? new AudioProcessor.AudioFormat(inputAudioFormat.sampleRate, inputAudioFormat.channelCount, 2) : AudioProcessor.AudioFormat.NOT_SET;
    }

    @Override
    public void queueInput(ByteBuffer inputBuffer) {
        int position = inputBuffer.position();
        int limit = inputBuffer.limit();
        int size = limit - position;
        ByteBuffer buffer = this.replaceOutputBuffer(switch (this.inputAudioFormat.encoding) {
            case 3 -> size * 2;
            case 0x10000000 -> size;
            case 0x20000000 -> size / 3 * 2;
            case 4, 0x30000000 -> size / 2;
            default -> throw new IllegalStateException();
        });
        switch (this.inputAudioFormat.encoding) {
            case 3: {
                for (int i = position; i < limit; ++i) {
                    buffer.put((byte)0);
                    buffer.put((byte)((inputBuffer.get(i) & 0xFF) - 128));
                }
                break;
            }
            case 0x10000000: {
                for (int i = position; i < limit; i += 2) {
                    buffer.put(inputBuffer.get(i + 1));
                    buffer.put(inputBuffer.get(i));
                }
                break;
            }
            case 0x20000000: {
                for (int i = position; i < limit; i += 3) {
                    buffer.put(inputBuffer.get(i + 1));
                    buffer.put(inputBuffer.get(i + 2));
                }
                break;
            }
            case 0x30000000: {
                for (int i = position; i < limit; i += 4) {
                    buffer.put(inputBuffer.get(i + 2));
                    buffer.put(inputBuffer.get(i + 3));
                }
                break;
            }
            case 4: {
                for (int i = position; i < limit; i += 4) {
                    float floatValue = Util.constrainValue(inputBuffer.getFloat(i), -1.0f, 1.0f);
                    short shortValue = (short)(floatValue * 32767.0f);
                    buffer.put((byte)(shortValue & 0xFF));
                    buffer.put((byte)(shortValue >> 8 & 0xFF));
                }
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        inputBuffer.position(inputBuffer.limit());
        buffer.flip();
    }
}

