/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.media.PlaybackParams;
import android.os.Handler;
import android.os.Looper;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.TextureView;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import com.akamai.amp.exoplayer2.AudioBecomingNoisyManager;
import com.akamai.amp.exoplayer2.AudioFocusManager;
import com.akamai.amp.exoplayer2.BasePlayer;
import com.akamai.amp.exoplayer2.DefaultLoadControl;
import com.akamai.amp.exoplayer2.DefaultRenderersFactory;
import com.akamai.amp.exoplayer2.ExoPlaybackException;
import com.akamai.amp.exoplayer2.ExoPlayer;
import com.akamai.amp.exoplayer2.ExoPlayerImpl;
import com.akamai.amp.exoplayer2.Format;
import com.akamai.amp.exoplayer2.LoadControl;
import com.akamai.amp.exoplayer2.MediaItem;
import com.akamai.amp.exoplayer2.PlaybackParameters;
import com.akamai.amp.exoplayer2.Player;
import com.akamai.amp.exoplayer2.PlayerMessage;
import com.akamai.amp.exoplayer2.Renderer;
import com.akamai.amp.exoplayer2.RenderersFactory;
import com.akamai.amp.exoplayer2.SeekParameters;
import com.akamai.amp.exoplayer2.StreamVolumeManager;
import com.akamai.amp.exoplayer2.Timeline;
import com.akamai.amp.exoplayer2.WakeLockManager;
import com.akamai.amp.exoplayer2.WifiLockManager;
import com.akamai.amp.exoplayer2.ampcustom.AmpBasePlayer;
import com.akamai.amp.exoplayer2.analytics.AnalyticsCollector;
import com.akamai.amp.exoplayer2.analytics.AnalyticsListener;
import com.akamai.amp.exoplayer2.audio.AudioAttributes;
import com.akamai.amp.exoplayer2.audio.AudioListener;
import com.akamai.amp.exoplayer2.audio.AudioRendererEventListener;
import com.akamai.amp.exoplayer2.audio.AuxEffectInfo;
import com.akamai.amp.exoplayer2.decoder.DecoderCounters;
import com.akamai.amp.exoplayer2.device.DeviceInfo;
import com.akamai.amp.exoplayer2.device.DeviceListener;
import com.akamai.amp.exoplayer2.extractor.DefaultExtractorsFactory;
import com.akamai.amp.exoplayer2.extractor.ExtractorsFactory;
import com.akamai.amp.exoplayer2.metadata.Metadata;
import com.akamai.amp.exoplayer2.metadata.MetadataOutput;
import com.akamai.amp.exoplayer2.source.DefaultMediaSourceFactory;
import com.akamai.amp.exoplayer2.source.MediaSource;
import com.akamai.amp.exoplayer2.source.MediaSourceFactory;
import com.akamai.amp.exoplayer2.source.ShuffleOrder;
import com.akamai.amp.exoplayer2.source.TrackGroupArray;
import com.akamai.amp.exoplayer2.text.Cue;
import com.akamai.amp.exoplayer2.text.TextOutput;
import com.akamai.amp.exoplayer2.trackselection.DefaultTrackSelector;
import com.akamai.amp.exoplayer2.trackselection.TrackSelectionArray;
import com.akamai.amp.exoplayer2.trackselection.TrackSelector;
import com.akamai.amp.exoplayer2.upstream.BandwidthMeter;
import com.akamai.amp.exoplayer2.upstream.DefaultBandwidthMeter;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.Clock;
import com.akamai.amp.exoplayer2.util.Log;
import com.akamai.amp.exoplayer2.util.PriorityTaskManager;
import com.akamai.amp.exoplayer2.util.Util;
import com.akamai.amp.exoplayer2.video.VideoDecoderOutputBufferRenderer;
import com.akamai.amp.exoplayer2.video.VideoFrameMetadataListener;
import com.akamai.amp.exoplayer2.video.VideoRendererEventListener;
import com.akamai.amp.exoplayer2.video.spherical.CameraMotionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;

public class SimpleExoPlayer
extends BasePlayer
implements ExoPlayer,
Player.AudioComponent,
Player.VideoComponent,
Player.TextComponent,
Player.MetadataComponent,
Player.DeviceComponent {
    private static final String TAG = "SimpleExoPlayer";
    private static final String WRONG_THREAD_ERROR_MESSAGE = "Player is accessed on the wrong thread. See https://exoplayer.dev/issues/player-accessed-on-wrong-thread";
    protected final Renderer[] renderers;
    private final ExoPlayerImpl player;
    private final ComponentListener componentListener;
    private final CopyOnWriteArraySet<com.akamai.amp.exoplayer2.video.VideoListener> videoListeners;
    private final CopyOnWriteArraySet<AudioListener> audioListeners;
    private final CopyOnWriteArraySet<TextOutput> textOutputs;
    private final CopyOnWriteArraySet<MetadataOutput> metadataOutputs;
    private final CopyOnWriteArraySet<DeviceListener> deviceListeners;
    private final CopyOnWriteArraySet<VideoRendererEventListener> videoDebugListeners;
    private final CopyOnWriteArraySet<AudioRendererEventListener> audioDebugListeners;
    private final AnalyticsCollector analyticsCollector;
    private final AudioBecomingNoisyManager audioBecomingNoisyManager;
    private final AudioFocusManager audioFocusManager;
    private final StreamVolumeManager streamVolumeManager;
    private final WakeLockManager wakeLockManager;
    private final WifiLockManager wifiLockManager;
    @Nullable
    private Format videoFormat;
    @Nullable
    private Format audioFormat;
    @Nullable
    private VideoDecoderOutputBufferRenderer videoDecoderOutputBufferRenderer;
    @Nullable
    private Surface surface;
    private boolean ownsSurface;
    private int videoScalingMode;
    @Nullable
    private SurfaceHolder surfaceHolder;
    @Nullable
    private TextureView textureView;
    private int surfaceWidth;
    private int surfaceHeight;
    @Nullable
    private DecoderCounters videoDecoderCounters;
    @Nullable
    private DecoderCounters audioDecoderCounters;
    private int audioSessionId;
    private AudioAttributes audioAttributes;
    private float audioVolume;
    private boolean skipSilenceEnabled;
    private List<Cue> currentCues;
    @Nullable
    private VideoFrameMetadataListener videoFrameMetadataListener;
    @Nullable
    private CameraMotionListener cameraMotionListener;
    private boolean throwsWhenUsingWrongThread;
    private boolean hasNotifiedFullWrongThreadWarning;
    @Nullable
    private PriorityTaskManager priorityTaskManager;
    private boolean isPriorityTaskManagerRegistered;
    private boolean playerReleased;
    private DeviceInfo deviceInfo;

    @Deprecated
    protected SimpleExoPlayer(Context context, RenderersFactory renderersFactory, TrackSelector trackSelector, MediaSourceFactory mediaSourceFactory, LoadControl loadControl, BandwidthMeter bandwidthMeter, AnalyticsCollector analyticsCollector, boolean useLazyPreparation, Clock clock, Looper applicationLooper) {
        this(new Builder(context, renderersFactory).setTrackSelector(trackSelector).setMediaSourceFactory(mediaSourceFactory).setLoadControl(loadControl).setBandwidthMeter(bandwidthMeter).setAnalyticsCollector(analyticsCollector).setUseLazyPreparation(useLazyPreparation).setClock(clock).setLooper(applicationLooper));
    }

    protected SimpleExoPlayer(Builder builder) {
        this.analyticsCollector = builder.analyticsCollector;
        this.priorityTaskManager = builder.priorityTaskManager;
        this.audioAttributes = builder.audioAttributes;
        this.videoScalingMode = builder.videoScalingMode;
        this.skipSilenceEnabled = builder.skipSilenceEnabled;
        this.componentListener = new ComponentListener();
        this.videoListeners = new CopyOnWriteArraySet();
        this.audioListeners = new CopyOnWriteArraySet();
        this.textOutputs = new CopyOnWriteArraySet();
        this.metadataOutputs = new CopyOnWriteArraySet();
        this.deviceListeners = new CopyOnWriteArraySet();
        this.videoDebugListeners = new CopyOnWriteArraySet();
        this.audioDebugListeners = new CopyOnWriteArraySet();
        Handler eventHandler = new Handler(builder.looper);
        this.renderers = builder.renderersFactory.createRenderers(eventHandler, this.componentListener, this.componentListener, this.componentListener, this.componentListener);
        this.audioVolume = 1.0f;
        this.audioSessionId = 0;
        this.currentCues = Collections.emptyList();
        this.player = new ExoPlayerImpl(this.renderers, builder.trackSelector, builder.mediaSourceFactory, builder.loadControl, builder.bandwidthMeter, this.analyticsCollector, builder.useLazyPreparation, builder.seekParameters, builder.pauseAtEndOfMediaItems, builder.clock, builder.looper);
        this.player.addListener(this.componentListener);
        this.videoDebugListeners.add(this.analyticsCollector);
        this.videoListeners.add(this.analyticsCollector);
        this.audioDebugListeners.add(this.analyticsCollector);
        this.audioListeners.add(this.analyticsCollector);
        this.addMetadataOutput(this.analyticsCollector);
        this.audioBecomingNoisyManager = new AudioBecomingNoisyManager(builder.context, eventHandler, this.componentListener);
        this.audioBecomingNoisyManager.setEnabled(builder.handleAudioBecomingNoisy);
        this.audioFocusManager = new AudioFocusManager(builder.context, eventHandler, this.componentListener);
        this.audioFocusManager.setAudioAttributes(builder.handleAudioFocus ? this.audioAttributes : null);
        this.streamVolumeManager = new StreamVolumeManager(builder.context, eventHandler, this.componentListener);
        this.streamVolumeManager.setStreamType(Util.getStreamTypeForAudioUsage(this.audioAttributes.usage));
        this.wakeLockManager = new WakeLockManager(builder.context);
        this.wakeLockManager.setEnabled(builder.wakeMode != 0);
        this.wifiLockManager = new WifiLockManager(builder.context);
        this.wifiLockManager.setEnabled(builder.wakeMode == 2);
        this.deviceInfo = SimpleExoPlayer.createDeviceInfo(this.streamVolumeManager);
        if (!builder.throwWhenStuckBuffering) {
            this.player.experimentalDisableThrowWhenStuckBuffering();
        }
        this.sendRendererMessage(1, 3, this.audioAttributes);
        this.sendRendererMessage(2, 4, this.videoScalingMode);
        this.sendRendererMessage(1, 101, this.skipSilenceEnabled);
    }

    @Override
    public void experimentalSetOffloadSchedulingEnabled(boolean offloadSchedulingEnabled) {
        this.player.experimentalSetOffloadSchedulingEnabled(offloadSchedulingEnabled);
    }

    @Override
    @Nullable
    public Player.AudioComponent getAudioComponent() {
        return this;
    }

    @Override
    @Nullable
    public Player.VideoComponent getVideoComponent() {
        return this;
    }

    @Override
    @Nullable
    public Player.TextComponent getTextComponent() {
        return this;
    }

    @Override
    @Nullable
    public Player.MetadataComponent getMetadataComponent() {
        return this;
    }

    @Override
    @Nullable
    public Player.DeviceComponent getDeviceComponent() {
        return this;
    }

    @Override
    public void setVideoScalingMode(int videoScalingMode) {
        this.verifyApplicationThread();
        this.videoScalingMode = videoScalingMode;
        this.sendRendererMessage(2, 4, videoScalingMode);
    }

    public List<Cue> getCueByPosition(long position) {
        return new ArrayList<Cue>();
    }

    @Override
    public int getVideoScalingMode() {
        return this.videoScalingMode;
    }

    @Override
    public void clearVideoSurface() {
        this.verifyApplicationThread();
        this.removeSurfaceCallbacks();
        this.setVideoSurfaceInternal(null, false);
        this.maybeNotifySurfaceSizeChanged(0, 0);
    }

    @Override
    public void clearVideoSurface(@Nullable Surface surface) {
        this.verifyApplicationThread();
        if (surface != null && surface == this.surface) {
            this.clearVideoSurface();
        }
    }

    @Override
    public void setVideoSurface(@Nullable Surface surface) {
        this.verifyApplicationThread();
        this.removeSurfaceCallbacks();
        if (surface != null) {
            this.clearVideoDecoderOutputBufferRenderer();
        }
        this.setVideoSurfaceInternal(surface, false);
        int newSurfaceSize = surface == null ? 0 : -1;
        this.maybeNotifySurfaceSizeChanged(newSurfaceSize, newSurfaceSize);
    }

    @Override
    public void setVideoSurfaceHolder(@Nullable SurfaceHolder surfaceHolder) {
        this.verifyApplicationThread();
        this.removeSurfaceCallbacks();
        if (surfaceHolder != null) {
            this.clearVideoDecoderOutputBufferRenderer();
        }
        this.surfaceHolder = surfaceHolder;
        if (surfaceHolder == null) {
            this.setVideoSurfaceInternal(null, false);
            this.maybeNotifySurfaceSizeChanged(0, 0);
        } else {
            surfaceHolder.addCallback((SurfaceHolder.Callback)this.componentListener);
            Surface surface = surfaceHolder.getSurface();
            if (surface != null && surface.isValid()) {
                this.setVideoSurfaceInternal(surface, false);
                Rect surfaceSize = surfaceHolder.getSurfaceFrame();
                this.maybeNotifySurfaceSizeChanged(surfaceSize.width(), surfaceSize.height());
            } else {
                this.setVideoSurfaceInternal(null, false);
                this.maybeNotifySurfaceSizeChanged(0, 0);
            }
        }
    }

    @Override
    public void clearVideoSurfaceHolder(@Nullable SurfaceHolder surfaceHolder) {
        this.verifyApplicationThread();
        if (surfaceHolder != null && surfaceHolder == this.surfaceHolder) {
            this.setVideoSurfaceHolder(null);
        }
    }

    @Override
    public void setVideoSurfaceView(@Nullable SurfaceView surfaceView) {
        this.setVideoSurfaceHolder(surfaceView == null ? null : surfaceView.getHolder());
    }

    @Override
    public void clearVideoSurfaceView(@Nullable SurfaceView surfaceView) {
        this.clearVideoSurfaceHolder(surfaceView == null ? null : surfaceView.getHolder());
    }

    @Override
    public void setVideoTextureView(@Nullable TextureView textureView) {
        this.verifyApplicationThread();
        this.removeSurfaceCallbacks();
        if (textureView != null) {
            this.clearVideoDecoderOutputBufferRenderer();
        }
        this.textureView = textureView;
        if (textureView == null) {
            this.setVideoSurfaceInternal(null, true);
            this.maybeNotifySurfaceSizeChanged(0, 0);
        } else {
            SurfaceTexture surfaceTexture;
            if (textureView.getSurfaceTextureListener() != null) {
                Log.w(TAG, "Replacing existing SurfaceTextureListener.");
            }
            textureView.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this.componentListener);
            SurfaceTexture surfaceTexture2 = surfaceTexture = textureView.isAvailable() ? textureView.getSurfaceTexture() : null;
            if (surfaceTexture == null) {
                this.setVideoSurfaceInternal(null, true);
                this.maybeNotifySurfaceSizeChanged(0, 0);
            } else {
                this.setVideoSurfaceInternal(new Surface(surfaceTexture), true);
                this.maybeNotifySurfaceSizeChanged(textureView.getWidth(), textureView.getHeight());
            }
        }
    }

    @Override
    public void clearVideoTextureView(@Nullable TextureView textureView) {
        this.verifyApplicationThread();
        if (textureView != null && textureView == this.textureView) {
            this.setVideoTextureView(null);
        }
    }

    @Override
    public void setVideoDecoderOutputBufferRenderer(@Nullable VideoDecoderOutputBufferRenderer videoDecoderOutputBufferRenderer) {
        this.verifyApplicationThread();
        if (videoDecoderOutputBufferRenderer != null) {
            this.clearVideoSurface();
        }
        this.setVideoDecoderOutputBufferRendererInternal(videoDecoderOutputBufferRenderer);
    }

    @Override
    public void clearVideoDecoderOutputBufferRenderer() {
        this.verifyApplicationThread();
        this.setVideoDecoderOutputBufferRendererInternal(null);
    }

    @Override
    public void clearVideoDecoderOutputBufferRenderer(@Nullable VideoDecoderOutputBufferRenderer videoDecoderOutputBufferRenderer) {
        this.verifyApplicationThread();
        if (videoDecoderOutputBufferRenderer != null && videoDecoderOutputBufferRenderer == this.videoDecoderOutputBufferRenderer) {
            this.clearVideoDecoderOutputBufferRenderer();
        }
    }

    @Override
    public void addAudioListener(AudioListener listener) {
        Assertions.checkNotNull(listener);
        this.audioListeners.add(listener);
    }

    @Override
    public void removeAudioListener(AudioListener listener) {
        this.audioListeners.remove(listener);
    }

    @Override
    public void setAudioAttributes(AudioAttributes audioAttributes) {
        this.setAudioAttributes(audioAttributes, false);
    }

    @Override
    public void setAudioAttributes(AudioAttributes audioAttributes, boolean handleAudioFocus) {
        this.verifyApplicationThread();
        if (this.playerReleased) {
            return;
        }
        if (!Util.areEqual(this.audioAttributes, audioAttributes)) {
            this.audioAttributes = audioAttributes;
            this.sendRendererMessage(1, 3, audioAttributes);
            this.streamVolumeManager.setStreamType(Util.getStreamTypeForAudioUsage(audioAttributes.usage));
            for (AudioListener audioListener : this.audioListeners) {
                audioListener.onAudioAttributesChanged(audioAttributes);
            }
        }
        this.audioFocusManager.setAudioAttributes(handleAudioFocus ? audioAttributes : null);
        boolean playWhenReady = this.getPlayWhenReady();
        int playerCommand = this.audioFocusManager.updateAudioFocus(playWhenReady, this.getPlaybackState());
        this.updatePlayWhenReady(playWhenReady, playerCommand, SimpleExoPlayer.getPlayWhenReadyChangeReason(playWhenReady, playerCommand));
    }

    @Override
    public AudioAttributes getAudioAttributes() {
        return this.audioAttributes;
    }

    @Override
    public void setAudioSessionId(int audioSessionId) {
        this.verifyApplicationThread();
        if (this.audioSessionId == audioSessionId) {
            return;
        }
        this.audioSessionId = audioSessionId;
        this.sendRendererMessage(1, 102, audioSessionId);
        if (audioSessionId != 0) {
            this.notifyAudioSessionIdSet();
        }
    }

    @Override
    public int getAudioSessionId() {
        return this.audioSessionId;
    }

    @Override
    public void setAuxEffectInfo(AuxEffectInfo auxEffectInfo) {
        this.verifyApplicationThread();
        this.sendRendererMessage(1, 5, auxEffectInfo);
    }

    @Override
    public void clearAuxEffectInfo() {
        this.setAuxEffectInfo(new AuxEffectInfo(0, 0.0f));
    }

    @Override
    public void setVolume(float audioVolume) {
        this.verifyApplicationThread();
        audioVolume = Util.constrainValue(audioVolume, 0.0f, 1.0f);
        if (this.audioVolume == audioVolume) {
            return;
        }
        this.audioVolume = audioVolume;
        this.sendVolumeToRenderers();
        for (AudioListener audioListener : this.audioListeners) {
            audioListener.onVolumeChanged(audioVolume);
        }
    }

    @Override
    public float getVolume() {
        return this.audioVolume;
    }

    @Override
    public boolean getSkipSilenceEnabled() {
        return this.skipSilenceEnabled;
    }

    @Override
    public void setSkipSilenceEnabled(boolean skipSilenceEnabled) {
        this.verifyApplicationThread();
        if (this.skipSilenceEnabled == skipSilenceEnabled) {
            return;
        }
        this.skipSilenceEnabled = skipSilenceEnabled;
        this.sendRendererMessage(1, 101, skipSilenceEnabled);
        this.notifySkipSilenceEnabledChanged();
    }

    @Deprecated
    public void setAudioStreamType(int streamType) {
        int usage = Util.getAudioUsageForStreamType(streamType);
        int contentType = Util.getAudioContentTypeForStreamType(streamType);
        AudioAttributes audioAttributes = new AudioAttributes.Builder().setUsage(usage).setContentType(contentType).build();
        this.setAudioAttributes(audioAttributes);
    }

    @Deprecated
    public int getAudioStreamType() {
        return Util.getStreamTypeForAudioUsage(this.audioAttributes.usage);
    }

    public AnalyticsCollector getAnalyticsCollector() {
        return this.analyticsCollector;
    }

    public void addAnalyticsListener(AnalyticsListener listener) {
        Assertions.checkNotNull(listener);
        this.analyticsCollector.addListener(listener);
    }

    public void removeAnalyticsListener(AnalyticsListener listener) {
        this.analyticsCollector.removeListener(listener);
    }

    public void setHandleAudioBecomingNoisy(boolean handleAudioBecomingNoisy) {
        this.verifyApplicationThread();
        if (this.playerReleased) {
            return;
        }
        this.audioBecomingNoisyManager.setEnabled(handleAudioBecomingNoisy);
    }

    public void setPriorityTaskManager(@Nullable PriorityTaskManager priorityTaskManager) {
        this.verifyApplicationThread();
        if (Util.areEqual(this.priorityTaskManager, priorityTaskManager)) {
            return;
        }
        if (this.isPriorityTaskManagerRegistered) {
            Assertions.checkNotNull(this.priorityTaskManager).remove(0);
        }
        if (priorityTaskManager != null && this.isLoading()) {
            priorityTaskManager.add(0);
            this.isPriorityTaskManagerRegistered = true;
        } else {
            this.isPriorityTaskManagerRegistered = false;
        }
        this.priorityTaskManager = priorityTaskManager;
    }

    @Deprecated
    @RequiresApi(value=23)
    public void setPlaybackParams(@Nullable PlaybackParams params) {
        PlaybackParameters playbackParameters;
        if (params != null) {
            params.allowDefaults();
            playbackParameters = new PlaybackParameters(params.getSpeed(), params.getPitch());
        } else {
            playbackParameters = null;
        }
        this.setPlaybackParameters(playbackParameters);
    }

    @Nullable
    public Format getVideoFormat() {
        return this.videoFormat;
    }

    @Nullable
    public Format getAudioFormat() {
        return this.audioFormat;
    }

    @Nullable
    public DecoderCounters getVideoDecoderCounters() {
        return this.videoDecoderCounters;
    }

    @Nullable
    public DecoderCounters getAudioDecoderCounters() {
        return this.audioDecoderCounters;
    }

    @Override
    public void addVideoListener(com.akamai.amp.exoplayer2.video.VideoListener listener) {
        Assertions.checkNotNull(listener);
        this.videoListeners.add(listener);
    }

    @Override
    public void removeVideoListener(com.akamai.amp.exoplayer2.video.VideoListener listener) {
        this.videoListeners.remove(listener);
    }

    @Override
    public void setVideoFrameMetadataListener(VideoFrameMetadataListener listener) {
        this.verifyApplicationThread();
        this.videoFrameMetadataListener = listener;
        this.sendRendererMessage(2, 6, listener);
    }

    @Override
    public void clearVideoFrameMetadataListener(VideoFrameMetadataListener listener) {
        this.verifyApplicationThread();
        if (this.videoFrameMetadataListener != listener) {
            return;
        }
        this.sendRendererMessage(2, 6, null);
    }

    @Override
    public void setCameraMotionListener(CameraMotionListener listener) {
        this.verifyApplicationThread();
        this.cameraMotionListener = listener;
        this.sendRendererMessage(5, 7, listener);
    }

    @Override
    public void clearCameraMotionListener(CameraMotionListener listener) {
        this.verifyApplicationThread();
        if (this.cameraMotionListener != listener) {
            return;
        }
        this.sendRendererMessage(5, 7, null);
    }

    @Deprecated
    public void setVideoListener(@Nullable VideoListener listener) {
        this.videoListeners.clear();
        if (listener != null) {
            this.addVideoListener(listener);
        }
    }

    @Deprecated
    public void clearVideoListener(VideoListener listener) {
        this.removeVideoListener(listener);
    }

    @Override
    public void addTextOutput(TextOutput listener) {
        Assertions.checkNotNull(listener);
        this.textOutputs.add(listener);
    }

    @Override
    public void removeTextOutput(TextOutput listener) {
        this.textOutputs.remove(listener);
    }

    @Override
    public List<Cue> getCurrentCues() {
        this.verifyApplicationThread();
        return this.currentCues;
    }

    @Deprecated
    public void setTextOutput(TextOutput output) {
        this.textOutputs.clear();
        if (output != null) {
            this.addTextOutput(output);
        }
    }

    @Deprecated
    public void clearTextOutput(TextOutput output) {
        this.removeTextOutput(output);
    }

    @Override
    public void addMetadataOutput(MetadataOutput listener) {
        Assertions.checkNotNull(listener);
        this.metadataOutputs.add(listener);
    }

    @Override
    public void removeMetadataOutput(MetadataOutput listener) {
        this.metadataOutputs.remove(listener);
    }

    @Deprecated
    public void setMetadataOutput(MetadataOutput output) {
        this.metadataOutputs.retainAll(Collections.singleton(this.analyticsCollector));
        if (output != null) {
            this.addMetadataOutput(output);
        }
    }

    @Deprecated
    public void clearMetadataOutput(MetadataOutput output) {
        this.removeMetadataOutput(output);
    }

    @Deprecated
    public void setVideoDebugListener(@Nullable VideoRendererEventListener listener) {
        this.videoDebugListeners.retainAll(Collections.singleton(this.analyticsCollector));
        if (listener != null) {
            this.addVideoDebugListener(listener);
        }
    }

    @Deprecated
    public void addVideoDebugListener(VideoRendererEventListener listener) {
        Assertions.checkNotNull(listener);
        this.videoDebugListeners.add(listener);
    }

    @Deprecated
    public void removeVideoDebugListener(VideoRendererEventListener listener) {
        this.videoDebugListeners.remove(listener);
    }

    @Deprecated
    public void setAudioDebugListener(@Nullable AudioRendererEventListener listener) {
        this.audioDebugListeners.retainAll(Collections.singleton(this.analyticsCollector));
        if (listener != null) {
            this.addAudioDebugListener(listener);
        }
    }

    @Deprecated
    public void addAudioDebugListener(AudioRendererEventListener listener) {
        Assertions.checkNotNull(listener);
        this.audioDebugListeners.add(listener);
    }

    @Deprecated
    public void removeAudioDebugListener(AudioRendererEventListener listener) {
        this.audioDebugListeners.remove(listener);
    }

    @Override
    public Looper getPlaybackLooper() {
        return this.player.getPlaybackLooper();
    }

    @Override
    public Looper getApplicationLooper() {
        return this.player.getApplicationLooper();
    }

    @Override
    public void addListener(Player.EventListener listener) {
        Assertions.checkNotNull(listener);
        this.player.addListener(listener);
    }

    @Override
    public void removeListener(Player.EventListener listener) {
        this.player.removeListener(listener);
    }

    @Override
    public int getPlaybackState() {
        this.verifyApplicationThread();
        return this.player.getPlaybackState();
    }

    @Override
    public int getPlaybackSuppressionReason() {
        this.verifyApplicationThread();
        return this.player.getPlaybackSuppressionReason();
    }

    @Override
    @Deprecated
    @Nullable
    public ExoPlaybackException getPlaybackError() {
        return this.getPlayerError();
    }

    @Override
    @Nullable
    public ExoPlaybackException getPlayerError() {
        this.verifyApplicationThread();
        return this.player.getPlayerError();
    }

    @Override
    @Deprecated
    public void retry() {
        this.verifyApplicationThread();
        this.prepare();
    }

    @Override
    public void prepare() {
        this.verifyApplicationThread();
        boolean playWhenReady = this.getPlayWhenReady();
        int playerCommand = this.audioFocusManager.updateAudioFocus(playWhenReady, 2);
        this.updatePlayWhenReady(playWhenReady, playerCommand, SimpleExoPlayer.getPlayWhenReadyChangeReason(playWhenReady, playerCommand));
        this.player.prepare();
    }

    @Override
    @Deprecated
    public void prepare(MediaSource mediaSource) {
        this.prepare(mediaSource, true, true);
    }

    @Override
    @Deprecated
    public void prepare(MediaSource mediaSource, boolean resetPosition, boolean resetState) {
        this.verifyApplicationThread();
        this.setMediaSources(Collections.singletonList(mediaSource), resetPosition ? 0 : -1, -9223372036854775807L);
        this.prepare();
    }

    @Override
    public void setMediaItems(List<MediaItem> mediaItems) {
        this.verifyApplicationThread();
        this.analyticsCollector.resetForNewPlaylist();
        this.player.setMediaItems(mediaItems);
    }

    @Override
    public void setMediaItems(List<MediaItem> mediaItems, boolean resetPosition) {
        this.verifyApplicationThread();
        this.analyticsCollector.resetForNewPlaylist();
        this.player.setMediaItems(mediaItems, resetPosition);
    }

    @Override
    public void setMediaItems(List<MediaItem> mediaItems, int startWindowIndex, long startPositionMs) {
        this.verifyApplicationThread();
        this.analyticsCollector.resetForNewPlaylist();
        this.player.setMediaItems(mediaItems, startWindowIndex, startPositionMs);
    }

    @Override
    public void setMediaItem(MediaItem mediaItem) {
        this.verifyApplicationThread();
        this.analyticsCollector.resetForNewPlaylist();
        this.player.setMediaItem(mediaItem);
    }

    @Override
    public void setMediaItem(MediaItem mediaItem, boolean resetPosition) {
        this.verifyApplicationThread();
        this.analyticsCollector.resetForNewPlaylist();
        this.player.setMediaItem(mediaItem, resetPosition);
    }

    @Override
    public void setMediaItem(MediaItem mediaItem, long startPositionMs) {
        this.verifyApplicationThread();
        this.analyticsCollector.resetForNewPlaylist();
        this.player.setMediaItem(mediaItem, startPositionMs);
    }

    @Override
    public void setMediaSources(List<MediaSource> mediaSources) {
        this.verifyApplicationThread();
        this.analyticsCollector.resetForNewPlaylist();
        this.player.setMediaSources(mediaSources);
    }

    @Override
    public void setMediaSources(List<MediaSource> mediaSources, boolean resetPosition) {
        this.verifyApplicationThread();
        this.analyticsCollector.resetForNewPlaylist();
        this.player.setMediaSources(mediaSources, resetPosition);
    }

    @Override
    public void setMediaSources(List<MediaSource> mediaSources, int startWindowIndex, long startPositionMs) {
        this.verifyApplicationThread();
        this.analyticsCollector.resetForNewPlaylist();
        this.player.setMediaSources(mediaSources, startWindowIndex, startPositionMs);
    }

    @Override
    public void setMediaSource(MediaSource mediaSource) {
        this.verifyApplicationThread();
        this.analyticsCollector.resetForNewPlaylist();
        this.player.setMediaSource(mediaSource);
    }

    @Override
    public void setMediaSource(MediaSource mediaSource, boolean resetPosition) {
        this.verifyApplicationThread();
        this.analyticsCollector.resetForNewPlaylist();
        this.player.setMediaSource(mediaSource, resetPosition);
    }

    @Override
    public void setMediaSource(MediaSource mediaSource, long startPositionMs) {
        this.verifyApplicationThread();
        this.analyticsCollector.resetForNewPlaylist();
        this.player.setMediaSource(mediaSource, startPositionMs);
    }

    @Override
    public void addMediaItems(List<MediaItem> mediaItems) {
        this.verifyApplicationThread();
        this.player.addMediaItems(mediaItems);
    }

    @Override
    public void addMediaItems(int index, List<MediaItem> mediaItems) {
        this.verifyApplicationThread();
        this.player.addMediaItems(index, mediaItems);
    }

    @Override
    public void addMediaItem(MediaItem mediaItem) {
        this.verifyApplicationThread();
        this.player.addMediaItem(mediaItem);
    }

    @Override
    public void addMediaItem(int index, MediaItem mediaItem) {
        this.verifyApplicationThread();
        this.player.addMediaItem(index, mediaItem);
    }

    @Override
    public void addMediaSource(MediaSource mediaSource) {
        this.verifyApplicationThread();
        this.player.addMediaSource(mediaSource);
    }

    @Override
    public void addMediaSource(int index, MediaSource mediaSource) {
        this.verifyApplicationThread();
        this.player.addMediaSource(index, mediaSource);
    }

    @Override
    public void addMediaSources(List<MediaSource> mediaSources) {
        this.verifyApplicationThread();
        this.player.addMediaSources(mediaSources);
    }

    @Override
    public void addMediaSources(int index, List<MediaSource> mediaSources) {
        this.verifyApplicationThread();
        this.player.addMediaSources(index, mediaSources);
    }

    @Override
    public void moveMediaItem(int currentIndex, int newIndex) {
        this.verifyApplicationThread();
        this.player.moveMediaItem(currentIndex, newIndex);
    }

    @Override
    public void moveMediaItems(int fromIndex, int toIndex, int newIndex) {
        this.verifyApplicationThread();
        this.player.moveMediaItems(fromIndex, toIndex, newIndex);
    }

    @Override
    public void removeMediaItem(int index) {
        this.verifyApplicationThread();
        this.player.removeMediaItem(index);
    }

    @Override
    public void removeMediaItems(int fromIndex, int toIndex) {
        this.verifyApplicationThread();
        this.player.removeMediaItems(fromIndex, toIndex);
    }

    @Override
    public void clearMediaItems() {
        this.verifyApplicationThread();
        this.player.clearMediaItems();
    }

    @Override
    public void setShuffleOrder(ShuffleOrder shuffleOrder) {
        this.verifyApplicationThread();
        this.player.setShuffleOrder(shuffleOrder);
    }

    @Override
    public void setPlayWhenReady(boolean playWhenReady) {
        this.verifyApplicationThread();
        int playerCommand = this.audioFocusManager.updateAudioFocus(playWhenReady, this.getPlaybackState());
        this.updatePlayWhenReady(playWhenReady, playerCommand, SimpleExoPlayer.getPlayWhenReadyChangeReason(playWhenReady, playerCommand));
    }

    @Override
    public boolean getPlayWhenReady() {
        this.verifyApplicationThread();
        return this.player.getPlayWhenReady();
    }

    @Override
    public void setPauseAtEndOfMediaItems(boolean pauseAtEndOfMediaItems) {
        this.verifyApplicationThread();
        this.player.setPauseAtEndOfMediaItems(pauseAtEndOfMediaItems);
    }

    @Override
    public boolean getPauseAtEndOfMediaItems() {
        this.verifyApplicationThread();
        return this.player.getPauseAtEndOfMediaItems();
    }

    @Override
    public int getRepeatMode() {
        this.verifyApplicationThread();
        return this.player.getRepeatMode();
    }

    @Override
    public void setRepeatMode(int repeatMode) {
        this.verifyApplicationThread();
        this.player.setRepeatMode(repeatMode);
    }

    @Override
    public void setShuffleModeEnabled(boolean shuffleModeEnabled) {
        this.verifyApplicationThread();
        this.player.setShuffleModeEnabled(shuffleModeEnabled);
    }

    @Override
    public boolean getShuffleModeEnabled() {
        this.verifyApplicationThread();
        return this.player.getShuffleModeEnabled();
    }

    @Override
    public boolean isLoading() {
        this.verifyApplicationThread();
        return this.player.isLoading();
    }

    @Override
    public void seekTo(int windowIndex, long positionMs) {
        this.verifyApplicationThread();
        this.analyticsCollector.notifySeekStarted();
        this.player.seekTo(windowIndex, positionMs);
    }

    @Override
    public void setPlaybackParameters(@Nullable PlaybackParameters playbackParameters) {
        this.verifyApplicationThread();
        this.player.setPlaybackParameters(playbackParameters);
    }

    @Override
    public PlaybackParameters getPlaybackParameters() {
        this.verifyApplicationThread();
        return this.player.getPlaybackParameters();
    }

    @Override
    public void setSeekParameters(@Nullable SeekParameters seekParameters) {
        this.verifyApplicationThread();
        this.player.setSeekParameters(seekParameters);
    }

    @Override
    public SeekParameters getSeekParameters() {
        this.verifyApplicationThread();
        return this.player.getSeekParameters();
    }

    @Override
    public void setForegroundMode(boolean foregroundMode) {
        this.verifyApplicationThread();
        this.player.setForegroundMode(foregroundMode);
    }

    @Override
    public void stop(boolean reset) {
        this.verifyApplicationThread();
        this.audioFocusManager.updateAudioFocus(this.getPlayWhenReady(), 1);
        this.player.stop(reset);
        this.currentCues = Collections.emptyList();
    }

    @Override
    public void release() {
        this.verifyApplicationThread();
        this.audioBecomingNoisyManager.setEnabled(false);
        this.streamVolumeManager.release();
        this.wakeLockManager.setStayAwake(false);
        this.wifiLockManager.setStayAwake(false);
        this.audioFocusManager.release();
        this.player.release();
        this.removeSurfaceCallbacks();
        if (this.surface != null) {
            if (this.ownsSurface) {
                this.surface.release();
            }
            this.surface = null;
        }
        if (this.isPriorityTaskManagerRegistered) {
            Assertions.checkNotNull(this.priorityTaskManager).remove(0);
            this.isPriorityTaskManagerRegistered = false;
        }
        this.currentCues = Collections.emptyList();
        this.playerReleased = true;
    }

    @Override
    public PlayerMessage createMessage(PlayerMessage.Target target) {
        this.verifyApplicationThread();
        return this.player.createMessage(target);
    }

    @Override
    public int getRendererCount() {
        this.verifyApplicationThread();
        return this.player.getRendererCount();
    }

    @Override
    public int getRendererType(int index) {
        this.verifyApplicationThread();
        return this.player.getRendererType(index);
    }

    @Override
    @Nullable
    public TrackSelector getTrackSelector() {
        this.verifyApplicationThread();
        return this.player.getTrackSelector();
    }

    @Override
    public TrackGroupArray getCurrentTrackGroups() {
        this.verifyApplicationThread();
        return this.player.getCurrentTrackGroups();
    }

    @Override
    public TrackSelectionArray getCurrentTrackSelections() {
        this.verifyApplicationThread();
        return this.player.getCurrentTrackSelections();
    }

    @Override
    public Timeline getCurrentTimeline() {
        this.verifyApplicationThread();
        return this.player.getCurrentTimeline();
    }

    @Override
    public int getCurrentPeriodIndex() {
        this.verifyApplicationThread();
        return this.player.getCurrentPeriodIndex();
    }

    @Override
    public int getCurrentWindowIndex() {
        this.verifyApplicationThread();
        return this.player.getCurrentWindowIndex();
    }

    @Override
    public long getDuration() {
        this.verifyApplicationThread();
        return this.player.getDuration();
    }

    @Override
    public long getCurrentPosition() {
        this.verifyApplicationThread();
        return this.player.getCurrentPosition();
    }

    @Override
    public long getBufferedPosition() {
        this.verifyApplicationThread();
        return this.player.getBufferedPosition();
    }

    @Override
    public long getTotalBufferedDuration() {
        this.verifyApplicationThread();
        return this.player.getTotalBufferedDuration();
    }

    @Override
    public boolean isPlayingAd() {
        this.verifyApplicationThread();
        return this.player.isPlayingAd();
    }

    @Override
    public int getCurrentAdGroupIndex() {
        this.verifyApplicationThread();
        return this.player.getCurrentAdGroupIndex();
    }

    @Override
    public int getCurrentAdIndexInAdGroup() {
        this.verifyApplicationThread();
        return this.player.getCurrentAdIndexInAdGroup();
    }

    @Override
    public long getContentPosition() {
        this.verifyApplicationThread();
        return this.player.getContentPosition();
    }

    @Override
    public long getContentBufferedPosition() {
        this.verifyApplicationThread();
        return this.player.getContentBufferedPosition();
    }

    @Deprecated
    public void setHandleWakeLock(boolean handleWakeLock) {
        this.setWakeMode(handleWakeLock ? 1 : 0);
    }

    public void setWakeMode(int wakeMode) {
        this.verifyApplicationThread();
        switch (wakeMode) {
            case 0: {
                this.wakeLockManager.setEnabled(false);
                this.wifiLockManager.setEnabled(false);
                break;
            }
            case 1: {
                this.wakeLockManager.setEnabled(true);
                this.wifiLockManager.setEnabled(false);
                break;
            }
            case 2: {
                this.wakeLockManager.setEnabled(true);
                this.wifiLockManager.setEnabled(true);
                break;
            }
        }
    }

    @Override
    public void addDeviceListener(DeviceListener listener) {
        Assertions.checkNotNull(listener);
        this.deviceListeners.add(listener);
    }

    @Override
    public void removeDeviceListener(DeviceListener listener) {
        this.deviceListeners.remove(listener);
    }

    @Override
    public DeviceInfo getDeviceInfo() {
        this.verifyApplicationThread();
        return this.deviceInfo;
    }

    @Override
    public int getDeviceVolume() {
        this.verifyApplicationThread();
        return this.streamVolumeManager.getVolume();
    }

    @Override
    public boolean isDeviceMuted() {
        this.verifyApplicationThread();
        return this.streamVolumeManager.isMuted();
    }

    @Override
    public void setDeviceVolume(int volume) {
        this.verifyApplicationThread();
        this.streamVolumeManager.setVolume(volume);
    }

    @Override
    public void increaseDeviceVolume() {
        this.verifyApplicationThread();
        this.streamVolumeManager.increaseVolume();
    }

    @Override
    public void decreaseDeviceVolume() {
        this.verifyApplicationThread();
        this.streamVolumeManager.decreaseVolume();
    }

    @Override
    public void setDeviceMuted(boolean muted) {
        this.verifyApplicationThread();
        this.streamVolumeManager.setMuted(muted);
    }

    public void setThrowsWhenUsingWrongThread(boolean throwsWhenUsingWrongThread) {
        this.throwsWhenUsingWrongThread = throwsWhenUsingWrongThread;
    }

    private void removeSurfaceCallbacks() {
        if (this.textureView != null) {
            if (this.textureView.getSurfaceTextureListener() != this.componentListener) {
                Log.w(TAG, "SurfaceTextureListener already unset or replaced.");
            } else {
                this.textureView.setSurfaceTextureListener(null);
            }
            this.textureView = null;
        }
        if (this.surfaceHolder != null) {
            this.surfaceHolder.removeCallback((SurfaceHolder.Callback)this.componentListener);
            this.surfaceHolder = null;
        }
    }

    private void setVideoSurfaceInternal(@Nullable Surface surface, boolean ownsSurface) {
        ArrayList<PlayerMessage> messages = new ArrayList<PlayerMessage>();
        for (Renderer renderer : this.renderers) {
            if (renderer.getTrackType() != 2) continue;
            messages.add(this.player.createMessage(renderer).setType(1).setPayload(surface).send());
        }
        if (this.surface != null && this.surface != surface) {
            try {
                for (PlayerMessage message : messages) {
                    message.blockUntilDelivered();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (this.ownsSurface) {
                this.surface.release();
            }
        }
        this.surface = surface;
        this.ownsSurface = ownsSurface;
    }

    private void setVideoDecoderOutputBufferRendererInternal(@Nullable VideoDecoderOutputBufferRenderer videoDecoderOutputBufferRenderer) {
        this.sendRendererMessage(2, 8, videoDecoderOutputBufferRenderer);
        this.videoDecoderOutputBufferRenderer = videoDecoderOutputBufferRenderer;
    }

    private void maybeNotifySurfaceSizeChanged(int width, int height) {
        if (width != this.surfaceWidth || height != this.surfaceHeight) {
            this.surfaceWidth = width;
            this.surfaceHeight = height;
            for (com.akamai.amp.exoplayer2.video.VideoListener videoListener : this.videoListeners) {
                videoListener.onSurfaceSizeChanged(width, height);
            }
        }
    }

    private void sendVolumeToRenderers() {
        float scaledVolume = this.audioVolume * this.audioFocusManager.getVolumeMultiplier();
        this.sendRendererMessage(1, 2, Float.valueOf(scaledVolume));
    }

    private void notifyAudioSessionIdSet() {
        for (AudioListener audioListener : this.audioListeners) {
            if (this.audioDebugListeners.contains(audioListener)) continue;
            audioListener.onAudioSessionId(this.audioSessionId);
        }
        for (AudioRendererEventListener audioDebugListener : this.audioDebugListeners) {
            audioDebugListener.onAudioSessionId(this.audioSessionId);
        }
    }

    private void notifySkipSilenceEnabledChanged() {
        for (AudioListener audioListener : this.audioListeners) {
            if (this.audioDebugListeners.contains(audioListener)) continue;
            audioListener.onSkipSilenceEnabledChanged(this.skipSilenceEnabled);
        }
        for (AudioRendererEventListener audioRendererEventListener : this.audioDebugListeners) {
            audioRendererEventListener.onSkipSilenceEnabledChanged(this.skipSilenceEnabled);
        }
    }

    private void updatePlayWhenReady(boolean playWhenReady, int playerCommand, int playWhenReadyChangeReason) {
        int playbackSuppressionReason;
        playWhenReady = playWhenReady && playerCommand != -1;
        int n = playbackSuppressionReason = playWhenReady && playerCommand != 1 ? 1 : 0;
        if (this.player == null) {
            return;
        }
        this.player.setPlayWhenReady(playWhenReady, playbackSuppressionReason, playWhenReadyChangeReason);
    }

    private void updateWakeAndWifiLock() {
        int playbackState = this.getPlaybackState();
        switch (playbackState) {
            case 2: 
            case 3: {
                this.wakeLockManager.setStayAwake(this.getPlayWhenReady());
                this.wifiLockManager.setStayAwake(this.getPlayWhenReady());
                break;
            }
            case 1: 
            case 4: {
                this.wakeLockManager.setStayAwake(false);
                this.wifiLockManager.setStayAwake(false);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private void verifyApplicationThread() {
        if (Looper.myLooper() != this.getApplicationLooper()) {
            if (this.throwsWhenUsingWrongThread) {
                throw new IllegalStateException(WRONG_THREAD_ERROR_MESSAGE);
            }
            Log.w(TAG, WRONG_THREAD_ERROR_MESSAGE, this.hasNotifiedFullWrongThreadWarning ? null : new IllegalStateException());
            this.hasNotifiedFullWrongThreadWarning = true;
        }
    }

    private void sendRendererMessage(int trackType, int messageType, @Nullable Object payload) {
        for (Renderer renderer : this.renderers) {
            if (renderer.getTrackType() != trackType) continue;
            this.player.createMessage(renderer).setType(messageType).setPayload(payload).send();
        }
    }

    private static DeviceInfo createDeviceInfo(StreamVolumeManager streamVolumeManager) {
        return new DeviceInfo(0, streamVolumeManager.getMinVolume(), streamVolumeManager.getMaxVolume());
    }

    private static int getPlayWhenReadyChangeReason(boolean playWhenReady, int playerCommand) {
        return playWhenReady && playerCommand != 1 ? 2 : 1;
    }

    public static final class Builder {
        private final Context context;
        private final RenderersFactory renderersFactory;
        private Clock clock;
        private TrackSelector trackSelector;
        private MediaSourceFactory mediaSourceFactory;
        private LoadControl loadControl;
        private BandwidthMeter bandwidthMeter;
        private AnalyticsCollector analyticsCollector;
        private Looper looper;
        @Nullable
        private PriorityTaskManager priorityTaskManager;
        private AudioAttributes audioAttributes;
        private boolean handleAudioFocus;
        private int wakeMode;
        private boolean handleAudioBecomingNoisy;
        private boolean skipSilenceEnabled;
        private int videoScalingMode;
        private boolean useLazyPreparation;
        private SeekParameters seekParameters;
        private boolean pauseAtEndOfMediaItems;
        private boolean throwWhenStuckBuffering;
        private boolean buildCalled;

        public Builder(Context context) {
            this(context, new DefaultRenderersFactory(context), new DefaultExtractorsFactory());
        }

        public Builder(Context context, RenderersFactory renderersFactory) {
            this(context, renderersFactory, new DefaultExtractorsFactory());
        }

        public Builder(Context context, ExtractorsFactory extractorsFactory) {
            this(context, new DefaultRenderersFactory(context), extractorsFactory);
        }

        public Builder(Context context, RenderersFactory renderersFactory, ExtractorsFactory extractorsFactory) {
            this(context, renderersFactory, new DefaultTrackSelector(context), new DefaultMediaSourceFactory(context, extractorsFactory), new DefaultLoadControl(), DefaultBandwidthMeter.getSingletonInstance(context), new AnalyticsCollector(Clock.DEFAULT));
        }

        public Builder(Context context, RenderersFactory renderersFactory, TrackSelector trackSelector, MediaSourceFactory mediaSourceFactory, LoadControl loadControl, BandwidthMeter bandwidthMeter, AnalyticsCollector analyticsCollector) {
            this.context = context;
            this.renderersFactory = renderersFactory;
            this.trackSelector = trackSelector;
            this.mediaSourceFactory = mediaSourceFactory;
            this.loadControl = loadControl;
            this.bandwidthMeter = bandwidthMeter;
            this.analyticsCollector = analyticsCollector;
            this.looper = Util.getCurrentOrMainLooper();
            this.audioAttributes = AudioAttributes.DEFAULT;
            this.wakeMode = 0;
            this.videoScalingMode = 1;
            this.useLazyPreparation = true;
            this.seekParameters = SeekParameters.DEFAULT;
            this.clock = Clock.DEFAULT;
            this.throwWhenStuckBuffering = true;
        }

        public Builder setTrackSelector(TrackSelector trackSelector) {
            Assertions.checkState(!this.buildCalled);
            this.trackSelector = trackSelector;
            return this;
        }

        public Builder setMediaSourceFactory(MediaSourceFactory mediaSourceFactory) {
            Assertions.checkState(!this.buildCalled);
            this.mediaSourceFactory = mediaSourceFactory;
            return this;
        }

        public Builder setLoadControl(LoadControl loadControl) {
            Assertions.checkState(!this.buildCalled);
            this.loadControl = loadControl;
            return this;
        }

        public Builder setBandwidthMeter(BandwidthMeter bandwidthMeter) {
            Assertions.checkState(!this.buildCalled);
            this.bandwidthMeter = bandwidthMeter;
            return this;
        }

        public Builder setLooper(Looper looper) {
            Assertions.checkState(!this.buildCalled);
            this.looper = looper;
            return this;
        }

        public Builder setAnalyticsCollector(AnalyticsCollector analyticsCollector) {
            Assertions.checkState(!this.buildCalled);
            this.analyticsCollector = analyticsCollector;
            return this;
        }

        public Builder setPriorityTaskManager(@Nullable PriorityTaskManager priorityTaskManager) {
            Assertions.checkState(!this.buildCalled);
            this.priorityTaskManager = priorityTaskManager;
            return this;
        }

        public Builder setAudioAttributes(AudioAttributes audioAttributes, boolean handleAudioFocus) {
            Assertions.checkState(!this.buildCalled);
            this.audioAttributes = audioAttributes;
            this.handleAudioFocus = handleAudioFocus;
            return this;
        }

        public Builder setWakeMode(int wakeMode) {
            Assertions.checkState(!this.buildCalled);
            this.wakeMode = wakeMode;
            return this;
        }

        public Builder setHandleAudioBecomingNoisy(boolean handleAudioBecomingNoisy) {
            Assertions.checkState(!this.buildCalled);
            this.handleAudioBecomingNoisy = handleAudioBecomingNoisy;
            return this;
        }

        public Builder setSkipSilenceEnabled(boolean skipSilenceEnabled) {
            Assertions.checkState(!this.buildCalled);
            this.skipSilenceEnabled = skipSilenceEnabled;
            return this;
        }

        public Builder setVideoScalingMode(int videoScalingMode) {
            Assertions.checkState(!this.buildCalled);
            this.videoScalingMode = videoScalingMode;
            return this;
        }

        public Builder setUseLazyPreparation(boolean useLazyPreparation) {
            Assertions.checkState(!this.buildCalled);
            this.useLazyPreparation = useLazyPreparation;
            return this;
        }

        public Builder setSeekParameters(SeekParameters seekParameters) {
            Assertions.checkState(!this.buildCalled);
            this.seekParameters = seekParameters;
            return this;
        }

        public Builder setPauseAtEndOfMediaItems(boolean pauseAtEndOfMediaItems) {
            Assertions.checkState(!this.buildCalled);
            this.pauseAtEndOfMediaItems = pauseAtEndOfMediaItems;
            return this;
        }

        public Builder experimentalSetThrowWhenStuckBuffering(boolean throwWhenStuckBuffering) {
            this.throwWhenStuckBuffering = throwWhenStuckBuffering;
            return this;
        }

        @VisibleForTesting
        public Builder setClock(Clock clock) {
            Assertions.checkState(!this.buildCalled);
            this.clock = clock;
            return this;
        }

        public AmpBasePlayer build() {
            Assertions.checkState(!this.buildCalled);
            this.buildCalled = true;
            return new AmpBasePlayer(this.context, this.renderersFactory, this.trackSelector, this.mediaSourceFactory, this.loadControl, this.bandwidthMeter, this.analyticsCollector);
        }
    }

    private final class ComponentListener
    implements VideoRendererEventListener,
    AudioRendererEventListener,
    TextOutput,
    MetadataOutput,
    SurfaceHolder.Callback,
    TextureView.SurfaceTextureListener,
    AudioFocusManager.PlayerControl,
    AudioBecomingNoisyManager.EventListener,
    StreamVolumeManager.Listener,
    Player.EventListener {
        private ComponentListener() {
        }

        @Override
        public void onVideoEnabled(DecoderCounters counters) {
            SimpleExoPlayer.this.videoDecoderCounters = counters;
            for (VideoRendererEventListener videoDebugListener : SimpleExoPlayer.this.videoDebugListeners) {
                videoDebugListener.onVideoEnabled(counters);
            }
        }

        @Override
        public void onVideoDecoderInitialized(String decoderName, long initializedTimestampMs, long initializationDurationMs) {
            for (VideoRendererEventListener videoDebugListener : SimpleExoPlayer.this.videoDebugListeners) {
                videoDebugListener.onVideoDecoderInitialized(decoderName, initializedTimestampMs, initializationDurationMs);
            }
        }

        @Override
        public void onVideoInputFormatChanged(Format format) {
            SimpleExoPlayer.this.videoFormat = format;
            for (VideoRendererEventListener videoDebugListener : SimpleExoPlayer.this.videoDebugListeners) {
                videoDebugListener.onVideoInputFormatChanged(format);
            }
        }

        @Override
        public void onDroppedFrames(int count, long elapsed) {
            for (VideoRendererEventListener videoDebugListener : SimpleExoPlayer.this.videoDebugListeners) {
                videoDebugListener.onDroppedFrames(count, elapsed);
            }
        }

        @Override
        public void onVideoSizeChanged(int width, int height, int unappliedRotationDegrees, float pixelWidthHeightRatio) {
            for (com.akamai.amp.exoplayer2.video.VideoListener videoListener : SimpleExoPlayer.this.videoListeners) {
                if (SimpleExoPlayer.this.videoDebugListeners.contains(videoListener)) continue;
                videoListener.onVideoSizeChanged(width, height, unappliedRotationDegrees, pixelWidthHeightRatio);
            }
            for (VideoRendererEventListener videoDebugListener : SimpleExoPlayer.this.videoDebugListeners) {
                videoDebugListener.onVideoSizeChanged(width, height, unappliedRotationDegrees, pixelWidthHeightRatio);
            }
        }

        @Override
        public void onRenderedFirstFrame(Surface surface) {
            if (SimpleExoPlayer.this.surface == surface) {
                for (com.akamai.amp.exoplayer2.video.VideoListener videoListener : SimpleExoPlayer.this.videoListeners) {
                    videoListener.onRenderedFirstFrame();
                }
            }
            for (VideoRendererEventListener videoDebugListener : SimpleExoPlayer.this.videoDebugListeners) {
                videoDebugListener.onRenderedFirstFrame(surface);
            }
        }

        @Override
        public void onVideoDisabled(DecoderCounters counters) {
            for (VideoRendererEventListener videoDebugListener : SimpleExoPlayer.this.videoDebugListeners) {
                videoDebugListener.onVideoDisabled(counters);
            }
            SimpleExoPlayer.this.videoFormat = null;
            SimpleExoPlayer.this.videoDecoderCounters = null;
        }

        @Override
        public void onVideoFrameProcessingOffset(long totalProcessingOffsetUs, int frameCount) {
            for (VideoRendererEventListener videoDebugListener : SimpleExoPlayer.this.videoDebugListeners) {
                videoDebugListener.onVideoFrameProcessingOffset(totalProcessingOffsetUs, frameCount);
            }
        }

        @Override
        public void onAudioEnabled(DecoderCounters counters) {
            SimpleExoPlayer.this.audioDecoderCounters = counters;
            for (AudioRendererEventListener audioDebugListener : SimpleExoPlayer.this.audioDebugListeners) {
                audioDebugListener.onAudioEnabled(counters);
            }
        }

        @Override
        public void onAudioSessionId(int sessionId) {
            if (SimpleExoPlayer.this.audioSessionId == sessionId) {
                return;
            }
            SimpleExoPlayer.this.audioSessionId = sessionId;
            SimpleExoPlayer.this.notifyAudioSessionIdSet();
        }

        @Override
        public void onAudioDecoderInitialized(String decoderName, long initializedTimestampMs, long initializationDurationMs) {
            for (AudioRendererEventListener audioDebugListener : SimpleExoPlayer.this.audioDebugListeners) {
                audioDebugListener.onAudioDecoderInitialized(decoderName, initializedTimestampMs, initializationDurationMs);
            }
        }

        @Override
        public void onAudioInputFormatChanged(Format format) {
            SimpleExoPlayer.this.audioFormat = format;
            for (AudioRendererEventListener audioDebugListener : SimpleExoPlayer.this.audioDebugListeners) {
                audioDebugListener.onAudioInputFormatChanged(format);
            }
        }

        @Override
        public void onAudioPositionAdvancing(long playoutStartSystemTimeMs) {
            for (AudioRendererEventListener audioDebugListener : SimpleExoPlayer.this.audioDebugListeners) {
                audioDebugListener.onAudioPositionAdvancing(playoutStartSystemTimeMs);
            }
        }

        @Override
        public void onAudioUnderrun(int bufferSize, long bufferSizeMs, long elapsedSinceLastFeedMs) {
            for (AudioRendererEventListener audioDebugListener : SimpleExoPlayer.this.audioDebugListeners) {
                audioDebugListener.onAudioUnderrun(bufferSize, bufferSizeMs, elapsedSinceLastFeedMs);
            }
        }

        @Override
        public void onAudioDisabled(DecoderCounters counters) {
            for (AudioRendererEventListener audioDebugListener : SimpleExoPlayer.this.audioDebugListeners) {
                audioDebugListener.onAudioDisabled(counters);
            }
            SimpleExoPlayer.this.audioFormat = null;
            SimpleExoPlayer.this.audioDecoderCounters = null;
            SimpleExoPlayer.this.audioSessionId = 0;
        }

        @Override
        public void onSkipSilenceEnabledChanged(boolean skipSilenceEnabled) {
            if (SimpleExoPlayer.this.skipSilenceEnabled == skipSilenceEnabled) {
                return;
            }
            SimpleExoPlayer.this.skipSilenceEnabled = skipSilenceEnabled;
            SimpleExoPlayer.this.notifySkipSilenceEnabledChanged();
        }

        @Override
        public void onCues(List<Cue> cues) {
            SimpleExoPlayer.this.currentCues = cues;
            for (TextOutput textOutput : SimpleExoPlayer.this.textOutputs) {
                textOutput.onCues(cues);
            }
        }

        @Override
        public void onMetadata(Metadata metadata) {
            for (MetadataOutput metadataOutput : SimpleExoPlayer.this.metadataOutputs) {
                metadataOutput.onMetadata(metadata);
            }
        }

        public void surfaceCreated(SurfaceHolder holder) {
            SimpleExoPlayer.this.setVideoSurfaceInternal(holder.getSurface(), false);
        }

        public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
            SimpleExoPlayer.this.maybeNotifySurfaceSizeChanged(width, height);
        }

        public void surfaceDestroyed(SurfaceHolder holder) {
            SimpleExoPlayer.this.setVideoSurfaceInternal(null, false);
            SimpleExoPlayer.this.maybeNotifySurfaceSizeChanged(0, 0);
        }

        public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int width, int height) {
            SimpleExoPlayer.this.setVideoSurfaceInternal(new Surface(surfaceTexture), true);
            SimpleExoPlayer.this.maybeNotifySurfaceSizeChanged(width, height);
        }

        public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int width, int height) {
            SimpleExoPlayer.this.maybeNotifySurfaceSizeChanged(width, height);
        }

        public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
            SimpleExoPlayer.this.setVideoSurfaceInternal(null, true);
            SimpleExoPlayer.this.maybeNotifySurfaceSizeChanged(0, 0);
            return true;
        }

        public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        }

        @Override
        public void setVolumeMultiplier(float volumeMultiplier) {
            SimpleExoPlayer.this.sendVolumeToRenderers();
        }

        @Override
        public void executePlayerCommand(int playerCommand) {
            boolean playWhenReady = SimpleExoPlayer.this.getPlayWhenReady();
            SimpleExoPlayer.this.updatePlayWhenReady(playWhenReady, playerCommand, SimpleExoPlayer.getPlayWhenReadyChangeReason(playWhenReady, playerCommand));
        }

        @Override
        public void onAudioBecomingNoisy() {
            SimpleExoPlayer.this.updatePlayWhenReady(false, -1, 3);
        }

        @Override
        public void onStreamTypeChanged(int streamType) {
            DeviceInfo deviceInfo = SimpleExoPlayer.createDeviceInfo(SimpleExoPlayer.this.streamVolumeManager);
            if (!deviceInfo.equals(SimpleExoPlayer.this.deviceInfo)) {
                SimpleExoPlayer.this.deviceInfo = deviceInfo;
                for (DeviceListener deviceListener : SimpleExoPlayer.this.deviceListeners) {
                    deviceListener.onDeviceInfoChanged(deviceInfo);
                }
            }
        }

        @Override
        public void onStreamVolumeChanged(int streamVolume, boolean streamMuted) {
            for (DeviceListener deviceListener : SimpleExoPlayer.this.deviceListeners) {
                deviceListener.onDeviceVolumeChanged(streamVolume, streamMuted);
            }
        }

        @Override
        public void onIsLoadingChanged(boolean isLoading) {
            if (SimpleExoPlayer.this.priorityTaskManager != null) {
                if (isLoading && !SimpleExoPlayer.this.isPriorityTaskManagerRegistered) {
                    SimpleExoPlayer.this.priorityTaskManager.add(0);
                    SimpleExoPlayer.this.isPriorityTaskManagerRegistered = true;
                } else if (!isLoading && SimpleExoPlayer.this.isPriorityTaskManagerRegistered) {
                    SimpleExoPlayer.this.priorityTaskManager.remove(0);
                    SimpleExoPlayer.this.isPriorityTaskManagerRegistered = false;
                }
            }
        }

        @Override
        public void onPlaybackStateChanged(int playbackState) {
            SimpleExoPlayer.this.updateWakeAndWifiLock();
        }

        @Override
        public void onPlayWhenReadyChanged(boolean playWhenReady, int reason) {
            SimpleExoPlayer.this.updateWakeAndWifiLock();
        }
    }

    @Deprecated
    public static interface VideoListener
    extends com.akamai.amp.exoplayer2.video.VideoListener {
    }
}

