/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2;

import android.os.SystemClock;
import android.text.TextUtils;
import androidx.annotation.CheckResult;
import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.Format;
import com.akamai.amp.exoplayer2.RendererCapabilities;
import com.akamai.amp.exoplayer2.source.MediaSource;
import com.akamai.amp.exoplayer2.util.Assertions;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.TimeoutException;

public final class ExoPlaybackException
extends Exception {
    public static final int TYPE_SOURCE = 0;
    public static final int TYPE_RENDERER = 1;
    public static final int TYPE_UNEXPECTED = 2;
    public static final int TYPE_REMOTE = 3;
    public static final int TYPE_OUT_OF_MEMORY = 4;
    public static final int TYPE_TIMEOUT = 5;
    public final int type;
    public static final int TIMEOUT_OPERATION_UNDEFINED = 0;
    public static final int TIMEOUT_OPERATION_RELEASE = 1;
    public static final int TIMEOUT_OPERATION_SET_FOREGROUND_MODE = 2;
    @Nullable
    public final String rendererName;
    public final int rendererIndex;
    @Nullable
    public final Format rendererFormat;
    public final int rendererFormatSupport;
    public final int timeoutOperation;
    public final long timestampMs;
    @Nullable
    public final MediaSource.MediaPeriodId mediaPeriodId;
    @Nullable
    private final Throwable cause;

    public static ExoPlaybackException createForSource(IOException cause) {
        return new ExoPlaybackException(0, (Throwable)cause);
    }

    public static ExoPlaybackException createForRenderer(Exception cause, String rendererName, int rendererIndex, @Nullable Format rendererFormat, int rendererFormatSupport) {
        return new ExoPlaybackException(1, cause, null, rendererName, rendererIndex, rendererFormat, rendererFormat == null ? 4 : rendererFormatSupport, 0);
    }

    public static ExoPlaybackException createForUnexpected(RuntimeException cause) {
        return new ExoPlaybackException(2, (Throwable)cause);
    }

    public static ExoPlaybackException createForRemote(String message) {
        return new ExoPlaybackException(3, message);
    }

    public static ExoPlaybackException createForOutOfMemory(OutOfMemoryError cause) {
        return new ExoPlaybackException(4, (Throwable)cause);
    }

    public static ExoPlaybackException createForTimeout(TimeoutException cause, int timeoutOperation) {
        return new ExoPlaybackException(5, cause, null, null, -1, null, 4, timeoutOperation);
    }

    private ExoPlaybackException(int type, Throwable cause) {
        this(type, cause, null, null, -1, null, 4, 0);
    }

    private ExoPlaybackException(int type, String message) {
        this(type, null, message, null, -1, null, 4, 0);
    }

    private ExoPlaybackException(int type, @Nullable Throwable cause, @Nullable String customMessage, @Nullable String rendererName, int rendererIndex, @Nullable Format rendererFormat, int rendererFormatSupport, int timeoutOperation) {
        this(ExoPlaybackException.deriveMessage(type, customMessage, rendererName, rendererIndex, rendererFormat, rendererFormatSupport), cause, type, rendererName, rendererIndex, rendererFormat, rendererFormatSupport, null, timeoutOperation, SystemClock.elapsedRealtime());
    }

    private ExoPlaybackException(@Nullable String message, @Nullable Throwable cause, int type, @Nullable String rendererName, int rendererIndex, @Nullable Format rendererFormat, int rendererFormatSupport, @Nullable MediaSource.MediaPeriodId mediaPeriodId, int timeoutOperation, long timestampMs) {
        super(message, cause);
        this.type = type;
        this.cause = cause;
        this.rendererName = rendererName;
        this.rendererIndex = rendererIndex;
        this.rendererFormat = rendererFormat;
        this.rendererFormatSupport = rendererFormatSupport;
        this.mediaPeriodId = mediaPeriodId;
        this.timeoutOperation = timeoutOperation;
        this.timestampMs = timestampMs;
    }

    public IOException getSourceException() {
        Assertions.checkState(this.type == 0);
        return (IOException)Assertions.checkNotNull(this.cause);
    }

    public Exception getRendererException() {
        Assertions.checkState(this.type == 1);
        return (Exception)Assertions.checkNotNull(this.cause);
    }

    public RuntimeException getUnexpectedException() {
        Assertions.checkState(this.type == 2);
        return (RuntimeException)Assertions.checkNotNull(this.cause);
    }

    public OutOfMemoryError getOutOfMemoryError() {
        Assertions.checkState(this.type == 4);
        return (OutOfMemoryError)Assertions.checkNotNull(this.cause);
    }

    public TimeoutException getTimeoutException() {
        Assertions.checkState(this.type == 5);
        return (TimeoutException)Assertions.checkNotNull(this.cause);
    }

    @CheckResult
    ExoPlaybackException copyWithMediaPeriodId(@Nullable MediaSource.MediaPeriodId mediaPeriodId) {
        return new ExoPlaybackException(this.getMessage(), this.cause, this.type, this.rendererName, this.rendererIndex, this.rendererFormat, this.rendererFormatSupport, mediaPeriodId, this.timeoutOperation, this.timestampMs);
    }

    @Nullable
    private static String deriveMessage(int type, @Nullable String customMessage, @Nullable String rendererName, int rendererIndex, @Nullable Format rendererFormat, int rendererFormatSupport) {
        String message = switch (type) {
            case 0 -> "Source error";
            case 1 -> rendererName + " error, index=" + rendererIndex + ", format=" + rendererFormat + ", format_supported=" + RendererCapabilities.getFormatSupportString(rendererFormatSupport);
            case 3 -> "Remote error";
            case 4 -> "Out of memory error";
            case 5 -> "Timeout error";
            default -> "Unexpected runtime error";
        };
        if (!TextUtils.isEmpty((CharSequence)customMessage)) {
            message = message + ": " + customMessage;
        }
        return message;
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TimeoutOperation {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Type {
    }
}

