/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.utils;

import android.util.Log;
import com.akamai.amp.config.Config;
import com.akamai.amp.media.elements.DRMKey;
import com.akamai.amp.media.elements.Media;
import com.akamai.amp.media.elements.MediaResource;
import com.akamai.amp.media.elements.Source;
import com.akamai.amp.media.exowrapper2.drm.DrmScheme;
import com.akamai.amp.parser.feed.FeedParser;
import com.akamai.amp.parser.feed.MediaParser;
import com.akamai.amp.parser.utils.UtilsParser;
import org.json.JSONException;
import org.json.JSONObject;

public class MediaResourceUtils {
    public static MediaResource createMediaResourceFromURL(String mediaAssetUrl, String extension, DrmScheme drmScheme, String drmLicenseUrl) {
        MediaResource mediaResource = MediaResourceUtils.createMediaResourceFromURL(mediaAssetUrl, drmScheme, drmLicenseUrl);
        mediaResource.setExtension(extension);
        return mediaResource;
    }

    public static MediaResource createMediaResourceFromURL(String mediaAssetUrl, DrmScheme drmScheme, String drmLicenseUrl) {
        MediaResource mediaResource = MediaResourceUtils.createMediaResourceFromURL(mediaAssetUrl);
        mediaResource.setDRMKey(new DRMKey(drmLicenseUrl, drmScheme));
        mediaResource.setSelectedScheme(drmScheme);
        return mediaResource;
    }

    public static MediaResource createMediaResourceFromURL(String mediaAssetUrl, String extension) {
        MediaResource mediaResource = MediaResourceUtils.createMediaResourceFromURL(mediaAssetUrl);
        mediaResource.setExtension(extension);
        return mediaResource;
    }

    public static MediaResource createMediaResourceFromURL(String url) {
        return new MediaResource(url, null);
    }

    public static MediaResource createMediaResourceFromRawMedia(String rawMedia) {
        Media mediaObject = MediaParser.buildMedia(UtilsParser.getObj("media", UtilsParser.getObjectFromString(rawMedia)));
        return MediaResourceUtils.createMediaResourceFromMediaObject(mediaObject);
    }

    public static MediaResource createMediaResourceFromRawFeed(String rawFeed) {
        MediaResource mediaResource = new MediaResource();
        FeedParser mFeedParser = new FeedParser();
        mFeedParser.loadFeedFromString(rawFeed, mediaResource);
        return mediaResource;
    }

    public static MediaResource createMediaResourceFromMediaObject(Media media) {
        MediaResource mediaResource = new MediaResource();
        if (media != null) {
            Config.getConfig().media = media;
            mediaResource.setTitle(media.getTitle());
            mediaResource.setPoster(media.getPoster());
            mediaResource.setDuration(media.getDuration());
            mediaResource.setDRMKeys(media.getDrmKeys());
            if (media.getDrmKeys().size() != 0) {
                mediaResource.setSelectedScheme(media.getDrmKeys().get(0).getDRMScheme());
            }
            if (media.getMetadata() != null) {
                MediaResourceUtils.setMetadata(media, mediaResource);
            } else {
                Log.w((String)"VideoPlayerContainer", (String)"Metadata provided is null");
            }
            if (media.getSource() != null) {
                MediaResourceUtils.setSourcesFromMedia(media, mediaResource);
            } else {
                Log.w((String)"VideoPlayerContainer", (String)"No sources provided");
            }
        } else {
            Log.e((String)MediaResourceUtils.class.getName(), (String)"Media provided is null");
        }
        return mediaResource;
    }

    private static void setMetadata(Media media, MediaResource mediaResource) {
        try {
            JSONObject metadata = new JSONObject(media.getMetadata());
            mediaResource.setMetadata(metadata);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private static void setSourcesFromMedia(Media media, MediaResource mediaResource) throws NullPointerException {
        String backupURL = null;
        for (Source source : media.getSource()) {
            if (source.getType().equals("application/x-mpegURL")) {
                mediaResource.setUrl(source.getSrc());
                continue;
            }
            if (!source.getType().equals("video/mp4")) continue;
            backupURL = source.getSrc();
        }
        if (mediaResource.getUrl() == null && backupURL != null) {
            mediaResource.setUrl(backupURL);
        }
    }
}

