/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.parser.config;

import com.akamai.amp.config.data.MediaAnalyticsData;
import com.akamai.amp.parser.utils.UtilsParser;
import java.util.Hashtable;
import java.util.Iterator;
import org.json.JSONObject;

public class MediaAnalyticsParser {
    public static final String MEDIA_ANALYTICS_TAG = "mediaanalytics";
    public static final String CONFIG_URL_TAG = "config";
    public static final String DIMENSIONES_TAG = "dimensions";

    public MediaAnalyticsData buildMediaAnalyticsData(JSONObject root) {
        JSONObject mediaAnalyticsObject = UtilsParser.getObj(MEDIA_ANALYTICS_TAG, root);
        MediaAnalyticsData mediaAnalyticsData = new MediaAnalyticsData();
        String configURL = UtilsParser.getValue(CONFIG_URL_TAG, mediaAnalyticsObject);
        if (configURL != null) {
            mediaAnalyticsData.setMediaAnalyticsBeacon(configURL);
        }
        JSONObject dimensions = UtilsParser.getObj(DIMENSIONES_TAG, mediaAnalyticsObject);
        Hashtable<String, String> dimensionsTable = new Hashtable<String, String>();
        Iterator i = dimensions.keys();
        while (i.hasNext()) {
            String key = (String)i.next();
            String value = UtilsParser.getValue(key, dimensions);
            dimensionsTable.put(key, value);
        }
        mediaAnalyticsData.setMediaAnalyticsDimensions(dimensionsTable);
        return mediaAnalyticsData;
    }
}

