/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.upstream;

import android.net.Uri;
import android.util.Base64;
import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.ParserException;
import com.akamai.amp.exoplayer2.upstream.BaseDataSource;
import com.akamai.amp.exoplayer2.upstream.DataSourceException;
import com.akamai.amp.exoplayer2.upstream.DataSpec;
import com.akamai.amp.exoplayer2.util.Util;
import com.google.common.base.Charsets;
import java.io.IOException;
import java.net.URLDecoder;

public final class DataSchemeDataSource
extends BaseDataSource {
    public static final String SCHEME_DATA = "data";
    @Nullable
    private DataSpec dataSpec;
    @Nullable
    private byte[] data;
    private int endPosition;
    private int readPosition;

    public DataSchemeDataSource() {
        super(false);
    }

    @Override
    public long open(DataSpec dataSpec) throws IOException {
        this.transferInitializing(dataSpec);
        this.dataSpec = dataSpec;
        this.readPosition = (int)dataSpec.position;
        Uri uri = dataSpec.uri;
        String scheme = uri.getScheme();
        if (!SCHEME_DATA.equals(scheme)) {
            throw new ParserException("Unsupported scheme: " + scheme);
        }
        String[] uriParts = Util.split(uri.getSchemeSpecificPart(), ",");
        if (uriParts.length != 2) {
            throw new ParserException("Unexpected URI format: " + uri);
        }
        String dataString = uriParts[1];
        if (uriParts[0].contains(";base64")) {
            try {
                this.data = Base64.decode((String)dataString, (int)0);
            }
            catch (IllegalArgumentException e) {
                throw new ParserException("Error while parsing Base64 encoded string: " + dataString, e);
            }
        } else {
            this.data = Util.getUtf8Bytes(URLDecoder.decode(dataString, Charsets.US_ASCII.name()));
        }
        int n = this.endPosition = dataSpec.length != -1L ? (int)dataSpec.length + this.readPosition : this.data.length;
        if (this.endPosition > this.data.length || this.readPosition > this.endPosition) {
            this.data = null;
            throw new DataSourceException(0);
        }
        this.transferStarted(dataSpec);
        return (long)this.endPosition - (long)this.readPosition;
    }

    @Override
    public int read(byte[] buffer, int offset, int readLength) {
        if (readLength == 0) {
            return 0;
        }
        int remainingBytes = this.endPosition - this.readPosition;
        if (remainingBytes == 0) {
            return -1;
        }
        readLength = Math.min(readLength, remainingBytes);
        System.arraycopy(Util.castNonNull(this.data), this.readPosition, buffer, offset, readLength);
        this.readPosition += readLength;
        this.bytesTransferred(readLength);
        return readLength;
    }

    @Override
    @Nullable
    public Uri getUri() {
        return this.dataSpec != null ? this.dataSpec.uri : null;
    }

    @Override
    public void close() {
        if (this.data != null) {
            this.data = null;
            this.transferEnded();
        }
        this.dataSpec = null;
    }
}

