/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.upstream;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.net.Uri;
import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.upstream.BaseDataSource;
import com.akamai.amp.exoplayer2.upstream.DataSpec;
import com.akamai.amp.exoplayer2.util.Util;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.FileChannel;

public final class ContentDataSource
extends BaseDataSource {
    private final ContentResolver resolver;
    @Nullable
    private Uri uri;
    @Nullable
    private AssetFileDescriptor assetFileDescriptor;
    @Nullable
    private FileInputStream inputStream;
    private long bytesRemaining;
    private boolean opened;

    public ContentDataSource(Context context) {
        super(false);
        this.resolver = context.getContentResolver();
    }

    @Override
    public long open(DataSpec dataSpec) throws ContentDataSourceException {
        try {
            FileInputStream inputStream;
            AssetFileDescriptor assetFileDescriptor;
            Uri uri;
            this.uri = uri = dataSpec.uri;
            this.transferInitializing(dataSpec);
            this.assetFileDescriptor = assetFileDescriptor = this.resolver.openAssetFileDescriptor(uri, "r");
            if (assetFileDescriptor == null) {
                throw new FileNotFoundException("Could not open file descriptor for: " + uri);
            }
            this.inputStream = inputStream = new FileInputStream(assetFileDescriptor.getFileDescriptor());
            long assetStartOffset = assetFileDescriptor.getStartOffset();
            long skipped = inputStream.skip(assetStartOffset + dataSpec.position) - assetStartOffset;
            if (skipped != dataSpec.position) {
                throw new EOFException();
            }
            if (dataSpec.length != -1L) {
                this.bytesRemaining = dataSpec.length;
            } else {
                long assetFileDescriptorLength = assetFileDescriptor.getLength();
                if (assetFileDescriptorLength == -1L) {
                    FileChannel channel = inputStream.getChannel();
                    long channelSize = channel.size();
                    if (channelSize == 0L) {
                        this.bytesRemaining = -1L;
                    } else {
                        this.bytesRemaining = channelSize - channel.position();
                        if (this.bytesRemaining < 0L) {
                            throw new EOFException();
                        }
                    }
                } else {
                    this.bytesRemaining = assetFileDescriptorLength - skipped;
                    if (this.bytesRemaining < 0L) {
                        throw new EOFException();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new ContentDataSourceException(e);
        }
        this.opened = true;
        this.transferStarted(dataSpec);
        return this.bytesRemaining;
    }

    @Override
    public int read(byte[] buffer, int offset, int readLength) throws ContentDataSourceException {
        int bytesRead;
        if (readLength == 0) {
            return 0;
        }
        if (this.bytesRemaining == 0L) {
            return -1;
        }
        try {
            int bytesToRead = this.bytesRemaining == -1L ? readLength : (int)Math.min(this.bytesRemaining, (long)readLength);
            bytesRead = Util.castNonNull(this.inputStream).read(buffer, offset, bytesToRead);
        }
        catch (IOException e) {
            throw new ContentDataSourceException(e);
        }
        if (bytesRead == -1) {
            if (this.bytesRemaining != -1L) {
                throw new ContentDataSourceException(new EOFException());
            }
            return -1;
        }
        if (this.bytesRemaining != -1L) {
            this.bytesRemaining -= (long)bytesRead;
        }
        this.bytesTransferred(bytesRead);
        return bytesRead;
    }

    @Override
    @Nullable
    public Uri getUri() {
        return this.uri;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() throws ContentDataSourceException {
        this.uri = null;
        try {
            if (this.inputStream == null) return;
            this.inputStream.close();
            return;
        }
        catch (IOException e) {
            throw new ContentDataSourceException(e);
        }
        finally {
            this.inputStream = null;
            try {
                if (this.assetFileDescriptor != null) {
                    this.assetFileDescriptor.close();
                }
            }
            catch (IOException e) {
                throw new ContentDataSourceException(e);
            }
            finally {
                this.assetFileDescriptor = null;
                if (this.opened) {
                    this.opened = false;
                    this.transferEnded();
                }
            }
        }
    }

    public static class ContentDataSourceException
    extends IOException {
        public ContentDataSourceException(IOException cause) {
            super(cause);
        }
    }
}

