/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.metadata.icy;

import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.metadata.Metadata;
import com.akamai.amp.exoplayer2.metadata.MetadataInputBuffer;
import com.akamai.amp.exoplayer2.metadata.SimpleMetadataDecoder;
import com.akamai.amp.exoplayer2.metadata.icy.IcyInfo;
import com.akamai.amp.exoplayer2.util.Util;
import com.google.common.base.Charsets;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class IcyDecoder
extends SimpleMetadataDecoder {
    private static final Pattern METADATA_ELEMENT = Pattern.compile("(.+?)='(.*?)';", 32);
    private static final String STREAM_KEY_NAME = "streamtitle";
    private static final String STREAM_KEY_URL = "streamurl";
    private final CharsetDecoder utf8Decoder = Charsets.UTF_8.newDecoder();
    private final CharsetDecoder iso88591Decoder = Charsets.ISO_8859_1.newDecoder();

    @Override
    protected Metadata decode(MetadataInputBuffer inputBuffer, ByteBuffer buffer) {
        String icyString = this.decodeToString(buffer);
        byte[] icyBytes = new byte[buffer.limit()];
        buffer.get(icyBytes);
        if (icyString == null) {
            return new Metadata(new IcyInfo(icyBytes, null, null));
        }
        String name = null;
        String url = null;
        int index = 0;
        Matcher matcher = METADATA_ELEMENT.matcher(icyString);
        while (matcher.find(index)) {
            String key = Util.toLowerInvariant(matcher.group(1));
            String value = matcher.group(2);
            if (key != null) {
                switch (key) {
                    case "streamtitle": {
                        name = value;
                        break;
                    }
                    case "streamurl": {
                        url = value;
                        break;
                    }
                }
            }
            index = matcher.end();
        }
        return new Metadata(new IcyInfo(icyBytes, name, url));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private String decodeToString(ByteBuffer data) {
        try {
            String string2 = this.utf8Decoder.decode(data).toString();
            return string2;
        }
        catch (CharacterCodingException characterCodingException) {
        }
        finally {
            this.utf8Decoder.reset();
            data.rewind();
        }
        try {
            String string3 = this.iso88591Decoder.decode(data).toString();
            return string3;
        }
        catch (CharacterCodingException e) {
            String string4 = null;
            return string4;
        }
        finally {
            this.iso88591Decoder.reset();
            data.rewind();
        }
    }
}

