/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.utils;

import android.os.Handler;
import android.os.Looper;
import com.akamai.amp.media.VideoPlayerView;
import com.akamai.amp.utils.LogManager;
import java.util.Objects;

public class PlayerDataPool {
    private final int REFRESH_RATE = 500;
    public VideoPlayerView playerInstance;
    public long currentStreamPositionMS;
    public String protocol;
    public int streamType;
    public int videoWidth;
    public int videoHeight;
    public long currentBitrate;
    public int dropFramesCount;
    public int streamDuration;
    public boolean buffering;
    public int width;
    public int height;
    public boolean paused;
    private Handler dataPoolHandler;
    private final Runnable dataPollRunnable = new Runnable(){

        @Override
        public void run() {
            PlayerDataPool.this.currentStreamPositionMS = PlayerDataPool.this.playerInstance.getCurrentStreamPositionMS();
            PlayerDataPool.this.protocol = PlayerDataPool.this.playerInstance.getProtocol();
            PlayerDataPool.this.streamType = PlayerDataPool.this.playerInstance.getStreamType();
            PlayerDataPool.this.videoWidth = PlayerDataPool.this.playerInstance.getVideoWidth();
            PlayerDataPool.this.videoHeight = PlayerDataPool.this.playerInstance.getVideoHeight();
            PlayerDataPool.this.currentBitrate = PlayerDataPool.this.playerInstance.getCurrentBitrate();
            PlayerDataPool.this.dropFramesCount = PlayerDataPool.this.playerInstance.getDropFramesCount();
            PlayerDataPool.this.streamDuration = PlayerDataPool.this.playerInstance.getStreamDuration();
            PlayerDataPool.this.buffering = PlayerDataPool.this.playerInstance.isBuffering();
            PlayerDataPool.this.width = PlayerDataPool.this.playerInstance.getWidth();
            PlayerDataPool.this.height = PlayerDataPool.this.playerInstance.getHeight();
            PlayerDataPool.this.paused = PlayerDataPool.this.playerInstance.isPaused();
            PlayerDataPool.this.dataPoolHandler.postDelayed((Runnable)this, 500L);
        }
    };

    public PlayerDataPool(VideoPlayerView playerInstance) {
        this.playerInstance = Objects.requireNonNull(playerInstance);
        this.initDataUpdate();
    }

    private void initDataUpdate() {
        Looper playerLooper = this.playerInstance.getCurrentLooper();
        if (playerLooper != null) {
            this.dataPoolHandler = new Handler(playerLooper);
            this.dataPoolHandler.post(this.dataPollRunnable);
        } else {
            LogManager.error(this.getClass().getCanonicalName(), "Player Looper is invalid, Mux Event Bus can't gather data");
        }
    }

    public void stopPlayerUpdate() {
        if (this.dataPoolHandler != null) {
            this.dataPoolHandler.removeCallbacks(this.dataPollRunnable);
        }
    }
}

