/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.license.manager;

import android.content.Context;
import android.webkit.URLUtil;
import com.akamai.amp.license.manager.AES256LicenseDecryption;
import com.akamai.amp.license.manager.LicenseGetTask;
import com.akamai.amp.license.manager.OnLicenseTaskCompleted;
import com.akamai.amp.utils.LogManager;
import org.json.JSONException;
import org.json.JSONObject;

public class AMPLicenseManager {
    public static LICENSE_TYPE licenseTypeSelected = LICENSE_TYPE.NONE;
    private static AMPLicenseManager instance;
    private String apiKey;
    private boolean licenseRequested;
    private boolean licenseRetrieved;
    private LicenseValidationListener licenseValidationListener;
    private AES256LicenseDecryption aes256LicenseDecryption = new AES256LicenseDecryption();
    private static final String AMP_LICENSE_ENDPOINT = "https://amp.akamaized.net/hosted/2.0/player.esi?";

    public static AMPLicenseManager getInstance() {
        if (instance == null) {
            instance = new AMPLicenseManager();
        }
        return instance;
    }

    public void requestLicenseWithApiKey() {
        this.licenseRequested = true;
        String stringURL = "https://amp.akamaized.net/hosted/2.0/player.esi?apikey=" + this.apiKey;
        if (URLUtil.isValidUrl((String)stringURL)) {
            new LicenseGetTask(new OnLicenseTaskCompleted(){

                @Override
                public void onLicenseRetrievedSuccessfully(String encryptedResult) {
                    try {
                        JSONObject licenseValue = new JSONObject(encryptedResult);
                        AMPLicenseManager.this.aes256LicenseDecryption.setAllowPlaybackUponFail(false);
                        AMPLicenseManager.this.aes256LicenseDecryption.setEncryptedResult(licenseValue.getString("token"));
                    }
                    catch (JSONException e) {
                        AMPLicenseManager.this.aes256LicenseDecryption.setAllowPlaybackUponFail(true);
                    }
                    AMPLicenseManager.this.licenseRetrieved = true;
                    if (AMPLicenseManager.this.licenseValidationListener != null) {
                        AMPLicenseManager.this.licenseValidationListener.licenseValidated();
                    }
                }

                @Override
                public void onLicenseFailed(boolean allowPlayback) {
                    if (!allowPlayback) {
                        String message = "The api key provided is invalid";
                        LogManager.error("Api Key", message);
                    }
                    AMPLicenseManager.this.aes256LicenseDecryption.setAllowPlaybackUponFail(allowPlayback);
                    AMPLicenseManager.this.licenseRetrieved = true;
                    if (AMPLicenseManager.this.licenseValidationListener != null) {
                        AMPLicenseManager.this.licenseValidationListener.licenseValidated();
                    }
                }
            }).execute(new String[]{stringURL});
        }
    }

    public static void setApiKey(String apiKey) {
        AMPLicenseManager licenseHandler = AMPLicenseManager.getInstance();
        if (licenseHandler.licenseRetrieved) {
            return;
        }
        licenseHandler.apiKey = apiKey;
        licenseTypeSelected = LICENSE_TYPE.AES256;
        licenseHandler.requestLicenseWithApiKey();
    }

    public void allowLicenseRecheck() {
        AMPLicenseManager.instance.licenseRetrieved = false;
    }

    public static void flushLicense() {
        AMPLicenseManager.instance.aes256LicenseDecryption = null;
        AMPLicenseManager.instance.licenseRetrieved = false;
        AMPLicenseManager.instance.licenseRequested = false;
        AMPLicenseManager.instance.apiKey = null;
        instance = null;
    }

    public boolean isLicenseAllowingPlaybackUponFail() {
        boolean licenseValidationIncomplete;
        boolean bl = licenseValidationIncomplete = this.aes256LicenseDecryption != null && this.aes256LicenseDecryption.isAllowPlaybackUponFail();
        if (licenseValidationIncomplete) {
            LogManager.log("Api Key", "License was validated correctly before, no validation retries");
        } else {
            LogManager.error("Api Key", "License validation is incomplete, AMP will try to validate the API key again");
        }
        return licenseValidationIncomplete;
    }

    public boolean isLicenseRetrieved() {
        if (this.licenseRetrieved) {
            LogManager.log("Api Key", "License has been retrieved");
        } else {
            LogManager.error("Api Key", "License hasn't been retrieved");
        }
        return this.licenseRetrieved;
    }

    public boolean isLicenseRequested() {
        if (this.licenseRequested) {
            LogManager.log("Api Key", "License requested");
        } else {
            LogManager.error("Api Key", "License NOT requested");
        }
        return this.licenseRequested;
    }

    public void setLicenseValidationListener(LicenseValidationListener licenseValidationListener) {
        this.licenseValidationListener = licenseValidationListener;
        if (this.licenseRetrieved) {
            licenseValidationListener.licenseValidated();
        }
    }

    public boolean isLicenseValid(Context context) {
        boolean licenseIsValid = this.aes256LicenseDecryption.isLicenseValid(context);
        if (licenseIsValid) {
            LogManager.log("Api Key", "License is Valid!");
        }
        return licenseIsValid;
    }

    public AES256LicenseDecryption getAes256LicenseDecryption() {
        return this.aes256LicenseDecryption;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public static enum LICENSE_TYPE {
        AES256,
        RSA,
        NONE;

    }

    public static interface LicenseValidationListener {
        public void licenseValidated();
    }
}

