/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.trackselection;

import android.content.Context;
import android.graphics.Point;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Pair;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.ExoPlaybackException;
import com.akamai.amp.exoplayer2.Format;
import com.akamai.amp.exoplayer2.RendererCapabilities;
import com.akamai.amp.exoplayer2.RendererConfiguration;
import com.akamai.amp.exoplayer2.source.TrackGroup;
import com.akamai.amp.exoplayer2.source.TrackGroupArray;
import com.akamai.amp.exoplayer2.trackselection.AdaptiveTrackSelection;
import com.akamai.amp.exoplayer2.trackselection.MappingTrackSelector;
import com.akamai.amp.exoplayer2.trackselection.TrackSelection;
import com.akamai.amp.exoplayer2.trackselection.TrackSelectionParameters;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.Util;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.checkerframework.checker.initialization.qual.UnderInitialization;
import org.checkerframework.checker.nullness.compatqual.NullableType;

public class DefaultTrackSelector
extends MappingTrackSelector {
    private static final float FRACTION_TO_CONSIDER_FULLSCREEN = 0.98f;
    private static final int[] NO_TRACKS = new int[0];
    private static final Ordering<Integer> FORMAT_VALUE_ORDERING = Ordering.from((first, second) -> first == -1 ? (second == -1 ? 0 : -1) : (second == -1 ? 1 : first - second));
    private static final Ordering<Integer> NO_ORDER = Ordering.from((first, second) -> 0);
    private final TrackSelection.Factory trackSelectionFactory;
    private final AtomicReference<Parameters> parametersReference;
    private boolean allowMultipleAdaptiveSelections;

    @Deprecated
    public DefaultTrackSelector() {
        this(Parameters.DEFAULT_WITHOUT_CONTEXT, (TrackSelection.Factory)new AdaptiveTrackSelection.Factory());
    }

    @Deprecated
    public DefaultTrackSelector(TrackSelection.Factory trackSelectionFactory) {
        this(Parameters.DEFAULT_WITHOUT_CONTEXT, trackSelectionFactory);
    }

    public DefaultTrackSelector(Context context) {
        this(context, (TrackSelection.Factory)new AdaptiveTrackSelection.Factory());
    }

    public DefaultTrackSelector(Context context, TrackSelection.Factory trackSelectionFactory) {
        this(Parameters.getDefaults(context), trackSelectionFactory);
    }

    public DefaultTrackSelector(Parameters parameters, TrackSelection.Factory trackSelectionFactory) {
        this.trackSelectionFactory = trackSelectionFactory;
        this.parametersReference = new AtomicReference<Parameters>(parameters);
    }

    public void setParameters(Parameters parameters) {
        Assertions.checkNotNull(parameters);
        if (!this.parametersReference.getAndSet(parameters).equals(parameters)) {
            this.invalidate();
        }
    }

    public void setParameters(ParametersBuilder parametersBuilder) {
        this.setParameters(parametersBuilder.build());
    }

    public Parameters getParameters() {
        return this.parametersReference.get();
    }

    public ParametersBuilder buildUponParameters() {
        return this.getParameters().buildUpon();
    }

    public void experimentalAllowMultipleAdaptiveSelections() {
        this.allowMultipleAdaptiveSelections = true;
    }

    @Override
    protected final Pair<@NullableType RendererConfiguration[], @NullableType TrackSelection[]> selectTracks(MappingTrackSelector.MappedTrackInfo mappedTrackInfo, int[][][] rendererFormatSupports, int[] rendererMixedMimeTypeAdaptationSupports) throws ExoPlaybackException {
        Parameters params = this.parametersReference.get();
        int rendererCount = mappedTrackInfo.getRendererCount();
        @NullableType TrackSelection.Definition[] definitions = this.selectAllTracks(mappedTrackInfo, rendererFormatSupports, rendererMixedMimeTypeAdaptationSupports, params);
        for (int i = 0; i < rendererCount; ++i) {
            if (params.getRendererDisabled(i)) {
                definitions[i] = null;
                continue;
            }
            TrackGroupArray rendererTrackGroups = mappedTrackInfo.getTrackGroups(i);
            if (!params.hasSelectionOverride(i, rendererTrackGroups)) continue;
            SelectionOverride override = params.getSelectionOverride(i, rendererTrackGroups);
            definitions[i] = override == null ? null : new TrackSelection.Definition(rendererTrackGroups.get(override.groupIndex), override.tracks, override.reason, (Object)override.data);
        }
        @NullableType TrackSelection[] rendererTrackSelections = this.trackSelectionFactory.createTrackSelections(definitions, this.getBandwidthMeter());
        @NullableType RendererConfiguration[] rendererConfigurations = new RendererConfiguration[rendererCount];
        for (int i = 0; i < rendererCount; ++i) {
            boolean forceRendererDisabled = params.getRendererDisabled(i);
            boolean rendererEnabled = !forceRendererDisabled && (mappedTrackInfo.getRendererType(i) == 6 || rendererTrackSelections[i] != null);
            rendererConfigurations[i] = rendererEnabled ? RendererConfiguration.DEFAULT : null;
        }
        DefaultTrackSelector.maybeConfigureRenderersForTunneling(mappedTrackInfo, rendererFormatSupports, rendererConfigurations, rendererTrackSelections, params.tunnelingAudioSessionId);
        return Pair.create((Object)rendererConfigurations, (Object)rendererTrackSelections);
    }

    protected @NullableType TrackSelection.Definition[] selectAllTracks(MappingTrackSelector.MappedTrackInfo mappedTrackInfo, int[][][] rendererFormatSupports, int[] rendererMixedMimeTypeAdaptationSupports, Parameters params) throws ExoPlaybackException {
        int rendererCount = mappedTrackInfo.getRendererCount();
        @NullableType TrackSelection.Definition[] definitions = new TrackSelection.Definition[rendererCount];
        boolean seenVideoRendererWithMappedTracks = false;
        boolean selectedVideoTracks = false;
        for (int i = 0; i < rendererCount; ++i) {
            if (2 != mappedTrackInfo.getRendererType(i)) continue;
            if (!selectedVideoTracks) {
                definitions[i] = this.selectVideoTrack(mappedTrackInfo.getTrackGroups(i), rendererFormatSupports[i], rendererMixedMimeTypeAdaptationSupports[i], params, true);
                selectedVideoTracks = definitions[i] != null;
            }
            seenVideoRendererWithMappedTracks |= mappedTrackInfo.getTrackGroups((int)i).length > 0;
        }
        AudioTrackScore selectedAudioTrackScore = null;
        String selectedAudioLanguage = null;
        int selectedAudioRendererIndex = -1;
        for (int i = 0; i < rendererCount; ++i) {
            TrackSelection.Definition definition;
            if (1 != mappedTrackInfo.getRendererType(i)) continue;
            boolean enableAdaptiveTrackSelection = this.allowMultipleAdaptiveSelections || !seenVideoRendererWithMappedTracks;
            Pair<TrackSelection.Definition, AudioTrackScore> audioSelection = this.selectAudioTrack(mappedTrackInfo.getTrackGroups(i), rendererFormatSupports[i], rendererMixedMimeTypeAdaptationSupports[i], params, enableAdaptiveTrackSelection);
            if (audioSelection == null || selectedAudioTrackScore != null && ((AudioTrackScore)audioSelection.second).compareTo(selectedAudioTrackScore) <= 0) continue;
            if (selectedAudioRendererIndex != -1) {
                definitions[selectedAudioRendererIndex] = null;
            }
            definitions[i] = definition = (TrackSelection.Definition)audioSelection.first;
            selectedAudioLanguage = definition.group.getFormat((int)definition.tracks[0]).language;
            selectedAudioTrackScore = (AudioTrackScore)audioSelection.second;
            selectedAudioRendererIndex = i;
        }
        TextTrackScore selectedTextTrackScore = null;
        int selectedTextRendererIndex = -1;
        block6: for (int i = 0; i < rendererCount; ++i) {
            int trackType = mappedTrackInfo.getRendererType(i);
            switch (trackType) {
                case 1: 
                case 2: {
                    continue block6;
                }
                case 3: {
                    Pair<TrackSelection.Definition, TextTrackScore> textSelection = this.selectTextTrack(mappedTrackInfo.getTrackGroups(i), rendererFormatSupports[i], params, selectedAudioLanguage);
                    if (textSelection == null || selectedTextTrackScore != null && ((TextTrackScore)textSelection.second).compareTo(selectedTextTrackScore) <= 0) continue block6;
                    if (selectedTextRendererIndex != -1) {
                        definitions[selectedTextRendererIndex] = null;
                    }
                    definitions[i] = (TrackSelection.Definition)textSelection.first;
                    selectedTextTrackScore = (TextTrackScore)textSelection.second;
                    selectedTextRendererIndex = i;
                    continue block6;
                }
                default: {
                    definitions[i] = this.selectOtherTrack(trackType, mappedTrackInfo.getTrackGroups(i), rendererFormatSupports[i], params);
                }
            }
        }
        return definitions;
    }

    @Nullable
    protected TrackSelection.Definition selectVideoTrack(TrackGroupArray groups, int[][] formatSupport, int mixedMimeTypeAdaptationSupports, Parameters params, boolean enableAdaptiveTrackSelection) throws ExoPlaybackException {
        TrackSelection.Definition definition = null;
        if (!params.forceHighestSupportedBitrate && !params.forceLowestBitrate && enableAdaptiveTrackSelection) {
            definition = DefaultTrackSelector.selectAdaptiveVideoTrack(groups, formatSupport, mixedMimeTypeAdaptationSupports, params);
        }
        if (definition == null) {
            definition = DefaultTrackSelector.selectFixedVideoTrack(groups, formatSupport, params);
        }
        return definition;
    }

    @Nullable
    private static TrackSelection.Definition selectAdaptiveVideoTrack(TrackGroupArray groups, int[][] formatSupport, int mixedMimeTypeAdaptationSupports, Parameters params) {
        int requiredAdaptiveSupport = params.allowVideoNonSeamlessAdaptiveness ? 24 : 16;
        boolean allowMixedMimeTypes = params.allowVideoMixedMimeTypeAdaptiveness && (mixedMimeTypeAdaptationSupports & requiredAdaptiveSupport) != 0;
        for (int i = 0; i < groups.length; ++i) {
            TrackGroup group = groups.get(i);
            int[] adaptiveTracks = DefaultTrackSelector.getAdaptiveVideoTracksForGroup(group, formatSupport[i], allowMixedMimeTypes, requiredAdaptiveSupport, params.maxVideoWidth, params.maxVideoHeight, params.maxVideoFrameRate, params.maxVideoBitrate, params.minVideoWidth, params.minVideoHeight, params.minVideoFrameRate, params.minVideoBitrate, params.viewportWidth, params.viewportHeight, params.viewportOrientationMayChange);
            if (adaptiveTracks.length <= 0) continue;
            return new TrackSelection.Definition(group, adaptiveTracks);
        }
        return null;
    }

    private static int[] getAdaptiveVideoTracksForGroup(TrackGroup group, int[] formatSupport, boolean allowMixedMimeTypes, int requiredAdaptiveSupport, int maxVideoWidth, int maxVideoHeight, int maxVideoFrameRate, int maxVideoBitrate, int minVideoWidth, int minVideoHeight, int minVideoFrameRate, int minVideoBitrate, int viewportWidth, int viewportHeight, boolean viewportOrientationMayChange) {
        if (group.length < 2) {
            return NO_TRACKS;
        }
        List<Integer> selectedTrackIndices = DefaultTrackSelector.getViewportFilteredTrackIndices(group, viewportWidth, viewportHeight, viewportOrientationMayChange);
        if (selectedTrackIndices.size() < 2) {
            return NO_TRACKS;
        }
        String selectedMimeType = null;
        if (!allowMixedMimeTypes) {
            HashSet<@NullableType String> seenMimeTypes = new HashSet<String>();
            int selectedMimeTypeTrackCount = 0;
            for (int i = 0; i < selectedTrackIndices.size(); ++i) {
                int countForMimeType;
                int trackIndex = selectedTrackIndices.get(i);
                String sampleMimeType = group.getFormat((int)trackIndex).sampleMimeType;
                if (!seenMimeTypes.add(sampleMimeType) || (countForMimeType = DefaultTrackSelector.getAdaptiveVideoTrackCountForMimeType(group, formatSupport, requiredAdaptiveSupport, sampleMimeType, maxVideoWidth, maxVideoHeight, maxVideoFrameRate, maxVideoBitrate, minVideoWidth, minVideoHeight, minVideoFrameRate, minVideoBitrate, selectedTrackIndices)) <= selectedMimeTypeTrackCount) continue;
                selectedMimeType = sampleMimeType;
                selectedMimeTypeTrackCount = countForMimeType;
            }
        }
        DefaultTrackSelector.filterAdaptiveVideoTrackCountForMimeType(group, formatSupport, requiredAdaptiveSupport, selectedMimeType, maxVideoWidth, maxVideoHeight, maxVideoFrameRate, maxVideoBitrate, minVideoWidth, minVideoHeight, minVideoFrameRate, minVideoBitrate, selectedTrackIndices);
        return selectedTrackIndices.size() < 2 ? NO_TRACKS : Ints.toArray(selectedTrackIndices);
    }

    private static int getAdaptiveVideoTrackCountForMimeType(TrackGroup group, int[] formatSupport, int requiredAdaptiveSupport, @Nullable String mimeType, int maxVideoWidth, int maxVideoHeight, int maxVideoFrameRate, int maxVideoBitrate, int minVideoWidth, int minVideoHeight, int minVideoFrameRate, int minVideoBitrate, List<Integer> selectedTrackIndices) {
        int adaptiveTrackCount = 0;
        for (int i = 0; i < selectedTrackIndices.size(); ++i) {
            int trackIndex = selectedTrackIndices.get(i);
            if (!DefaultTrackSelector.isSupportedAdaptiveVideoTrack(group.getFormat(trackIndex), mimeType, formatSupport[trackIndex], requiredAdaptiveSupport, maxVideoWidth, maxVideoHeight, maxVideoFrameRate, maxVideoBitrate, minVideoWidth, minVideoHeight, minVideoFrameRate, minVideoBitrate)) continue;
            ++adaptiveTrackCount;
        }
        return adaptiveTrackCount;
    }

    private static void filterAdaptiveVideoTrackCountForMimeType(TrackGroup group, int[] formatSupport, int requiredAdaptiveSupport, @Nullable String mimeType, int maxVideoWidth, int maxVideoHeight, int maxVideoFrameRate, int maxVideoBitrate, int minVideoWidth, int minVideoHeight, int minVideoFrameRate, int minVideoBitrate, List<Integer> selectedTrackIndices) {
        for (int i = selectedTrackIndices.size() - 1; i >= 0; --i) {
            int trackIndex = selectedTrackIndices.get(i);
            if (DefaultTrackSelector.isSupportedAdaptiveVideoTrack(group.getFormat(trackIndex), mimeType, formatSupport[trackIndex], requiredAdaptiveSupport, maxVideoWidth, maxVideoHeight, maxVideoFrameRate, maxVideoBitrate, minVideoWidth, minVideoHeight, minVideoFrameRate, minVideoBitrate)) continue;
            selectedTrackIndices.remove(i);
        }
    }

    private static boolean isSupportedAdaptiveVideoTrack(Format format, @Nullable String mimeType, int formatSupport, int requiredAdaptiveSupport, int maxVideoWidth, int maxVideoHeight, int maxVideoFrameRate, int maxVideoBitrate, int minVideoWidth, int minVideoHeight, int minVideoFrameRate, int minVideoBitrate) {
        if ((format.roleFlags & 0x4000) != 0) {
            return false;
        }
        return DefaultTrackSelector.isSupported(formatSupport, false) && (formatSupport & requiredAdaptiveSupport) != 0 && (mimeType == null || Util.areEqual(format.sampleMimeType, mimeType)) && (format.width == -1 || minVideoWidth <= format.width && format.width <= maxVideoWidth) && (format.height == -1 || minVideoHeight <= format.height && format.height <= maxVideoHeight) && (format.frameRate == -1.0f || (float)minVideoFrameRate <= format.frameRate && format.frameRate <= (float)maxVideoFrameRate) && (format.bitrate == -1 || minVideoBitrate <= format.bitrate && format.bitrate <= maxVideoBitrate);
    }

    @Nullable
    private static TrackSelection.Definition selectFixedVideoTrack(TrackGroupArray groups, int[][] formatSupport, Parameters params) {
        int selectedTrackIndex = -1;
        TrackGroup selectedGroup = null;
        VideoTrackScore selectedTrackScore = null;
        for (int groupIndex = 0; groupIndex < groups.length; ++groupIndex) {
            TrackGroup trackGroup = groups.get(groupIndex);
            List<Integer> viewportFilteredTrackIndices = DefaultTrackSelector.getViewportFilteredTrackIndices(trackGroup, params.viewportWidth, params.viewportHeight, params.viewportOrientationMayChange);
            int[] trackFormatSupport = formatSupport[groupIndex];
            for (int trackIndex = 0; trackIndex < trackGroup.length; ++trackIndex) {
                Format format = trackGroup.getFormat(trackIndex);
                if ((format.roleFlags & 0x4000) != 0 || !DefaultTrackSelector.isSupported(trackFormatSupport[trackIndex], params.exceedRendererCapabilitiesIfNecessary)) continue;
                VideoTrackScore trackScore = new VideoTrackScore(format, params, trackFormatSupport[trackIndex], viewportFilteredTrackIndices.contains(trackIndex));
                if (!trackScore.isWithinMaxConstraints && !params.exceedVideoConstraintsIfNecessary || selectedTrackScore != null && trackScore.compareTo(selectedTrackScore) <= 0) continue;
                selectedGroup = trackGroup;
                selectedTrackIndex = trackIndex;
                selectedTrackScore = trackScore;
            }
        }
        return selectedGroup == null ? null : new TrackSelection.Definition(selectedGroup, selectedTrackIndex);
    }

    @Nullable
    protected Pair<TrackSelection.Definition, AudioTrackScore> selectAudioTrack(TrackGroupArray groups, int[][] formatSupport, int mixedMimeTypeAdaptationSupports, Parameters params, boolean enableAdaptiveTrackSelection) throws ExoPlaybackException {
        int[] adaptiveTracks;
        int selectedTrackIndex = -1;
        int selectedGroupIndex = -1;
        AudioTrackScore selectedTrackScore = null;
        for (int groupIndex = 0; groupIndex < groups.length; ++groupIndex) {
            TrackGroup trackGroup = groups.get(groupIndex);
            int[] trackFormatSupport = formatSupport[groupIndex];
            for (int trackIndex = 0; trackIndex < trackGroup.length; ++trackIndex) {
                if (!DefaultTrackSelector.isSupported(trackFormatSupport[trackIndex], params.exceedRendererCapabilitiesIfNecessary)) continue;
                Format format = trackGroup.getFormat(trackIndex);
                AudioTrackScore trackScore = new AudioTrackScore(format, params, trackFormatSupport[trackIndex]);
                if (!trackScore.isWithinConstraints && !params.exceedAudioConstraintsIfNecessary || selectedTrackScore != null && trackScore.compareTo(selectedTrackScore) <= 0) continue;
                selectedGroupIndex = groupIndex;
                selectedTrackIndex = trackIndex;
                selectedTrackScore = trackScore;
            }
        }
        if (selectedGroupIndex == -1) {
            return null;
        }
        TrackGroup selectedGroup = groups.get(selectedGroupIndex);
        TrackSelection.Definition definition = null;
        if (!params.forceHighestSupportedBitrate && !params.forceLowestBitrate && enableAdaptiveTrackSelection && (adaptiveTracks = DefaultTrackSelector.getAdaptiveAudioTracks(selectedGroup, formatSupport[selectedGroupIndex], selectedTrackIndex, params.maxAudioBitrate, params.allowAudioMixedMimeTypeAdaptiveness, params.allowAudioMixedSampleRateAdaptiveness, params.allowAudioMixedChannelCountAdaptiveness)).length > 1) {
            definition = new TrackSelection.Definition(selectedGroup, adaptiveTracks);
        }
        if (definition == null) {
            definition = new TrackSelection.Definition(selectedGroup, selectedTrackIndex);
        }
        return Pair.create(definition, (Object)Assertions.checkNotNull(selectedTrackScore));
    }

    private static int[] getAdaptiveAudioTracks(TrackGroup group, int[] formatSupport, int primaryTrackIndex, int maxAudioBitrate, boolean allowMixedMimeTypeAdaptiveness, boolean allowMixedSampleRateAdaptiveness, boolean allowAudioMixedChannelCountAdaptiveness) {
        Format primaryFormat = group.getFormat(primaryTrackIndex);
        int[] adaptiveIndices = new int[group.length];
        int count = 0;
        for (int i = 0; i < group.length; ++i) {
            if (i != primaryTrackIndex && !DefaultTrackSelector.isSupportedAdaptiveAudioTrack(group.getFormat(i), formatSupport[i], primaryFormat, maxAudioBitrate, allowMixedMimeTypeAdaptiveness, allowMixedSampleRateAdaptiveness, allowAudioMixedChannelCountAdaptiveness)) continue;
            adaptiveIndices[count++] = i;
        }
        return Arrays.copyOf(adaptiveIndices, count);
    }

    private static boolean isSupportedAdaptiveAudioTrack(Format format, int formatSupport, Format primaryFormat, int maxAudioBitrate, boolean allowMixedMimeTypeAdaptiveness, boolean allowMixedSampleRateAdaptiveness, boolean allowAudioMixedChannelCountAdaptiveness) {
        return DefaultTrackSelector.isSupported(formatSupport, false) && (format.bitrate == -1 || format.bitrate <= maxAudioBitrate) && (allowAudioMixedChannelCountAdaptiveness || format.channelCount != -1 && format.channelCount == primaryFormat.channelCount) && (allowMixedMimeTypeAdaptiveness || format.sampleMimeType != null && TextUtils.equals((CharSequence)format.sampleMimeType, (CharSequence)primaryFormat.sampleMimeType)) && (allowMixedSampleRateAdaptiveness || format.sampleRate != -1 && format.sampleRate == primaryFormat.sampleRate);
    }

    @Nullable
    protected Pair<TrackSelection.Definition, TextTrackScore> selectTextTrack(TrackGroupArray groups, int[][] formatSupport, Parameters params, @Nullable String selectedAudioLanguage) throws ExoPlaybackException {
        TrackGroup selectedGroup = null;
        int selectedTrackIndex = -1;
        TextTrackScore selectedTrackScore = null;
        for (int groupIndex = 0; groupIndex < groups.length; ++groupIndex) {
            TrackGroup trackGroup = groups.get(groupIndex);
            int[] trackFormatSupport = formatSupport[groupIndex];
            for (int trackIndex = 0; trackIndex < trackGroup.length; ++trackIndex) {
                if (!DefaultTrackSelector.isSupported(trackFormatSupport[trackIndex], params.exceedRendererCapabilitiesIfNecessary)) continue;
                Format format = trackGroup.getFormat(trackIndex);
                TextTrackScore trackScore = new TextTrackScore(format, params, trackFormatSupport[trackIndex], selectedAudioLanguage);
                if (!trackScore.isWithinConstraints || selectedTrackScore != null && trackScore.compareTo(selectedTrackScore) <= 0) continue;
                selectedGroup = trackGroup;
                selectedTrackIndex = trackIndex;
                selectedTrackScore = trackScore;
            }
        }
        return selectedGroup == null ? null : Pair.create((Object)new TrackSelection.Definition(selectedGroup, selectedTrackIndex), (Object)Assertions.checkNotNull(selectedTrackScore));
    }

    @Nullable
    protected TrackSelection.Definition selectOtherTrack(int trackType, TrackGroupArray groups, int[][] formatSupport, Parameters params) throws ExoPlaybackException {
        TrackGroup selectedGroup = null;
        int selectedTrackIndex = 0;
        OtherTrackScore selectedTrackScore = null;
        for (int groupIndex = 0; groupIndex < groups.length; ++groupIndex) {
            TrackGroup trackGroup = groups.get(groupIndex);
            int[] trackFormatSupport = formatSupport[groupIndex];
            for (int trackIndex = 0; trackIndex < trackGroup.length; ++trackIndex) {
                if (!DefaultTrackSelector.isSupported(trackFormatSupport[trackIndex], params.exceedRendererCapabilitiesIfNecessary)) continue;
                Format format = trackGroup.getFormat(trackIndex);
                OtherTrackScore trackScore = new OtherTrackScore(format, trackFormatSupport[trackIndex]);
                if (selectedTrackScore != null && trackScore.compareTo(selectedTrackScore) <= 0) continue;
                selectedGroup = trackGroup;
                selectedTrackIndex = trackIndex;
                selectedTrackScore = trackScore;
            }
        }
        return selectedGroup == null ? null : new TrackSelection.Definition(selectedGroup, selectedTrackIndex);
    }

    private static void maybeConfigureRenderersForTunneling(MappingTrackSelector.MappedTrackInfo mappedTrackInfo, int[][][] renderererFormatSupports, @NullableType RendererConfiguration[] rendererConfigurations, @NullableType TrackSelection[] trackSelections, int tunnelingAudioSessionId) {
        if (tunnelingAudioSessionId == 0) {
            return;
        }
        int tunnelingAudioRendererIndex = -1;
        int tunnelingVideoRendererIndex = -1;
        boolean enableTunneling = true;
        for (int i = 0; i < mappedTrackInfo.getRendererCount(); ++i) {
            int rendererType = mappedTrackInfo.getRendererType(i);
            TrackSelection trackSelection = trackSelections[i];
            if (rendererType != 1 && rendererType != 2 || trackSelection == null || !DefaultTrackSelector.rendererSupportsTunneling(renderererFormatSupports[i], mappedTrackInfo.getTrackGroups(i), trackSelection)) continue;
            if (rendererType == 1) {
                if (tunnelingAudioRendererIndex != -1) {
                    enableTunneling = false;
                    break;
                }
                tunnelingAudioRendererIndex = i;
                continue;
            }
            if (tunnelingVideoRendererIndex != -1) {
                enableTunneling = false;
                break;
            }
            tunnelingVideoRendererIndex = i;
        }
        if (enableTunneling &= tunnelingAudioRendererIndex != -1 && tunnelingVideoRendererIndex != -1) {
            RendererConfiguration tunnelingRendererConfiguration;
            rendererConfigurations[tunnelingAudioRendererIndex] = tunnelingRendererConfiguration = new RendererConfiguration(tunnelingAudioSessionId);
            rendererConfigurations[tunnelingVideoRendererIndex] = tunnelingRendererConfiguration;
        }
    }

    private static boolean rendererSupportsTunneling(int[][] formatSupport, TrackGroupArray trackGroups, TrackSelection selection) {
        if (selection == null) {
            return false;
        }
        int trackGroupIndex = trackGroups.indexOf(selection.getTrackGroup());
        for (int i = 0; i < selection.length(); ++i) {
            int trackFormatSupport = formatSupport[trackGroupIndex][selection.getIndexInTrackGroup(i)];
            if (RendererCapabilities.getTunnelingSupport(trackFormatSupport) == 32) continue;
            return false;
        }
        return true;
    }

    protected static boolean isSupported(int formatSupport, boolean allowExceedsCapabilities) {
        int maskedSupport = RendererCapabilities.getFormatSupport(formatSupport);
        return maskedSupport == 4 || allowExceedsCapabilities && maskedSupport == 3;
    }

    @Nullable
    protected static String normalizeUndeterminedLanguageToNull(@Nullable String language) {
        return TextUtils.isEmpty((CharSequence)language) || TextUtils.equals((CharSequence)language, (CharSequence)"und") ? null : language;
    }

    protected static int getFormatLanguageScore(Format format, @Nullable String language, boolean allowUndeterminedFormatLanguage) {
        String queryMainLanguage;
        if (!TextUtils.isEmpty((CharSequence)language) && language.equals(format.language)) {
            return 4;
        }
        language = DefaultTrackSelector.normalizeUndeterminedLanguageToNull(language);
        String formatLanguage = DefaultTrackSelector.normalizeUndeterminedLanguageToNull(format.language);
        if (formatLanguage == null || language == null) {
            return allowUndeterminedFormatLanguage && formatLanguage == null ? 1 : 0;
        }
        if (formatLanguage.startsWith(language) || language.startsWith(formatLanguage)) {
            return 3;
        }
        String formatMainLanguage = Util.splitAtFirst(formatLanguage, "-")[0];
        if (formatMainLanguage.equals(queryMainLanguage = Util.splitAtFirst(language, "-")[0])) {
            return 2;
        }
        return 0;
    }

    private static List<Integer> getViewportFilteredTrackIndices(TrackGroup group, int viewportWidth, int viewportHeight, boolean orientationMayChange) {
        Format format;
        int i;
        ArrayList<Integer> selectedTrackIndices = new ArrayList<Integer>(group.length);
        for (int i2 = 0; i2 < group.length; ++i2) {
            selectedTrackIndices.add(i2);
        }
        if (viewportWidth == Integer.MAX_VALUE || viewportHeight == Integer.MAX_VALUE) {
            return selectedTrackIndices;
        }
        int maxVideoPixelsToRetain = Integer.MAX_VALUE;
        for (i = 0; i < group.length; ++i) {
            format = group.getFormat(i);
            if (format.width <= 0 || format.height <= 0) continue;
            Point maxVideoSizeInViewport = DefaultTrackSelector.getMaxVideoSizeInViewport(orientationMayChange, viewportWidth, viewportHeight, format.width, format.height);
            int videoPixels = format.width * format.height;
            if (format.width < (int)((float)maxVideoSizeInViewport.x * 0.98f) || format.height < (int)((float)maxVideoSizeInViewport.y * 0.98f) || videoPixels >= maxVideoPixelsToRetain) continue;
            maxVideoPixelsToRetain = videoPixels;
        }
        if (maxVideoPixelsToRetain != Integer.MAX_VALUE) {
            for (i = selectedTrackIndices.size() - 1; i >= 0; --i) {
                format = group.getFormat(selectedTrackIndices.get(i));
                int pixelCount = format.getPixelCount();
                if (pixelCount != -1 && pixelCount <= maxVideoPixelsToRetain) continue;
                selectedTrackIndices.remove(i);
            }
        }
        return selectedTrackIndices;
    }

    private static Point getMaxVideoSizeInViewport(boolean orientationMayChange, int viewportWidth, int viewportHeight, int videoWidth, int videoHeight) {
        if (orientationMayChange && videoWidth > videoHeight != viewportWidth > viewportHeight) {
            int tempViewportWidth = viewportWidth;
            viewportWidth = viewportHeight;
            viewportHeight = tempViewportWidth;
        }
        if (videoWidth * viewportHeight >= videoHeight * viewportWidth) {
            return new Point(viewportWidth, Util.ceilDivide(viewportWidth * videoHeight, videoWidth));
        }
        return new Point(Util.ceilDivide(viewportHeight * videoWidth, videoHeight), viewportHeight);
    }

    public static final class Parameters
    extends TrackSelectionParameters {
        public static final Parameters DEFAULT_WITHOUT_CONTEXT = new ParametersBuilder().build();
        public final int maxVideoWidth;
        public final int maxVideoHeight;
        public final int maxVideoFrameRate;
        public final int maxVideoBitrate;
        public final int minVideoWidth;
        public final int minVideoHeight;
        public final int minVideoFrameRate;
        public final int minVideoBitrate;
        public final boolean exceedVideoConstraintsIfNecessary;
        public final boolean allowVideoMixedMimeTypeAdaptiveness;
        public final boolean allowVideoNonSeamlessAdaptiveness;
        public final int viewportWidth;
        public final int viewportHeight;
        public final boolean viewportOrientationMayChange;
        public final int maxAudioChannelCount;
        public final int maxAudioBitrate;
        public final boolean exceedAudioConstraintsIfNecessary;
        public final boolean allowAudioMixedMimeTypeAdaptiveness;
        public final boolean allowAudioMixedSampleRateAdaptiveness;
        public final boolean allowAudioMixedChannelCountAdaptiveness;
        public final boolean forceLowestBitrate;
        public final boolean forceHighestSupportedBitrate;
        public final boolean exceedRendererCapabilitiesIfNecessary;
        public final int tunnelingAudioSessionId;
        private final SparseArray<Map<TrackGroupArray, @NullableType SelectionOverride>> selectionOverrides;
        private final SparseBooleanArray rendererDisabledFlags;
        public static final Parcelable.Creator<Parameters> CREATOR = new Parcelable.Creator<Parameters>(){

            public Parameters createFromParcel(Parcel in) {
                return new Parameters(in);
            }

            public Parameters[] newArray(int size) {
                return new Parameters[size];
            }
        };

        public static Parameters getDefaults(Context context) {
            return new ParametersBuilder(context).build();
        }

        Parameters(int maxVideoWidth, int maxVideoHeight, int maxVideoFrameRate, int maxVideoBitrate, int minVideoWidth, int minVideoHeight, int minVideoFrameRate, int minVideoBitrate, boolean exceedVideoConstraintsIfNecessary, boolean allowVideoMixedMimeTypeAdaptiveness, boolean allowVideoNonSeamlessAdaptiveness, int viewportWidth, int viewportHeight, boolean viewportOrientationMayChange, @Nullable String preferredAudioLanguage, int maxAudioChannelCount, int maxAudioBitrate, boolean exceedAudioConstraintsIfNecessary, boolean allowAudioMixedMimeTypeAdaptiveness, boolean allowAudioMixedSampleRateAdaptiveness, boolean allowAudioMixedChannelCountAdaptiveness, @Nullable String preferredTextLanguage, int preferredTextRoleFlags, boolean selectUndeterminedTextLanguage, int disabledTextTrackSelectionFlags, boolean forceLowestBitrate, boolean forceHighestSupportedBitrate, boolean exceedRendererCapabilitiesIfNecessary, int tunnelingAudioSessionId, SparseArray<Map<TrackGroupArray, @NullableType SelectionOverride>> selectionOverrides, SparseBooleanArray rendererDisabledFlags) {
            super(preferredAudioLanguage, preferredTextLanguage, preferredTextRoleFlags, selectUndeterminedTextLanguage, disabledTextTrackSelectionFlags);
            this.maxVideoWidth = maxVideoWidth;
            this.maxVideoHeight = maxVideoHeight;
            this.maxVideoFrameRate = maxVideoFrameRate;
            this.maxVideoBitrate = maxVideoBitrate;
            this.minVideoWidth = minVideoWidth;
            this.minVideoHeight = minVideoHeight;
            this.minVideoFrameRate = minVideoFrameRate;
            this.minVideoBitrate = minVideoBitrate;
            this.exceedVideoConstraintsIfNecessary = exceedVideoConstraintsIfNecessary;
            this.allowVideoMixedMimeTypeAdaptiveness = allowVideoMixedMimeTypeAdaptiveness;
            this.allowVideoNonSeamlessAdaptiveness = allowVideoNonSeamlessAdaptiveness;
            this.viewportWidth = viewportWidth;
            this.viewportHeight = viewportHeight;
            this.viewportOrientationMayChange = viewportOrientationMayChange;
            this.maxAudioChannelCount = maxAudioChannelCount;
            this.maxAudioBitrate = maxAudioBitrate;
            this.exceedAudioConstraintsIfNecessary = exceedAudioConstraintsIfNecessary;
            this.allowAudioMixedMimeTypeAdaptiveness = allowAudioMixedMimeTypeAdaptiveness;
            this.allowAudioMixedSampleRateAdaptiveness = allowAudioMixedSampleRateAdaptiveness;
            this.allowAudioMixedChannelCountAdaptiveness = allowAudioMixedChannelCountAdaptiveness;
            this.forceLowestBitrate = forceLowestBitrate;
            this.forceHighestSupportedBitrate = forceHighestSupportedBitrate;
            this.exceedRendererCapabilitiesIfNecessary = exceedRendererCapabilitiesIfNecessary;
            this.tunnelingAudioSessionId = tunnelingAudioSessionId;
            this.selectionOverrides = selectionOverrides;
            this.rendererDisabledFlags = rendererDisabledFlags;
        }

        Parameters(Parcel in) {
            super(in);
            this.maxVideoWidth = in.readInt();
            this.maxVideoHeight = in.readInt();
            this.maxVideoFrameRate = in.readInt();
            this.maxVideoBitrate = in.readInt();
            this.minVideoWidth = in.readInt();
            this.minVideoHeight = in.readInt();
            this.minVideoFrameRate = in.readInt();
            this.minVideoBitrate = in.readInt();
            this.exceedVideoConstraintsIfNecessary = Util.readBoolean(in);
            this.allowVideoMixedMimeTypeAdaptiveness = Util.readBoolean(in);
            this.allowVideoNonSeamlessAdaptiveness = Util.readBoolean(in);
            this.viewportWidth = in.readInt();
            this.viewportHeight = in.readInt();
            this.viewportOrientationMayChange = Util.readBoolean(in);
            this.maxAudioChannelCount = in.readInt();
            this.maxAudioBitrate = in.readInt();
            this.exceedAudioConstraintsIfNecessary = Util.readBoolean(in);
            this.allowAudioMixedMimeTypeAdaptiveness = Util.readBoolean(in);
            this.allowAudioMixedSampleRateAdaptiveness = Util.readBoolean(in);
            this.allowAudioMixedChannelCountAdaptiveness = Util.readBoolean(in);
            this.forceLowestBitrate = Util.readBoolean(in);
            this.forceHighestSupportedBitrate = Util.readBoolean(in);
            this.exceedRendererCapabilitiesIfNecessary = Util.readBoolean(in);
            this.tunnelingAudioSessionId = in.readInt();
            this.selectionOverrides = Parameters.readSelectionOverrides(in);
            this.rendererDisabledFlags = Util.castNonNull(in.readSparseBooleanArray());
        }

        public final boolean getRendererDisabled(int rendererIndex) {
            return this.rendererDisabledFlags.get(rendererIndex);
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public final boolean hasSelectionOverride(int rendererIndex, TrackGroupArray groups) {
            @NullableType Map overrides = (Map)this.selectionOverrides.get(rendererIndex);
            return overrides != null && overrides.containsKey(groups);
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable
        public final SelectionOverride getSelectionOverride(int rendererIndex, TrackGroupArray groups) {
            @NullableType Map overrides = (Map)this.selectionOverrides.get(rendererIndex);
            return overrides != null ? (SelectionOverride)overrides.get(groups) : null;
        }

        @Override
        public ParametersBuilder buildUpon() {
            return new ParametersBuilder(this);
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Parameters other = (Parameters)obj;
            return super.equals(obj) && this.maxVideoWidth == other.maxVideoWidth && this.maxVideoHeight == other.maxVideoHeight && this.maxVideoFrameRate == other.maxVideoFrameRate && this.maxVideoBitrate == other.maxVideoBitrate && this.minVideoWidth == other.minVideoWidth && this.minVideoHeight == other.minVideoHeight && this.minVideoFrameRate == other.minVideoFrameRate && this.minVideoBitrate == other.minVideoBitrate && this.exceedVideoConstraintsIfNecessary == other.exceedVideoConstraintsIfNecessary && this.allowVideoMixedMimeTypeAdaptiveness == other.allowVideoMixedMimeTypeAdaptiveness && this.allowVideoNonSeamlessAdaptiveness == other.allowVideoNonSeamlessAdaptiveness && this.viewportOrientationMayChange == other.viewportOrientationMayChange && this.viewportWidth == other.viewportWidth && this.viewportHeight == other.viewportHeight && this.maxAudioChannelCount == other.maxAudioChannelCount && this.maxAudioBitrate == other.maxAudioBitrate && this.exceedAudioConstraintsIfNecessary == other.exceedAudioConstraintsIfNecessary && this.allowAudioMixedMimeTypeAdaptiveness == other.allowAudioMixedMimeTypeAdaptiveness && this.allowAudioMixedSampleRateAdaptiveness == other.allowAudioMixedSampleRateAdaptiveness && this.allowAudioMixedChannelCountAdaptiveness == other.allowAudioMixedChannelCountAdaptiveness && this.forceLowestBitrate == other.forceLowestBitrate && this.forceHighestSupportedBitrate == other.forceHighestSupportedBitrate && this.exceedRendererCapabilitiesIfNecessary == other.exceedRendererCapabilitiesIfNecessary && this.tunnelingAudioSessionId == other.tunnelingAudioSessionId && Parameters.areRendererDisabledFlagsEqual(this.rendererDisabledFlags, other.rendererDisabledFlags) && Parameters.areSelectionOverridesEqual(this.selectionOverrides, other.selectionOverrides);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.maxVideoWidth;
            result = 31 * result + this.maxVideoHeight;
            result = 31 * result + this.maxVideoFrameRate;
            result = 31 * result + this.maxVideoBitrate;
            result = 31 * result + this.minVideoWidth;
            result = 31 * result + this.minVideoHeight;
            result = 31 * result + this.minVideoFrameRate;
            result = 31 * result + this.minVideoBitrate;
            result = 31 * result + (this.exceedVideoConstraintsIfNecessary ? 1 : 0);
            result = 31 * result + (this.allowVideoMixedMimeTypeAdaptiveness ? 1 : 0);
            result = 31 * result + (this.allowVideoNonSeamlessAdaptiveness ? 1 : 0);
            result = 31 * result + (this.viewportOrientationMayChange ? 1 : 0);
            result = 31 * result + this.viewportWidth;
            result = 31 * result + this.viewportHeight;
            result = 31 * result + this.maxAudioChannelCount;
            result = 31 * result + this.maxAudioBitrate;
            result = 31 * result + (this.exceedAudioConstraintsIfNecessary ? 1 : 0);
            result = 31 * result + (this.allowAudioMixedMimeTypeAdaptiveness ? 1 : 0);
            result = 31 * result + (this.allowAudioMixedSampleRateAdaptiveness ? 1 : 0);
            result = 31 * result + (this.allowAudioMixedChannelCountAdaptiveness ? 1 : 0);
            result = 31 * result + (this.forceLowestBitrate ? 1 : 0);
            result = 31 * result + (this.forceHighestSupportedBitrate ? 1 : 0);
            result = 31 * result + (this.exceedRendererCapabilitiesIfNecessary ? 1 : 0);
            result = 31 * result + this.tunnelingAudioSessionId;
            return result;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.maxVideoWidth);
            dest.writeInt(this.maxVideoHeight);
            dest.writeInt(this.maxVideoFrameRate);
            dest.writeInt(this.maxVideoBitrate);
            dest.writeInt(this.minVideoWidth);
            dest.writeInt(this.minVideoHeight);
            dest.writeInt(this.minVideoFrameRate);
            dest.writeInt(this.minVideoBitrate);
            Util.writeBoolean(dest, this.exceedVideoConstraintsIfNecessary);
            Util.writeBoolean(dest, this.allowVideoMixedMimeTypeAdaptiveness);
            Util.writeBoolean(dest, this.allowVideoNonSeamlessAdaptiveness);
            dest.writeInt(this.viewportWidth);
            dest.writeInt(this.viewportHeight);
            Util.writeBoolean(dest, this.viewportOrientationMayChange);
            dest.writeInt(this.maxAudioChannelCount);
            dest.writeInt(this.maxAudioBitrate);
            Util.writeBoolean(dest, this.exceedAudioConstraintsIfNecessary);
            Util.writeBoolean(dest, this.allowAudioMixedMimeTypeAdaptiveness);
            Util.writeBoolean(dest, this.allowAudioMixedSampleRateAdaptiveness);
            Util.writeBoolean(dest, this.allowAudioMixedChannelCountAdaptiveness);
            Util.writeBoolean(dest, this.forceLowestBitrate);
            Util.writeBoolean(dest, this.forceHighestSupportedBitrate);
            Util.writeBoolean(dest, this.exceedRendererCapabilitiesIfNecessary);
            dest.writeInt(this.tunnelingAudioSessionId);
            Parameters.writeSelectionOverridesToParcel(dest, this.selectionOverrides);
            dest.writeSparseBooleanArray(this.rendererDisabledFlags);
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        private static SparseArray<Map<TrackGroupArray, @NullableType SelectionOverride>> readSelectionOverrides(Parcel in) {
            int renderersWithOverridesCount = in.readInt();
            @NullableType SparseArray selectionOverrides = new SparseArray(renderersWithOverridesCount);
            for (int i = 0; i < renderersWithOverridesCount; ++i) {
                int rendererIndex = in.readInt();
                int overrideCount = in.readInt();
                HashMap<TrackGroupArray, @NullableType SelectionOverride> overrides = new HashMap<TrackGroupArray, SelectionOverride>(overrideCount);
                for (int j = 0; j < overrideCount; ++j) {
                    TrackGroupArray trackGroups = Assertions.checkNotNull((TrackGroupArray)in.readParcelable(TrackGroupArray.class.getClassLoader()));
                    SelectionOverride override = (SelectionOverride)in.readParcelable(SelectionOverride.class.getClassLoader());
                    overrides.put(trackGroups, override);
                }
                selectionOverrides.put(rendererIndex, overrides);
            }
            return selectionOverrides;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        private static void writeSelectionOverridesToParcel(Parcel dest, SparseArray<Map<TrackGroupArray, @NullableType SelectionOverride>> selectionOverrides) {
            int renderersWithOverridesCount = selectionOverrides.size();
            dest.writeInt(renderersWithOverridesCount);
            for (int i = 0; i < renderersWithOverridesCount; ++i) {
                int rendererIndex = selectionOverrides.keyAt(i);
                @NullableType Map overrides = (Map)selectionOverrides.valueAt(i);
                int overrideCount = overrides.size();
                dest.writeInt(rendererIndex);
                dest.writeInt(overrideCount);
                for (Map.Entry override : overrides.entrySet()) {
                    dest.writeParcelable((Parcelable)override.getKey(), 0);
                    dest.writeParcelable((Parcelable)override.getValue(), 0);
                }
            }
        }

        private static boolean areRendererDisabledFlagsEqual(SparseBooleanArray first, SparseBooleanArray second) {
            int firstSize = first.size();
            if (second.size() != firstSize) {
                return false;
            }
            for (int indexInFirst = 0; indexInFirst < firstSize; ++indexInFirst) {
                if (second.indexOfKey(first.keyAt(indexInFirst)) >= 0) continue;
                return false;
            }
            return true;
        }

        private static boolean areSelectionOverridesEqual(SparseArray<Map<TrackGroupArray, @NullableType SelectionOverride>> first, SparseArray<Map<TrackGroupArray, @NullableType SelectionOverride>> second) {
            int firstSize = first.size();
            if (second.size() != firstSize) {
                return false;
            }
            for (int indexInFirst = 0; indexInFirst < firstSize; ++indexInFirst) {
                int indexInSecond = second.indexOfKey(first.keyAt(indexInFirst));
                if (indexInSecond >= 0 && Parameters.areSelectionOverridesEqual((Map)first.valueAt(indexInFirst), (Map)second.valueAt(indexInSecond))) continue;
                return false;
            }
            return true;
        }

        private static boolean areSelectionOverridesEqual(Map<TrackGroupArray, @NullableType SelectionOverride> first, Map<TrackGroupArray, @NullableType SelectionOverride> second) {
            int firstSize = first.size();
            if (second.size() != firstSize) {
                return false;
            }
            for (Map.Entry<TrackGroupArray, SelectionOverride> firstEntry : first.entrySet()) {
                TrackGroupArray key = firstEntry.getKey();
                if (second.containsKey(key) && Util.areEqual(firstEntry.getValue(), second.get(key))) continue;
                return false;
            }
            return true;
        }
    }

    public static final class ParametersBuilder
    extends TrackSelectionParameters.Builder {
        private int maxVideoWidth;
        private int maxVideoHeight;
        private int maxVideoFrameRate;
        private int maxVideoBitrate;
        private int minVideoWidth;
        private int minVideoHeight;
        private int minVideoFrameRate;
        private int minVideoBitrate;
        private boolean exceedVideoConstraintsIfNecessary;
        private boolean allowVideoMixedMimeTypeAdaptiveness;
        private boolean allowVideoNonSeamlessAdaptiveness;
        private int viewportWidth;
        private int viewportHeight;
        private boolean viewportOrientationMayChange;
        private int maxAudioChannelCount;
        private int maxAudioBitrate;
        private boolean exceedAudioConstraintsIfNecessary;
        private boolean allowAudioMixedMimeTypeAdaptiveness;
        private boolean allowAudioMixedSampleRateAdaptiveness;
        private boolean allowAudioMixedChannelCountAdaptiveness;
        private boolean forceLowestBitrate;
        private boolean forceHighestSupportedBitrate;
        private boolean exceedRendererCapabilitiesIfNecessary;
        private int tunnelingAudioSessionId;
        private final SparseArray<Map<TrackGroupArray, @NullableType SelectionOverride>> selectionOverrides;
        private final SparseBooleanArray rendererDisabledFlags;

        @Deprecated
        public ParametersBuilder() {
            this.setInitialValuesWithoutContext();
            this.selectionOverrides = new SparseArray();
            this.rendererDisabledFlags = new SparseBooleanArray();
        }

        public ParametersBuilder(Context context) {
            super(context);
            this.setInitialValuesWithoutContext();
            this.selectionOverrides = new SparseArray();
            this.rendererDisabledFlags = new SparseBooleanArray();
            this.setViewportSizeToPhysicalDisplaySize(context, true);
        }

        private ParametersBuilder(Parameters initialValues) {
            super(initialValues);
            this.maxVideoWidth = initialValues.maxVideoWidth;
            this.maxVideoHeight = initialValues.maxVideoHeight;
            this.maxVideoFrameRate = initialValues.maxVideoFrameRate;
            this.maxVideoBitrate = initialValues.maxVideoBitrate;
            this.minVideoWidth = initialValues.minVideoWidth;
            this.minVideoHeight = initialValues.minVideoHeight;
            this.minVideoFrameRate = initialValues.minVideoFrameRate;
            this.minVideoBitrate = initialValues.minVideoBitrate;
            this.exceedVideoConstraintsIfNecessary = initialValues.exceedVideoConstraintsIfNecessary;
            this.allowVideoMixedMimeTypeAdaptiveness = initialValues.allowVideoMixedMimeTypeAdaptiveness;
            this.allowVideoNonSeamlessAdaptiveness = initialValues.allowVideoNonSeamlessAdaptiveness;
            this.viewportWidth = initialValues.viewportWidth;
            this.viewportHeight = initialValues.viewportHeight;
            this.viewportOrientationMayChange = initialValues.viewportOrientationMayChange;
            this.maxAudioChannelCount = initialValues.maxAudioChannelCount;
            this.maxAudioBitrate = initialValues.maxAudioBitrate;
            this.exceedAudioConstraintsIfNecessary = initialValues.exceedAudioConstraintsIfNecessary;
            this.allowAudioMixedMimeTypeAdaptiveness = initialValues.allowAudioMixedMimeTypeAdaptiveness;
            this.allowAudioMixedSampleRateAdaptiveness = initialValues.allowAudioMixedSampleRateAdaptiveness;
            this.allowAudioMixedChannelCountAdaptiveness = initialValues.allowAudioMixedChannelCountAdaptiveness;
            this.forceLowestBitrate = initialValues.forceLowestBitrate;
            this.forceHighestSupportedBitrate = initialValues.forceHighestSupportedBitrate;
            this.exceedRendererCapabilitiesIfNecessary = initialValues.exceedRendererCapabilitiesIfNecessary;
            this.tunnelingAudioSessionId = initialValues.tunnelingAudioSessionId;
            this.selectionOverrides = ParametersBuilder.cloneSelectionOverrides(initialValues.selectionOverrides);
            this.rendererDisabledFlags = initialValues.rendererDisabledFlags.clone();
        }

        public ParametersBuilder setMaxVideoSizeSd() {
            return this.setMaxVideoSize(1279, 719);
        }

        public ParametersBuilder clearVideoSizeConstraints() {
            return this.setMaxVideoSize(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        public ParametersBuilder setMaxVideoSize(int maxVideoWidth, int maxVideoHeight) {
            this.maxVideoWidth = maxVideoWidth;
            this.maxVideoHeight = maxVideoHeight;
            return this;
        }

        public ParametersBuilder setMaxVideoFrameRate(int maxVideoFrameRate) {
            this.maxVideoFrameRate = maxVideoFrameRate;
            return this;
        }

        public ParametersBuilder setMaxVideoBitrate(int maxVideoBitrate) {
            this.maxVideoBitrate = maxVideoBitrate;
            return this;
        }

        public ParametersBuilder setMinVideoSize(int minVideoWidth, int minVideoHeight) {
            this.minVideoWidth = minVideoWidth;
            this.minVideoHeight = minVideoHeight;
            return this;
        }

        public ParametersBuilder setMinVideoFrameRate(int minVideoFrameRate) {
            this.minVideoFrameRate = minVideoFrameRate;
            return this;
        }

        public ParametersBuilder setMinVideoBitrate(int minVideoBitrate) {
            this.minVideoBitrate = minVideoBitrate;
            return this;
        }

        public ParametersBuilder setExceedVideoConstraintsIfNecessary(boolean exceedVideoConstraintsIfNecessary) {
            this.exceedVideoConstraintsIfNecessary = exceedVideoConstraintsIfNecessary;
            return this;
        }

        public ParametersBuilder setAllowVideoMixedMimeTypeAdaptiveness(boolean allowVideoMixedMimeTypeAdaptiveness) {
            this.allowVideoMixedMimeTypeAdaptiveness = allowVideoMixedMimeTypeAdaptiveness;
            return this;
        }

        public ParametersBuilder setAllowVideoNonSeamlessAdaptiveness(boolean allowVideoNonSeamlessAdaptiveness) {
            this.allowVideoNonSeamlessAdaptiveness = allowVideoNonSeamlessAdaptiveness;
            return this;
        }

        public ParametersBuilder setViewportSizeToPhysicalDisplaySize(Context context, boolean viewportOrientationMayChange) {
            Point viewportSize = Util.getCurrentDisplayModeSize(context);
            return this.setViewportSize(viewportSize.x, viewportSize.y, viewportOrientationMayChange);
        }

        public ParametersBuilder clearViewportSizeConstraints() {
            return this.setViewportSize(Integer.MAX_VALUE, Integer.MAX_VALUE, true);
        }

        public ParametersBuilder setViewportSize(int viewportWidth, int viewportHeight, boolean viewportOrientationMayChange) {
            this.viewportWidth = viewportWidth;
            this.viewportHeight = viewportHeight;
            this.viewportOrientationMayChange = viewportOrientationMayChange;
            return this;
        }

        @Override
        public ParametersBuilder setPreferredAudioLanguage(@Nullable String preferredAudioLanguage) {
            super.setPreferredAudioLanguage(preferredAudioLanguage);
            return this;
        }

        public ParametersBuilder setMaxAudioChannelCount(int maxAudioChannelCount) {
            this.maxAudioChannelCount = maxAudioChannelCount;
            return this;
        }

        public ParametersBuilder setMaxAudioBitrate(int maxAudioBitrate) {
            this.maxAudioBitrate = maxAudioBitrate;
            return this;
        }

        public ParametersBuilder setExceedAudioConstraintsIfNecessary(boolean exceedAudioConstraintsIfNecessary) {
            this.exceedAudioConstraintsIfNecessary = exceedAudioConstraintsIfNecessary;
            return this;
        }

        public ParametersBuilder setAllowAudioMixedMimeTypeAdaptiveness(boolean allowAudioMixedMimeTypeAdaptiveness) {
            this.allowAudioMixedMimeTypeAdaptiveness = allowAudioMixedMimeTypeAdaptiveness;
            return this;
        }

        public ParametersBuilder setAllowAudioMixedSampleRateAdaptiveness(boolean allowAudioMixedSampleRateAdaptiveness) {
            this.allowAudioMixedSampleRateAdaptiveness = allowAudioMixedSampleRateAdaptiveness;
            return this;
        }

        public ParametersBuilder setAllowAudioMixedChannelCountAdaptiveness(boolean allowAudioMixedChannelCountAdaptiveness) {
            this.allowAudioMixedChannelCountAdaptiveness = allowAudioMixedChannelCountAdaptiveness;
            return this;
        }

        @Override
        public ParametersBuilder setPreferredTextLanguageAndRoleFlagsToCaptioningManagerSettings(Context context) {
            super.setPreferredTextLanguageAndRoleFlagsToCaptioningManagerSettings(context);
            return this;
        }

        @Override
        public ParametersBuilder setPreferredTextLanguage(@Nullable String preferredTextLanguage) {
            super.setPreferredTextLanguage(preferredTextLanguage);
            return this;
        }

        @Override
        public ParametersBuilder setPreferredTextRoleFlags(int preferredTextRoleFlags) {
            super.setPreferredTextRoleFlags(preferredTextRoleFlags);
            return this;
        }

        @Override
        public ParametersBuilder setSelectUndeterminedTextLanguage(boolean selectUndeterminedTextLanguage) {
            super.setSelectUndeterminedTextLanguage(selectUndeterminedTextLanguage);
            return this;
        }

        @Override
        public ParametersBuilder setDisabledTextTrackSelectionFlags(int disabledTextTrackSelectionFlags) {
            super.setDisabledTextTrackSelectionFlags(disabledTextTrackSelectionFlags);
            return this;
        }

        public ParametersBuilder setForceLowestBitrate(boolean forceLowestBitrate) {
            this.forceLowestBitrate = forceLowestBitrate;
            return this;
        }

        public ParametersBuilder setForceHighestSupportedBitrate(boolean forceHighestSupportedBitrate) {
            this.forceHighestSupportedBitrate = forceHighestSupportedBitrate;
            return this;
        }

        public ParametersBuilder setExceedRendererCapabilitiesIfNecessary(boolean exceedRendererCapabilitiesIfNecessary) {
            this.exceedRendererCapabilitiesIfNecessary = exceedRendererCapabilitiesIfNecessary;
            return this;
        }

        public ParametersBuilder setTunnelingAudioSessionId(int tunnelingAudioSessionId) {
            this.tunnelingAudioSessionId = tunnelingAudioSessionId;
            return this;
        }

        public final ParametersBuilder setRendererDisabled(int rendererIndex, boolean disabled) {
            if (this.rendererDisabledFlags.get(rendererIndex) == disabled) {
                return this;
            }
            if (disabled) {
                this.rendererDisabledFlags.put(rendererIndex, true);
            } else {
                this.rendererDisabledFlags.delete(rendererIndex);
            }
            return this;
        }

        public final ParametersBuilder setSelectionOverride(int rendererIndex, TrackGroupArray groups, @Nullable SelectionOverride override) {
            HashMap<TrackGroupArray, @NullableType SelectionOverride> overrides = (HashMap<TrackGroupArray, SelectionOverride>)this.selectionOverrides.get(rendererIndex);
            if (overrides == null) {
                overrides = new HashMap<TrackGroupArray, SelectionOverride>();
                this.selectionOverrides.put(rendererIndex, overrides);
            }
            if (overrides.containsKey(groups) && Util.areEqual(overrides.get(groups), override)) {
                return this;
            }
            overrides.put(groups, override);
            return this;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public final ParametersBuilder clearSelectionOverride(int rendererIndex, TrackGroupArray groups) {
            @NullableType Map overrides = (Map)this.selectionOverrides.get(rendererIndex);
            if (overrides == null || !overrides.containsKey(groups)) {
                return this;
            }
            overrides.remove(groups);
            if (overrides.isEmpty()) {
                this.selectionOverrides.remove(rendererIndex);
            }
            return this;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public final ParametersBuilder clearSelectionOverrides(int rendererIndex) {
            @NullableType Map overrides = (Map)this.selectionOverrides.get(rendererIndex);
            if (overrides == null || overrides.isEmpty()) {
                return this;
            }
            this.selectionOverrides.remove(rendererIndex);
            return this;
        }

        public final ParametersBuilder clearSelectionOverrides() {
            if (this.selectionOverrides.size() == 0) {
                return this;
            }
            this.selectionOverrides.clear();
            return this;
        }

        @Override
        public Parameters build() {
            return new Parameters(this.maxVideoWidth, this.maxVideoHeight, this.maxVideoFrameRate, this.maxVideoBitrate, this.minVideoWidth, this.minVideoHeight, this.minVideoFrameRate, this.minVideoBitrate, this.exceedVideoConstraintsIfNecessary, this.allowVideoMixedMimeTypeAdaptiveness, this.allowVideoNonSeamlessAdaptiveness, this.viewportWidth, this.viewportHeight, this.viewportOrientationMayChange, this.preferredAudioLanguage, this.maxAudioChannelCount, this.maxAudioBitrate, this.exceedAudioConstraintsIfNecessary, this.allowAudioMixedMimeTypeAdaptiveness, this.allowAudioMixedSampleRateAdaptiveness, this.allowAudioMixedChannelCountAdaptiveness, this.preferredTextLanguage, this.preferredTextRoleFlags, this.selectUndeterminedTextLanguage, this.disabledTextTrackSelectionFlags, this.forceLowestBitrate, this.forceHighestSupportedBitrate, this.exceedRendererCapabilitiesIfNecessary, this.tunnelingAudioSessionId, this.selectionOverrides, this.rendererDisabledFlags);
        }

        private void setInitialValuesWithoutContext(@UnderInitialization ParametersBuilder this) {
            this.maxVideoWidth = Integer.MAX_VALUE;
            this.maxVideoHeight = Integer.MAX_VALUE;
            this.maxVideoFrameRate = Integer.MAX_VALUE;
            this.maxVideoBitrate = Integer.MAX_VALUE;
            this.exceedVideoConstraintsIfNecessary = true;
            this.allowVideoMixedMimeTypeAdaptiveness = false;
            this.allowVideoNonSeamlessAdaptiveness = true;
            this.viewportWidth = Integer.MAX_VALUE;
            this.viewportHeight = Integer.MAX_VALUE;
            this.viewportOrientationMayChange = true;
            this.maxAudioChannelCount = Integer.MAX_VALUE;
            this.maxAudioBitrate = Integer.MAX_VALUE;
            this.exceedAudioConstraintsIfNecessary = true;
            this.allowAudioMixedMimeTypeAdaptiveness = false;
            this.allowAudioMixedSampleRateAdaptiveness = false;
            this.allowAudioMixedChannelCountAdaptiveness = false;
            this.forceLowestBitrate = false;
            this.forceHighestSupportedBitrate = false;
            this.exceedRendererCapabilitiesIfNecessary = true;
            this.tunnelingAudioSessionId = 0;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        private static SparseArray<Map<TrackGroupArray, @NullableType SelectionOverride>> cloneSelectionOverrides(SparseArray<Map<TrackGroupArray, @NullableType SelectionOverride>> selectionOverrides) {
            @NullableType SparseArray clone = new SparseArray();
            for (int i = 0; i < selectionOverrides.size(); ++i) {
                clone.put(selectionOverrides.keyAt(i), new HashMap((Map)selectionOverrides.valueAt(i)));
            }
            return clone;
        }
    }

    public static final class SelectionOverride
    implements Parcelable {
        public final int groupIndex;
        public final int[] tracks;
        public final int length;
        public final int reason;
        public final int data;
        public static final Parcelable.Creator<SelectionOverride> CREATOR = new Parcelable.Creator<SelectionOverride>(){

            public SelectionOverride createFromParcel(Parcel in) {
                return new SelectionOverride(in);
            }

            public SelectionOverride[] newArray(int size) {
                return new SelectionOverride[size];
            }
        };

        public SelectionOverride(int groupIndex, int ... tracks) {
            this(groupIndex, tracks, 2, 0);
        }

        public SelectionOverride(int groupIndex, int[] tracks, int reason, int data) {
            this.groupIndex = groupIndex;
            this.tracks = Arrays.copyOf(tracks, tracks.length);
            this.length = tracks.length;
            this.reason = reason;
            this.data = data;
            Arrays.sort(this.tracks);
        }

        SelectionOverride(Parcel in) {
            this.groupIndex = in.readInt();
            this.length = in.readByte();
            this.tracks = new int[this.length];
            in.readIntArray(this.tracks);
            this.reason = in.readInt();
            this.data = in.readInt();
        }

        public boolean containsTrack(int track) {
            for (int overrideTrack : this.tracks) {
                if (overrideTrack != track) continue;
                return true;
            }
            return false;
        }

        public int hashCode() {
            int hash = 31 * this.groupIndex + Arrays.hashCode(this.tracks);
            hash = 31 * hash + this.reason;
            return 31 * hash + this.data;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            SelectionOverride other = (SelectionOverride)obj;
            return this.groupIndex == other.groupIndex && Arrays.equals(this.tracks, other.tracks) && this.reason == other.reason && this.data == other.data;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.groupIndex);
            dest.writeInt(this.tracks.length);
            dest.writeIntArray(this.tracks);
            dest.writeInt(this.reason);
            dest.writeInt(this.data);
        }
    }

    protected static final class AudioTrackScore
    implements Comparable<AudioTrackScore> {
        public final boolean isWithinConstraints;
        @Nullable
        private final String language;
        private final Parameters parameters;
        private final boolean isWithinRendererCapabilities;
        private final int preferredLanguageScore;
        private final int localeLanguageMatchIndex;
        private final int localeLanguageScore;
        private final boolean isDefaultSelectionFlag;
        private final int channelCount;
        private final int sampleRate;
        private final int bitrate;

        public AudioTrackScore(Format format, Parameters parameters, int formatSupport) {
            this.parameters = parameters;
            this.language = DefaultTrackSelector.normalizeUndeterminedLanguageToNull(format.language);
            this.isWithinRendererCapabilities = DefaultTrackSelector.isSupported(formatSupport, false);
            this.preferredLanguageScore = DefaultTrackSelector.getFormatLanguageScore(format, parameters.preferredAudioLanguage, false);
            this.isDefaultSelectionFlag = (format.selectionFlags & 1) != 0;
            this.channelCount = format.channelCount;
            this.sampleRate = format.sampleRate;
            this.bitrate = format.bitrate;
            this.isWithinConstraints = !(format.bitrate != -1 && format.bitrate > parameters.maxAudioBitrate || format.channelCount != -1 && format.channelCount > parameters.maxAudioChannelCount);
            String[] localeLanguages = Util.getSystemLanguageCodes();
            int bestMatchIndex = Integer.MAX_VALUE;
            int bestMatchScore = 0;
            for (int i = 0; i < localeLanguages.length; ++i) {
                int score = DefaultTrackSelector.getFormatLanguageScore(format, localeLanguages[i], false);
                if (score <= 0) continue;
                bestMatchIndex = i;
                bestMatchScore = score;
                break;
            }
            this.localeLanguageMatchIndex = bestMatchIndex;
            this.localeLanguageScore = bestMatchScore;
        }

        @Override
        public int compareTo(AudioTrackScore other) {
            Ordering<Integer> qualityOrdering = this.isWithinConstraints && this.isWithinRendererCapabilities ? FORMAT_VALUE_ORDERING : FORMAT_VALUE_ORDERING.reverse();
            return ComparisonChain.start().compareFalseFirst(this.isWithinRendererCapabilities, other.isWithinRendererCapabilities).compare(this.preferredLanguageScore, other.preferredLanguageScore).compareFalseFirst(this.isWithinConstraints, other.isWithinConstraints).compare((Object)this.bitrate, (Object)other.bitrate, (Comparator)(this.parameters.forceLowestBitrate ? FORMAT_VALUE_ORDERING.reverse() : NO_ORDER)).compareFalseFirst(this.isDefaultSelectionFlag, other.isDefaultSelectionFlag).compare((Object)this.localeLanguageMatchIndex, (Object)other.localeLanguageMatchIndex, (Comparator)Ordering.natural().reverse()).compare(this.localeLanguageScore, other.localeLanguageScore).compare((Object)this.channelCount, (Object)other.channelCount, qualityOrdering).compare((Object)this.sampleRate, (Object)other.sampleRate, qualityOrdering).compare((Object)this.bitrate, (Object)other.bitrate, Util.areEqual(this.language, other.language) ? qualityOrdering : NO_ORDER).result();
        }
    }

    protected static final class TextTrackScore
    implements Comparable<TextTrackScore> {
        public final boolean isWithinConstraints;
        private final boolean isWithinRendererCapabilities;
        private final boolean isDefault;
        private final boolean isForced;
        private final int preferredLanguageScore;
        private final int preferredRoleFlagsScore;
        private final int selectedAudioLanguageScore;
        private final boolean hasCaptionRoleFlags;

        public TextTrackScore(Format format, Parameters parameters, int trackFormatSupport, @Nullable String selectedAudioLanguage) {
            this.isWithinRendererCapabilities = DefaultTrackSelector.isSupported(trackFormatSupport, false);
            int maskedSelectionFlags = format.selectionFlags & ~parameters.disabledTextTrackSelectionFlags;
            this.isDefault = (maskedSelectionFlags & 1) != 0;
            this.isForced = (maskedSelectionFlags & 2) != 0;
            this.preferredLanguageScore = DefaultTrackSelector.getFormatLanguageScore(format, parameters.preferredTextLanguage, parameters.selectUndeterminedTextLanguage);
            this.preferredRoleFlagsScore = Integer.bitCount(format.roleFlags & parameters.preferredTextRoleFlags);
            this.hasCaptionRoleFlags = (format.roleFlags & 0x440) != 0;
            boolean selectedAudioLanguageUndetermined = DefaultTrackSelector.normalizeUndeterminedLanguageToNull(selectedAudioLanguage) == null;
            this.selectedAudioLanguageScore = DefaultTrackSelector.getFormatLanguageScore(format, selectedAudioLanguage, selectedAudioLanguageUndetermined);
            this.isWithinConstraints = this.preferredLanguageScore > 0 || parameters.preferredTextLanguage == null && this.preferredRoleFlagsScore > 0 || this.isDefault || this.isForced && this.selectedAudioLanguageScore > 0;
        }

        @Override
        public int compareTo(TextTrackScore other) {
            ComparisonChain chain = ComparisonChain.start().compareFalseFirst(this.isWithinRendererCapabilities, other.isWithinRendererCapabilities).compare(this.preferredLanguageScore, other.preferredLanguageScore).compare(this.preferredRoleFlagsScore, other.preferredRoleFlagsScore).compareFalseFirst(this.isDefault, other.isDefault).compare((Object)this.isForced, (Object)other.isForced, (Comparator)(this.preferredLanguageScore == 0 ? Ordering.natural() : Ordering.natural().reverse())).compare(this.selectedAudioLanguageScore, other.selectedAudioLanguageScore);
            if (this.preferredRoleFlagsScore == 0) {
                chain = chain.compareTrueFirst(this.hasCaptionRoleFlags, other.hasCaptionRoleFlags);
            }
            return chain.result();
        }
    }

    protected static final class VideoTrackScore
    implements Comparable<VideoTrackScore> {
        public final boolean isWithinMaxConstraints;
        private final Parameters parameters;
        private final boolean isWithinMinConstraints;
        private final boolean isWithinRendererCapabilities;
        private final int bitrate;
        private final int pixelCount;

        public VideoTrackScore(Format format, Parameters parameters, int formatSupport, boolean isSuitableForViewport) {
            this.parameters = parameters;
            this.isWithinMaxConstraints = !(!isSuitableForViewport || format.width != -1 && format.width > parameters.maxVideoWidth || format.height != -1 && format.height > parameters.maxVideoHeight || format.frameRate != -1.0f && !(format.frameRate <= (float)parameters.maxVideoFrameRate) || format.bitrate != -1 && format.bitrate > parameters.maxVideoBitrate);
            this.isWithinMinConstraints = !(!isSuitableForViewport || format.width != -1 && format.width < parameters.minVideoWidth || format.height != -1 && format.height < parameters.minVideoHeight || format.frameRate != -1.0f && !(format.frameRate >= (float)parameters.minVideoFrameRate) || format.bitrate != -1 && format.bitrate < parameters.minVideoBitrate);
            this.isWithinRendererCapabilities = DefaultTrackSelector.isSupported(formatSupport, false);
            this.bitrate = format.bitrate;
            this.pixelCount = format.getPixelCount();
        }

        @Override
        public int compareTo(VideoTrackScore other) {
            Ordering<Integer> qualityOrdering = this.isWithinMaxConstraints && this.isWithinRendererCapabilities ? FORMAT_VALUE_ORDERING : FORMAT_VALUE_ORDERING.reverse();
            return ComparisonChain.start().compareFalseFirst(this.isWithinRendererCapabilities, other.isWithinRendererCapabilities).compareFalseFirst(this.isWithinMaxConstraints, other.isWithinMaxConstraints).compareFalseFirst(this.isWithinMinConstraints, other.isWithinMinConstraints).compare((Object)this.bitrate, (Object)other.bitrate, (Comparator)(this.parameters.forceLowestBitrate ? FORMAT_VALUE_ORDERING.reverse() : NO_ORDER)).compare((Object)this.pixelCount, (Object)other.pixelCount, qualityOrdering).compare((Object)this.bitrate, (Object)other.bitrate, qualityOrdering).result();
        }
    }

    protected static final class OtherTrackScore
    implements Comparable<OtherTrackScore> {
        private final boolean isDefault;
        private final boolean isWithinRendererCapabilities;

        public OtherTrackScore(Format format, int trackFormatSupport) {
            this.isDefault = (format.selectionFlags & 1) != 0;
            this.isWithinRendererCapabilities = DefaultTrackSelector.isSupported(trackFormatSupport, false);
        }

        @Override
        public int compareTo(OtherTrackScore other) {
            return ComparisonChain.start().compareFalseFirst(this.isWithinRendererCapabilities, other.isWithinRendererCapabilities).compareFalseFirst(this.isDefault, other.isDefault).result();
        }
    }
}

