/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.source.chunk;

import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.Format;
import com.akamai.amp.exoplayer2.extractor.DefaultExtractorInput;
import com.akamai.amp.exoplayer2.source.chunk.Chunk;
import com.akamai.amp.exoplayer2.source.chunk.ChunkExtractor;
import com.akamai.amp.exoplayer2.upstream.DataSource;
import com.akamai.amp.exoplayer2.upstream.DataSpec;
import com.akamai.amp.exoplayer2.util.Util;
import java.io.IOException;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public final class InitializationChunk
extends Chunk {
    private final ChunkExtractor chunkExtractor;
    private @MonotonicNonNull ChunkExtractor.TrackOutputProvider trackOutputProvider;
    private long nextLoadPosition;
    private volatile boolean loadCanceled;

    public InitializationChunk(DataSource dataSource, DataSpec dataSpec, Format trackFormat, int trackSelectionReason, @Nullable Object trackSelectionData, ChunkExtractor chunkExtractor) {
        super(dataSource, dataSpec, 2, trackFormat, trackSelectionReason, trackSelectionData, -9223372036854775807L, -9223372036854775807L);
        this.chunkExtractor = chunkExtractor;
    }

    public void init(ChunkExtractor.TrackOutputProvider trackOutputProvider) {
        this.trackOutputProvider = trackOutputProvider;
    }

    @Override
    public void cancelLoad() {
        this.loadCanceled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load() throws IOException {
        if (this.nextLoadPosition == 0L) {
            this.chunkExtractor.init(this.trackOutputProvider, -9223372036854775807L, -9223372036854775807L);
        }
        try {
            DataSpec loadDataSpec = this.dataSpec.subrange(this.nextLoadPosition);
            DefaultExtractorInput input = new DefaultExtractorInput(this.dataSource, loadDataSpec.position, this.dataSource.open(loadDataSpec));
            try {
                while (!this.loadCanceled && this.chunkExtractor.read(input)) {
                }
            }
            finally {
                this.nextLoadPosition = input.getPosition() - this.dataSpec.position;
            }
        }
        finally {
            Util.closeQuietly(this.dataSource);
        }
    }
}

