/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.source.chunk;

import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.Format;
import com.akamai.amp.exoplayer2.source.chunk.BaseMediaChunkOutput;
import com.akamai.amp.exoplayer2.source.chunk.MediaChunk;
import com.akamai.amp.exoplayer2.upstream.DataSource;
import com.akamai.amp.exoplayer2.upstream.DataSpec;
import com.akamai.amp.exoplayer2.util.Assertions;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public abstract class BaseMediaChunk
extends MediaChunk {
    public final long clippedStartTimeUs;
    public final long clippedEndTimeUs;
    private @MonotonicNonNull BaseMediaChunkOutput output;
    private int @MonotonicNonNull [] firstSampleIndices;

    public BaseMediaChunk(DataSource dataSource, DataSpec dataSpec, Format trackFormat, int trackSelectionReason, @Nullable Object trackSelectionData, long startTimeUs, long endTimeUs, long clippedStartTimeUs, long clippedEndTimeUs, long chunkIndex) {
        super(dataSource, dataSpec, trackFormat, trackSelectionReason, trackSelectionData, startTimeUs, endTimeUs, chunkIndex);
        this.clippedStartTimeUs = clippedStartTimeUs;
        this.clippedEndTimeUs = clippedEndTimeUs;
    }

    public void init(BaseMediaChunkOutput output) {
        this.output = output;
        this.firstSampleIndices = output.getWriteIndices();
    }

    public final int getFirstSampleIndex(int trackIndex) {
        return Assertions.checkStateNotNull(this.firstSampleIndices)[trackIndex];
    }

    protected final BaseMediaChunkOutput getOutput() {
        return Assertions.checkStateNotNull(this.output);
    }
}

