/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.source;

import android.net.Uri;
import android.os.Handler;
import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.Format;
import com.akamai.amp.exoplayer2.MediaItem;
import com.akamai.amp.exoplayer2.Timeline;
import com.akamai.amp.exoplayer2.ampcustom.CustomLoadErrorHandlingPolicy;
import com.akamai.amp.exoplayer2.source.BaseMediaSource;
import com.akamai.amp.exoplayer2.source.LoadEventInfo;
import com.akamai.amp.exoplayer2.source.MediaLoadData;
import com.akamai.amp.exoplayer2.source.MediaPeriod;
import com.akamai.amp.exoplayer2.source.MediaSource;
import com.akamai.amp.exoplayer2.source.MediaSourceEventListener;
import com.akamai.amp.exoplayer2.source.SinglePeriodTimeline;
import com.akamai.amp.exoplayer2.source.SingleSampleMediaPeriod;
import com.akamai.amp.exoplayer2.trackselection.DefaultTrackSelector;
import com.akamai.amp.exoplayer2.upstream.Allocator;
import com.akamai.amp.exoplayer2.upstream.DataSource;
import com.akamai.amp.exoplayer2.upstream.DataSpec;
import com.akamai.amp.exoplayer2.upstream.DefaultLoadErrorHandlingPolicy;
import com.akamai.amp.exoplayer2.upstream.LoadErrorHandlingPolicy;
import com.akamai.amp.exoplayer2.upstream.TransferListener;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.Util;
import java.io.IOException;
import java.util.Collections;

public final class SingleSampleMediaSource
extends BaseMediaSource {
    private final DataSpec dataSpec;
    private final DataSource.Factory dataSourceFactory;
    private final Format format;
    private final long durationUs;
    private final LoadErrorHandlingPolicy loadErrorHandlingPolicy;
    private final boolean treatLoadErrorsAsEndOfStream;
    private final Timeline timeline;
    private final MediaItem mediaItem;
    @Nullable
    private TransferListener transferListener;

    @Deprecated
    public SingleSampleMediaSource(Uri uri, DataSource.Factory dataSourceFactory, Format format, long durationUs) {
        this(uri, dataSourceFactory, format, durationUs, 3);
    }

    @Deprecated
    public SingleSampleMediaSource(Uri uri, DataSource.Factory dataSourceFactory, Format format, long durationUs, int minLoadableRetryCount) {
        this(uri, dataSourceFactory, format, durationUs, minLoadableRetryCount, null, null, -1, false);
    }

    @Deprecated
    public SingleSampleMediaSource(Uri uri, DataSource.Factory dataSourceFactory, Format format, long durationUs, int minLoadableRetryCount, @Nullable Handler eventHandler, @Nullable EventListener eventListener, int eventSourceId, boolean treatLoadErrorsAsEndOfStream) {
        this(null, new MediaItem.Subtitle(uri, Assertions.checkNotNull(format.sampleMimeType), format.language, format.selectionFlags), dataSourceFactory, durationUs, new DefaultLoadErrorHandlingPolicy(minLoadableRetryCount), treatLoadErrorsAsEndOfStream, null);
        if (eventHandler != null && eventListener != null) {
            this.addEventListener(eventHandler, new EventListenerWrapper(eventListener, eventSourceId));
        }
    }

    private SingleSampleMediaSource(@Nullable String trackId, MediaItem.Subtitle subtitle, DataSource.Factory dataSourceFactory, long durationUs, LoadErrorHandlingPolicy loadErrorHandlingPolicy, boolean treatLoadErrorsAsEndOfStream, @Nullable Object tag) {
        this.dataSourceFactory = dataSourceFactory;
        this.durationUs = durationUs;
        this.loadErrorHandlingPolicy = loadErrorHandlingPolicy;
        this.treatLoadErrorsAsEndOfStream = treatLoadErrorsAsEndOfStream;
        this.mediaItem = new MediaItem.Builder().setUri(Uri.EMPTY).setMediaId(subtitle.uri.toString()).setSubtitles(Collections.singletonList(subtitle)).setTag(tag).build();
        this.format = new Format.Builder().setId(trackId).setSampleMimeType(subtitle.mimeType).setLanguage(subtitle.language).setSelectionFlags(subtitle.selectionFlags).setRoleFlags(subtitle.roleFlags).setLabel(subtitle.label).build();
        this.dataSpec = new DataSpec.Builder().setUri(subtitle.uri).setFlags(1).build();
        this.timeline = new SinglePeriodTimeline(durationUs, true, false, false, null, this.mediaItem);
    }

    @Override
    public boolean isLive() {
        return false;
    }

    @Override
    @Deprecated
    @Nullable
    public Object getTag() {
        return Util.castNonNull(this.mediaItem.playbackProperties).tag;
    }

    @Override
    public MediaItem getMediaItem() {
        return this.mediaItem;
    }

    @Override
    protected void prepareSourceInternal(@Nullable TransferListener mediaTransferListener) {
        this.transferListener = mediaTransferListener;
        this.refreshSourceInfo(this.timeline);
    }

    @Override
    public void maybeThrowSourceInfoRefreshError() {
    }

    @Override
    public MediaPeriod createPeriod(MediaSource.MediaPeriodId id, Allocator allocator, long startPositionUs) {
        return new SingleSampleMediaPeriod(this.dataSpec, this.dataSourceFactory, this.transferListener, this.format, this.durationUs, this.loadErrorHandlingPolicy, this.createEventDispatcher(id), this.treatLoadErrorsAsEndOfStream);
    }

    @Override
    public void releasePeriod(MediaPeriod mediaPeriod) {
        ((SingleSampleMediaPeriod)mediaPeriod).release();
    }

    @Override
    protected void releaseSourceInternal() {
    }

    @Deprecated
    public static interface EventListener {
        public void onLoadError(int var1, IOException var2);
    }

    @Deprecated
    private static final class EventListenerWrapper
    implements MediaSourceEventListener {
        private final EventListener eventListener;
        private final int eventSourceId;

        public EventListenerWrapper(EventListener eventListener, int eventSourceId) {
            this.eventListener = Assertions.checkNotNull(eventListener);
            this.eventSourceId = eventSourceId;
        }

        @Override
        public void onLoadError(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData, IOException error, boolean wasCanceled) {
            this.eventListener.onLoadError(this.eventSourceId, error);
        }
    }

    public static final class Factory {
        private final DataSource.Factory dataSourceFactory;
        private LoadErrorHandlingPolicy loadErrorHandlingPolicy;
        private boolean treatLoadErrorsAsEndOfStream;
        @Nullable
        private Object tag;
        @Nullable
        private String trackId;

        public Factory(DataSource.Factory dataSourceFactory, DefaultTrackSelector trackSelector) {
            this.dataSourceFactory = Assertions.checkNotNull(dataSourceFactory);
            this.loadErrorHandlingPolicy = new CustomLoadErrorHandlingPolicy(trackSelector, -1);
        }

        public Factory setTag(@Nullable Object tag) {
            this.tag = tag;
            return this;
        }

        public Factory setTrackId(@Nullable String trackId) {
            this.trackId = trackId;
            return this;
        }

        @Deprecated
        public Factory setMinLoadableRetryCount(int minLoadableRetryCount) {
            return this.setLoadErrorHandlingPolicy(new DefaultLoadErrorHandlingPolicy(minLoadableRetryCount));
        }

        public Factory setLoadErrorHandlingPolicy(@Nullable LoadErrorHandlingPolicy loadErrorHandlingPolicy) {
            this.loadErrorHandlingPolicy = loadErrorHandlingPolicy != null ? loadErrorHandlingPolicy : new DefaultLoadErrorHandlingPolicy();
            return this;
        }

        public Factory setTreatLoadErrorsAsEndOfStream(boolean treatLoadErrorsAsEndOfStream) {
            this.treatLoadErrorsAsEndOfStream = treatLoadErrorsAsEndOfStream;
            return this;
        }

        public SingleSampleMediaSource createMediaSource(MediaItem.Subtitle subtitle, long durationUs) {
            return new SingleSampleMediaSource(this.trackId, subtitle, this.dataSourceFactory, durationUs, this.loadErrorHandlingPolicy, this.treatLoadErrorsAsEndOfStream, this.tag);
        }

        @Deprecated
        public SingleSampleMediaSource createMediaSource(Uri uri, Format format, long durationUs) {
            return new SingleSampleMediaSource(format.id == null ? this.trackId : format.id, new MediaItem.Subtitle(uri, Assertions.checkNotNull(format.sampleMimeType), format.language, format.selectionFlags), this.dataSourceFactory, durationUs, this.loadErrorHandlingPolicy, this.treatLoadErrorsAsEndOfStream, this.tag);
        }
    }
}

