/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.source;

import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.C;
import com.akamai.amp.exoplayer2.Format;
import com.akamai.amp.exoplayer2.FormatHolder;
import com.akamai.amp.exoplayer2.SeekParameters;
import com.akamai.amp.exoplayer2.decoder.DecoderInputBuffer;
import com.akamai.amp.exoplayer2.source.LoadEventInfo;
import com.akamai.amp.exoplayer2.source.MediaLoadData;
import com.akamai.amp.exoplayer2.source.MediaPeriod;
import com.akamai.amp.exoplayer2.source.MediaSourceEventListener;
import com.akamai.amp.exoplayer2.source.SampleStream;
import com.akamai.amp.exoplayer2.source.TrackGroup;
import com.akamai.amp.exoplayer2.source.TrackGroupArray;
import com.akamai.amp.exoplayer2.trackselection.TrackSelection;
import com.akamai.amp.exoplayer2.upstream.DataSource;
import com.akamai.amp.exoplayer2.upstream.DataSpec;
import com.akamai.amp.exoplayer2.upstream.LoadErrorHandlingPolicy;
import com.akamai.amp.exoplayer2.upstream.Loader;
import com.akamai.amp.exoplayer2.upstream.StatsDataSource;
import com.akamai.amp.exoplayer2.upstream.TransferListener;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.MimeTypes;
import com.akamai.amp.exoplayer2.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.checkerframework.checker.nullness.compatqual.NullableType;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

final class SingleSampleMediaPeriod
implements MediaPeriod,
Loader.Callback<SourceLoadable> {
    private static final int INITIAL_SAMPLE_SIZE = 1024;
    private final DataSpec dataSpec;
    private final DataSource.Factory dataSourceFactory;
    @Nullable
    private final TransferListener transferListener;
    private final LoadErrorHandlingPolicy loadErrorHandlingPolicy;
    private final MediaSourceEventListener.EventDispatcher eventDispatcher;
    private final TrackGroupArray tracks;
    private final ArrayList<SampleStreamImpl> sampleStreams;
    private final long durationUs;
    final Loader loader;
    final Format format;
    final boolean treatLoadErrorsAsEndOfStream;
    boolean loadingFinished;
    byte @MonotonicNonNull [] sampleData;
    int sampleSize;

    public SingleSampleMediaPeriod(DataSpec dataSpec, DataSource.Factory dataSourceFactory, @Nullable TransferListener transferListener, Format format, long durationUs, LoadErrorHandlingPolicy loadErrorHandlingPolicy, MediaSourceEventListener.EventDispatcher eventDispatcher, boolean treatLoadErrorsAsEndOfStream) {
        this.dataSpec = dataSpec;
        this.dataSourceFactory = dataSourceFactory;
        this.transferListener = transferListener;
        this.format = format;
        this.durationUs = durationUs;
        this.loadErrorHandlingPolicy = loadErrorHandlingPolicy;
        this.eventDispatcher = eventDispatcher;
        this.treatLoadErrorsAsEndOfStream = treatLoadErrorsAsEndOfStream;
        this.tracks = new TrackGroupArray(new TrackGroup(format));
        this.sampleStreams = new ArrayList();
        this.loader = new Loader("Loader:SingleSampleMediaPeriod");
    }

    public void release() {
        this.loader.release();
    }

    @Override
    public void prepare(MediaPeriod.Callback callback, long positionUs) {
        callback.onPrepared(this);
    }

    @Override
    public void maybeThrowPrepareError() {
    }

    @Override
    public TrackGroupArray getTrackGroups() {
        return this.tracks;
    }

    @Override
    public long selectTracks(@NullableType TrackSelection[] selections, boolean[] mayRetainStreamFlags, @NullableType SampleStream[] streams, boolean[] streamResetFlags, long positionUs) {
        for (int i = 0; i < selections.length; ++i) {
            if (!(streams[i] == null || selections[i] != null && mayRetainStreamFlags[i])) {
                this.sampleStreams.remove(streams[i]);
                streams[i] = null;
            }
            if (streams[i] != null || selections[i] == null) continue;
            SampleStreamImpl stream = new SampleStreamImpl();
            this.sampleStreams.add(stream);
            streams[i] = stream;
            streamResetFlags[i] = true;
        }
        return positionUs;
    }

    @Override
    public void discardBuffer(long positionUs, boolean toKeyframe) {
    }

    @Override
    public void reevaluateBuffer(long positionUs) {
    }

    @Override
    public boolean continueLoading(long positionUs) {
        if (this.loadingFinished || this.loader.isLoading() || this.loader.hasFatalError()) {
            return false;
        }
        DataSource dataSource = this.dataSourceFactory.createDataSource();
        if (this.transferListener != null) {
            dataSource.addTransferListener(this.transferListener);
        }
        SourceLoadable loadable = new SourceLoadable(this.dataSpec, dataSource);
        long elapsedRealtimeMs = this.loader.startLoading(loadable, this, this.loadErrorHandlingPolicy.getMinimumLoadableRetryCount(1));
        this.eventDispatcher.loadStarted(new LoadEventInfo(loadable.loadTaskId, this.dataSpec, elapsedRealtimeMs), 1, -1, this.format, 0, null, 0L, this.durationUs);
        return true;
    }

    @Override
    public boolean isLoading() {
        return this.loader.isLoading();
    }

    @Override
    public long readDiscontinuity() {
        return -9223372036854775807L;
    }

    @Override
    public long getNextLoadPositionUs() {
        return this.loadingFinished || this.loader.isLoading() ? Long.MIN_VALUE : 0L;
    }

    @Override
    public long getBufferedPositionUs() {
        return this.loadingFinished ? Long.MIN_VALUE : 0L;
    }

    @Override
    public long seekToUs(long positionUs) {
        for (int i = 0; i < this.sampleStreams.size(); ++i) {
            this.sampleStreams.get(i).reset();
        }
        return positionUs;
    }

    @Override
    public long getAdjustedSeekPositionUs(long positionUs, SeekParameters seekParameters) {
        return positionUs;
    }

    @Override
    public void onLoadCompleted(SourceLoadable loadable, long elapsedRealtimeMs, long loadDurationMs) {
        this.sampleSize = (int)loadable.dataSource.getBytesRead();
        this.sampleData = Assertions.checkNotNull(loadable.sampleData);
        this.loadingFinished = true;
        StatsDataSource dataSource = loadable.dataSource;
        LoadEventInfo loadEventInfo = new LoadEventInfo(loadable.loadTaskId, loadable.dataSpec, dataSource.getLastOpenedUri(), dataSource.getLastResponseHeaders(), elapsedRealtimeMs, loadDurationMs, this.sampleSize);
        this.loadErrorHandlingPolicy.onLoadTaskConcluded(loadable.loadTaskId);
        this.eventDispatcher.loadCompleted(loadEventInfo, 1, -1, this.format, 0, null, 0L, this.durationUs);
    }

    @Override
    public void onLoadCanceled(SourceLoadable loadable, long elapsedRealtimeMs, long loadDurationMs, boolean released) {
        StatsDataSource dataSource = loadable.dataSource;
        LoadEventInfo loadEventInfo = new LoadEventInfo(loadable.loadTaskId, loadable.dataSpec, dataSource.getLastOpenedUri(), dataSource.getLastResponseHeaders(), elapsedRealtimeMs, loadDurationMs, dataSource.getBytesRead());
        this.loadErrorHandlingPolicy.onLoadTaskConcluded(loadable.loadTaskId);
        this.eventDispatcher.loadCanceled(loadEventInfo, 1, -1, null, 0, null, 0L, this.durationUs);
    }

    @Override
    public Loader.LoadErrorAction onLoadError(SourceLoadable loadable, long elapsedRealtimeMs, long loadDurationMs, IOException error, int errorCount) {
        Loader.LoadErrorAction action;
        boolean errorCanBePropagated;
        MediaLoadData mediaLoadData;
        StatsDataSource dataSource = loadable.dataSource;
        LoadEventInfo loadEventInfo = new LoadEventInfo(loadable.loadTaskId, loadable.dataSpec, dataSource.getLastOpenedUri(), dataSource.getLastResponseHeaders(), elapsedRealtimeMs, loadDurationMs, dataSource.getBytesRead());
        long retryDelay = this.loadErrorHandlingPolicy.getRetryDelayMsFor(new LoadErrorHandlingPolicy.LoadErrorInfo(loadEventInfo, mediaLoadData = new MediaLoadData(1, -1, this.format, 0, null, 0L, C.usToMs(this.durationUs)), error, errorCount));
        boolean bl = errorCanBePropagated = retryDelay == -9223372036854775807L || errorCount >= this.loadErrorHandlingPolicy.getMinimumLoadableRetryCount(1);
        if (this.treatLoadErrorsAsEndOfStream && errorCanBePropagated) {
            this.loadingFinished = true;
            action = Loader.DONT_RETRY;
        } else {
            action = retryDelay != -9223372036854775807L ? Loader.createRetryAction(false, retryDelay) : Loader.DONT_RETRY_FATAL;
        }
        boolean wasCanceled = !action.isRetry();
        this.eventDispatcher.loadError(loadEventInfo, 1, -1, this.format, 0, null, 0L, this.durationUs, error, wasCanceled);
        if (wasCanceled) {
            this.loadErrorHandlingPolicy.onLoadTaskConcluded(loadable.loadTaskId);
        }
        return action;
    }

    private final class SampleStreamImpl
    implements SampleStream {
        private static final int STREAM_STATE_SEND_FORMAT = 0;
        private static final int STREAM_STATE_SEND_SAMPLE = 1;
        private static final int STREAM_STATE_END_OF_STREAM = 2;
        private int streamState;
        private boolean notifiedDownstreamFormat;

        private SampleStreamImpl() {
        }

        public void reset() {
            if (this.streamState == 2) {
                this.streamState = 1;
            }
        }

        @Override
        public boolean isReady() {
            return SingleSampleMediaPeriod.this.loadingFinished;
        }

        @Override
        public void maybeThrowError() throws IOException {
            if (!SingleSampleMediaPeriod.this.treatLoadErrorsAsEndOfStream) {
                SingleSampleMediaPeriod.this.loader.maybeThrowError();
            }
        }

        @Override
        public int readData(FormatHolder formatHolder, DecoderInputBuffer buffer, boolean requireFormat) {
            this.maybeNotifyDownstreamFormat();
            if (this.streamState == 2) {
                buffer.addFlag(4);
                return -4;
            }
            if (requireFormat || this.streamState == 0) {
                formatHolder.format = SingleSampleMediaPeriod.this.format;
                this.streamState = 1;
                return -5;
            }
            if (SingleSampleMediaPeriod.this.loadingFinished) {
                if (SingleSampleMediaPeriod.this.sampleData != null) {
                    buffer.addFlag(1);
                    buffer.timeUs = 0L;
                    if (buffer.isFlagsOnly()) {
                        return -4;
                    }
                    buffer.ensureSpaceForWrite(SingleSampleMediaPeriod.this.sampleSize);
                    buffer.data.put(SingleSampleMediaPeriod.this.sampleData, 0, SingleSampleMediaPeriod.this.sampleSize);
                } else {
                    buffer.addFlag(4);
                }
                this.streamState = 2;
                return -4;
            }
            return -3;
        }

        @Override
        public int skipData(long positionUs) {
            this.maybeNotifyDownstreamFormat();
            if (positionUs > 0L && this.streamState != 2) {
                this.streamState = 2;
                return 1;
            }
            return 0;
        }

        private void maybeNotifyDownstreamFormat() {
            if (!this.notifiedDownstreamFormat) {
                SingleSampleMediaPeriod.this.eventDispatcher.downstreamFormatChanged(MimeTypes.getTrackType(SingleSampleMediaPeriod.this.format.sampleMimeType), SingleSampleMediaPeriod.this.format, 0, null, 0L);
                this.notifiedDownstreamFormat = true;
            }
        }
    }

    static final class SourceLoadable
    implements Loader.Loadable {
        public final long loadTaskId = LoadEventInfo.getNewId();
        public final DataSpec dataSpec;
        private final StatsDataSource dataSource;
        @Nullable
        private byte[] sampleData;

        public SourceLoadable(DataSpec dataSpec, DataSource dataSource) {
            this.dataSpec = dataSpec;
            this.dataSource = new StatsDataSource(dataSource);
        }

        @Override
        public void cancelLoad() {
        }

        @Override
        public void load() throws IOException {
            this.dataSource.resetBytesRead();
            try {
                this.dataSource.open(this.dataSpec);
                int result = 0;
                while (result != -1) {
                    int sampleSize = (int)this.dataSource.getBytesRead();
                    if (this.sampleData == null) {
                        this.sampleData = new byte[1024];
                    } else if (sampleSize == this.sampleData.length) {
                        this.sampleData = Arrays.copyOf(this.sampleData, this.sampleData.length * 2);
                    }
                    result = this.dataSource.read(this.sampleData, sampleSize, this.sampleData.length - sampleSize);
                }
            }
            finally {
                Util.closeQuietly(this.dataSource);
            }
        }
    }
}

