/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.offline;

import android.util.SparseArray;
import com.akamai.amp.exoplayer2.MediaItem;
import com.akamai.amp.exoplayer2.offline.DownloadRequest;
import com.akamai.amp.exoplayer2.offline.Downloader;
import com.akamai.amp.exoplayer2.offline.DownloaderFactory;
import com.akamai.amp.exoplayer2.offline.ProgressiveDownloader;
import com.akamai.amp.exoplayer2.upstream.cache.CacheDataSource;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.Util;
import java.lang.reflect.Constructor;
import java.util.concurrent.Executor;

public class DefaultDownloaderFactory
implements DownloaderFactory {
    private static final SparseArray<Constructor<? extends Downloader>> CONSTRUCTORS = DefaultDownloaderFactory.createDownloaderConstructors();
    private final CacheDataSource.Factory cacheDataSourceFactory;
    private final Executor executor;

    @Deprecated
    public DefaultDownloaderFactory(CacheDataSource.Factory cacheDataSourceFactory) {
        this(cacheDataSourceFactory, Runnable::run);
    }

    public DefaultDownloaderFactory(CacheDataSource.Factory cacheDataSourceFactory, Executor executor) {
        this.cacheDataSourceFactory = Assertions.checkNotNull(cacheDataSourceFactory);
        this.executor = Assertions.checkNotNull(executor);
    }

    @Override
    public Downloader createDownloader(DownloadRequest request) {
        int contentType = Util.inferContentTypeForUriAndMimeType(request.uri, request.mimeType);
        switch (contentType) {
            case 0: 
            case 1: 
            case 2: {
                return this.createDownloader(request, contentType);
            }
            case 3: {
                return new ProgressiveDownloader(new MediaItem.Builder().setUri(request.uri).setCustomCacheKey(request.customCacheKey).build(), this.cacheDataSourceFactory, this.executor);
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + contentType);
    }

    private Downloader createDownloader(DownloadRequest request, int contentType) {
        Constructor constructor = (Constructor)CONSTRUCTORS.get(contentType);
        if (constructor == null) {
            throw new IllegalStateException("Module missing for content type " + contentType);
        }
        MediaItem mediaItem = new MediaItem.Builder().setUri(request.uri).setStreamKeys(request.streamKeys).setCustomCacheKey(request.customCacheKey).setDrmKeySetId(request.keySetId).build();
        try {
            return (Downloader)constructor.newInstance(mediaItem, this.cacheDataSourceFactory, this.executor);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to instantiate downloader for content type " + contentType);
        }
    }

    private static SparseArray<Constructor<? extends Downloader>> createDownloaderConstructors() {
        SparseArray array = new SparseArray();
        try {
            array.put(0, DefaultDownloaderFactory.getDownloaderConstructor(Class.forName("com.akamai.amp.exoplayer2.source.dash.offline.DashDownloader")));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            array.put(2, DefaultDownloaderFactory.getDownloaderConstructor(Class.forName("com.akamai.amp.exoplayer2.source.hls.offline.HlsDownloader")));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            array.put(1, DefaultDownloaderFactory.getDownloaderConstructor(Class.forName("com.akamai.amp.exoplayer2.source.smoothstreaming.offline.SsDownloader")));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return array;
    }

    private static Constructor<? extends Downloader> getDownloaderConstructor(Class<?> clazz) {
        try {
            return clazz.asSubclass(Downloader.class).getConstructor(MediaItem.class, CacheDataSource.Factory.class, Executor.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Downloader constructor missing", e);
        }
    }
}

