/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import com.akamai.amp.exoplayer2.MediaItem;
import com.akamai.amp.exoplayer2.Timeline;
import com.akamai.amp.exoplayer2.source.DefaultMediaSourceFactory;
import com.akamai.amp.exoplayer2.source.MediaPeriod;
import com.akamai.amp.exoplayer2.source.MediaSource;
import com.akamai.amp.exoplayer2.source.MediaSourceFactory;
import com.akamai.amp.exoplayer2.source.TrackGroupArray;
import com.akamai.amp.exoplayer2.upstream.Allocator;
import com.akamai.amp.exoplayer2.upstream.DefaultAllocator;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.Util;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public final class MetadataRetriever {
    private MetadataRetriever() {
    }

    public static ListenableFuture<TrackGroupArray> retrieveMetadata(Context context, MediaItem mediaItem) {
        return MetadataRetriever.retrieveMetadata(new DefaultMediaSourceFactory(context), mediaItem);
    }

    public static ListenableFuture<TrackGroupArray> retrieveMetadata(MediaSourceFactory mediaSourceFactory, MediaItem mediaItem) {
        return new MetadataRetrieverInternal(mediaSourceFactory).retrieveMetadata(mediaItem);
    }

    private static final class MetadataRetrieverInternal {
        private static final int MESSAGE_PREPARE_SOURCE = 0;
        private static final int MESSAGE_CHECK_FOR_FAILURE = 1;
        private static final int MESSAGE_CONTINUE_LOADING = 2;
        private static final int MESSAGE_RELEASE = 3;
        private final MediaSourceFactory mediaSourceFactory;
        private final HandlerThread mediaSourceThread;
        private final Handler mediaSourceHandler;
        private final SettableFuture<TrackGroupArray> trackGroupsFuture;

        public MetadataRetrieverInternal(MediaSourceFactory mediaSourceFactory) {
            this.mediaSourceFactory = mediaSourceFactory;
            this.mediaSourceThread = new HandlerThread("ExoPlayer:MetadataRetriever");
            this.mediaSourceThread.start();
            this.mediaSourceHandler = Util.createHandler(this.mediaSourceThread.getLooper(), new MediaSourceHandlerCallback());
            this.trackGroupsFuture = SettableFuture.create();
        }

        public ListenableFuture<TrackGroupArray> retrieveMetadata(MediaItem mediaItem) {
            this.mediaSourceHandler.obtainMessage(0, (Object)mediaItem).sendToTarget();
            return this.trackGroupsFuture;
        }

        private final class MediaSourceHandlerCallback
        implements Handler.Callback {
            private static final int ERROR_POLL_INTERVAL_MS = 100;
            private final MediaSourceCaller mediaSourceCaller = new MediaSourceCaller();
            private @MonotonicNonNull MediaSource mediaSource;
            private @MonotonicNonNull MediaPeriod mediaPeriod;

            public boolean handleMessage(Message msg) {
                switch (msg.what) {
                    case 0: {
                        MediaItem mediaItem = (MediaItem)msg.obj;
                        this.mediaSource = MetadataRetrieverInternal.this.mediaSourceFactory.createMediaSource(mediaItem);
                        this.mediaSource.prepareSource(this.mediaSourceCaller, null);
                        MetadataRetrieverInternal.this.mediaSourceHandler.sendEmptyMessage(1);
                        return true;
                    }
                    case 1: {
                        try {
                            if (this.mediaPeriod == null) {
                                Assertions.checkNotNull(this.mediaSource).maybeThrowSourceInfoRefreshError();
                            } else {
                                this.mediaPeriod.maybeThrowPrepareError();
                            }
                            MetadataRetrieverInternal.this.mediaSourceHandler.sendEmptyMessageDelayed(1, 100L);
                        }
                        catch (Exception e) {
                            MetadataRetrieverInternal.this.trackGroupsFuture.setException((Throwable)e);
                            MetadataRetrieverInternal.this.mediaSourceHandler.obtainMessage(3).sendToTarget();
                        }
                        return true;
                    }
                    case 2: {
                        Assertions.checkNotNull(this.mediaPeriod).continueLoading(0L);
                        return true;
                    }
                    case 3: {
                        if (this.mediaPeriod != null) {
                            Assertions.checkNotNull(this.mediaSource).releasePeriod(this.mediaPeriod);
                        }
                        Assertions.checkNotNull(this.mediaSource).releaseSource(this.mediaSourceCaller);
                        MetadataRetrieverInternal.this.mediaSourceHandler.removeCallbacksAndMessages(null);
                        MetadataRetrieverInternal.this.mediaSourceThread.quit();
                        return true;
                    }
                }
                return false;
            }

            private final class MediaSourceCaller
            implements MediaSource.MediaSourceCaller {
                private final MediaPeriodCallback mediaPeriodCallback = new MediaPeriodCallback();
                private final Allocator allocator = new DefaultAllocator(true, 65536);
                private boolean mediaPeriodCreated;

                @Override
                public void onSourceInfoRefreshed(MediaSource source, Timeline timeline) {
                    if (this.mediaPeriodCreated) {
                        return;
                    }
                    this.mediaPeriodCreated = true;
                    MediaSourceHandlerCallback.this.mediaPeriod = source.createPeriod(new MediaSource.MediaPeriodId(timeline.getUidOfPeriod(0)), this.allocator, 0L);
                    MediaSourceHandlerCallback.this.mediaPeriod.prepare(this.mediaPeriodCallback, 0L);
                }

                private final class MediaPeriodCallback
                implements MediaPeriod.Callback {
                    private MediaPeriodCallback() {
                    }

                    @Override
                    public void onPrepared(MediaPeriod mediaPeriod) {
                        MetadataRetrieverInternal.this.trackGroupsFuture.set((Object)mediaPeriod.getTrackGroups());
                        MetadataRetrieverInternal.this.mediaSourceHandler.obtainMessage(3).sendToTarget();
                    }

                    @Override
                    public void onContinueLoadingRequested(MediaPeriod mediaPeriod) {
                        MetadataRetrieverInternal.this.mediaSourceHandler.obtainMessage(2).sendToTarget();
                    }
                }
            }
        }
    }
}

