/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.media.elements.loaders;

import com.akamai.amp.media.elements.MediaResource;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PMDFactoryLoader {
    private static final String URL_REGEX = "(http|https|file)(://.*?\\.)(mv|mp3||mp4|m4v|m4a|3gp|3gpp2|3g2)$";
    private static final Pattern URL_PATTERN = Pattern.compile("(http|https|file)(://.*?\\.)(mv|mp3||mp4|m4v|m4a|3gp|3gpp2|3g2)$", 2);
    private static final String[] SUPPORTED_MIME_TYPES = new String[]{"video/mp4", "audio/mp3", "audio/mpeg", "video/mp4v-es", "video/x-m4v", "video/3gpp", "video/3gpp2", "video/quicktime"};

    public static boolean canHandle(MediaResource mediaResource) {
        String url = mediaResource.getUrlWithoutQueryString();
        String mimeType = mediaResource.getMimeType();
        return PMDFactoryLoader.canHandle(url, mimeType);
    }

    public static boolean canHandle(String url, String mimeType) {
        Matcher matcher = URL_PATTERN.matcher(url);
        boolean urlMatchesRegex = matcher.matches();
        if (urlMatchesRegex) {
            return true;
        }
        boolean canHandleMimeType = Arrays.asList(SUPPORTED_MIME_TYPES).contains(mimeType);
        return canHandleMimeType;
    }
}

