/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.media.elements;

import androidx.annotation.NonNull;

public class QualityLevel
implements Comparable<QualityLevel> {
    private final int bitrateInBitsPerSecond;
    private final int width;
    private final int height;

    public QualityLevel(int bitrate, int width, int height) {
        this.bitrateInBitsPerSecond = bitrate;
        this.width = width;
        this.height = height;
    }

    public int getBitrateInBitsPerSecond() {
        return this.bitrateInBitsPerSecond;
    }

    public int getBitrateInKilobitsPerSecond() {
        return this.bitrateInBitsPerSecond / 1024;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    @Override
    public int compareTo(@NonNull QualityLevel other) {
        int comparisonResult = QualityLevel.compare(this, other);
        return comparisonResult;
    }

    private static int compare(QualityLevel thisQL, QualityLevel other) {
        int bitrateDiff = thisQL.bitrateInBitsPerSecond - other.bitrateInBitsPerSecond;
        if (bitrateDiff == 0) {
            int widthDiff = thisQL.width - other.width;
            if (widthDiff == 0) {
                int heightDiff = thisQL.height - other.height;
                return heightDiff;
            }
            return widthDiff;
        }
        return bitrateDiff;
    }

    public String toString() {
        return this.bitrateInBitsPerSecond / 1024 + "Kbps " + this.width + "x" + this.height;
    }
}

