/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.media.elements;

import android.os.AsyncTask;
import com.akamai.amp.media.elements.MediaResource;
import com.akamai.amp.media.hls.httpdownloaders.StringHttpDownloader;
import com.akamai.amp.utils.LogManager;
import com.akamai.amp.utils.MediaResourceUtils;

public class AMPFeedLoader
extends AsyncTask<String, Void, MediaResource> {
    private static final String TAG = "Android SDK - AMP Feed Loader";
    private AMPFeedLoaderListener mListener;

    public AMPFeedLoader(AMPFeedLoaderListener listener) {
        this.mListener = listener;
    }

    protected MediaResource doInBackground(String ... params) {
        String url = params[0];
        LogManager.log(TAG, "Loading feed url: " + url);
        StringHttpDownloader downloader = new StringHttpDownloader();
        String fileData = (String)downloader.loadFile(url, null, false);
        MediaResource mediaResource = new MediaResource();
        if (fileData != null) {
            LogManager.log(TAG, "Parsing json feed");
            mediaResource = MediaResourceUtils.createMediaResourceFromRawFeed(fileData);
        }
        return mediaResource;
    }

    protected void onPostExecute(MediaResource result) {
        LogManager.log(TAG, "Raising feed url was downloaded");
        if (result != null) {
            LogManager.log(TAG, "Url to open: " + result.getUrl() + ", Title: " + result.getTitle());
        }
        if (this.mListener != null) {
            this.mListener.feedLoaded(result);
        }
        super.onPostExecute((Object)result);
    }

    public static interface AMPFeedLoaderListener {
        public void feedLoaded(MediaResource var1);
    }
}

