/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.license.decryption;

import com.akamai.amp.license.decryption.StreamUtils;
import com.akamai.amp.license.decryption.Validate;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

class TrailerInputStream
extends InputStream {
    private static final int EOF_VALUE = -1;
    private final int trailerSize;
    private final InputStream in;
    private byte[] trailerBuffer;

    public TrailerInputStream(InputStream in, int trailerSize) {
        Validate.notNull(in, "InputStream cannot be null.", new Object[0]);
        Validate.isTrue(trailerSize > -1, "Trailer size cannot be negative.", new Object[0]);
        this.in = in;
        this.trailerSize = trailerSize;
    }

    private void fillTrailerBuffer() throws IOException {
        this.trailerBuffer = new byte[this.trailerSize];
        if (this.trailerSize == 0) {
            return;
        }
        int bytesRead = StreamUtils.readAllBytes(this.in, this.trailerBuffer);
        if (bytesRead != this.trailerBuffer.length) {
            throw new EOFException(String.format("Trailer size was %d bytes but stream only contained %d bytes.", this.trailerSize, bytesRead));
        }
    }

    @Override
    public int read() throws IOException {
        int nextByte;
        if (this.trailerBuffer == null) {
            this.fillTrailerBuffer();
        }
        if ((nextByte = this.in.read()) == -1) {
            return nextByte;
        }
        if (this.trailerBuffer.length == 0) {
            return nextByte;
        }
        int result = this.trailerBuffer[0] & 0xFF;
        System.arraycopy(this.trailerBuffer, 1, this.trailerBuffer, 0, this.trailerBuffer.length - 1);
        this.trailerBuffer[this.trailerBuffer.length - 1] = (byte)nextByte;
        return result;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        byte[] inputBuffer;
        int numBytesRead;
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.trailerBuffer == null) {
            this.fillTrailerBuffer();
        }
        if ((numBytesRead = this.in.read(inputBuffer = new byte[len])) == -1) {
            return numBytesRead;
        }
        if (this.trailerSize == 0) {
            System.arraycopy(inputBuffer, 0, b, off, numBytesRead);
            return numBytesRead;
        }
        if (numBytesRead <= this.trailerSize) {
            System.arraycopy(this.trailerBuffer, 0, b, off, numBytesRead);
            System.arraycopy(this.trailerBuffer, numBytesRead, this.trailerBuffer, 0, this.trailerSize - numBytesRead);
            System.arraycopy(inputBuffer, 0, this.trailerBuffer, this.trailerSize - numBytesRead, numBytesRead);
        } else {
            System.arraycopy(this.trailerBuffer, 0, b, off, this.trailerSize);
            System.arraycopy(inputBuffer, 0, b, off += this.trailerSize, numBytesRead - this.trailerSize);
            System.arraycopy(inputBuffer, numBytesRead - this.trailerSize, this.trailerBuffer, 0, this.trailerSize);
        }
        return numBytesRead;
    }

    @Override
    public int available() throws IOException {
        if (this.trailerBuffer == null) {
            return Math.max(0, this.in.available() - this.trailerSize);
        }
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    public byte[] getTrailer() {
        return (byte[])this.trailerBuffer.clone();
    }
}

