/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.license.decryption;

import com.akamai.amp.license.decryption.AES256JNCryptor;
import com.akamai.amp.license.decryption.CryptorException;
import com.akamai.amp.license.decryption.Validate;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class AES256JNCryptorOutputStream
extends OutputStream {
    private CipherOutputStream cipherStream;
    private MacOutputStream macOutputStream;
    private boolean writtenHeader;
    private final boolean passwordBased;
    private byte[] encryptionSalt;
    private byte[] iv;
    private byte[] hmacSalt;

    public AES256JNCryptorOutputStream(OutputStream out, SecretKey encryptionKey, SecretKey hmacKey) throws CryptorException {
        Validate.notNull(out, "Output stream cannot be null.", new Object[0]);
        Validate.notNull(encryptionKey, "Encryption key cannot be null.", new Object[0]);
        Validate.notNull(hmacKey, "HMAC key cannot be null.", new Object[0]);
        byte[] iv = AES256JNCryptor.getSecureRandomData(16);
        this.passwordBased = false;
        this.createStreams(encryptionKey, hmacKey, iv, out);
    }

    public AES256JNCryptorOutputStream(OutputStream out, char[] password, int iterations) throws CryptorException {
        Validate.notNull(out, "Output stream cannot be null.", new Object[0]);
        Validate.notNull(password, "Password cannot be null.", new Object[0]);
        Validate.isTrue(password.length > 0, "Password cannot be empty.", new Object[0]);
        Validate.isTrue(iterations > 0, "Iterations must be greater than zero.", new Object[0]);
        AES256JNCryptor cryptor = new AES256JNCryptor(iterations);
        this.encryptionSalt = AES256JNCryptor.getSecureRandomData(8);
        SecretKey encryptionKey = cryptor.keyForPassword(password, this.encryptionSalt);
        this.hmacSalt = AES256JNCryptor.getSecureRandomData(8);
        SecretKey hmacKey = cryptor.keyForPassword(password, this.hmacSalt);
        this.iv = AES256JNCryptor.getSecureRandomData(16);
        this.passwordBased = true;
        this.createStreams(encryptionKey, hmacKey, this.iv, out);
    }

    public AES256JNCryptorOutputStream(OutputStream out, char[] password) throws CryptorException {
        this(out, password, 10000);
    }

    private void createStreams(SecretKey encryptionKey, SecretKey hmacKey, byte[] iv, OutputStream out) throws CryptorException {
        this.iv = iv;
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, (Key)encryptionKey, new IvParameterSpec(iv));
            try {
                Mac mac = Mac.getInstance("HmacSHA256");
                mac.init(hmacKey);
                this.macOutputStream = new MacOutputStream(out, mac);
                this.cipherStream = new CipherOutputStream(this.macOutputStream, cipher);
            }
            catch (GeneralSecurityException e) {
                throw new CryptorException("Failed to initialize HMac", e);
            }
        }
        catch (GeneralSecurityException e) {
            throw new CryptorException("Failed to initialize AES cipher", e);
        }
    }

    private void writeHeader() throws IOException {
        if (this.passwordBased) {
            this.macOutputStream.write(3);
            this.macOutputStream.write(1);
            this.macOutputStream.write(this.encryptionSalt);
            this.macOutputStream.write(this.hmacSalt);
            this.macOutputStream.write(this.iv);
        } else {
            this.macOutputStream.write(3);
            this.macOutputStream.write(0);
            this.macOutputStream.write(this.iv);
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (!this.writtenHeader) {
            this.writeHeader();
            this.writtenHeader = true;
        }
        this.cipherStream.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (!this.writtenHeader) {
            this.writeHeader();
            this.writtenHeader = true;
        }
        this.cipherStream.write(b, off, len);
    }

    @Override
    public void close() throws IOException {
        this.cipherStream.close();
    }

    private static class MacOutputStream
    extends FilterOutputStream {
        private final Mac mac;

        MacOutputStream(OutputStream out, Mac mac) {
            super(out);
            this.mac = mac;
        }

        @Override
        public void write(int b) throws IOException {
            this.mac.update((byte)b);
            this.out.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.mac.update(b, off, len);
            this.out.write(b, off, len);
        }

        @Override
        public void close() throws IOException {
            byte[] macData = this.mac.doFinal();
            this.out.write(macData);
            this.out.flush();
            this.out.close();
        }
    }
}

