/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.text;

import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.decoder.DecoderInputBuffer;
import com.akamai.amp.exoplayer2.decoder.OutputBuffer;
import com.akamai.amp.exoplayer2.decoder.SimpleDecoder;
import com.akamai.amp.exoplayer2.text.SimpleSubtitleOutputBuffer;
import com.akamai.amp.exoplayer2.text.Subtitle;
import com.akamai.amp.exoplayer2.text.SubtitleDecoder;
import com.akamai.amp.exoplayer2.text.SubtitleDecoderException;
import com.akamai.amp.exoplayer2.text.SubtitleInputBuffer;
import com.akamai.amp.exoplayer2.text.SubtitleOutputBuffer;
import com.akamai.amp.exoplayer2.util.Assertions;
import java.nio.ByteBuffer;

public abstract class SimpleSubtitleDecoder
extends SimpleDecoder<SubtitleInputBuffer, SubtitleOutputBuffer, SubtitleDecoderException>
implements SubtitleDecoder {
    private final String name;

    protected SimpleSubtitleDecoder(String name) {
        super((DecoderInputBuffer[])new SubtitleInputBuffer[2], (OutputBuffer[])new SubtitleOutputBuffer[2]);
        this.name = name;
        this.setInitialInputBufferSize(1024);
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public void setPositionUs(long timeUs) {
    }

    @Override
    protected final SubtitleInputBuffer createInputBuffer() {
        return new SubtitleInputBuffer();
    }

    @Override
    protected final SubtitleOutputBuffer createOutputBuffer() {
        return new SimpleSubtitleOutputBuffer(x$0 -> this.releaseOutputBuffer(x$0));
    }

    @Override
    protected final SubtitleDecoderException createUnexpectedDecodeException(Throwable error) {
        return new SubtitleDecoderException("Unexpected decode error", error);
    }

    @Override
    @Nullable
    protected final SubtitleDecoderException decode(SubtitleInputBuffer inputBuffer, SubtitleOutputBuffer outputBuffer, boolean reset) {
        try {
            ByteBuffer inputData = Assertions.checkNotNull(inputBuffer.data);
            Subtitle subtitle = this.decode(inputData.array(), inputData.limit(), reset);
            outputBuffer.setContent(inputBuffer.timeUs, subtitle, inputBuffer.subsampleOffsetUs);
            outputBuffer.clearFlag(Integer.MIN_VALUE);
            return null;
        }
        catch (SubtitleDecoderException e) {
            return e;
        }
    }

    @Override
    protected abstract Subtitle decode(byte[] var1, int var2, boolean var3) throws SubtitleDecoderException;
}

