/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.extractor.ogg;

import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.extractor.ExtractorInput;
import com.akamai.amp.exoplayer2.extractor.FlacFrameReader;
import com.akamai.amp.exoplayer2.extractor.FlacMetadataReader;
import com.akamai.amp.exoplayer2.extractor.FlacSeekTableSeekMap;
import com.akamai.amp.exoplayer2.extractor.FlacStreamMetadata;
import com.akamai.amp.exoplayer2.extractor.SeekMap;
import com.akamai.amp.exoplayer2.extractor.ogg.OggSeeker;
import com.akamai.amp.exoplayer2.extractor.ogg.StreamReader;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.ParsableByteArray;
import com.akamai.amp.exoplayer2.util.Util;
import java.util.Arrays;

final class FlacReader
extends StreamReader {
    private static final byte AUDIO_PACKET_TYPE = -1;
    private static final int FRAME_HEADER_SAMPLE_NUMBER_OFFSET = 4;
    @Nullable
    private FlacStreamMetadata streamMetadata;
    @Nullable
    private FlacOggSeeker flacOggSeeker;

    FlacReader() {
    }

    public static boolean verifyBitstreamType(ParsableByteArray data) {
        return data.bytesLeft() >= 5 && data.readUnsignedByte() == 127 && data.readUnsignedInt() == 1179402563L;
    }

    @Override
    protected void reset(boolean headerData) {
        super.reset(headerData);
        if (headerData) {
            this.streamMetadata = null;
            this.flacOggSeeker = null;
        }
    }

    private static boolean isAudioPacket(byte[] data) {
        return data[0] == -1;
    }

    @Override
    protected long preparePayload(ParsableByteArray packet) {
        if (!FlacReader.isAudioPacket(packet.getData())) {
            return -1L;
        }
        return this.getFlacFrameBlockSize(packet);
    }

    @Override
    protected boolean readHeaders(ParsableByteArray packet, long position, StreamReader.SetupData setupData) {
        byte[] data = packet.getData();
        FlacStreamMetadata streamMetadata = this.streamMetadata;
        if (streamMetadata == null) {
            this.streamMetadata = streamMetadata = new FlacStreamMetadata(data, 17);
            byte[] metadata = Arrays.copyOfRange(data, 9, packet.limit());
            setupData.format = streamMetadata.getFormat(metadata, null);
        } else if ((data[0] & 0x7F) == 3) {
            FlacStreamMetadata.SeekTable seekTable = FlacMetadataReader.readSeekTableMetadataBlock(packet);
            this.streamMetadata = streamMetadata = streamMetadata.copyWithSeekTable(seekTable);
            this.flacOggSeeker = new FlacOggSeeker(streamMetadata, seekTable);
        } else if (FlacReader.isAudioPacket(data)) {
            if (this.flacOggSeeker != null) {
                this.flacOggSeeker.setFirstFrameOffset(position);
                setupData.oggSeeker = this.flacOggSeeker;
            }
            return false;
        }
        return true;
    }

    private int getFlacFrameBlockSize(ParsableByteArray packet) {
        int blockSizeKey = (packet.getData()[2] & 0xFF) >> 4;
        if (blockSizeKey == 6 || blockSizeKey == 7) {
            packet.skipBytes(4);
            packet.readUtf8EncodedLong();
        }
        int result = FlacFrameReader.readFrameBlockSizeSamplesFromKey(packet, blockSizeKey);
        packet.setPosition(0);
        return result;
    }

    private static final class FlacOggSeeker
    implements OggSeeker {
        private FlacStreamMetadata streamMetadata;
        private FlacStreamMetadata.SeekTable seekTable;
        private long firstFrameOffset;
        private long pendingSeekGranule;

        public FlacOggSeeker(FlacStreamMetadata streamMetadata, FlacStreamMetadata.SeekTable seekTable) {
            this.streamMetadata = streamMetadata;
            this.seekTable = seekTable;
            this.firstFrameOffset = -1L;
            this.pendingSeekGranule = -1L;
        }

        public void setFirstFrameOffset(long firstFrameOffset) {
            this.firstFrameOffset = firstFrameOffset;
        }

        @Override
        public long read(ExtractorInput input) {
            if (this.pendingSeekGranule >= 0L) {
                long result = -(this.pendingSeekGranule + 2L);
                this.pendingSeekGranule = -1L;
                return result;
            }
            return -1L;
        }

        @Override
        public void startSeek(long targetGranule) {
            long[] seekPointGranules = this.seekTable.pointSampleNumbers;
            int index = Util.binarySearchFloor(seekPointGranules, targetGranule, true, true);
            this.pendingSeekGranule = seekPointGranules[index];
        }

        @Override
        public SeekMap createSeekMap() {
            Assertions.checkState(this.firstFrameOffset != -1L);
            return new FlacSeekTableSeekMap(this.streamMetadata, this.firstFrameOffset);
        }
    }
}

