/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.analytics;

import android.view.Surface;
import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.ExoPlaybackException;
import com.akamai.amp.exoplayer2.Format;
import com.akamai.amp.exoplayer2.MediaItem;
import com.akamai.amp.exoplayer2.PlaybackParameters;
import com.akamai.amp.exoplayer2.Timeline;
import com.akamai.amp.exoplayer2.audio.AudioAttributes;
import com.akamai.amp.exoplayer2.decoder.DecoderCounters;
import com.akamai.amp.exoplayer2.metadata.Metadata;
import com.akamai.amp.exoplayer2.source.LoadEventInfo;
import com.akamai.amp.exoplayer2.source.MediaLoadData;
import com.akamai.amp.exoplayer2.source.MediaSource;
import com.akamai.amp.exoplayer2.source.TrackGroupArray;
import com.akamai.amp.exoplayer2.trackselection.TrackSelectionArray;
import com.google.common.base.Objects;
import java.io.IOException;

public interface AnalyticsListener {
    @Deprecated
    default public void onPlayerStateChanged(EventTime eventTime, boolean playWhenReady, int playbackState) {
    }

    default public void onPlaybackStateChanged(EventTime eventTime, int state) {
    }

    default public void onPlayWhenReadyChanged(EventTime eventTime, boolean playWhenReady, int reason) {
    }

    default public void onPlaybackSuppressionReasonChanged(EventTime eventTime, int playbackSuppressionReason) {
    }

    default public void onIsPlayingChanged(EventTime eventTime, boolean isPlaying) {
    }

    default public void onTimelineChanged(EventTime eventTime, int reason) {
    }

    default public void onMediaItemTransition(EventTime eventTime, @Nullable MediaItem mediaItem, int reason) {
    }

    default public void onPositionDiscontinuity(EventTime eventTime, int reason) {
    }

    default public void onSeekStarted(EventTime eventTime) {
    }

    @Deprecated
    default public void onSeekProcessed(EventTime eventTime) {
    }

    default public void onPlaybackParametersChanged(EventTime eventTime, PlaybackParameters playbackParameters) {
    }

    default public void onRepeatModeChanged(EventTime eventTime, int repeatMode) {
    }

    default public void onShuffleModeChanged(EventTime eventTime, boolean shuffleModeEnabled) {
    }

    default public void onIsLoadingChanged(EventTime eventTime, boolean isLoading) {
        this.onLoadingChanged(eventTime, isLoading);
    }

    @Deprecated
    default public void onLoadingChanged(EventTime eventTime, boolean isLoading) {
    }

    default public void onPlayerError(EventTime eventTime, ExoPlaybackException error) {
    }

    default public void onTracksChanged(EventTime eventTime, TrackGroupArray trackGroups, TrackSelectionArray trackSelections) {
    }

    default public void onLoadStarted(EventTime eventTime, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData) {
    }

    default public void onLoadCompleted(EventTime eventTime, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData) {
    }

    default public void onLoadCanceled(EventTime eventTime, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData) {
    }

    default public void onLoadError(EventTime eventTime, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData, IOException error, boolean wasCanceled) {
    }

    default public void onDownstreamFormatChanged(EventTime eventTime, MediaLoadData mediaLoadData) {
    }

    default public void onUpstreamDiscarded(EventTime eventTime, MediaLoadData mediaLoadData) {
    }

    default public void onBandwidthEstimate(EventTime eventTime, int totalLoadTimeMs, long totalBytesLoaded, long bitrateEstimate) {
    }

    default public void onMetadata(EventTime eventTime, Metadata metadata) {
    }

    @Deprecated
    default public void onDecoderEnabled(EventTime eventTime, int trackType, DecoderCounters decoderCounters) {
    }

    @Deprecated
    default public void onDecoderInitialized(EventTime eventTime, int trackType, String decoderName, long initializationDurationMs) {
    }

    @Deprecated
    default public void onDecoderInputFormatChanged(EventTime eventTime, int trackType, Format format) {
    }

    @Deprecated
    default public void onDecoderDisabled(EventTime eventTime, int trackType, DecoderCounters decoderCounters) {
    }

    default public void onAudioEnabled(EventTime eventTime, DecoderCounters counters) {
    }

    default public void onAudioDecoderInitialized(EventTime eventTime, String decoderName, long initializationDurationMs) {
    }

    default public void onAudioInputFormatChanged(EventTime eventTime, Format format) {
    }

    default public void onAudioPositionAdvancing(EventTime eventTime, long playoutStartSystemTimeMs) {
    }

    default public void onAudioUnderrun(EventTime eventTime, int bufferSize, long bufferSizeMs, long elapsedSinceLastFeedMs) {
    }

    default public void onAudioDisabled(EventTime eventTime, DecoderCounters counters) {
    }

    default public void onAudioSessionId(EventTime eventTime, int audioSessionId) {
    }

    default public void onAudioAttributesChanged(EventTime eventTime, AudioAttributes audioAttributes) {
    }

    default public void onSkipSilenceEnabledChanged(EventTime eventTime, boolean skipSilenceEnabled) {
    }

    default public void onVolumeChanged(EventTime eventTime, float volume) {
    }

    default public void onVideoEnabled(EventTime eventTime, DecoderCounters counters) {
    }

    default public void onVideoDecoderInitialized(EventTime eventTime, String decoderName, long initializationDurationMs) {
    }

    default public void onVideoInputFormatChanged(EventTime eventTime, Format format) {
    }

    default public void onDroppedVideoFrames(EventTime eventTime, int droppedFrames, long elapsedMs) {
    }

    default public void onVideoDisabled(EventTime eventTime, DecoderCounters counters) {
    }

    default public void onVideoFrameProcessingOffset(EventTime eventTime, long totalProcessingOffsetUs, int frameCount) {
    }

    default public void onRenderedFirstFrame(EventTime eventTime, @Nullable Surface surface) {
    }

    default public void onVideoSizeChanged(EventTime eventTime, int width, int height, int unappliedRotationDegrees, float pixelWidthHeightRatio) {
    }

    default public void onSurfaceSizeChanged(EventTime eventTime, int width, int height) {
    }

    default public void onDrmSessionAcquired(EventTime eventTime) {
    }

    default public void onDrmKeysLoaded(EventTime eventTime) {
    }

    default public void onDrmSessionManagerError(EventTime eventTime, Exception error) {
    }

    default public void onDrmKeysRestored(EventTime eventTime) {
    }

    default public void onDrmKeysRemoved(EventTime eventTime) {
    }

    default public void onDrmSessionReleased(EventTime eventTime) {
    }

    public static final class EventTime {
        public final long realtimeMs;
        public final Timeline timeline;
        public final int windowIndex;
        @Nullable
        public final MediaSource.MediaPeriodId mediaPeriodId;
        public final long eventPlaybackPositionMs;
        public final Timeline currentTimeline;
        public final int currentWindowIndex;
        @Nullable
        public final MediaSource.MediaPeriodId currentMediaPeriodId;
        public final long currentPlaybackPositionMs;
        public final long totalBufferedDurationMs;

        public EventTime(long realtimeMs, Timeline timeline, int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, long eventPlaybackPositionMs, Timeline currentTimeline, int currentWindowIndex, @Nullable MediaSource.MediaPeriodId currentMediaPeriodId, long currentPlaybackPositionMs, long totalBufferedDurationMs) {
            this.realtimeMs = realtimeMs;
            this.timeline = timeline;
            this.windowIndex = windowIndex;
            this.mediaPeriodId = mediaPeriodId;
            this.eventPlaybackPositionMs = eventPlaybackPositionMs;
            this.currentTimeline = currentTimeline;
            this.currentWindowIndex = currentWindowIndex;
            this.currentMediaPeriodId = currentMediaPeriodId;
            this.currentPlaybackPositionMs = currentPlaybackPositionMs;
            this.totalBufferedDurationMs = totalBufferedDurationMs;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EventTime eventTime = (EventTime)o;
            return this.realtimeMs == eventTime.realtimeMs && this.windowIndex == eventTime.windowIndex && this.eventPlaybackPositionMs == eventTime.eventPlaybackPositionMs && this.currentWindowIndex == eventTime.currentWindowIndex && this.currentPlaybackPositionMs == eventTime.currentPlaybackPositionMs && this.totalBufferedDurationMs == eventTime.totalBufferedDurationMs && Objects.equal((Object)this.timeline, (Object)eventTime.timeline) && Objects.equal((Object)this.mediaPeriodId, (Object)eventTime.mediaPeriodId) && Objects.equal((Object)this.currentTimeline, (Object)eventTime.currentTimeline) && Objects.equal((Object)this.currentMediaPeriodId, (Object)eventTime.currentMediaPeriodId);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.realtimeMs, this.timeline, this.windowIndex, this.mediaPeriodId, this.eventPlaybackPositionMs, this.currentTimeline, this.currentWindowIndex, this.currentMediaPeriodId, this.currentPlaybackPositionMs, this.totalBufferedDurationMs});
        }
    }
}

