/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2;

import android.annotation.SuppressLint;
import com.akamai.amp.exoplayer2.ExoPlaybackException;
import com.akamai.amp.exoplayer2.Format;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public interface RendererCapabilities {
    public static final int FORMAT_SUPPORT_MASK = 7;
    public static final int FORMAT_HANDLED = 4;
    public static final int FORMAT_EXCEEDS_CAPABILITIES = 3;
    public static final int FORMAT_UNSUPPORTED_DRM = 2;
    public static final int FORMAT_UNSUPPORTED_SUBTYPE = 1;
    public static final int FORMAT_UNSUPPORTED_TYPE = 0;
    public static final int ADAPTIVE_SUPPORT_MASK = 24;
    public static final int ADAPTIVE_SEAMLESS = 16;
    public static final int ADAPTIVE_NOT_SEAMLESS = 8;
    public static final int ADAPTIVE_NOT_SUPPORTED = 0;
    public static final int TUNNELING_SUPPORT_MASK = 32;
    public static final int TUNNELING_SUPPORTED = 32;
    public static final int TUNNELING_NOT_SUPPORTED = 0;

    public static int create(int formatSupport) {
        return RendererCapabilities.create(formatSupport, 0, 0);
    }

    @SuppressLint(value={"WrongConstant"})
    public static int create(int formatSupport, int adaptiveSupport, int tunnelingSupport) {
        return formatSupport | adaptiveSupport | tunnelingSupport;
    }

    @SuppressLint(value={"WrongConstant"})
    public static int getFormatSupport(int supportFlags) {
        return supportFlags & 7;
    }

    @SuppressLint(value={"WrongConstant"})
    public static int getAdaptiveSupport(int supportFlags) {
        return supportFlags & 0x18;
    }

    @SuppressLint(value={"WrongConstant"})
    public static int getTunnelingSupport(int supportFlags) {
        return supportFlags & 0x20;
    }

    public static String getFormatSupportString(int formatSupport) {
        switch (formatSupport) {
            case 4: {
                return "YES";
            }
            case 3: {
                return "NO_EXCEEDS_CAPABILITIES";
            }
            case 2: {
                return "NO_UNSUPPORTED_DRM";
            }
            case 1: {
                return "NO_UNSUPPORTED_TYPE";
            }
            case 0: {
                return "NO";
            }
        }
        throw new IllegalStateException();
    }

    public String getName();

    public int getTrackType();

    public int supportsFormat(Format var1) throws ExoPlaybackException;

    public int supportsMixedMimeTypeAdaptation() throws ExoPlaybackException;

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Capabilities {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TunnelingSupport {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AdaptiveSupport {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FormatSupport {
    }
}

