/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.util.Pair;
import androidx.annotation.CheckResult;
import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.C;
import com.akamai.amp.exoplayer2.DefaultMediaClock;
import com.akamai.amp.exoplayer2.ExoPlaybackException;
import com.akamai.amp.exoplayer2.Format;
import com.akamai.amp.exoplayer2.LoadControl;
import com.akamai.amp.exoplayer2.MediaPeriodHolder;
import com.akamai.amp.exoplayer2.MediaPeriodInfo;
import com.akamai.amp.exoplayer2.MediaPeriodQueue;
import com.akamai.amp.exoplayer2.MediaSourceList;
import com.akamai.amp.exoplayer2.PlaybackInfo;
import com.akamai.amp.exoplayer2.PlaybackParameters;
import com.akamai.amp.exoplayer2.PlayerMessage;
import com.akamai.amp.exoplayer2.PlaylistTimeline;
import com.akamai.amp.exoplayer2.Renderer;
import com.akamai.amp.exoplayer2.RendererCapabilities;
import com.akamai.amp.exoplayer2.RendererConfiguration;
import com.akamai.amp.exoplayer2.SeekParameters;
import com.akamai.amp.exoplayer2.Timeline;
import com.akamai.amp.exoplayer2.analytics.AnalyticsCollector;
import com.akamai.amp.exoplayer2.source.MediaPeriod;
import com.akamai.amp.exoplayer2.source.MediaSource;
import com.akamai.amp.exoplayer2.source.SampleStream;
import com.akamai.amp.exoplayer2.source.ShuffleOrder;
import com.akamai.amp.exoplayer2.source.TrackGroupArray;
import com.akamai.amp.exoplayer2.trackselection.TrackSelection;
import com.akamai.amp.exoplayer2.trackselection.TrackSelector;
import com.akamai.amp.exoplayer2.trackselection.TrackSelectorResult;
import com.akamai.amp.exoplayer2.upstream.BandwidthMeter;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.Clock;
import com.akamai.amp.exoplayer2.util.HandlerWrapper;
import com.akamai.amp.exoplayer2.util.Log;
import com.akamai.amp.exoplayer2.util.TraceUtil;
import com.akamai.amp.exoplayer2.util.Util;
import com.google.common.base.Supplier;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ExoPlayerImplInternal
implements Handler.Callback,
MediaPeriod.Callback,
TrackSelector.InvalidationListener,
MediaSourceList.MediaSourceListInfoRefreshListener,
DefaultMediaClock.PlaybackParametersListener,
PlayerMessage.Sender {
    private static final String TAG = "ExoPlayerImplInternal";
    private static final int MSG_PREPARE = 0;
    private static final int MSG_SET_PLAY_WHEN_READY = 1;
    private static final int MSG_DO_SOME_WORK = 2;
    private static final int MSG_SEEK_TO = 3;
    private static final int MSG_SET_PLAYBACK_PARAMETERS = 4;
    private static final int MSG_SET_SEEK_PARAMETERS = 5;
    private static final int MSG_STOP = 6;
    private static final int MSG_RELEASE = 7;
    private static final int MSG_PERIOD_PREPARED = 8;
    private static final int MSG_SOURCE_CONTINUE_LOADING_REQUESTED = 9;
    private static final int MSG_TRACK_SELECTION_INVALIDATED = 10;
    private static final int MSG_SET_REPEAT_MODE = 11;
    private static final int MSG_SET_SHUFFLE_ENABLED = 12;
    private static final int MSG_SET_FOREGROUND_MODE = 13;
    private static final int MSG_SEND_MESSAGE = 14;
    private static final int MSG_SEND_MESSAGE_TO_TARGET_THREAD = 15;
    private static final int MSG_PLAYBACK_PARAMETERS_CHANGED_INTERNAL = 16;
    private static final int MSG_SET_MEDIA_SOURCES = 17;
    private static final int MSG_ADD_MEDIA_SOURCES = 18;
    private static final int MSG_MOVE_MEDIA_SOURCES = 19;
    private static final int MSG_REMOVE_MEDIA_SOURCES = 20;
    private static final int MSG_SET_SHUFFLE_ORDER = 21;
    private static final int MSG_PLAYLIST_UPDATE_REQUESTED = 22;
    private static final int MSG_SET_PAUSE_AT_END_OF_WINDOW = 23;
    private static final int MSG_SET_OFFLOAD_SCHEDULING_ENABLED = 24;
    private static final int ACTIVE_INTERVAL_MS = 10;
    private static final int IDLE_INTERVAL_MS = 1000;
    private static final long MIN_RENDERER_SLEEP_DURATION_MS = 2000L;
    private final Renderer[] renderers;
    private final RendererCapabilities[] rendererCapabilities;
    private final TrackSelector trackSelector;
    private final TrackSelectorResult emptyTrackSelectorResult;
    private final LoadControl loadControl;
    private final BandwidthMeter bandwidthMeter;
    private final HandlerWrapper handler;
    private final HandlerThread internalPlaybackThread;
    private final Looper playbackLooper;
    private final Timeline.Window window;
    private final Timeline.Period period;
    private final long backBufferDurationUs;
    private final boolean retainBackBufferFromKeyframe;
    private final DefaultMediaClock mediaClock;
    private final ArrayList<PendingMessageInfo> pendingMessages;
    private final Clock clock;
    private final PlaybackInfoUpdateListener playbackInfoUpdateListener;
    private final MediaPeriodQueue queue;
    private final MediaSourceList mediaSourceList;
    private SeekParameters seekParameters;
    private PlaybackInfo playbackInfo;
    private PlaybackInfoUpdate playbackInfoUpdate;
    private boolean released;
    private boolean pauseAtEndOfWindow;
    private boolean pendingPauseAtEndOfPeriod;
    public static boolean rebuffering = false;
    private boolean shouldContinueLoading;
    private int repeatMode;
    private boolean shuffleModeEnabled;
    private boolean foregroundMode;
    private boolean requestForRendererSleep;
    private boolean offloadSchedulingEnabled;
    private int enabledRendererCount;
    @Nullable
    private SeekPosition pendingInitialSeekPosition;
    private long rendererPositionUs;
    private int nextPendingMessageIndexHint;
    private boolean deliverPendingMessageAtStartPositionRequired;
    private long releaseTimeoutMs;
    private boolean throwWhenStuckBuffering;

    public ExoPlayerImplInternal(Renderer[] renderers, TrackSelector trackSelector, TrackSelectorResult emptyTrackSelectorResult, LoadControl loadControl, BandwidthMeter bandwidthMeter, int repeatMode, boolean shuffleModeEnabled, @Nullable AnalyticsCollector analyticsCollector, SeekParameters seekParameters, boolean pauseAtEndOfWindow, Looper applicationLooper, Clock clock, PlaybackInfoUpdateListener playbackInfoUpdateListener) {
        this.playbackInfoUpdateListener = playbackInfoUpdateListener;
        this.renderers = renderers;
        this.trackSelector = trackSelector;
        this.emptyTrackSelectorResult = emptyTrackSelectorResult;
        this.loadControl = loadControl;
        this.bandwidthMeter = bandwidthMeter;
        this.repeatMode = repeatMode;
        this.shuffleModeEnabled = shuffleModeEnabled;
        this.seekParameters = seekParameters;
        this.pauseAtEndOfWindow = pauseAtEndOfWindow;
        this.clock = clock;
        this.throwWhenStuckBuffering = true;
        this.backBufferDurationUs = loadControl.getBackBufferDurationUs();
        this.retainBackBufferFromKeyframe = loadControl.retainBackBufferFromKeyframe();
        this.playbackInfo = PlaybackInfo.createDummy(emptyTrackSelectorResult);
        this.playbackInfoUpdate = new PlaybackInfoUpdate(this.playbackInfo);
        this.rendererCapabilities = new RendererCapabilities[renderers.length];
        for (int i = 0; i < renderers.length; ++i) {
            renderers[i].setIndex(i);
            this.rendererCapabilities[i] = renderers[i].getCapabilities();
        }
        this.mediaClock = new DefaultMediaClock(this, clock);
        this.pendingMessages = new ArrayList();
        this.window = new Timeline.Window();
        this.period = new Timeline.Period();
        trackSelector.init(this, bandwidthMeter);
        this.deliverPendingMessageAtStartPositionRequired = true;
        Handler eventHandler = new Handler(applicationLooper);
        this.queue = new MediaPeriodQueue(analyticsCollector, eventHandler);
        this.mediaSourceList = new MediaSourceList(this, analyticsCollector, eventHandler);
        this.internalPlaybackThread = new HandlerThread("ExoPlayer:Playback", -16);
        this.internalPlaybackThread.start();
        this.playbackLooper = this.internalPlaybackThread.getLooper();
        this.handler = clock.createHandler(this.playbackLooper, this);
    }

    public void experimentalSetReleaseTimeoutMs(long releaseTimeoutMs) {
        this.releaseTimeoutMs = releaseTimeoutMs;
    }

    public void experimentalDisableThrowWhenStuckBuffering() {
        this.throwWhenStuckBuffering = false;
    }

    public void experimentalSetOffloadSchedulingEnabled(boolean offloadSchedulingEnabled) {
        this.handler.obtainMessage(24, offloadSchedulingEnabled ? 1 : 0, 0).sendToTarget();
    }

    public void prepare() {
        this.handler.obtainMessage(0).sendToTarget();
    }

    public void setPlayWhenReady(boolean playWhenReady, int playbackSuppressionReason) {
        this.handler.obtainMessage(1, playWhenReady ? 1 : 0, playbackSuppressionReason).sendToTarget();
    }

    public void setPauseAtEndOfWindow(boolean pauseAtEndOfWindow) {
        this.handler.obtainMessage(23, pauseAtEndOfWindow ? 1 : 0, 0).sendToTarget();
    }

    public void setRepeatMode(int repeatMode) {
        this.handler.obtainMessage(11, repeatMode, 0).sendToTarget();
    }

    public void setShuffleModeEnabled(boolean shuffleModeEnabled) {
        this.handler.obtainMessage(12, shuffleModeEnabled ? 1 : 0, 0).sendToTarget();
    }

    public void seekTo(Timeline timeline, int windowIndex, long positionUs) {
        this.handler.obtainMessage(3, new SeekPosition(timeline, windowIndex, positionUs)).sendToTarget();
    }

    public void setPlaybackParameters(PlaybackParameters playbackParameters) {
        this.handler.obtainMessage(4, playbackParameters).sendToTarget();
    }

    public void setSeekParameters(SeekParameters seekParameters) {
        this.handler.obtainMessage(5, seekParameters).sendToTarget();
    }

    public void stop() {
        this.handler.obtainMessage(6).sendToTarget();
    }

    public void setMediaSources(List<MediaSourceList.MediaSourceHolder> mediaSources, int windowIndex, long positionUs, ShuffleOrder shuffleOrder) {
        this.handler.obtainMessage(17, new MediaSourceListUpdateMessage(mediaSources, shuffleOrder, windowIndex, positionUs)).sendToTarget();
    }

    public void addMediaSources(int index, List<MediaSourceList.MediaSourceHolder> mediaSources, ShuffleOrder shuffleOrder) {
        this.handler.obtainMessage(18, index, 0, new MediaSourceListUpdateMessage(mediaSources, shuffleOrder, -1, -9223372036854775807L)).sendToTarget();
    }

    public void removeMediaSources(int fromIndex, int toIndex, ShuffleOrder shuffleOrder) {
        this.handler.obtainMessage(20, fromIndex, toIndex, shuffleOrder).sendToTarget();
    }

    public void moveMediaSources(int fromIndex, int toIndex, int newFromIndex, ShuffleOrder shuffleOrder) {
        MoveMediaItemsMessage moveMediaItemsMessage = new MoveMediaItemsMessage(fromIndex, toIndex, newFromIndex, shuffleOrder);
        this.handler.obtainMessage(19, moveMediaItemsMessage).sendToTarget();
    }

    public void setShuffleOrder(ShuffleOrder shuffleOrder) {
        this.handler.obtainMessage(21, shuffleOrder).sendToTarget();
    }

    @Override
    public synchronized void sendMessage(PlayerMessage message) {
        if (this.released || !this.internalPlaybackThread.isAlive()) {
            Log.w(TAG, "Ignoring messages sent after release.");
            message.markAsProcessed(false);
            return;
        }
        this.handler.obtainMessage(14, message).sendToTarget();
    }

    public synchronized boolean setForegroundMode(boolean foregroundMode) {
        if (this.released || !this.internalPlaybackThread.isAlive()) {
            return true;
        }
        if (foregroundMode) {
            this.handler.obtainMessage(13, 1, 0).sendToTarget();
            return true;
        }
        AtomicBoolean processedFlag = new AtomicBoolean();
        this.handler.obtainMessage(13, 0, 0, processedFlag).sendToTarget();
        if (this.releaseTimeoutMs > 0L) {
            this.waitUninterruptibly((Supplier<Boolean>)((Supplier)processedFlag::get), this.releaseTimeoutMs);
        } else {
            this.waitUninterruptibly((Supplier<Boolean>)((Supplier)processedFlag::get));
        }
        return processedFlag.get();
    }

    public synchronized boolean release() {
        if (this.released || !this.internalPlaybackThread.isAlive()) {
            return true;
        }
        this.handler.sendEmptyMessage(7);
        if (this.releaseTimeoutMs > 0L) {
            this.waitUninterruptibly((Supplier<Boolean>)((Supplier)() -> this.released), this.releaseTimeoutMs);
        } else {
            this.waitUninterruptibly((Supplier<Boolean>)((Supplier)() -> this.released));
        }
        return this.released;
    }

    public Looper getPlaybackLooper() {
        return this.playbackLooper;
    }

    @Override
    public void onPlaylistUpdateRequested() {
        this.handler.sendEmptyMessage(22);
    }

    @Override
    public void onPrepared(MediaPeriod source) {
        this.handler.obtainMessage(8, source).sendToTarget();
    }

    @Override
    public void onContinueLoadingRequested(MediaPeriod source) {
        this.handler.obtainMessage(9, source).sendToTarget();
    }

    @Override
    public void onTrackSelectionsInvalidated() {
        this.handler.sendEmptyMessage(10);
    }

    @Override
    public void onPlaybackParametersChanged(PlaybackParameters newPlaybackParameters) {
        this.sendPlaybackParametersChangedInternal(newPlaybackParameters, false);
    }

    public boolean handleMessage(Message msg) {
        try {
            switch (msg.what) {
                case 0: {
                    this.prepareInternal();
                    break;
                }
                case 1: {
                    this.setPlayWhenReadyInternal(msg.arg1 != 0, msg.arg2, true, 1);
                    break;
                }
                case 11: {
                    this.setRepeatModeInternal(msg.arg1);
                    break;
                }
                case 12: {
                    this.setShuffleModeEnabledInternal(msg.arg1 != 0);
                    break;
                }
                case 2: {
                    this.doSomeWork();
                    break;
                }
                case 3: {
                    this.seekToInternal((SeekPosition)msg.obj);
                    break;
                }
                case 4: {
                    this.setPlaybackParametersInternal((PlaybackParameters)msg.obj);
                    break;
                }
                case 5: {
                    this.setSeekParametersInternal((SeekParameters)msg.obj);
                    break;
                }
                case 13: {
                    this.setForegroundModeInternal(msg.arg1 != 0, (AtomicBoolean)msg.obj);
                    break;
                }
                case 6: {
                    this.stopInternal(false, true);
                    break;
                }
                case 8: {
                    this.handlePeriodPrepared((MediaPeriod)msg.obj);
                    break;
                }
                case 9: {
                    this.handleContinueLoadingRequested((MediaPeriod)msg.obj);
                    break;
                }
                case 10: {
                    this.reselectTracksInternal();
                    break;
                }
                case 16: {
                    this.handlePlaybackParameters((PlaybackParameters)msg.obj, msg.arg1 != 0);
                    break;
                }
                case 14: {
                    this.sendMessageInternal((PlayerMessage)msg.obj);
                    break;
                }
                case 15: {
                    this.sendMessageToTargetThread((PlayerMessage)msg.obj);
                    break;
                }
                case 17: {
                    this.setMediaItemsInternal((MediaSourceListUpdateMessage)msg.obj);
                    break;
                }
                case 18: {
                    this.addMediaItemsInternal((MediaSourceListUpdateMessage)msg.obj, msg.arg1);
                    break;
                }
                case 19: {
                    this.moveMediaItemsInternal((MoveMediaItemsMessage)msg.obj);
                    break;
                }
                case 20: {
                    this.removeMediaItemsInternal(msg.arg1, msg.arg2, (ShuffleOrder)msg.obj);
                    break;
                }
                case 21: {
                    this.setShuffleOrderInternal((ShuffleOrder)msg.obj);
                    break;
                }
                case 22: {
                    this.mediaSourceListUpdateRequestedInternal();
                    break;
                }
                case 23: {
                    this.setPauseAtEndOfWindowInternal(msg.arg1 != 0);
                    break;
                }
                case 24: {
                    this.setOffloadSchedulingEnabledInternal(msg.arg1 == 1);
                    break;
                }
                case 7: {
                    this.releaseInternal();
                    return true;
                }
                default: {
                    return false;
                }
            }
            this.maybeNotifyPlaybackInfoChanged();
        }
        catch (ExoPlaybackException e) {
            MediaPeriodHolder readingPeriod;
            if (e.type == 1 && (readingPeriod = this.queue.getReadingPeriod()) != null) {
                e = e.copyWithMediaPeriodId(readingPeriod.info.id);
            }
            Log.e(TAG, "Playback error", e);
            this.stopInternal(true, false);
            this.playbackInfo = this.playbackInfo.copyWithPlaybackError(e);
            this.maybeNotifyPlaybackInfoChanged();
        }
        catch (IOException e) {
            ExoPlaybackException error = ExoPlaybackException.createForSource(e);
            MediaPeriodHolder playingPeriod = this.queue.getPlayingPeriod();
            if (playingPeriod != null) {
                error = error.copyWithMediaPeriodId(playingPeriod.info.id);
            }
            Log.e(TAG, "Playback error", error);
            this.stopInternal(false, false);
            this.playbackInfo = this.playbackInfo.copyWithPlaybackError(error);
            this.maybeNotifyPlaybackInfoChanged();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            ExoPlaybackException error = e instanceof OutOfMemoryError ? ExoPlaybackException.createForOutOfMemory((OutOfMemoryError)e) : ExoPlaybackException.createForUnexpected((RuntimeException)e);
            Log.e(TAG, "Playback error", error);
            this.stopInternal(true, false);
            this.playbackInfo = this.playbackInfo.copyWithPlaybackError(error);
            this.maybeNotifyPlaybackInfoChanged();
        }
        return true;
    }

    private synchronized void waitUninterruptibly(Supplier<Boolean> condition) {
        boolean wasInterrupted = false;
        while (!((Boolean)condition.get()).booleanValue()) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
            }
        }
        if (wasInterrupted) {
            Thread.currentThread().interrupt();
        }
    }

    private synchronized void waitUninterruptibly(Supplier<Boolean> condition, long timeoutMs) {
        long deadlineMs = this.clock.elapsedRealtime() + timeoutMs;
        long remainingMs = timeoutMs;
        boolean wasInterrupted = false;
        while (!((Boolean)condition.get()).booleanValue() && remainingMs > 0L) {
            try {
                this.wait(remainingMs);
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
            }
            remainingMs = deadlineMs - this.clock.elapsedRealtime();
        }
        if (wasInterrupted) {
            Thread.currentThread().interrupt();
        }
    }

    private void setState(int state) {
        if (this.playbackInfo.playbackState != state) {
            this.playbackInfo = this.playbackInfo.copyWithPlaybackState(state);
        }
    }

    private void maybeNotifyPlaybackInfoChanged() {
        this.playbackInfoUpdate.setPlaybackInfo(this.playbackInfo);
        if (this.playbackInfoUpdate.hasPendingChange) {
            this.playbackInfoUpdateListener.onPlaybackInfoUpdate(this.playbackInfoUpdate);
            this.playbackInfoUpdate = new PlaybackInfoUpdate(this.playbackInfo);
        }
    }

    private void prepareInternal() {
        this.playbackInfoUpdate.incrementPendingOperationAcks(1);
        this.resetInternal(false, false, false, true);
        this.loadControl.onPrepared();
        this.setState(this.playbackInfo.timeline.isEmpty() ? 4 : 2);
        this.mediaSourceList.prepare(this.bandwidthMeter.getTransferListener());
        this.handler.sendEmptyMessage(2);
    }

    private void setMediaItemsInternal(MediaSourceListUpdateMessage mediaSourceListUpdateMessage) throws ExoPlaybackException {
        this.playbackInfoUpdate.incrementPendingOperationAcks(1);
        if (mediaSourceListUpdateMessage.windowIndex != -1) {
            this.pendingInitialSeekPosition = new SeekPosition(new PlaylistTimeline(mediaSourceListUpdateMessage.mediaSourceHolders, mediaSourceListUpdateMessage.shuffleOrder), mediaSourceListUpdateMessage.windowIndex, mediaSourceListUpdateMessage.positionUs);
        }
        Timeline timeline = this.mediaSourceList.setMediaSources(mediaSourceListUpdateMessage.mediaSourceHolders, mediaSourceListUpdateMessage.shuffleOrder);
        this.handleMediaSourceListInfoRefreshed(timeline);
    }

    private void addMediaItemsInternal(MediaSourceListUpdateMessage addMessage, int insertionIndex) throws ExoPlaybackException {
        this.playbackInfoUpdate.incrementPendingOperationAcks(1);
        Timeline timeline = this.mediaSourceList.addMediaSources(insertionIndex == -1 ? this.mediaSourceList.getSize() : insertionIndex, addMessage.mediaSourceHolders, addMessage.shuffleOrder);
        this.handleMediaSourceListInfoRefreshed(timeline);
    }

    private void moveMediaItemsInternal(MoveMediaItemsMessage moveMediaItemsMessage) throws ExoPlaybackException {
        this.playbackInfoUpdate.incrementPendingOperationAcks(1);
        Timeline timeline = this.mediaSourceList.moveMediaSourceRange(moveMediaItemsMessage.fromIndex, moveMediaItemsMessage.toIndex, moveMediaItemsMessage.newFromIndex, moveMediaItemsMessage.shuffleOrder);
        this.handleMediaSourceListInfoRefreshed(timeline);
    }

    private void removeMediaItemsInternal(int fromIndex, int toIndex, ShuffleOrder shuffleOrder) throws ExoPlaybackException {
        this.playbackInfoUpdate.incrementPendingOperationAcks(1);
        Timeline timeline = this.mediaSourceList.removeMediaSourceRange(fromIndex, toIndex, shuffleOrder);
        this.handleMediaSourceListInfoRefreshed(timeline);
    }

    private void mediaSourceListUpdateRequestedInternal() throws ExoPlaybackException {
        this.handleMediaSourceListInfoRefreshed(this.mediaSourceList.createTimeline());
    }

    private void setShuffleOrderInternal(ShuffleOrder shuffleOrder) throws ExoPlaybackException {
        this.playbackInfoUpdate.incrementPendingOperationAcks(1);
        Timeline timeline = this.mediaSourceList.setShuffleOrder(shuffleOrder);
        this.handleMediaSourceListInfoRefreshed(timeline);
    }

    private void setPlayWhenReadyInternal(boolean playWhenReady, int playbackSuppressionReason, boolean operationAck, int reason) throws ExoPlaybackException {
        this.playbackInfoUpdate.incrementPendingOperationAcks(operationAck ? 1 : 0);
        this.playbackInfoUpdate.setPlayWhenReadyChangeReason(reason);
        this.playbackInfo = this.playbackInfo.copyWithPlayWhenReady(playWhenReady, playbackSuppressionReason);
        rebuffering = false;
        if (!this.shouldPlayWhenReady()) {
            this.stopRenderers();
            this.updatePlaybackPositions();
        } else if (this.playbackInfo.playbackState == 3) {
            this.startRenderers();
            this.handler.sendEmptyMessage(2);
        } else if (this.playbackInfo.playbackState == 2) {
            this.handler.sendEmptyMessage(2);
        }
    }

    private void setPauseAtEndOfWindowInternal(boolean pauseAtEndOfWindow) throws ExoPlaybackException {
        this.pauseAtEndOfWindow = pauseAtEndOfWindow;
        this.resetPendingPauseAtEndOfPeriod();
        if (this.pendingPauseAtEndOfPeriod && this.queue.getReadingPeriod() != this.queue.getPlayingPeriod()) {
            this.seekToCurrentPosition(true);
            this.handleLoadingMediaPeriodChanged(false);
        }
    }

    private void setOffloadSchedulingEnabledInternal(boolean offloadSchedulingEnabled) {
        if (offloadSchedulingEnabled == this.offloadSchedulingEnabled) {
            return;
        }
        this.offloadSchedulingEnabled = offloadSchedulingEnabled;
        int state = this.playbackInfo.playbackState;
        if (offloadSchedulingEnabled || state == 4 || state == 1) {
            this.playbackInfo = this.playbackInfo.copyWithOffloadSchedulingEnabled(offloadSchedulingEnabled);
        } else {
            this.handler.sendEmptyMessage(2);
        }
    }

    private void setRepeatModeInternal(int repeatMode) throws ExoPlaybackException {
        this.repeatMode = repeatMode;
        if (!this.queue.updateRepeatMode(this.playbackInfo.timeline, repeatMode)) {
            this.seekToCurrentPosition(true);
        }
        this.handleLoadingMediaPeriodChanged(false);
    }

    private void setShuffleModeEnabledInternal(boolean shuffleModeEnabled) throws ExoPlaybackException {
        this.shuffleModeEnabled = shuffleModeEnabled;
        if (!this.queue.updateShuffleModeEnabled(this.playbackInfo.timeline, shuffleModeEnabled)) {
            this.seekToCurrentPosition(true);
        }
        this.handleLoadingMediaPeriodChanged(false);
    }

    private void seekToCurrentPosition(boolean sendDiscontinuity) throws ExoPlaybackException {
        MediaSource.MediaPeriodId periodId = this.queue.getPlayingPeriod().info.id;
        long newPositionUs = this.seekToPeriodPosition(periodId, this.playbackInfo.positionUs, true, false);
        if (newPositionUs != this.playbackInfo.positionUs) {
            this.playbackInfo = this.handlePositionDiscontinuity(periodId, newPositionUs, this.playbackInfo.requestedContentPositionUs);
            if (sendDiscontinuity) {
                this.playbackInfoUpdate.setPositionDiscontinuity(4);
            }
        }
    }

    private void startRenderers() throws ExoPlaybackException {
        rebuffering = false;
        this.mediaClock.start();
        for (Renderer renderer : this.renderers) {
            if (!ExoPlayerImplInternal.isRendererEnabled(renderer)) continue;
            renderer.start();
        }
    }

    private void stopRenderers() throws ExoPlaybackException {
        this.mediaClock.stop();
        for (Renderer renderer : this.renderers) {
            if (!ExoPlayerImplInternal.isRendererEnabled(renderer)) continue;
            this.ensureStopped(renderer);
        }
    }

    private void updatePlaybackPositions() throws ExoPlaybackException {
        long discontinuityPositionUs;
        MediaPeriodHolder playingPeriodHolder = this.queue.getPlayingPeriod();
        if (playingPeriodHolder == null) {
            return;
        }
        long l = discontinuityPositionUs = playingPeriodHolder.prepared ? playingPeriodHolder.mediaPeriod.readDiscontinuity() : -9223372036854775807L;
        if (discontinuityPositionUs != -9223372036854775807L) {
            this.resetRendererPosition(discontinuityPositionUs);
            if (discontinuityPositionUs != this.playbackInfo.positionUs) {
                this.playbackInfo = this.handlePositionDiscontinuity(this.playbackInfo.periodId, discontinuityPositionUs, this.playbackInfo.requestedContentPositionUs);
                this.playbackInfoUpdate.setPositionDiscontinuity(4);
            }
        } else {
            this.rendererPositionUs = this.mediaClock.syncAndGetPositionUs(playingPeriodHolder != this.queue.getReadingPeriod());
            long periodPositionUs = playingPeriodHolder.toPeriodTime(this.rendererPositionUs);
            this.maybeTriggerPendingMessages(this.playbackInfo.positionUs, periodPositionUs);
            this.playbackInfo.positionUs = periodPositionUs;
        }
        MediaPeriodHolder loadingPeriod = this.queue.getLoadingPeriod();
        this.playbackInfo.bufferedPositionUs = loadingPeriod.getBufferedPositionUs();
        this.playbackInfo.totalBufferedDurationUs = this.getTotalBufferedDurationUs();
    }

    private void doSomeWork() throws ExoPlaybackException, IOException {
        boolean finishedRendering;
        long operationStartTimeMs = this.clock.uptimeMillis();
        this.updatePeriods();
        if (this.playbackInfo.playbackState == 1 || this.playbackInfo.playbackState == 4) {
            this.handler.removeMessages(2);
            return;
        }
        MediaPeriodHolder playingPeriodHolder = this.queue.getPlayingPeriod();
        if (playingPeriodHolder == null) {
            this.scheduleNextWork(operationStartTimeMs, 10L);
            return;
        }
        TraceUtil.beginSection("doSomeWork");
        this.updatePlaybackPositions();
        boolean renderersEnded = true;
        boolean renderersAllowPlayback = true;
        if (playingPeriodHolder.prepared) {
            long rendererPositionElapsedRealtimeUs = SystemClock.elapsedRealtime() * 1000L;
            playingPeriodHolder.mediaPeriod.discardBuffer(this.playbackInfo.positionUs - this.backBufferDurationUs, this.retainBackBufferFromKeyframe);
            for (int i = 0; i < this.renderers.length; ++i) {
                Renderer renderer = this.renderers[i];
                if (!ExoPlayerImplInternal.isRendererEnabled(renderer)) continue;
                renderer.render(this.rendererPositionUs, rendererPositionElapsedRealtimeUs);
                renderersEnded = renderersEnded && renderer.isEnded();
                boolean isReadingAhead = playingPeriodHolder.sampleStreams[i] != renderer.getStream();
                boolean isWaitingForNextStream = !isReadingAhead && renderer.hasReadStreamToEnd();
                boolean allowsPlayback = isReadingAhead || isWaitingForNextStream || renderer.isReady() || renderer.isEnded();
                boolean bl = renderersAllowPlayback = renderersAllowPlayback && allowsPlayback;
                if (allowsPlayback) continue;
                renderer.maybeThrowStreamError();
            }
        } else {
            playingPeriodHolder.mediaPeriod.maybeThrowPrepareError();
        }
        long playingPeriodDurationUs = playingPeriodHolder.info.durationUs;
        boolean bl = finishedRendering = renderersEnded && playingPeriodHolder.prepared && (playingPeriodDurationUs == -9223372036854775807L || playingPeriodDurationUs <= this.playbackInfo.positionUs);
        if (finishedRendering && this.pendingPauseAtEndOfPeriod) {
            this.pendingPauseAtEndOfPeriod = false;
            this.setPlayWhenReadyInternal(false, this.playbackInfo.playbackSuppressionReason, false, 5);
        }
        if (finishedRendering && playingPeriodHolder.info.isFinal) {
            this.setState(4);
            this.stopRenderers();
        } else if (this.playbackInfo.playbackState == 2 && this.shouldTransitionToReadyState(renderersAllowPlayback)) {
            this.setState(3);
            if (this.shouldPlayWhenReady()) {
                this.startRenderers();
            }
        } else if (this.playbackInfo.playbackState == 3 && !(this.enabledRendererCount != 0 ? renderersAllowPlayback : this.isTimelineReady())) {
            rebuffering = this.shouldPlayWhenReady();
            this.setState(2);
            this.stopRenderers();
        }
        if (this.playbackInfo.playbackState == 2) {
            for (int i = 0; i < this.renderers.length; ++i) {
                if (!ExoPlayerImplInternal.isRendererEnabled(this.renderers[i]) || this.renderers[i].getStream() != playingPeriodHolder.sampleStreams[i]) continue;
                this.renderers[i].maybeThrowStreamError();
            }
            if (this.throwWhenStuckBuffering && !this.playbackInfo.isLoading && this.playbackInfo.totalBufferedDurationUs < 500000L && this.isLoadingPossible()) {
                throw new IllegalStateException("Playback stuck buffering and not loading");
            }
        }
        if (this.offloadSchedulingEnabled != this.playbackInfo.offloadSchedulingEnabled) {
            this.playbackInfo = this.playbackInfo.copyWithOffloadSchedulingEnabled(this.offloadSchedulingEnabled);
        }
        if (this.shouldPlayWhenReady() && this.playbackInfo.playbackState == 3 || this.playbackInfo.playbackState == 2) {
            this.maybeScheduleWakeup(operationStartTimeMs, 10L);
        } else if (this.enabledRendererCount != 0 && this.playbackInfo.playbackState != 4) {
            this.scheduleNextWork(operationStartTimeMs, 1000L);
        } else {
            this.handler.removeMessages(2);
        }
        this.requestForRendererSleep = false;
        TraceUtil.endSection();
    }

    private void scheduleNextWork(long thisOperationStartTimeMs, long intervalMs) {
        this.handler.removeMessages(2);
        this.handler.sendEmptyMessageAtTime(2, thisOperationStartTimeMs + intervalMs);
    }

    private void maybeScheduleWakeup(long operationStartTimeMs, long intervalMs) {
        if (this.offloadSchedulingEnabled && this.requestForRendererSleep) {
            return;
        }
        this.scheduleNextWork(operationStartTimeMs, intervalMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void seekToInternal(SeekPosition seekPosition) throws ExoPlaybackException {
        boolean seekPositionAdjusted;
        long requestedContentPosition;
        long periodPositionUs;
        MediaSource.MediaPeriodId periodId;
        this.playbackInfoUpdate.incrementPendingOperationAcks(1);
        Pair<Object, Long> resolvedSeekPosition = ExoPlayerImplInternal.resolveSeekPosition(this.playbackInfo.timeline, seekPosition, true, this.repeatMode, this.shuffleModeEnabled, this.window, this.period);
        if (resolvedSeekPosition == null) {
            Pair<MediaSource.MediaPeriodId, Long> firstPeriodAndPosition = this.getPlaceholderFirstMediaPeriodPosition(this.playbackInfo.timeline);
            periodId = (MediaSource.MediaPeriodId)firstPeriodAndPosition.first;
            periodPositionUs = (Long)firstPeriodAndPosition.second;
            requestedContentPosition = -9223372036854775807L;
            seekPositionAdjusted = !this.playbackInfo.timeline.isEmpty();
        } else {
            Object periodUid = resolvedSeekPosition.first;
            long resolvedContentPosition = (Long)resolvedSeekPosition.second;
            requestedContentPosition = seekPosition.windowPositionUs == -9223372036854775807L ? -9223372036854775807L : resolvedContentPosition;
            periodId = this.queue.resolveMediaPeriodIdForAds(this.playbackInfo.timeline, periodUid, resolvedContentPosition);
            if (periodId.isAd()) {
                this.playbackInfo.timeline.getPeriodByUid(periodId.periodUid, this.period);
                periodPositionUs = this.period.getFirstAdIndexToPlay(periodId.adGroupIndex) == periodId.adIndexInAdGroup ? this.period.getAdResumePositionUs() : 0L;
                seekPositionAdjusted = true;
            } else {
                periodPositionUs = resolvedContentPosition;
                seekPositionAdjusted = seekPosition.windowPositionUs == -9223372036854775807L;
            }
        }
        try {
            if (this.playbackInfo.timeline.isEmpty()) {
                this.pendingInitialSeekPosition = seekPosition;
            } else if (resolvedSeekPosition == null) {
                if (this.playbackInfo.playbackState != 1) {
                    this.setState(4);
                }
                this.resetInternal(false, true, false, true);
            } else {
                long newPeriodPositionUs = periodPositionUs;
                if (periodId.equals(this.playbackInfo.periodId)) {
                    MediaPeriodHolder playingPeriodHolder = this.queue.getPlayingPeriod();
                    if (playingPeriodHolder != null && playingPeriodHolder.prepared && newPeriodPositionUs != 0L) {
                        newPeriodPositionUs = playingPeriodHolder.mediaPeriod.getAdjustedSeekPositionUs(newPeriodPositionUs, this.seekParameters);
                    }
                    if (C.usToMs(newPeriodPositionUs) == C.usToMs(this.playbackInfo.positionUs) && (this.playbackInfo.playbackState == 2 || this.playbackInfo.playbackState == 3)) {
                        periodPositionUs = this.playbackInfo.positionUs;
                        return;
                    }
                }
                newPeriodPositionUs = this.seekToPeriodPosition(periodId, newPeriodPositionUs, this.playbackInfo.playbackState == 4);
                seekPositionAdjusted |= periodPositionUs != newPeriodPositionUs;
                periodPositionUs = newPeriodPositionUs;
            }
        }
        finally {
            this.playbackInfo = this.handlePositionDiscontinuity(periodId, periodPositionUs, requestedContentPosition);
            if (seekPositionAdjusted) {
                this.playbackInfoUpdate.setPositionDiscontinuity(2);
            }
        }
    }

    private long seekToPeriodPosition(MediaSource.MediaPeriodId periodId, long periodPositionUs, boolean forceBufferingState) throws ExoPlaybackException {
        return this.seekToPeriodPosition(periodId, periodPositionUs, this.queue.getPlayingPeriod() != this.queue.getReadingPeriod(), forceBufferingState);
    }

    private long seekToPeriodPosition(MediaSource.MediaPeriodId periodId, long periodPositionUs, boolean forceDisableRenderers, boolean forceBufferingState) throws ExoPlaybackException {
        MediaPeriodHolder oldPlayingPeriodHolder;
        MediaPeriodHolder newPlayingPeriodHolder;
        this.stopRenderers();
        rebuffering = false;
        if (forceBufferingState || this.playbackInfo.playbackState == 3) {
            this.setState(2);
        }
        for (newPlayingPeriodHolder = oldPlayingPeriodHolder = this.queue.getPlayingPeriod(); newPlayingPeriodHolder != null && !periodId.equals(newPlayingPeriodHolder.info.id); newPlayingPeriodHolder = newPlayingPeriodHolder.getNext()) {
        }
        if (forceDisableRenderers || oldPlayingPeriodHolder != newPlayingPeriodHolder || newPlayingPeriodHolder != null && newPlayingPeriodHolder.toRendererTime(periodPositionUs) < 0L) {
            for (Renderer renderer : this.renderers) {
                this.disableRenderer(renderer);
            }
            if (newPlayingPeriodHolder != null) {
                while (this.queue.getPlayingPeriod() != newPlayingPeriodHolder) {
                    this.queue.advancePlayingPeriod();
                }
                this.queue.removeAfter(newPlayingPeriodHolder);
                newPlayingPeriodHolder.setRendererOffset(0L);
                this.enableRenderers();
            }
        }
        if (newPlayingPeriodHolder != null) {
            this.queue.removeAfter(newPlayingPeriodHolder);
            if (!newPlayingPeriodHolder.prepared) {
                newPlayingPeriodHolder.info = newPlayingPeriodHolder.info.copyWithStartPositionUs(periodPositionUs);
            } else {
                if (newPlayingPeriodHolder.info.durationUs != -9223372036854775807L && periodPositionUs >= newPlayingPeriodHolder.info.durationUs) {
                    periodPositionUs = Math.max(0L, newPlayingPeriodHolder.info.durationUs - 1L);
                }
                if (newPlayingPeriodHolder.hasEnabledTracks) {
                    periodPositionUs = newPlayingPeriodHolder.mediaPeriod.seekToUs(periodPositionUs);
                    newPlayingPeriodHolder.mediaPeriod.discardBuffer(periodPositionUs - this.backBufferDurationUs, this.retainBackBufferFromKeyframe);
                }
            }
            this.resetRendererPosition(periodPositionUs);
            this.maybeContinueLoading();
        } else {
            this.queue.clear();
            this.resetRendererPosition(periodPositionUs);
        }
        this.handleLoadingMediaPeriodChanged(false);
        this.handler.sendEmptyMessage(2);
        return periodPositionUs;
    }

    private void resetRendererPosition(long periodPositionUs) throws ExoPlaybackException {
        MediaPeriodHolder playingMediaPeriod = this.queue.getPlayingPeriod();
        this.rendererPositionUs = playingMediaPeriod == null ? periodPositionUs : playingMediaPeriod.toRendererTime(periodPositionUs);
        this.mediaClock.resetPosition(this.rendererPositionUs);
        for (Renderer renderer : this.renderers) {
            if (!ExoPlayerImplInternal.isRendererEnabled(renderer)) continue;
            renderer.resetPosition(this.rendererPositionUs);
        }
        this.notifyTrackSelectionDiscontinuity();
    }

    private void setPlaybackParametersInternal(PlaybackParameters playbackParameters) {
        this.mediaClock.setPlaybackParameters(playbackParameters);
        this.sendPlaybackParametersChangedInternal(this.mediaClock.getPlaybackParameters(), true);
    }

    private void setSeekParametersInternal(SeekParameters seekParameters) {
        this.seekParameters = seekParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setForegroundModeInternal(boolean foregroundMode, @Nullable AtomicBoolean processedFlag) {
        if (this.foregroundMode != foregroundMode) {
            this.foregroundMode = foregroundMode;
            if (!foregroundMode) {
                for (Renderer renderer : this.renderers) {
                    if (ExoPlayerImplInternal.isRendererEnabled(renderer)) continue;
                    renderer.reset();
                }
            }
        }
        if (processedFlag == null) return;
        Renderer[] rendererArray = this;
        synchronized (this) {
            processedFlag.set(true);
            this.notifyAll();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private void stopInternal(boolean forceResetRenderers, boolean acknowledgeStop) {
        this.resetInternal(forceResetRenderers || !this.foregroundMode, false, true, false);
        this.playbackInfoUpdate.incrementPendingOperationAcks(acknowledgeStop ? 1 : 0);
        this.loadControl.onStopped();
        this.setState(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseInternal() {
        this.resetInternal(true, false, true, false);
        this.loadControl.onReleased();
        this.setState(1);
        this.internalPlaybackThread.quit();
        ExoPlayerImplInternal exoPlayerImplInternal = this;
        synchronized (exoPlayerImplInternal) {
            this.released = true;
            this.notifyAll();
        }
    }

    private void resetInternal(boolean resetRenderers, boolean resetPosition, boolean releaseMediaSourceList, boolean resetError) {
        this.handler.removeMessages(2);
        rebuffering = false;
        this.mediaClock.stop();
        this.rendererPositionUs = 0L;
        for (Renderer renderer : this.renderers) {
            try {
                this.disableRenderer(renderer);
            }
            catch (ExoPlaybackException | RuntimeException e) {
                Log.e(TAG, "Disable failed.", e);
            }
        }
        if (resetRenderers) {
            for (Renderer renderer : this.renderers) {
                try {
                    renderer.reset();
                }
                catch (RuntimeException e) {
                    Log.e(TAG, "Reset failed.", e);
                }
            }
        }
        this.enabledRendererCount = 0;
        MediaSource.MediaPeriodId mediaPeriodId = this.playbackInfo.periodId;
        long startPositionUs = this.playbackInfo.positionUs;
        long requestedContentPositionUs = ExoPlayerImplInternal.shouldUseRequestedContentPosition(this.playbackInfo, this.period, this.window) ? this.playbackInfo.requestedContentPositionUs : this.playbackInfo.positionUs;
        boolean resetTrackInfo = false;
        if (resetPosition) {
            this.pendingInitialSeekPosition = null;
            Pair<MediaSource.MediaPeriodId, Long> firstPeriodAndPosition = this.getPlaceholderFirstMediaPeriodPosition(this.playbackInfo.timeline);
            mediaPeriodId = (MediaSource.MediaPeriodId)firstPeriodAndPosition.first;
            startPositionUs = (Long)firstPeriodAndPosition.second;
            requestedContentPositionUs = -9223372036854775807L;
            if (!mediaPeriodId.equals(this.playbackInfo.periodId)) {
                resetTrackInfo = true;
            }
        }
        this.queue.clear();
        this.shouldContinueLoading = false;
        this.playbackInfo = new PlaybackInfo(this.playbackInfo.timeline, mediaPeriodId, requestedContentPositionUs, this.playbackInfo.playbackState, resetError ? null : this.playbackInfo.playbackError, false, resetTrackInfo ? TrackGroupArray.EMPTY : this.playbackInfo.trackGroups, resetTrackInfo ? this.emptyTrackSelectorResult : this.playbackInfo.trackSelectorResult, mediaPeriodId, this.playbackInfo.playWhenReady, this.playbackInfo.playbackSuppressionReason, this.playbackInfo.playbackParameters, startPositionUs, 0L, startPositionUs, this.offloadSchedulingEnabled);
        if (releaseMediaSourceList) {
            this.mediaSourceList.release();
        }
    }

    private Pair<MediaSource.MediaPeriodId, Long> getPlaceholderFirstMediaPeriodPosition(Timeline timeline) {
        if (timeline.isEmpty()) {
            return Pair.create((Object)PlaybackInfo.getDummyPeriodForEmptyTimeline(), (Object)0L);
        }
        int firstWindowIndex = timeline.getFirstWindowIndex(this.shuffleModeEnabled);
        Pair<Object, Long> firstPeriodAndPosition = timeline.getPeriodPosition(this.window, this.period, firstWindowIndex, -9223372036854775807L);
        MediaSource.MediaPeriodId firstPeriodId = this.queue.resolveMediaPeriodIdForAds(timeline, firstPeriodAndPosition.first, 0L);
        long positionUs = (Long)firstPeriodAndPosition.second;
        if (firstPeriodId.isAd()) {
            timeline.getPeriodByUid(firstPeriodId.periodUid, this.period);
            positionUs = firstPeriodId.adIndexInAdGroup == this.period.getFirstAdIndexToPlay(firstPeriodId.adGroupIndex) ? this.period.getAdResumePositionUs() : 0L;
        }
        return Pair.create((Object)firstPeriodId, (Object)positionUs);
    }

    private void sendMessageInternal(PlayerMessage message) throws ExoPlaybackException {
        if (message.getPositionMs() == -9223372036854775807L) {
            this.sendMessageToTarget(message);
        } else if (this.playbackInfo.timeline.isEmpty()) {
            this.pendingMessages.add(new PendingMessageInfo(message));
        } else {
            PendingMessageInfo pendingMessageInfo = new PendingMessageInfo(message);
            if (ExoPlayerImplInternal.resolvePendingMessagePosition(pendingMessageInfo, this.playbackInfo.timeline, this.playbackInfo.timeline, this.repeatMode, this.shuffleModeEnabled, this.window, this.period)) {
                this.pendingMessages.add(pendingMessageInfo);
                Collections.sort(this.pendingMessages);
            } else {
                message.markAsProcessed(false);
            }
        }
    }

    private void sendMessageToTarget(PlayerMessage message) throws ExoPlaybackException {
        if (message.getHandler().getLooper() == this.playbackLooper) {
            this.deliverMessage(message);
            if (this.playbackInfo.playbackState == 3 || this.playbackInfo.playbackState == 2) {
                this.handler.sendEmptyMessage(2);
            }
        } else {
            this.handler.obtainMessage(15, message).sendToTarget();
        }
    }

    private void sendMessageToTargetThread(PlayerMessage message) {
        Handler handler = message.getHandler();
        if (!handler.getLooper().getThread().isAlive()) {
            Log.w("TAG", "Trying to send message on a dead thread.");
            message.markAsProcessed(false);
            return;
        }
        handler.post(() -> {
            try {
                this.deliverMessage(message);
            }
            catch (ExoPlaybackException e) {
                Log.e(TAG, "Unexpected error delivering message on external thread.", e);
                throw new RuntimeException(e);
            }
        });
    }

    private void deliverMessage(PlayerMessage message) throws ExoPlaybackException {
        if (message.isCanceled()) {
            return;
        }
        try {
            message.getTarget().handleMessage(message.getType(), message.getPayload());
        }
        finally {
            message.markAsProcessed(true);
        }
    }

    private void resolvePendingMessagePositions(Timeline newTimeline, Timeline previousTimeline) {
        if (newTimeline.isEmpty() && previousTimeline.isEmpty()) {
            return;
        }
        for (int i = this.pendingMessages.size() - 1; i >= 0; --i) {
            if (ExoPlayerImplInternal.resolvePendingMessagePosition(this.pendingMessages.get(i), newTimeline, previousTimeline, this.repeatMode, this.shuffleModeEnabled, this.window, this.period)) continue;
            this.pendingMessages.get((int)i).message.markAsProcessed(false);
            this.pendingMessages.remove(i);
        }
        Collections.sort(this.pendingMessages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeTriggerPendingMessages(long oldPeriodPositionUs, long newPeriodPositionUs) throws ExoPlaybackException {
        PendingMessageInfo nextInfo;
        PendingMessageInfo previousInfo;
        if (this.pendingMessages.isEmpty() || this.playbackInfo.periodId.isAd()) {
            return;
        }
        if (this.deliverPendingMessageAtStartPositionRequired) {
            --oldPeriodPositionUs;
            this.deliverPendingMessageAtStartPositionRequired = false;
        }
        int currentPeriodIndex = this.playbackInfo.timeline.getIndexOfPeriod(this.playbackInfo.periodId.periodUid);
        int nextPendingMessageIndex = Math.min(this.nextPendingMessageIndexHint, this.pendingMessages.size());
        PendingMessageInfo pendingMessageInfo = previousInfo = nextPendingMessageIndex > 0 ? this.pendingMessages.get(nextPendingMessageIndex - 1) : null;
        while (previousInfo != null && (previousInfo.resolvedPeriodIndex > currentPeriodIndex || previousInfo.resolvedPeriodIndex == currentPeriodIndex && previousInfo.resolvedPeriodTimeUs > oldPeriodPositionUs)) {
            previousInfo = --nextPendingMessageIndex > 0 ? this.pendingMessages.get(nextPendingMessageIndex - 1) : null;
        }
        PendingMessageInfo pendingMessageInfo2 = nextInfo = nextPendingMessageIndex < this.pendingMessages.size() ? this.pendingMessages.get(nextPendingMessageIndex) : null;
        while (nextInfo != null && nextInfo.resolvedPeriodUid != null && (nextInfo.resolvedPeriodIndex < currentPeriodIndex || nextInfo.resolvedPeriodIndex == currentPeriodIndex && nextInfo.resolvedPeriodTimeUs <= oldPeriodPositionUs)) {
            nextInfo = ++nextPendingMessageIndex < this.pendingMessages.size() ? this.pendingMessages.get(nextPendingMessageIndex) : null;
        }
        while (nextInfo != null && nextInfo.resolvedPeriodUid != null && nextInfo.resolvedPeriodIndex == currentPeriodIndex && nextInfo.resolvedPeriodTimeUs > oldPeriodPositionUs && nextInfo.resolvedPeriodTimeUs <= newPeriodPositionUs) {
            try {
                this.sendMessageToTarget(nextInfo.message);
            }
            finally {
                if (nextInfo.message.getDeleteAfterDelivery() || nextInfo.message.isCanceled()) {
                    this.pendingMessages.remove(nextPendingMessageIndex);
                } else {
                    ++nextPendingMessageIndex;
                }
            }
            nextInfo = nextPendingMessageIndex < this.pendingMessages.size() ? this.pendingMessages.get(nextPendingMessageIndex) : null;
        }
        this.nextPendingMessageIndexHint = nextPendingMessageIndex;
    }

    private void ensureStopped(Renderer renderer) throws ExoPlaybackException {
        if (renderer.getState() == 2) {
            renderer.stop();
        }
    }

    private void disableRenderer(Renderer renderer) throws ExoPlaybackException {
        if (!ExoPlayerImplInternal.isRendererEnabled(renderer)) {
            return;
        }
        this.mediaClock.onRendererDisabled(renderer);
        this.ensureStopped(renderer);
        renderer.disable();
        --this.enabledRendererCount;
    }

    private void reselectTracksInternal() throws ExoPlaybackException {
        TrackSelectorResult newTrackSelectorResult;
        float playbackSpeed = this.mediaClock.getPlaybackParameters().speed;
        MediaPeriodHolder periodHolder = this.queue.getPlayingPeriod();
        MediaPeriodHolder readingPeriodHolder = this.queue.getReadingPeriod();
        boolean selectionsChangedForReadPeriod = true;
        while (true) {
            if (periodHolder == null || !periodHolder.prepared) {
                return;
            }
            newTrackSelectorResult = periodHolder.selectTracks(playbackSpeed, this.playbackInfo.timeline);
            if (!newTrackSelectorResult.isEquivalent(periodHolder.getTrackSelectorResult())) break;
            if (periodHolder == readingPeriodHolder) {
                selectionsChangedForReadPeriod = false;
            }
            periodHolder = periodHolder.getNext();
        }
        if (selectionsChangedForReadPeriod) {
            MediaPeriodHolder playingPeriodHolder = this.queue.getPlayingPeriod();
            boolean recreateStreams = this.queue.removeAfter(playingPeriodHolder);
            boolean[] streamResetFlags = new boolean[this.renderers.length];
            long periodPositionUs = playingPeriodHolder.applyTrackSelection(newTrackSelectorResult, this.playbackInfo.positionUs, recreateStreams, streamResetFlags);
            this.playbackInfo = this.handlePositionDiscontinuity(this.playbackInfo.periodId, periodPositionUs, this.playbackInfo.requestedContentPositionUs);
            if (this.playbackInfo.playbackState != 4 && periodPositionUs != this.playbackInfo.positionUs) {
                this.playbackInfoUpdate.setPositionDiscontinuity(4);
                this.resetRendererPosition(periodPositionUs);
            }
            boolean[] rendererWasEnabledFlags = new boolean[this.renderers.length];
            for (int i = 0; i < this.renderers.length; ++i) {
                Renderer renderer = this.renderers[i];
                rendererWasEnabledFlags[i] = ExoPlayerImplInternal.isRendererEnabled(renderer);
                SampleStream sampleStream = playingPeriodHolder.sampleStreams[i];
                if (!rendererWasEnabledFlags[i]) continue;
                if (sampleStream != renderer.getStream()) {
                    this.disableRenderer(renderer);
                    continue;
                }
                if (!streamResetFlags[i]) continue;
                renderer.resetPosition(this.rendererPositionUs);
            }
            this.enableRenderers(rendererWasEnabledFlags);
        } else {
            this.queue.removeAfter(periodHolder);
            if (periodHolder.prepared) {
                long loadingPeriodPositionUs = Math.max(periodHolder.info.startPositionUs, periodHolder.toPeriodTime(this.rendererPositionUs));
                periodHolder.applyTrackSelection(newTrackSelectorResult, loadingPeriodPositionUs, false);
            }
        }
        this.handleLoadingMediaPeriodChanged(true);
        if (this.playbackInfo.playbackState != 4) {
            this.maybeContinueLoading();
            this.updatePlaybackPositions();
            this.handler.sendEmptyMessage(2);
        }
    }

    private void updateTrackSelectionPlaybackSpeed(float playbackSpeed) {
        for (MediaPeriodHolder periodHolder = this.queue.getPlayingPeriod(); periodHolder != null; periodHolder = periodHolder.getNext()) {
            TrackSelection[] trackSelections;
            for (TrackSelection trackSelection : trackSelections = periodHolder.getTrackSelectorResult().selections.getAll()) {
                if (trackSelection == null) continue;
                trackSelection.onPlaybackSpeed(playbackSpeed);
            }
        }
    }

    private void notifyTrackSelectionDiscontinuity() {
        for (MediaPeriodHolder periodHolder = this.queue.getPlayingPeriod(); periodHolder != null; periodHolder = periodHolder.getNext()) {
            TrackSelection[] trackSelections;
            for (TrackSelection trackSelection : trackSelections = periodHolder.getTrackSelectorResult().selections.getAll()) {
                if (trackSelection == null) continue;
                trackSelection.onDiscontinuity();
            }
        }
    }

    private boolean shouldTransitionToReadyState(boolean renderersReadyOrEnded) {
        if (this.enabledRendererCount == 0) {
            return this.isTimelineReady();
        }
        if (!renderersReadyOrEnded) {
            return false;
        }
        if (!this.playbackInfo.isLoading) {
            return true;
        }
        MediaPeriodHolder loadingHolder = this.queue.getLoadingPeriod();
        boolean bufferedToEnd = loadingHolder.isFullyBuffered() && loadingHolder.info.isFinal;
        return bufferedToEnd || this.loadControl.shouldStartPlayback(this.getTotalBufferedDurationUs(), this.mediaClock.getPlaybackParameters().speed, rebuffering);
    }

    private boolean isTimelineReady() {
        MediaPeriodHolder playingPeriodHolder = this.queue.getPlayingPeriod();
        long playingPeriodDurationUs = playingPeriodHolder.info.durationUs;
        return playingPeriodHolder.prepared && (playingPeriodDurationUs == -9223372036854775807L || this.playbackInfo.positionUs < playingPeriodDurationUs || !this.shouldPlayWhenReady());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMediaSourceListInfoRefreshed(Timeline timeline) throws ExoPlaybackException {
        PositionUpdateForPlaylistChange positionUpdate = ExoPlayerImplInternal.resolvePositionForPlaylistChange(timeline, this.playbackInfo, this.pendingInitialSeekPosition, this.queue, this.repeatMode, this.shuffleModeEnabled, this.window, this.period);
        MediaSource.MediaPeriodId newPeriodId = positionUpdate.periodId;
        long newRequestedContentPositionUs = positionUpdate.requestedContentPositionUs;
        boolean forceBufferingState = positionUpdate.forceBufferingState;
        long newPositionUs = positionUpdate.periodPositionUs;
        boolean periodPositionChanged = !this.playbackInfo.periodId.equals(newPeriodId) || newPositionUs != this.playbackInfo.positionUs;
        try {
            if (positionUpdate.endPlayback) {
                if (this.playbackInfo.playbackState != 1) {
                    this.setState(4);
                }
                this.resetInternal(false, false, false, true);
            }
            if (!periodPositionChanged) {
                if (!this.queue.updateQueuedPeriods(timeline, this.rendererPositionUs, this.getMaxRendererReadPositionUs())) {
                    this.seekToCurrentPosition(false);
                }
            } else if (!timeline.isEmpty()) {
                for (MediaPeriodHolder periodHolder = this.queue.getPlayingPeriod(); periodHolder != null; periodHolder = periodHolder.getNext()) {
                    if (!periodHolder.info.id.equals(newPeriodId)) continue;
                    periodHolder.info = this.queue.getUpdatedMediaPeriodInfo(timeline, periodHolder.info);
                }
                newPositionUs = this.seekToPeriodPosition(newPeriodId, newPositionUs, forceBufferingState);
            }
        }
        finally {
            if (periodPositionChanged || newRequestedContentPositionUs != this.playbackInfo.requestedContentPositionUs) {
                this.playbackInfo = this.handlePositionDiscontinuity(newPeriodId, newPositionUs, newRequestedContentPositionUs);
            }
            this.resetPendingPauseAtEndOfPeriod();
            this.resolvePendingMessagePositions(timeline, this.playbackInfo.timeline);
            this.playbackInfo = this.playbackInfo.copyWithTimeline(timeline);
            if (!timeline.isEmpty()) {
                this.pendingInitialSeekPosition = null;
            }
            this.handleLoadingMediaPeriodChanged(false);
        }
    }

    private long getMaxRendererReadPositionUs() {
        MediaPeriodHolder readingHolder = this.queue.getReadingPeriod();
        if (readingHolder == null) {
            return 0L;
        }
        long maxReadPositionUs = readingHolder.getRendererOffset();
        if (!readingHolder.prepared) {
            return maxReadPositionUs;
        }
        for (int i = 0; i < this.renderers.length; ++i) {
            if (!ExoPlayerImplInternal.isRendererEnabled(this.renderers[i]) || this.renderers[i].getStream() != readingHolder.sampleStreams[i]) continue;
            long readingPositionUs = this.renderers[i].getReadingPositionUs();
            if (readingPositionUs == Long.MIN_VALUE) {
                return Long.MIN_VALUE;
            }
            maxReadPositionUs = Math.max(readingPositionUs, maxReadPositionUs);
        }
        return maxReadPositionUs;
    }

    private void updatePeriods() throws ExoPlaybackException, IOException {
        if (this.playbackInfo.timeline.isEmpty() || !this.mediaSourceList.isPrepared()) {
            return;
        }
        this.maybeUpdateLoadingPeriod();
        this.maybeUpdateReadingPeriod();
        this.maybeUpdateReadingRenderers();
        this.maybeUpdatePlayingPeriod();
    }

    private void maybeUpdateLoadingPeriod() throws ExoPlaybackException {
        MediaPeriodInfo info;
        this.queue.reevaluateBuffer(this.rendererPositionUs);
        if (this.queue.shouldLoadNextMediaPeriod() && (info = this.queue.getNextMediaPeriodInfo(this.rendererPositionUs, this.playbackInfo)) != null) {
            MediaPeriodHolder mediaPeriodHolder = this.queue.enqueueNextMediaPeriodHolder(this.rendererCapabilities, this.trackSelector, this.loadControl.getAllocator(), this.mediaSourceList, info, this.emptyTrackSelectorResult);
            mediaPeriodHolder.mediaPeriod.prepare(this, info.startPositionUs);
            if (this.queue.getPlayingPeriod() == mediaPeriodHolder) {
                this.resetRendererPosition(mediaPeriodHolder.getStartPositionRendererTime());
            }
            this.handleLoadingMediaPeriodChanged(false);
        }
        if (this.shouldContinueLoading) {
            this.shouldContinueLoading = this.isLoadingPossible();
            this.updateIsLoading();
        } else {
            this.maybeContinueLoading();
        }
    }

    private void maybeUpdateReadingPeriod() {
        MediaPeriodHolder readingPeriodHolder = this.queue.getReadingPeriod();
        if (readingPeriodHolder == null) {
            return;
        }
        if (readingPeriodHolder.getNext() == null || this.pendingPauseAtEndOfPeriod) {
            if (readingPeriodHolder.info.isFinal || this.pendingPauseAtEndOfPeriod) {
                for (int i = 0; i < this.renderers.length; ++i) {
                    Renderer renderer = this.renderers[i];
                    SampleStream sampleStream = readingPeriodHolder.sampleStreams[i];
                    if (sampleStream == null || renderer.getStream() != sampleStream || !renderer.hasReadStreamToEnd()) continue;
                    renderer.setCurrentStreamFinal();
                }
            }
            return;
        }
        if (!this.hasReadingPeriodFinishedReading()) {
            return;
        }
        if (!readingPeriodHolder.getNext().prepared && this.rendererPositionUs < readingPeriodHolder.getNext().getStartPositionRendererTime()) {
            return;
        }
        TrackSelectorResult oldTrackSelectorResult = readingPeriodHolder.getTrackSelectorResult();
        readingPeriodHolder = this.queue.advanceReadingPeriod();
        TrackSelectorResult newTrackSelectorResult = readingPeriodHolder.getTrackSelectorResult();
        if (readingPeriodHolder.prepared && readingPeriodHolder.mediaPeriod.readDiscontinuity() != -9223372036854775807L) {
            this.setAllRendererStreamsFinal();
            return;
        }
        for (int i = 0; i < this.renderers.length; ++i) {
            boolean oldRendererEnabled = oldTrackSelectorResult.isRendererEnabled(i);
            boolean newRendererEnabled = newTrackSelectorResult.isRendererEnabled(i);
            if (!oldRendererEnabled || this.renderers[i].isCurrentStreamFinal()) continue;
            boolean isNoSampleRenderer = this.rendererCapabilities[i].getTrackType() == 6;
            RendererConfiguration oldConfig = oldTrackSelectorResult.rendererConfigurations[i];
            RendererConfiguration newConfig = newTrackSelectorResult.rendererConfigurations[i];
            if (newRendererEnabled && newConfig.equals(oldConfig) && !isNoSampleRenderer) continue;
            this.renderers[i].setCurrentStreamFinal();
        }
    }

    private void maybeUpdateReadingRenderers() throws ExoPlaybackException {
        MediaPeriodHolder readingPeriod = this.queue.getReadingPeriod();
        if (readingPeriod == null || this.queue.getPlayingPeriod() == readingPeriod || readingPeriod.allRenderersEnabled) {
            return;
        }
        if (this.replaceStreamsOrDisableRendererForTransition()) {
            this.enableRenderers();
        }
    }

    private boolean replaceStreamsOrDisableRendererForTransition() throws ExoPlaybackException {
        MediaPeriodHolder readingPeriodHolder = this.queue.getReadingPeriod();
        TrackSelectorResult newTrackSelectorResult = readingPeriodHolder.getTrackSelectorResult();
        boolean needsToWaitForRendererToEnd = false;
        for (int i = 0; i < this.renderers.length; ++i) {
            Renderer renderer = this.renderers[i];
            if (!ExoPlayerImplInternal.isRendererEnabled(renderer)) continue;
            boolean rendererIsReadingOldStream = renderer.getStream() != readingPeriodHolder.sampleStreams[i];
            boolean rendererShouldBeEnabled = newTrackSelectorResult.isRendererEnabled(i);
            if (rendererShouldBeEnabled && !rendererIsReadingOldStream) continue;
            if (!renderer.isCurrentStreamFinal()) {
                Format[] formats = ExoPlayerImplInternal.getFormats(newTrackSelectorResult.selections.get(i));
                renderer.replaceStream(formats, readingPeriodHolder.sampleStreams[i], readingPeriodHolder.getStartPositionRendererTime(), readingPeriodHolder.getRendererOffset());
                continue;
            }
            if (renderer.isEnded()) {
                this.disableRenderer(renderer);
                continue;
            }
            needsToWaitForRendererToEnd = true;
        }
        return !needsToWaitForRendererToEnd;
    }

    private void maybeUpdatePlayingPeriod() throws ExoPlaybackException {
        boolean advancedPlayingPeriod = false;
        while (this.shouldAdvancePlayingPeriod()) {
            if (advancedPlayingPeriod) {
                this.maybeNotifyPlaybackInfoChanged();
            }
            MediaPeriodHolder oldPlayingPeriodHolder = this.queue.getPlayingPeriod();
            MediaPeriodHolder newPlayingPeriodHolder = this.queue.advancePlayingPeriod();
            this.playbackInfo = this.handlePositionDiscontinuity(newPlayingPeriodHolder.info.id, newPlayingPeriodHolder.info.startPositionUs, newPlayingPeriodHolder.info.requestedContentPositionUs);
            int discontinuityReason = oldPlayingPeriodHolder.info.isLastInTimelinePeriod ? 0 : 3;
            this.playbackInfoUpdate.setPositionDiscontinuity(discontinuityReason);
            this.resetPendingPauseAtEndOfPeriod();
            this.updatePlaybackPositions();
            advancedPlayingPeriod = true;
        }
    }

    private void resetPendingPauseAtEndOfPeriod() {
        MediaPeriodHolder playingPeriod = this.queue.getPlayingPeriod();
        this.pendingPauseAtEndOfPeriod = playingPeriod != null && playingPeriod.info.isLastInTimelineWindow && this.pauseAtEndOfWindow;
    }

    private boolean shouldAdvancePlayingPeriod() {
        if (!this.shouldPlayWhenReady()) {
            return false;
        }
        if (this.pendingPauseAtEndOfPeriod) {
            return false;
        }
        MediaPeriodHolder playingPeriodHolder = this.queue.getPlayingPeriod();
        if (playingPeriodHolder == null) {
            return false;
        }
        MediaPeriodHolder nextPlayingPeriodHolder = playingPeriodHolder.getNext();
        return nextPlayingPeriodHolder != null && this.rendererPositionUs >= nextPlayingPeriodHolder.getStartPositionRendererTime() && nextPlayingPeriodHolder.allRenderersEnabled;
    }

    private boolean hasReadingPeriodFinishedReading() {
        MediaPeriodHolder readingPeriodHolder = this.queue.getReadingPeriod();
        if (!readingPeriodHolder.prepared) {
            return false;
        }
        for (int i = 0; i < this.renderers.length; ++i) {
            Renderer renderer = this.renderers[i];
            SampleStream sampleStream = readingPeriodHolder.sampleStreams[i];
            if (renderer.getStream() == sampleStream && (sampleStream == null || renderer.hasReadStreamToEnd())) continue;
            return false;
        }
        return true;
    }

    private void setAllRendererStreamsFinal() {
        for (Renderer renderer : this.renderers) {
            if (renderer.getStream() == null) continue;
            renderer.setCurrentStreamFinal();
        }
    }

    private void handlePeriodPrepared(MediaPeriod mediaPeriod) throws ExoPlaybackException {
        if (!this.queue.isLoading(mediaPeriod)) {
            return;
        }
        MediaPeriodHolder loadingPeriodHolder = this.queue.getLoadingPeriod();
        loadingPeriodHolder.handlePrepared(this.mediaClock.getPlaybackParameters().speed, this.playbackInfo.timeline);
        this.updateLoadControlTrackSelection(loadingPeriodHolder.getTrackGroups(), loadingPeriodHolder.getTrackSelectorResult());
        if (loadingPeriodHolder == this.queue.getPlayingPeriod()) {
            this.resetRendererPosition(loadingPeriodHolder.info.startPositionUs);
            this.enableRenderers();
            this.playbackInfo = this.handlePositionDiscontinuity(this.playbackInfo.periodId, loadingPeriodHolder.info.startPositionUs, this.playbackInfo.requestedContentPositionUs);
        }
        this.maybeContinueLoading();
    }

    private void handleContinueLoadingRequested(MediaPeriod mediaPeriod) {
        if (!this.queue.isLoading(mediaPeriod)) {
            return;
        }
        this.queue.reevaluateBuffer(this.rendererPositionUs);
        this.maybeContinueLoading();
    }

    private void handlePlaybackParameters(PlaybackParameters playbackParameters, boolean acknowledgeCommand) throws ExoPlaybackException {
        this.playbackInfoUpdate.incrementPendingOperationAcks(acknowledgeCommand ? 1 : 0);
        this.playbackInfo = this.playbackInfo.copyWithPlaybackParameters(playbackParameters);
        this.updateTrackSelectionPlaybackSpeed(playbackParameters.speed);
        for (Renderer renderer : this.renderers) {
            if (renderer == null) continue;
            renderer.setOperatingRate(playbackParameters.speed);
        }
    }

    private void maybeContinueLoading() {
        this.shouldContinueLoading = this.shouldContinueLoading();
        if (this.shouldContinueLoading) {
            this.queue.getLoadingPeriod().continueLoading(this.rendererPositionUs);
        }
        this.updateIsLoading();
    }

    private boolean shouldContinueLoading() {
        if (!this.isLoadingPossible()) {
            return false;
        }
        MediaPeriodHolder loadingPeriodHolder = this.queue.getLoadingPeriod();
        long bufferedDurationUs = this.getTotalBufferedDurationUs(loadingPeriodHolder.getNextLoadPositionUs());
        long playbackPositionUs = loadingPeriodHolder == this.queue.getPlayingPeriod() ? loadingPeriodHolder.toPeriodTime(this.rendererPositionUs) : loadingPeriodHolder.toPeriodTime(this.rendererPositionUs) - loadingPeriodHolder.info.startPositionUs;
        return this.loadControl.shouldContinueLoading(playbackPositionUs, bufferedDurationUs, this.mediaClock.getPlaybackParameters().speed);
    }

    private boolean isLoadingPossible() {
        MediaPeriodHolder loadingPeriodHolder = this.queue.getLoadingPeriod();
        if (loadingPeriodHolder == null) {
            return false;
        }
        long nextLoadPositionUs = loadingPeriodHolder.getNextLoadPositionUs();
        return nextLoadPositionUs != Long.MIN_VALUE;
    }

    private void updateIsLoading() {
        boolean isLoading;
        MediaPeriodHolder loadingPeriod = this.queue.getLoadingPeriod();
        boolean bl = isLoading = this.shouldContinueLoading || loadingPeriod != null && loadingPeriod.mediaPeriod.isLoading();
        if (isLoading != this.playbackInfo.isLoading) {
            this.playbackInfo = this.playbackInfo.copyWithIsLoading(isLoading);
        }
    }

    @CheckResult
    private PlaybackInfo handlePositionDiscontinuity(MediaSource.MediaPeriodId mediaPeriodId, long positionUs, long contentPositionUs) {
        this.deliverPendingMessageAtStartPositionRequired = this.deliverPendingMessageAtStartPositionRequired || positionUs != this.playbackInfo.positionUs || !mediaPeriodId.equals(this.playbackInfo.periodId);
        this.resetPendingPauseAtEndOfPeriod();
        TrackGroupArray trackGroupArray = this.playbackInfo.trackGroups;
        TrackSelectorResult trackSelectorResult = this.playbackInfo.trackSelectorResult;
        if (this.mediaSourceList.isPrepared()) {
            MediaPeriodHolder playingPeriodHolder = this.queue.getPlayingPeriod();
            trackGroupArray = playingPeriodHolder == null ? TrackGroupArray.EMPTY : playingPeriodHolder.getTrackGroups();
            trackSelectorResult = playingPeriodHolder == null ? this.emptyTrackSelectorResult : playingPeriodHolder.getTrackSelectorResult();
        } else if (!mediaPeriodId.equals(this.playbackInfo.periodId)) {
            trackGroupArray = TrackGroupArray.EMPTY;
            trackSelectorResult = this.emptyTrackSelectorResult;
        }
        return this.playbackInfo.copyWithNewPosition(mediaPeriodId, positionUs, contentPositionUs, this.getTotalBufferedDurationUs(), trackGroupArray, trackSelectorResult);
    }

    private void enableRenderers() throws ExoPlaybackException {
        this.enableRenderers(new boolean[this.renderers.length]);
    }

    private void enableRenderers(boolean[] rendererWasEnabledFlags) throws ExoPlaybackException {
        int i;
        MediaPeriodHolder readingMediaPeriod = this.queue.getReadingPeriod();
        TrackSelectorResult trackSelectorResult = readingMediaPeriod.getTrackSelectorResult();
        for (i = 0; i < this.renderers.length; ++i) {
            if (trackSelectorResult.isRendererEnabled(i)) continue;
            this.renderers[i].reset();
        }
        for (i = 0; i < this.renderers.length; ++i) {
            if (!trackSelectorResult.isRendererEnabled(i)) continue;
            this.enableRenderer(i, rendererWasEnabledFlags[i]);
        }
        readingMediaPeriod.allRenderersEnabled = true;
    }

    private void enableRenderer(int rendererIndex, boolean wasRendererEnabled) throws ExoPlaybackException {
        Renderer renderer = this.renderers[rendererIndex];
        if (ExoPlayerImplInternal.isRendererEnabled(renderer)) {
            return;
        }
        MediaPeriodHolder periodHolder = this.queue.getReadingPeriod();
        boolean mayRenderStartOfStream = periodHolder == this.queue.getPlayingPeriod();
        TrackSelectorResult trackSelectorResult = periodHolder.getTrackSelectorResult();
        RendererConfiguration rendererConfiguration = trackSelectorResult.rendererConfigurations[rendererIndex];
        TrackSelection newSelection = trackSelectorResult.selections.get(rendererIndex);
        Format[] formats = ExoPlayerImplInternal.getFormats(newSelection);
        boolean playing = this.shouldPlayWhenReady() && this.playbackInfo.playbackState == 3;
        boolean joining = !wasRendererEnabled && playing;
        ++this.enabledRendererCount;
        renderer.enable(rendererConfiguration, formats, periodHolder.sampleStreams[rendererIndex], this.rendererPositionUs, joining, mayRenderStartOfStream, periodHolder.getStartPositionRendererTime(), periodHolder.getRendererOffset());
        renderer.handleMessage(103, new Renderer.WakeupListener(){

            @Override
            public void onSleep(long wakeupDeadlineMs) {
                if (wakeupDeadlineMs >= 2000L) {
                    ExoPlayerImplInternal.this.requestForRendererSleep = true;
                }
            }

            @Override
            public void onWakeup() {
                ExoPlayerImplInternal.this.handler.sendEmptyMessage(2);
            }
        });
        this.mediaClock.onRendererEnabled(renderer);
        if (playing) {
            renderer.start();
        }
    }

    private void handleLoadingMediaPeriodChanged(boolean loadingTrackSelectionChanged) {
        boolean loadingMediaPeriodChanged;
        MediaPeriodHolder loadingMediaPeriodHolder = this.queue.getLoadingPeriod();
        MediaSource.MediaPeriodId loadingMediaPeriodId = loadingMediaPeriodHolder == null ? this.playbackInfo.periodId : loadingMediaPeriodHolder.info.id;
        boolean bl = loadingMediaPeriodChanged = !this.playbackInfo.loadingMediaPeriodId.equals(loadingMediaPeriodId);
        if (loadingMediaPeriodChanged) {
            this.playbackInfo = this.playbackInfo.copyWithLoadingMediaPeriodId(loadingMediaPeriodId);
        }
        this.playbackInfo.bufferedPositionUs = loadingMediaPeriodHolder == null ? this.playbackInfo.positionUs : loadingMediaPeriodHolder.getBufferedPositionUs();
        this.playbackInfo.totalBufferedDurationUs = this.getTotalBufferedDurationUs();
        if ((loadingMediaPeriodChanged || loadingTrackSelectionChanged) && loadingMediaPeriodHolder != null && loadingMediaPeriodHolder.prepared) {
            this.updateLoadControlTrackSelection(loadingMediaPeriodHolder.getTrackGroups(), loadingMediaPeriodHolder.getTrackSelectorResult());
        }
    }

    private long getTotalBufferedDurationUs() {
        return this.getTotalBufferedDurationUs(this.playbackInfo.bufferedPositionUs);
    }

    private long getTotalBufferedDurationUs(long bufferedPositionInLoadingPeriodUs) {
        MediaPeriodHolder loadingPeriodHolder = this.queue.getLoadingPeriod();
        if (loadingPeriodHolder == null) {
            return 0L;
        }
        long totalBufferedDurationUs = bufferedPositionInLoadingPeriodUs - loadingPeriodHolder.toPeriodTime(this.rendererPositionUs);
        return Math.max(0L, totalBufferedDurationUs);
    }

    private void updateLoadControlTrackSelection(TrackGroupArray trackGroups, TrackSelectorResult trackSelectorResult) {
        this.loadControl.onTracksSelected(this.renderers, trackGroups, trackSelectorResult.selections);
    }

    private void sendPlaybackParametersChangedInternal(PlaybackParameters playbackParameters, boolean acknowledgeCommand) {
        this.handler.obtainMessage(16, acknowledgeCommand ? 1 : 0, 0, playbackParameters).sendToTarget();
    }

    private boolean shouldPlayWhenReady() {
        return this.playbackInfo.playWhenReady && this.playbackInfo.playbackSuppressionReason == 0;
    }

    private static PositionUpdateForPlaylistChange resolvePositionForPlaylistChange(Timeline timeline, PlaybackInfo playbackInfo, @Nullable SeekPosition pendingInitialSeekPosition, MediaPeriodQueue queue, int repeatMode, boolean shuffleModeEnabled, Timeline.Window window, Timeline.Period period) {
        long oldContentPositionUs;
        if (timeline.isEmpty()) {
            return new PositionUpdateForPlaylistChange(PlaybackInfo.getDummyPeriodForEmptyTimeline(), 0L, -9223372036854775807L, false, true);
        }
        MediaSource.MediaPeriodId oldPeriodId = playbackInfo.periodId;
        Object newPeriodUid = oldPeriodId.periodUid;
        boolean shouldUseRequestedContentPosition = ExoPlayerImplInternal.shouldUseRequestedContentPosition(playbackInfo, period, window);
        long newContentPositionUs = oldContentPositionUs = shouldUseRequestedContentPosition ? playbackInfo.requestedContentPositionUs : playbackInfo.positionUs;
        int startAtDefaultPositionWindowIndex = -1;
        boolean forceBufferingState = false;
        boolean endPlayback = false;
        if (pendingInitialSeekPosition != null) {
            Pair<Object, Long> periodPosition = ExoPlayerImplInternal.resolveSeekPosition(timeline, pendingInitialSeekPosition, true, repeatMode, shuffleModeEnabled, window, period);
            if (periodPosition == null) {
                endPlayback = true;
                startAtDefaultPositionWindowIndex = timeline.getFirstWindowIndex(shuffleModeEnabled);
            } else {
                if (pendingInitialSeekPosition.windowPositionUs == -9223372036854775807L) {
                    startAtDefaultPositionWindowIndex = timeline.getPeriodByUid((Object)periodPosition.first, (Timeline.Period)period).windowIndex;
                } else {
                    newPeriodUid = periodPosition.first;
                    newContentPositionUs = (Long)periodPosition.second;
                }
                forceBufferingState = playbackInfo.playbackState == 4;
            }
        } else if (playbackInfo.timeline.isEmpty()) {
            startAtDefaultPositionWindowIndex = timeline.getFirstWindowIndex(shuffleModeEnabled);
        } else if (timeline.getIndexOfPeriod(newPeriodUid) == -1) {
            Object subsequentPeriodUid = ExoPlayerImplInternal.resolveSubsequentPeriod(window, period, repeatMode, shuffleModeEnabled, newPeriodUid, playbackInfo.timeline, timeline);
            if (subsequentPeriodUid == null) {
                endPlayback = true;
                startAtDefaultPositionWindowIndex = timeline.getFirstWindowIndex(shuffleModeEnabled);
            } else {
                startAtDefaultPositionWindowIndex = timeline.getPeriodByUid((Object)subsequentPeriodUid, (Timeline.Period)period).windowIndex;
            }
        } else if (shouldUseRequestedContentPosition) {
            if (oldContentPositionUs == -9223372036854775807L) {
                startAtDefaultPositionWindowIndex = timeline.getPeriodByUid((Object)newPeriodUid, (Timeline.Period)period).windowIndex;
            } else {
                playbackInfo.timeline.getPeriodByUid(oldPeriodId.periodUid, period);
                long windowPositionUs = oldContentPositionUs + period.getPositionInWindowUs();
                int windowIndex = timeline.getPeriodByUid((Object)newPeriodUid, (Timeline.Period)period).windowIndex;
                Pair<Object, Long> periodPosition = timeline.getPeriodPosition(window, period, windowIndex, windowPositionUs);
                newPeriodUid = periodPosition.first;
                newContentPositionUs = (Long)periodPosition.second;
            }
        }
        long contentPositionForAdResolutionUs = newContentPositionUs;
        if (startAtDefaultPositionWindowIndex != -1) {
            Pair<Object, Long> defaultPosition = timeline.getPeriodPosition(window, period, startAtDefaultPositionWindowIndex, -9223372036854775807L);
            newPeriodUid = defaultPosition.first;
            contentPositionForAdResolutionUs = (Long)defaultPosition.second;
            newContentPositionUs = -9223372036854775807L;
        }
        MediaSource.MediaPeriodId periodIdWithAds = queue.resolveMediaPeriodIdForAds(timeline, newPeriodUid, contentPositionForAdResolutionUs);
        boolean earliestCuePointIsUnchangedOrLater = periodIdWithAds.nextAdGroupIndex == -1 || oldPeriodId.nextAdGroupIndex != -1 && periodIdWithAds.adGroupIndex >= oldPeriodId.nextAdGroupIndex;
        boolean oldAndNewPeriodIdAreSame = oldPeriodId.periodUid.equals(newPeriodUid) && !oldPeriodId.isAd() && !periodIdWithAds.isAd() && earliestCuePointIsUnchangedOrLater;
        MediaSource.MediaPeriodId newPeriodId = oldAndNewPeriodIdAreSame ? oldPeriodId : periodIdWithAds;
        long periodPositionUs = contentPositionForAdResolutionUs;
        if (newPeriodId.isAd()) {
            if (newPeriodId.equals(oldPeriodId)) {
                periodPositionUs = playbackInfo.positionUs;
            } else {
                timeline.getPeriodByUid(newPeriodId.periodUid, period);
                periodPositionUs = newPeriodId.adIndexInAdGroup == period.getFirstAdIndexToPlay(newPeriodId.adGroupIndex) ? period.getAdResumePositionUs() : 0L;
            }
        }
        return new PositionUpdateForPlaylistChange(newPeriodId, periodPositionUs, newContentPositionUs, forceBufferingState, endPlayback);
    }

    private static boolean shouldUseRequestedContentPosition(PlaybackInfo playbackInfo, Timeline.Period period, Timeline.Window window) {
        MediaSource.MediaPeriodId periodId = playbackInfo.periodId;
        Timeline timeline = playbackInfo.timeline;
        return periodId.isAd() || timeline.isEmpty() || timeline.getWindow((int)timeline.getPeriodByUid((Object)periodId.periodUid, (Timeline.Period)period).windowIndex, (Timeline.Window)window).isPlaceholder;
    }

    private static boolean resolvePendingMessagePosition(PendingMessageInfo pendingMessageInfo, Timeline newTimeline, Timeline previousTimeline, int repeatMode, boolean shuffleModeEnabled, Timeline.Window window, Timeline.Period period) {
        if (pendingMessageInfo.resolvedPeriodUid == null) {
            long requestPositionUs = pendingMessageInfo.message.getPositionMs() == Long.MIN_VALUE ? -9223372036854775807L : C.msToUs(pendingMessageInfo.message.getPositionMs());
            Pair<Object, Long> periodPosition = ExoPlayerImplInternal.resolveSeekPosition(newTimeline, new SeekPosition(pendingMessageInfo.message.getTimeline(), pendingMessageInfo.message.getWindowIndex(), requestPositionUs), false, repeatMode, shuffleModeEnabled, window, period);
            if (periodPosition == null) {
                return false;
            }
            pendingMessageInfo.setResolvedPosition(newTimeline.getIndexOfPeriod(periodPosition.first), (Long)periodPosition.second, periodPosition.first);
            if (pendingMessageInfo.message.getPositionMs() == Long.MIN_VALUE) {
                ExoPlayerImplInternal.resolvePendingMessageEndOfStreamPosition(newTimeline, pendingMessageInfo, window, period);
            }
            return true;
        }
        int index = newTimeline.getIndexOfPeriod(pendingMessageInfo.resolvedPeriodUid);
        if (index == -1) {
            return false;
        }
        if (pendingMessageInfo.message.getPositionMs() == Long.MIN_VALUE) {
            ExoPlayerImplInternal.resolvePendingMessageEndOfStreamPosition(newTimeline, pendingMessageInfo, window, period);
            return true;
        }
        pendingMessageInfo.resolvedPeriodIndex = index;
        previousTimeline.getPeriodByUid(pendingMessageInfo.resolvedPeriodUid, period);
        if (previousTimeline.getWindow((int)period.windowIndex, (Timeline.Window)window).isPlaceholder) {
            long windowPositionUs = pendingMessageInfo.resolvedPeriodTimeUs + period.getPositionInWindowUs();
            int windowIndex = newTimeline.getPeriodByUid((Object)pendingMessageInfo.resolvedPeriodUid, (Timeline.Period)period).windowIndex;
            Pair<Object, Long> periodPosition = newTimeline.getPeriodPosition(window, period, windowIndex, windowPositionUs);
            pendingMessageInfo.setResolvedPosition(newTimeline.getIndexOfPeriod(periodPosition.first), (Long)periodPosition.second, periodPosition.first);
        }
        return true;
    }

    private static void resolvePendingMessageEndOfStreamPosition(Timeline timeline, PendingMessageInfo messageInfo, Timeline.Window window, Timeline.Period period) {
        int windowIndex = timeline.getPeriodByUid((Object)messageInfo.resolvedPeriodUid, (Timeline.Period)period).windowIndex;
        int lastPeriodIndex = timeline.getWindow((int)windowIndex, (Timeline.Window)window).lastPeriodIndex;
        Object lastPeriodUid = timeline.getPeriod((int)lastPeriodIndex, (Timeline.Period)period, (boolean)true).uid;
        long positionUs = period.durationUs != -9223372036854775807L ? period.durationUs - 1L : Long.MAX_VALUE;
        messageInfo.setResolvedPosition(lastPeriodIndex, positionUs, lastPeriodUid);
    }

    @Nullable
    private static Pair<Object, Long> resolveSeekPosition(Timeline timeline, SeekPosition seekPosition, boolean trySubsequentPeriods, int repeatMode, boolean shuffleModeEnabled, Timeline.Window window, Timeline.Period period) {
        Object periodUid;
        Pair<Object, Long> periodPosition;
        Timeline seekTimeline = seekPosition.timeline;
        if (timeline.isEmpty()) {
            return null;
        }
        if (seekTimeline.isEmpty()) {
            seekTimeline = timeline;
        }
        try {
            periodPosition = seekTimeline.getPeriodPosition(window, period, seekPosition.windowIndex, seekPosition.windowPositionUs);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
        if (timeline.equals(seekTimeline)) {
            return periodPosition;
        }
        int periodIndex = timeline.getIndexOfPeriod(periodPosition.first);
        if (periodIndex != -1) {
            seekTimeline.getPeriodByUid(periodPosition.first, period);
            if (seekTimeline.getWindow((int)period.windowIndex, (Timeline.Window)window).isPlaceholder) {
                int newWindowIndex = timeline.getPeriodByUid((Object)periodPosition.first, (Timeline.Period)period).windowIndex;
                periodPosition = timeline.getPeriodPosition(window, period, newWindowIndex, seekPosition.windowPositionUs);
            }
            return periodPosition;
        }
        if (trySubsequentPeriods && (periodUid = ExoPlayerImplInternal.resolveSubsequentPeriod(window, period, repeatMode, shuffleModeEnabled, periodPosition.first, seekTimeline, timeline)) != null) {
            return timeline.getPeriodPosition(window, period, timeline.getPeriodByUid((Object)periodUid, (Timeline.Period)period).windowIndex, -9223372036854775807L);
        }
        return null;
    }

    @Nullable
    static Object resolveSubsequentPeriod(Timeline.Window window, Timeline.Period period, int repeatMode, boolean shuffleModeEnabled, Object oldPeriodUid, Timeline oldTimeline, Timeline newTimeline) {
        int oldPeriodIndex = oldTimeline.getIndexOfPeriod(oldPeriodUid);
        int newPeriodIndex = -1;
        int maxIterations = oldTimeline.getPeriodCount();
        for (int i = 0; i < maxIterations && newPeriodIndex == -1 && (oldPeriodIndex = oldTimeline.getNextPeriodIndex(oldPeriodIndex, period, window, repeatMode, shuffleModeEnabled)) != -1; ++i) {
            newPeriodIndex = newTimeline.getIndexOfPeriod(oldTimeline.getUidOfPeriod(oldPeriodIndex));
        }
        return newPeriodIndex == -1 ? null : newTimeline.getUidOfPeriod(newPeriodIndex);
    }

    private static Format[] getFormats(TrackSelection newSelection) {
        int length = newSelection != null ? newSelection.length() : 0;
        Format[] formats = new Format[length];
        for (int i = 0; i < length; ++i) {
            formats[i] = newSelection.getFormat(i);
        }
        return formats;
    }

    private static boolean isRendererEnabled(Renderer renderer) {
        return renderer.getState() != 0;
    }

    public static interface PlaybackInfoUpdateListener {
        public void onPlaybackInfoUpdate(PlaybackInfoUpdate var1);
    }

    public static final class PlaybackInfoUpdate {
        private boolean hasPendingChange;
        public PlaybackInfo playbackInfo;
        public int operationAcks;
        public boolean positionDiscontinuity;
        public int discontinuityReason;
        public boolean hasPlayWhenReadyChangeReason;
        public int playWhenReadyChangeReason;

        public PlaybackInfoUpdate(PlaybackInfo playbackInfo) {
            this.playbackInfo = playbackInfo;
        }

        public void incrementPendingOperationAcks(int operationAcks) {
            this.hasPendingChange |= operationAcks > 0;
            this.operationAcks += operationAcks;
        }

        public void setPlaybackInfo(PlaybackInfo playbackInfo) {
            this.hasPendingChange |= this.playbackInfo != playbackInfo;
            this.playbackInfo = playbackInfo;
        }

        public void setPositionDiscontinuity(int discontinuityReason) {
            if (this.positionDiscontinuity && this.discontinuityReason != 4) {
                Assertions.checkArgument(discontinuityReason == 4);
                return;
            }
            this.hasPendingChange = true;
            this.positionDiscontinuity = true;
            this.discontinuityReason = discontinuityReason;
        }

        public void setPlayWhenReadyChangeReason(int playWhenReadyChangeReason) {
            this.hasPendingChange = true;
            this.hasPlayWhenReadyChangeReason = true;
            this.playWhenReadyChangeReason = playWhenReadyChangeReason;
        }
    }

    private static final class SeekPosition {
        public final Timeline timeline;
        public final int windowIndex;
        public final long windowPositionUs;

        public SeekPosition(Timeline timeline, int windowIndex, long windowPositionUs) {
            this.timeline = timeline;
            this.windowIndex = windowIndex;
            this.windowPositionUs = windowPositionUs;
        }
    }

    private static final class MediaSourceListUpdateMessage {
        private final List<MediaSourceList.MediaSourceHolder> mediaSourceHolders;
        private final ShuffleOrder shuffleOrder;
        private final int windowIndex;
        private final long positionUs;

        private MediaSourceListUpdateMessage(List<MediaSourceList.MediaSourceHolder> mediaSourceHolders, ShuffleOrder shuffleOrder, int windowIndex, long positionUs) {
            this.mediaSourceHolders = mediaSourceHolders;
            this.shuffleOrder = shuffleOrder;
            this.windowIndex = windowIndex;
            this.positionUs = positionUs;
        }
    }

    private static class MoveMediaItemsMessage {
        public final int fromIndex;
        public final int toIndex;
        public final int newFromIndex;
        public final ShuffleOrder shuffleOrder;

        public MoveMediaItemsMessage(int fromIndex, int toIndex, int newFromIndex, ShuffleOrder shuffleOrder) {
            this.fromIndex = fromIndex;
            this.toIndex = toIndex;
            this.newFromIndex = newFromIndex;
            this.shuffleOrder = shuffleOrder;
        }
    }

    private static final class PendingMessageInfo
    implements Comparable<PendingMessageInfo> {
        public final PlayerMessage message;
        public int resolvedPeriodIndex;
        public long resolvedPeriodTimeUs;
        @Nullable
        public Object resolvedPeriodUid;

        public PendingMessageInfo(PlayerMessage message) {
            this.message = message;
        }

        public void setResolvedPosition(int periodIndex, long periodTimeUs, Object periodUid) {
            this.resolvedPeriodIndex = periodIndex;
            this.resolvedPeriodTimeUs = periodTimeUs;
            this.resolvedPeriodUid = periodUid;
        }

        @Override
        public int compareTo(PendingMessageInfo other) {
            if (this.resolvedPeriodUid == null != (other.resolvedPeriodUid == null)) {
                return this.resolvedPeriodUid != null ? -1 : 1;
            }
            if (this.resolvedPeriodUid == null) {
                return 0;
            }
            int comparePeriodIndex = this.resolvedPeriodIndex - other.resolvedPeriodIndex;
            if (comparePeriodIndex != 0) {
                return comparePeriodIndex;
            }
            return Util.compareLong(this.resolvedPeriodTimeUs, other.resolvedPeriodTimeUs);
        }
    }

    private static final class PositionUpdateForPlaylistChange {
        public final MediaSource.MediaPeriodId periodId;
        public final long periodPositionUs;
        public final long requestedContentPositionUs;
        public final boolean forceBufferingState;
        public final boolean endPlayback;

        public PositionUpdateForPlaylistChange(MediaSource.MediaPeriodId periodId, long periodPositionUs, long requestedContentPositionUs, boolean forceBufferingState, boolean endPlayback) {
            this.periodId = periodId;
            this.periodPositionUs = periodPositionUs;
            this.requestedContentPositionUs = requestedContentPositionUs;
            this.forceBufferingState = forceBufferingState;
            this.endPlayback = endPlayback;
        }
    }
}

