/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.downloader;

import android.content.Context;
import com.akamai.amp.exoplayer2.database.DatabaseProvider;
import com.akamai.amp.exoplayer2.database.ExoDatabaseProvider;
import com.akamai.amp.exoplayer2.upstream.cache.Cache;
import com.akamai.amp.exoplayer2.upstream.cache.CacheEvictor;
import com.akamai.amp.exoplayer2.upstream.cache.NoOpCacheEvictor;
import com.akamai.amp.exoplayer2.upstream.cache.SimpleCache;
import java.io.File;

public class LocalPathProvider {
    public static final String DOWNLOAD_NOTIFICATION_CHANNEL_ID = "download_channel";
    public static final String DOWNLOAD_ACTION_FILE = "actions";
    public static final String DOWNLOAD_TRACKER_ACTION_FILE = "tracked_actions";
    public static final String DOWNLOAD_CONTENT_DIRECTORY = "ampDownloads";
    private DatabaseProvider databaseProvider;
    private static Cache downloadCache;
    private File downloadDirectory;
    private Context context;

    public LocalPathProvider(Context context) {
        this.context = context;
    }

    public DatabaseProvider getDatabaseProvider() {
        if (this.databaseProvider == null) {
            this.databaseProvider = new ExoDatabaseProvider(this.context);
        }
        return this.databaseProvider;
    }

    public synchronized Cache getDownloadCache() {
        if (downloadCache == null) {
            File downloadContentDirectory = new File(this.getDownloadDirectory(), DOWNLOAD_CONTENT_DIRECTORY);
            downloadCache = new SimpleCache(downloadContentDirectory, (CacheEvictor)new NoOpCacheEvictor(), this.getDatabaseProvider());
        }
        return downloadCache;
    }

    public File getDownloadDirectory() {
        if (this.downloadDirectory == null) {
            this.downloadDirectory = this.context.getExternalFilesDir(null);
            if (this.downloadDirectory == null) {
                this.downloadDirectory = this.context.getFilesDir();
            }
        }
        return this.downloadDirectory;
    }

    public void releaseCache() {
        if (downloadCache != null) {
            downloadCache.release();
            downloadCache = null;
        }
    }
}

