/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.cmcd;

import com.akamai.amp.exoplayer2.upstream.DefaultHttpDataSource;
import com.akamai.amp.media.exowrapper2.DataSourceBuilder;
import java.util.HashMap;
import java.util.UUID;

public class CMCDProxy {
    public static final String ENCODED_BITRATE = "br";
    public static final String PLAYBACK_RATE = "pr";
    public static final String STREAM_FORMAT = "sf";
    public static final String SESSION_ID = "sid";
    public static final String STREAM_TYPE = "st";
    public static final String TOP_BITRATE = "tb";
    private String REQUEST_TYPE = "CMCD-Request";
    private String OBJECT_TYPE = "CMCD-Object";
    private String SESSION_TYPE = "CMCD-Session";
    private HashMap<String, String> commonMediaClientData = new HashMap();
    private Long encodedBitrate;
    private Integer topBitrate;
    private String streamType;
    private String sessionId;
    private String streamFormat;
    private Integer playbackRate;

    private void updateSession() {
        String sessionData = null;
        if (this.streamType != null) {
            sessionData = String.format("%s=%s", STREAM_TYPE, this.streamType);
        }
        if (this.sessionId != null) {
            sessionData = String.format("%s%s=%s", this.checkDataSize(sessionData), SESSION_ID, this.sessionId);
        }
        if (this.streamFormat != null) {
            sessionData = String.format("%s%s=%s", this.checkDataSize(sessionData), STREAM_FORMAT, this.streamFormat);
        }
        if (this.playbackRate != null) {
            sessionData = String.format("%s%s=%s", this.checkDataSize(sessionData), PLAYBACK_RATE, this.playbackRate);
        }
        if (sessionData != null && !sessionData.isEmpty()) {
            this.commonMediaClientData.put(this.SESSION_TYPE, sessionData);
            this.updateData();
        }
    }

    private void updateObject() {
        String objectData = null;
        if (this.topBitrate != null) {
            objectData = String.format("%s=%s", TOP_BITRATE, this.topBitrate);
        }
        if (objectData != null) {
            this.commonMediaClientData.put(this.OBJECT_TYPE, objectData);
            this.updateData();
        }
    }

    private void updateRequest() {
        String requestData = null;
        if (this.encodedBitrate != null) {
            requestData = String.format("%s=%s", ENCODED_BITRATE, this.encodedBitrate);
        }
        if (requestData != null) {
            this.commonMediaClientData.put(this.REQUEST_TYPE, requestData);
            this.updateData();
        }
    }

    private String checkDataSize(String data) {
        if (data != null) {
            return String.format("%s,", data);
        }
        return "";
    }

    public void updatePlaybackRate(Float playbackRate, Boolean isPaused) {
        this.playbackRate = isPaused != false ? Integer.valueOf(0) : ((double)playbackRate.floatValue() >= 2.0 ? Integer.valueOf(2) : null);
        this.updateSession();
    }

    public void updateSessionId(UUID sessionId) {
        this.sessionId = sessionId.toString();
        this.updateSession();
    }

    public void updateTopBitrate(Integer topBitrate) {
        this.topBitrate = topBitrate;
        this.updateObject();
    }

    public void updateStreamFormat(String protocol) {
        switch (protocol) {
            case "MPEG-DASH": {
                this.streamFormat = "d";
                break;
            }
            case "HLS": {
                this.streamFormat = "h";
                break;
            }
            case "Smooth": {
                this.streamFormat = "s";
                break;
            }
            default: {
                this.streamFormat = "o";
            }
        }
        this.updateSession();
    }

    public void updateStreamType(Boolean isLive) {
        this.streamType = isLive != false ? "l" : "v";
        this.updateSession();
    }

    public void updateEncodedBitrate(Long encodedBitrate) {
        this.encodedBitrate = encodedBitrate;
        this.updateRequest();
    }

    public void clearAllData() {
        DefaultHttpDataSource.clearAllCommonMediaClientData();
        this.commonMediaClientData.clear();
        this.updateData();
    }

    private void updateData() {
        DataSourceBuilder.updateCommonMediaClientData(this.commonMediaClientData);
    }
}

