/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.utils.autorecovery;

import android.os.Handler;
import com.akamai.amp.media.IPlayerEventsListener;
import com.akamai.amp.media.VideoPlayerContainer;
import com.akamai.amp.media.VideoPlayerViewExo;
import com.akamai.amp.media.elements.MediaResource;
import com.akamai.amp.media.errors.ErrorType;
import com.akamai.amp.tracker.AkamaiEvent;
import com.akamai.amp.tracker.DoGetTask;
import com.akamai.amp.tracker.OnTaskCompleted;
import com.akamai.amp.utils.LogManager;
import com.akamai.amp.utils.Utils;
import java.util.Date;

public class StreamAutorecovery {
    private static final String TAG = StreamAutorecovery.class.getSimpleName();
    private VideoPlayerContainer videoPlayerContainer;
    private String posterUrl;
    private long intervalMillis = 1000L;
    private Handler mHandler;
    private Runnable mRunnable;
    private final OnTaskCompleted httpResultListener = new OnTaskCompleted(){

        @Override
        public void onTaskCompleted(Integer result) {
            boolean isError;
            LogManager.log(TAG, "onTaskCompleted: HTTP code " + result);
            boolean bl = isError = result == null || result != 200;
            if (isError) {
                StreamAutorecovery.this.onStreamOffline();
            } else {
                StreamAutorecovery.this.onStreamOnline();
            }
        }
    };
    private final IPlayerEventsListener playerEventsListener = new IPlayerEventsListener(){

        @Override
        public boolean onPlayerEvent(int eventId) {
            StreamAutorecovery.this.processEvent(eventId);
            return true;
        }

        @Override
        public boolean onPlayerExtendedEvent(int eventId, int arg1, int arg2) {
            return false;
        }
    };
    private final VideoPlayerContainer.VideoPlayerContainerCallback exoCreatedCallback = new VideoPlayerContainer.VideoPlayerContainerCallback(){

        @Override
        public void onVideoPlayerCreated() {
            VideoPlayerViewExo exo = StreamAutorecovery.this.getExo();
            if (exo == null) {
                return;
            }
            exo.addEventsListener(StreamAutorecovery.this.playerEventsListener);
        }

        @Override
        public void onResourceReady(MediaResource resource) {
        }

        @Override
        public void onResourceError(ErrorType errorType, Exception exc) {
        }
    };

    public StreamAutorecovery(VideoPlayerContainer videoPlayerContainer, String posterUrl, long intervalMillis) {
        this.setVideoPlayerContainer(videoPlayerContainer);
        this.setPosterUrl(posterUrl);
        this.setIntervalMillis(intervalMillis);
        this.mHandler = new Handler();
    }

    public void setVideoPlayerContainer(VideoPlayerContainer param) {
        this.videoPlayerContainer = Utils.requireNonNull(param);
        this.registerContainerCallback();
        VideoPlayerViewExo exo = this.getExo();
        if (exo == null) {
            return;
        }
        exo.addEventsListener(this.playerEventsListener);
    }

    public void setPosterUrl(String param) {
        this.posterUrl = param;
    }

    private void setIntervalMillis(long param) {
        this.intervalMillis = param;
    }

    private void processEvent(int eventId) {
        if (4 == eventId) {
            boolean isHttpError;
            VideoPlayerViewExo exo = this.getExo();
            if (exo == null) {
                return;
            }
            int httpErrorCode = exo.getLastHttpErrorCode();
            boolean bl = isHttpError = httpErrorCode != 200 && httpErrorCode > 0;
            if (isHttpError) {
                LogManager.log(TAG, "HTTP error: " + httpErrorCode);
                this.onFirstHttpError();
                this.scheduleWork();
            }
        } else if (1 == eventId) {
            LogManager.log(TAG, "removePoster");
            this.videoPlayerContainer.removePoster();
        }
    }

    private void onFirstHttpError() {
        LogManager.log(TAG, "onFirstHttpError: loadPoster: " + this.posterUrl);
        this.videoPlayerContainer.loadPoster(this.posterUrl);
    }

    private void scheduleWork() {
        this.destroyRunnable();
        this.mRunnable = new Runnable(){

            @Override
            public void run() {
                StreamAutorecovery.this.doHttpQuery();
            }
        };
        this.mHandler.postDelayed(this.mRunnable, this.intervalMillis);
    }

    private void doHttpQuery() {
        String streamUrl = this.getStreamUrl();
        if (streamUrl == null) {
            return;
        }
        new DoGetTask(TAG, this.httpResultListener).execute(new String[]{streamUrl, AkamaiEvent.AUTORECOVERY.toString()});
    }

    private void onStreamOnline() {
        LogManager.log(TAG, "onStreamOnline " + new Date());
        String streamUrl = this.getStreamUrl();
        if (streamUrl == null) {
            return;
        }
        this.videoPlayerContainer.doAutoRecovery();
    }

    private void onStreamOffline() {
        LogManager.log(TAG, "onStreamOffline " + new Date());
        this.mHandler.postDelayed(this.mRunnable, this.intervalMillis);
    }

    private String getStreamUrl() {
        VideoPlayerViewExo exo = this.getExo();
        if (exo == null) {
            return null;
        }
        String streamUrl = exo.getStreamUrl();
        return streamUrl;
    }

    private VideoPlayerViewExo getExo() {
        if (this.videoPlayerContainer == null) {
            return null;
        }
        if (!this.videoPlayerContainer.isVideoPlayerViewAvailable()) {
            return null;
        }
        VideoPlayerViewExo videoPlayer = (VideoPlayerViewExo)this.videoPlayerContainer.getVideoPlayer();
        return videoPlayer;
    }

    private void destroyRunnable() {
        if (this.mHandler != null && this.mRunnable != null) {
            this.mHandler.removeCallbacks(this.mRunnable);
            this.mRunnable = null;
        }
    }

    private void registerContainerCallback() {
        this.videoPlayerContainer.addVideoPlayerContainerCallback(this.exoCreatedCallback);
    }
}

