/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.ui;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;

public class LicenseNotification
extends FrameLayout {
    private LicenseNotificationTextView licenseNotificationTextView;

    public LicenseNotification(Context context, String text) {
        super(context);
        this.init(context, text);
    }

    private void init(Context context, String text) {
        this.removeAllViews();
        this.setBackgroundColor(Color.parseColor((String)"#40FFFFFF"));
        this.licenseNotificationTextView = new LicenseNotificationTextView(context);
        this.licenseNotificationTextView.setText(text);
        this.licenseNotificationTextView.setTextSize(1, 25.0f);
        this.licenseNotificationTextView.setGravity(17);
        this.licenseNotificationTextView.setAllCaps(false);
        this.licenseNotificationTextView.setTypeface(this.licenseNotificationTextView.getTypeface(), 1);
        this.licenseNotificationTextView.setBackground((Drawable)new ColorDrawable(Color.parseColor((String)"#99FFFFFF")));
        FrameLayout.LayoutParams lParams = new FrameLayout.LayoutParams(-1, -2);
        lParams.gravity = 80;
        this.addView((View)this.licenseNotificationTextView, 0, (ViewGroup.LayoutParams)lParams);
    }

    private class LicenseNotificationTextView
    extends TextView {
        private Drawable textViewBackground;
        private Canvas textViewBackgroundCanvas;
        private Canvas maskCanvas;
        private Bitmap textViewBackgroundBitmap;
        private Bitmap maskBitmap;
        private Paint textPaint;

        public LicenseNotificationTextView(Context context) {
            super(context);
            this.textPaint = new Paint();
            this.textPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.XOR));
            this.setTextColor(-16777216);
            this.setBackground((Drawable)new ColorDrawable(0));
        }

        protected void onDraw(Canvas canvas) {
            canvas.drawColor(-16777216, PorterDuff.Mode.CLEAR);
            if (this.getWidth() != 0 && this.getHeight() != 0) {
                super.onDraw(this.maskCanvas);
                this.textViewBackground.draw(this.textViewBackgroundCanvas);
                this.textViewBackgroundCanvas.drawBitmap(this.maskBitmap, 0.0f, 0.0f, this.textPaint);
                canvas.drawBitmap(this.textViewBackgroundBitmap, 0.0f, 0.0f, null);
            }
        }

        public void setBackground(Drawable background) {
            if (this.textViewBackground != background) {
                this.textViewBackground = background;
            }
        }

        protected void onSizeChanged(int w, int h, int oldw, int oldh) {
            super.onSizeChanged(w, h, oldw, oldh);
            if (w != 0 && h != 0) {
                this.textViewBackgroundBitmap = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                this.textViewBackgroundCanvas = new Canvas(this.textViewBackgroundBitmap);
                this.maskBitmap = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ALPHA_8);
                this.maskCanvas = new Canvas(this.maskBitmap);
                this.textViewBackground.setBounds(0, 0, w, h);
            }
        }
    }
}

