/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.license.manager;

import android.os.AsyncTask;
import com.akamai.amp.license.manager.OnLicenseTaskCompleted;
import com.akamai.amp.utils.LogManager;
import java.io.ByteArrayOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;

public class LicenseGetTask
extends AsyncTask<String, Void, String> {
    public static final String TAG = LicenseGetTask.class.getSimpleName();
    private OnLicenseTaskCompleted listener;
    private int resultCode;

    public LicenseGetTask(OnLicenseTaskCompleted listener) {
        this.listener = listener;
    }

    protected String doInBackground(String ... params) {
        String getResult = this.executeGet(params[0]);
        return getResult;
    }

    protected void onPostExecute(String result) {
        LogManager.log(TAG, "License on GET execution result code: " + this.resultCode);
        if (result != null) {
            this.listener.onLicenseRetrievedSuccessfully(result);
        } else {
            this.listener.onLicenseFailed(this.resultCode != 403);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeGet(String targetURL) {
        HttpURLConnection connection = null;
        try {
            URL url = new URL(targetURL);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setUseCaches(false);
            this.resultCode = connection.getResponseCode();
            if (this.resultCode == 200) {
                int length;
                ByteArrayOutputStream result = new ByteArrayOutputStream();
                byte[] buffer = new byte[20480];
                while ((length = connection.getInputStream().read(buffer)) != -1) {
                    result.write(buffer, 0, length);
                }
                String string2 = result.toString(StandardCharsets.UTF_8.name());
                return string2;
            }
            String string3 = null;
            return string3;
        }
        catch (Exception e) {
            LogManager.log(TAG, "License on GET execution: " + e.getLocalizedMessage());
            String string4 = null;
            return string4;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }
}

