/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.text.ttml;

import android.text.Layout;
import androidx.annotation.Nullable;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

final class TtmlStyle {
    public static final int UNSPECIFIED = -1;
    public static final int STYLE_NORMAL = 0;
    public static final int STYLE_BOLD = 1;
    public static final int STYLE_ITALIC = 2;
    public static final int STYLE_BOLD_ITALIC = 3;
    public static final int FONT_SIZE_UNIT_PIXEL = 1;
    public static final int FONT_SIZE_UNIT_EM = 2;
    public static final int FONT_SIZE_UNIT_PERCENT = 3;
    private static final int OFF = 0;
    private static final int ON = 1;
    public static final int RUBY_TYPE_CONTAINER = 1;
    public static final int RUBY_TYPE_BASE = 2;
    public static final int RUBY_TYPE_TEXT = 3;
    public static final int RUBY_TYPE_DELIMITER = 4;
    @Nullable
    private String fontFamily;
    private int fontColor;
    private boolean hasFontColor;
    private int backgroundColor;
    private boolean hasBackgroundColor;
    private int linethrough = -1;
    private int underline = -1;
    private int bold = -1;
    private int italic = -1;
    private int fontSizeUnit = -1;
    private float fontSize;
    @Nullable
    private String id;
    private int rubyType = -1;
    private int rubyPosition = -1;
    @Nullable
    private Layout.Alignment textAlign;
    private int textCombine = -1;

    public int getStyle() {
        if (this.bold == -1 && this.italic == -1) {
            return -1;
        }
        return (this.bold == 1 ? 1 : 0) | (this.italic == 1 ? 2 : 0);
    }

    public boolean isLinethrough() {
        return this.linethrough == 1;
    }

    public TtmlStyle setLinethrough(boolean linethrough) {
        this.linethrough = linethrough ? 1 : 0;
        return this;
    }

    public boolean isUnderline() {
        return this.underline == 1;
    }

    public TtmlStyle setUnderline(boolean underline) {
        this.underline = underline ? 1 : 0;
        return this;
    }

    public TtmlStyle setBold(boolean bold) {
        this.bold = bold ? 1 : 0;
        return this;
    }

    public TtmlStyle setItalic(boolean italic) {
        this.italic = italic ? 1 : 0;
        return this;
    }

    @Nullable
    public String getFontFamily() {
        return this.fontFamily;
    }

    public TtmlStyle setFontFamily(@Nullable String fontFamily) {
        this.fontFamily = fontFamily;
        return this;
    }

    public int getFontColor() {
        if (!this.hasFontColor) {
            throw new IllegalStateException("Font color has not been defined.");
        }
        return this.fontColor;
    }

    public TtmlStyle setFontColor(int fontColor) {
        this.fontColor = fontColor;
        this.hasFontColor = true;
        return this;
    }

    public boolean hasFontColor() {
        return this.hasFontColor;
    }

    public int getBackgroundColor() {
        if (!this.hasBackgroundColor) {
            throw new IllegalStateException("Background color has not been defined.");
        }
        return this.backgroundColor;
    }

    public TtmlStyle setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.hasBackgroundColor = true;
        return this;
    }

    public boolean hasBackgroundColor() {
        return this.hasBackgroundColor;
    }

    public TtmlStyle chain(@Nullable TtmlStyle ancestor) {
        return this.inherit(ancestor, true);
    }

    public TtmlStyle inherit(@Nullable TtmlStyle ancestor) {
        return this.inherit(ancestor, false);
    }

    private TtmlStyle inherit(@Nullable TtmlStyle ancestor, boolean chaining) {
        if (ancestor != null) {
            if (!this.hasFontColor && ancestor.hasFontColor) {
                this.setFontColor(ancestor.fontColor);
            }
            if (this.bold == -1) {
                this.bold = ancestor.bold;
            }
            if (this.italic == -1) {
                this.italic = ancestor.italic;
            }
            if (this.fontFamily == null && ancestor.fontFamily != null) {
                this.fontFamily = ancestor.fontFamily;
            }
            if (this.linethrough == -1) {
                this.linethrough = ancestor.linethrough;
            }
            if (this.underline == -1) {
                this.underline = ancestor.underline;
            }
            if (this.rubyPosition == -1) {
                this.rubyPosition = ancestor.rubyPosition;
            }
            if (this.textAlign == null && ancestor.textAlign != null) {
                this.textAlign = ancestor.textAlign;
            }
            if (this.textCombine == -1) {
                this.textCombine = ancestor.textCombine;
            }
            if (this.fontSizeUnit == -1) {
                this.fontSizeUnit = ancestor.fontSizeUnit;
                this.fontSize = ancestor.fontSize;
            }
            if (chaining && !this.hasBackgroundColor && ancestor.hasBackgroundColor) {
                this.setBackgroundColor(ancestor.backgroundColor);
            }
            if (chaining && this.rubyType == -1 && ancestor.rubyType != -1) {
                this.rubyType = ancestor.rubyType;
            }
        }
        return this;
    }

    public TtmlStyle setId(@Nullable String id) {
        this.id = id;
        return this;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public TtmlStyle setRubyType(int rubyType) {
        this.rubyType = rubyType;
        return this;
    }

    public int getRubyType() {
        return this.rubyType;
    }

    public TtmlStyle setRubyPosition(int position) {
        this.rubyPosition = position;
        return this;
    }

    public int getRubyPosition() {
        return this.rubyPosition;
    }

    @Nullable
    public Layout.Alignment getTextAlign() {
        return this.textAlign;
    }

    public TtmlStyle setTextAlign(@Nullable Layout.Alignment textAlign) {
        this.textAlign = textAlign;
        return this;
    }

    public boolean getTextCombine() {
        return this.textCombine == 1;
    }

    public TtmlStyle setTextCombine(boolean combine) {
        this.textCombine = combine ? 1 : 0;
        return this;
    }

    public TtmlStyle setFontSize(float fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    public TtmlStyle setFontSizeUnit(int fontSizeUnit) {
        this.fontSizeUnit = fontSizeUnit;
        return this;
    }

    public int getFontSizeUnit() {
        return this.fontSizeUnit;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RubyType {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface OptionalBoolean {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FontSizeUnit {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StyleFlags {
    }
}

