/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.mediacodec;

import android.media.MediaCodec;
import android.media.MediaCrypto;
import android.media.MediaFormat;
import android.view.Surface;
import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.decoder.CryptoInfo;
import com.akamai.amp.exoplayer2.mediacodec.MediaCodecAdapter;

final class SynchronousMediaCodecAdapter
implements MediaCodecAdapter {
    private final MediaCodec codec;

    public SynchronousMediaCodecAdapter(MediaCodec mediaCodec) {
        this.codec = mediaCodec;
    }

    @Override
    public void configure(@Nullable MediaFormat mediaFormat, @Nullable Surface surface, @Nullable MediaCrypto crypto, int flags) {
        this.codec.configure(mediaFormat, surface, crypto, flags);
    }

    @Override
    public void start() {
        this.codec.start();
    }

    @Override
    public int dequeueInputBufferIndex() {
        return this.codec.dequeueInputBuffer(0L);
    }

    @Override
    public int dequeueOutputBufferIndex(MediaCodec.BufferInfo bufferInfo) {
        return this.codec.dequeueOutputBuffer(bufferInfo, 0L);
    }

    @Override
    public MediaFormat getOutputFormat() {
        return this.codec.getOutputFormat();
    }

    @Override
    public void queueInputBuffer(int index, int offset, int size, long presentationTimeUs, int flags) {
        this.codec.queueInputBuffer(index, offset, size, presentationTimeUs, flags);
    }

    @Override
    public void queueSecureInputBuffer(int index, int offset, CryptoInfo info, long presentationTimeUs, int flags) {
        this.codec.queueSecureInputBuffer(index, offset, info.getFrameworkCryptoInfo(), presentationTimeUs, flags);
    }

    @Override
    public void flush() {
        this.codec.flush();
    }

    @Override
    public void shutdown() {
    }

    @Override
    public MediaCodec getCodec() {
        return this.codec;
    }
}

