/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.utils;

import android.util.Log;
import java.io.PrintWriter;
import java.io.StringWriter;

public class LogManager {
    private static final String AMP_VERSION = "AMP SDK v9.10.7";
    private static boolean mLogEnabled = true;

    public static boolean isLogEnabled() {
        return mLogEnabled;
    }

    public static void setLogEnabled(boolean activate) {
        mLogEnabled = activate;
        if (mLogEnabled) {
            Log.i((String)AMP_VERSION, (String)("LogManager.setLogEnabled(" + mLogEnabled + ")"));
        }
    }

    public static void log(String tag, String text) {
        if (mLogEnabled) {
            Log.d((String)tag, (String)text);
        }
    }

    public static void error(String tag, String text) {
        if (mLogEnabled) {
            Log.e((String)tag, (String)text);
        }
    }

    public static void error(String tag, String s, Exception e) {
        if (mLogEnabled) {
            Log.e((String)tag, (String)s, (Throwable)e);
        }
    }

    public static void error(String tag, Exception e) {
        if (mLogEnabled) {
            String errorMessage = LogManager.getStackTrace(e);
            Log.e((String)tag, (String)errorMessage);
        }
    }

    private static String getStackTrace(Exception e) {
        if (e == null) {
            return "NULL Exception";
        }
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        String exceptionAsString = sw.toString();
        return exceptionAsString;
    }

    public static interface Logs {
        public void log(String var1);
    }
}

