/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.media.mute;

import com.akamai.amp.exoplayer2.SimpleExoPlayer;
import com.akamai.amp.media.Listeners;
import com.akamai.amp.media.mute.IMuteable;
import com.akamai.amp.media.mute.MuteListener;
import com.akamai.amp.utils.LogManager;

public class MuteHelper {
    private static final String TAG = "MuteHelper";
    public static final float MIN_VOLUME = 0.0f;
    public static final float MAX_VOLUME = 1.0f;
    public static float DUCK_VOLUME = 0.1f;
    private static boolean isMuted = false;
    private static final Listeners<MuteListener> listeners = new Listeners();

    public static boolean isMuted() {
        return isMuted;
    }

    public static boolean isUnmuted() {
        return !isMuted;
    }

    public static void mute() {
        isMuted = true;
        listeners.remove(null);
        for (MuteListener listener : listeners) {
            if (listener == null) continue;
            listener.onMuted();
        }
    }

    public static void unmute() {
        isMuted = false;
        listeners.remove(null);
        for (MuteListener listener : listeners) {
            if (listener == null) continue;
            listener.onUnmuted();
        }
    }

    public static void mute(IMuteable muteable) {
        MuteHelper.mute();
        if (muteable == null) {
            return;
        }
        LogManager.log(TAG, "mute() to " + MuteHelper.getClassName(muteable));
        muteable.mute();
    }

    public static void unmute(IMuteable muteable) {
        MuteHelper.unmute();
        if (muteable == null) {
            return;
        }
        LogManager.log(TAG, "unmute() to " + MuteHelper.getClassName(muteable));
        muteable.unmute();
    }

    public static void setVolume(IMuteable muteable, float volume) {
        if (muteable == null) {
            return;
        }
        LogManager.log(TAG, "unmute() to " + MuteHelper.getClassName(muteable));
        muteable.setVolume(volume);
        listeners.remove(null);
        for (MuteListener listener : listeners) {
            if (listener == null) continue;
            listener.onVolumeChanged(volume);
        }
    }

    public static void setCurrentMuteState(IMuteable muteable) {
        if (muteable == null) {
            return;
        }
        if (isMuted) {
            muteable.mute();
        } else {
            muteable.unmute();
        }
    }

    public static void setMuteState(IMuteable muteable, boolean isMutedParam) {
        isMuted = isMutedParam;
        MuteHelper.setCurrentMuteState(muteable);
    }

    public static void mute(SimpleExoPlayer player) {
        MuteHelper.mute();
        MuteHelper.trySetVolume(player, 0.0f);
    }

    public static void unmute(SimpleExoPlayer player) {
        MuteHelper.unmute();
        MuteHelper.trySetVolume(player, 1.0f);
    }

    public static void trySetVolume(SimpleExoPlayer player, float volume) {
        if (player == null) {
            return;
        }
        player.setVolume(volume);
    }

    private static String getClassName(IMuteable muteable) {
        if (muteable == null) {
            return "-NULL IMuteable-";
        }
        String className = muteable.getClass().getCanonicalName();
        return className;
    }

    public static void logCurrentMuteState() {
        LogManager.log(TAG, "MuteHelper.isMuted() " + MuteHelper.isMuted());
    }

    public static void addListener(MuteListener listener) {
        listeners.add(listener);
    }

    public static void removeListener(MuteListener listener) {
        listeners.remove(listener);
    }
}

